/*
 * Decompiled with CFR 0.152.
 */
package com.android.screenshottest.ui;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.screenshottest.ui.PreviewDetails;
import com.android.screenshottest.ui.UpdateReferenceImagesDialog;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidTestCaseResult;
import com.android.tools.idea.testartifacts.instrumented.testsuite.util.ScreenshotTestUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ImageLoader;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBImageIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0001)B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0016J\u0018\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u000e\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\"J\u0016\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\u0016J\u0012\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020\u0016H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001d\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00160\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001d\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00160\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018\u00a8\u0006*"}, d2={"Lcom/android/screenshottest/ui/PreviewItemPanel;", "Ljavax/swing/JPanel;", "previewData", "Lcom/android/screenshottest/ui/PreviewDetails;", "onImageLoaded", "Lkotlin/Function0;", "", "showDetails", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "<init>", "(Lcom/android/screenshottest/ui/PreviewDetails;Lkotlin/jvm/functions/Function0;ZLcom/intellij/openapi/diagnostic/Logger;)V", "getPreviewData", "()Lcom/android/screenshottest/ui/PreviewDetails;", "imagePanel", "Lcom/android/screenshottest/ui/PreviewItemPanel$ImagePanel;", "value", "isLoadedSuccessfully", "()Z", "loadedImagePaths", "", "", "getLoadedImagePaths", "()Ljava/util/Map;", "sourceImageToCopy", "getSourceImageToCopy", "showError", "message", "showPlaceholder", "color", "Lcom/intellij/ui/JBColor;", "showImageForView", "viewType", "Lcom/android/screenshottest/ui/UpdateReferenceImagesDialog$ScreenshotViewType;", "loadImage", "newPath", "testId", "createImageIcon", "Lcom/intellij/util/ui/JBImageIcon;", "path", "ImagePanel", "intellij.android.screenshot-test"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPreviewItemPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreviewItemPanel.kt\ncom/android/screenshottest/ui/PreviewItemPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,263:1\n1#2:264\n*E\n"})
public final class PreviewItemPanel
extends JPanel {
    @NotNull
    private final PreviewDetails previewData;
    @NotNull
    private final Function0<Unit> onImageLoaded;
    private final boolean showDetails;
    @NotNull
    private final Logger logger;
    @NotNull
    private final ImagePanel imagePanel;
    private boolean isLoadedSuccessfully;
    @NotNull
    private final Map<String, String> loadedImagePaths;
    @NotNull
    private final Map<String, String> sourceImageToCopy;
    public static final int $stable = 8;

    public PreviewItemPanel(@NotNull PreviewDetails previewData, @NotNull Function0<Unit> onImageLoaded, boolean showDetails, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)previewData, (String)"previewData");
        Intrinsics.checkNotNullParameter(onImageLoaded, (String)"onImageLoaded");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.previewData = previewData;
        this.onImageLoaded = onImageLoaded;
        this.showDetails = showDetails;
        this.logger = logger;
        this.loadedImagePaths = new LinkedHashMap();
        this.sourceImageToCopy = new LinkedHashMap();
        this.setLayout(new GridBagLayout());
        this.setOpaque(false);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.anchor = 17;
        c.fill = 0;
        c.weightx = 0.0;
        this.imagePanel = new ImagePanel();
        c.gridy = 0;
        this.add((Component)this.imagePanel, c);
        if (this.showDetails) {
            JBLabel jBLabel;
            JBLabel jBLabel2;
            JPanel jPanel;
            JPanel $this$_init__u24lambda_u240 = jPanel = new JPanel();
            boolean bl = false;
            $this$_init__u24lambda_u240.setLayout(new BoxLayout($this$_init__u24lambda_u240, 1));
            $this$_init__u24lambda_u240.setBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0));
            JPanel detailsPanel = jPanel;
            String string = this.previewData.getDiffPercent();
            Double diffDouble = string != null ? StringsKt.toDoubleOrNull((String)string) : null;
            String matchPercentage = ScreenshotTestUtils.INSTANCE.calculateMatchPercentage(diffDouble);
            String string2 = matchPercentage;
            if (string2 == null) {
                string2 = "0.00%";
            }
            JBLabel $this$_init__u24lambda_u241 = jBLabel2 = new JBLabel(string2);
            boolean bl2 = false;
            $this$_init__u24lambda_u241.setForeground(this.previewData.getTestResult() == AndroidTestCaseResult.PASSED ? JBColor.GREEN.darker() : (Color)JBColor.RED);
            $this$_init__u24lambda_u241.setFont($this$_init__u24lambda_u241.getFont().deriveFont(1));
            $this$_init__u24lambda_u241.setAlignmentX(0.0f);
            JBLabel matchLabel = jBLabel2;
            JBLabel $this$_init__u24lambda_u242 = jBLabel = new JBLabel(this.previewData.getPreviewName());
            boolean bl3 = false;
            $this$_init__u24lambda_u242.setAlignmentX(0.0f);
            JBLabel previewNameLabel = jBLabel;
            detailsPanel.add((Component)matchLabel);
            detailsPanel.add((Component)previewNameLabel);
            c.gridy = 1;
            this.add((Component)detailsPanel, c);
        }
    }

    public /* synthetic */ PreviewItemPanel(PreviewDetails previewDetails, Function0 function0, boolean bl, Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            Logger logger2 = Logger.getInstance(PreviewItemPanel.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger = logger2;
        }
        this(previewDetails, (Function0<Unit>)function0, bl, logger);
    }

    @NotNull
    public final PreviewDetails getPreviewData() {
        return this.previewData;
    }

    public final boolean isLoadedSuccessfully() {
        return this.isLoadedSuccessfully;
    }

    @NotNull
    public final Map<String, String> getLoadedImagePaths() {
        return this.loadedImagePaths;
    }

    @NotNull
    public final Map<String, String> getSourceImageToCopy() {
        return this.sourceImageToCopy;
    }

    public final void showError(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        ApplicationManager.getApplication().invokeLater(() -> PreviewItemPanel.showError$lambda$3(this, message));
    }

    private final void showPlaceholder(String message, JBColor color) {
        ApplicationManager.getApplication().invokeLater(() -> PreviewItemPanel.showPlaceholder$lambda$4(this, message, color));
    }

    public final void showImageForView(@NotNull UpdateReferenceImagesDialog.ScreenshotViewType viewType) {
        Intrinsics.checkNotNullParameter((Object)((Object)viewType), (String)"viewType");
        switch (WhenMappings.$EnumSwitchMapping$0[viewType.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                String string = this.previewData.getSrcImagePath();
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    this.loadImage(it, this.previewData.getTestId());
                    break;
                }
                this.showError("No New Image");
                break;
            }
            case 3: {
                String diffPath = this.previewData.getDiffImagePath();
                if (diffPath != null && new File(diffPath).exists()) {
                    this.loadImage(diffPath, this.previewData.getTestId());
                    break;
                }
                if (this.previewData.getTestResult() == AndroidTestCaseResult.PASSED) {
                    JBColor jBColor = JBColor.GREEN;
                    Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"GREEN");
                    this.showPlaceholder("No Difference", jBColor);
                    break;
                }
                JBColor jBColor = JBColor.RED;
                Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"RED");
                this.showPlaceholder("No Diff Image", jBColor);
                break;
            }
            case 4: {
                String refPath = this.previewData.getDestImagePath();
                if (refPath != null && new File(refPath).exists()) {
                    this.loadImage(refPath, this.previewData.getTestId());
                    break;
                }
                JBColor jBColor = JBColor.RED;
                Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"RED");
                this.showPlaceholder("No Reference Image", jBColor);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public final void loadImage(@NotNull String newPath, @NotNull String testId) {
        Intrinsics.checkNotNullParameter((Object)newPath, (String)"newPath");
        Intrinsics.checkNotNullParameter((Object)testId, (String)"testId");
        char[] cArray = new char[]{'.'};
        String simpleClassName = (String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)testId, (char[])cArray, (boolean)false, (int)2, (int)2, null));
        this.loadedImagePaths.put(newPath, simpleClassName);
        if (this.sourceImageToCopy.isEmpty()) {
            String string = this.previewData.getSrcImagePath();
            if (string != null) {
                String it = string;
                boolean bl = false;
                this.sourceImageToCopy.put(it, simpleClassName);
            }
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> PreviewItemPanel.loadImage$lambda$8(this, newPath));
    }

    private final JBImageIcon createImageIcon(String path) {
        JBImageIcon jBImageIcon;
        File ioFile = new File(path);
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(ioFile);
        if (virtualFile == null || virtualFile.getLength() == 0L) {
            this.logger.warn("Image file not found or is empty after build: " + path);
            return null;
        }
        try {
            byte[] byArray = virtualFile.contentsToByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"contentsToByteArray(...)");
            Image image = ImageLoader.loadFromBytes((byte[])byArray);
            if (image == null) {
                return null;
            }
            Image image2 = image;
            int w = image2.getWidth(null);
            int h = image2.getHeight(null);
            if (w <= 0 || h <= 0 || w <= 200 && h <= 200) {
                return new JBImageIcon(image2);
            }
            int newW = 0;
            int newH = 0;
            if (w > h) {
                newW = 200;
                newH = (int)((double)h * (double)newW / (double)w);
            } else {
                newH = 200;
                newW = (int)((double)w * (double)newH / (double)h);
            }
            int finalW = RangesKt.coerceAtLeast((int)newW, (int)1);
            int finalH = RangesKt.coerceAtLeast((int)newH, (int)1);
            Image scaledImage = ImageUtil.scaleImage((Image)image2, (int)finalW, (int)finalH);
            Intrinsics.checkNotNull((Object)scaledImage);
            jBImageIcon = new JBImageIcon(scaledImage);
        }
        catch (IOException e) {
            this.logger.error("IOException while loading image: " + path, (Throwable)e);
            jBImageIcon = null;
        }
        return jBImageIcon;
    }

    private static final void showError$lambda$3(PreviewItemPanel this$0, String $message) {
        this$0.isLoadedSuccessfully = false;
        ImagePanel.showText$default(this$0.imagePanel, $message, null, 2, null);
    }

    private static final void showPlaceholder$lambda$4(PreviewItemPanel this$0, String $message, JBColor $color) {
        this$0.imagePanel.showText($message, $color);
    }

    private static final void loadImage$lambda$8$lambda$7(JBImageIcon $image, PreviewItemPanel this$0) {
        if ($image != null) {
            this$0.imagePanel.setImage($image);
            this$0.revalidate();
            this$0.repaint();
            this$0.isLoadedSuccessfully = true;
            this$0.onImageLoaded.invoke();
        } else {
            this$0.showError("Couldn't load image");
        }
    }

    private static final void loadImage$lambda$8(PreviewItemPanel this$0, String $newPath) {
        JBImageIcon image = this$0.createImageIcon($newPath);
        ApplicationManager.getApplication().invokeLater(() -> PreviewItemPanel.loadImage$lambda$8$lambda$7(image, this$0));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u0018\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/screenshottest/ui/PreviewItemPanel$ImagePanel;", "Ljavax/swing/JPanel;", "<init>", "()V", "image", "Lcom/intellij/util/ui/JBImageIcon;", "loadingIcon", "Lcom/intellij/util/ui/AsyncProcessIcon;", "initialSize", "Ljava/awt/Dimension;", "setImage", "", "newImage", "showText", "message", "", "color", "Lcom/intellij/ui/JBColor;", "paintComponent", "g", "Ljava/awt/Graphics;", "intellij.android.screenshot-test"})
    @SourceDebugExtension(value={"SMAP\nPreviewItemPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreviewItemPanel.kt\ncom/android/screenshottest/ui/PreviewItemPanel$ImagePanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,263:1\n1#2:264\n*E\n"})
    private static final class ImagePanel
    extends JPanel {
        @Nullable
        private JBImageIcon image;
        @NotNull
        private final AsyncProcessIcon loadingIcon = new AsyncProcessIcon("Waiting for image...");
        @NotNull
        private final Dimension initialSize = new Dimension(200, 200);

        public ImagePanel() {
            super(new GridBagLayout());
            this.setPreferredSize(this.initialSize);
            this.setMaximumSize(this.initialSize);
            this.setBorder(BorderFactory.createLineBorder(JBColor.border()));
            this.add((Component)this.loadingIcon);
        }

        public final void setImage(@NotNull JBImageIcon newImage) {
            Intrinsics.checkNotNullParameter((Object)newImage, (String)"newImage");
            this.image = newImage;
            this.removeAll();
            Dimension newSize = new Dimension(newImage.getIconWidth(), newImage.getIconHeight());
            this.setPreferredSize(newSize);
            this.setMaximumSize(newSize);
            this.revalidate();
            this.repaint();
        }

        /*
         * WARNING - void declaration
         */
        public final void showText(@NotNull String message, @NotNull JBColor color) {
            void $this$showText_u24lambda_u240;
            JBLabel jBLabel;
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)color, (String)"color");
            this.image = null;
            this.removeAll();
            JBLabel jBLabel2 = jBLabel = new JBLabel(message);
            ImagePanel imagePanel = this;
            boolean bl = false;
            $this$showText_u24lambda_u240.setForeground((Color)color);
            imagePanel.add((Component)jBLabel);
            this.setPreferredSize(this.initialSize);
            this.setMaximumSize(this.initialSize);
            this.revalidate();
            this.repaint();
        }

        public static /* synthetic */ void showText$default(ImagePanel imagePanel, String string, JBColor jBColor, int n, Object object) {
            if ((n & 2) != 0) {
                JBColor jBColor2 = JBColor.RED;
                Intrinsics.checkNotNullExpressionValue((Object)jBColor2, (String)"RED");
                jBColor = jBColor2;
            }
            imagePanel.showText(string, jBColor);
        }

        @Override
        protected void paintComponent(@NotNull Graphics g) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                super.paintComponent(g);
                JBImageIcon jBImageIcon = this.image;
                if (jBImageIcon == null) break block0;
                JBImageIcon it = jBImageIcon;
                boolean bl = false;
                int x = (this.getWidth() - it.getIconWidth()) / 2;
                int y = (this.getHeight() - it.getIconHeight()) / 2;
                it.paintIcon((Component)this, g, x, y);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[UpdateReferenceImagesDialog.ScreenshotViewType.values().length];
            try {
                nArray[UpdateReferenceImagesDialog.ScreenshotViewType.ALL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UpdateReferenceImagesDialog.ScreenshotViewType.NEW.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UpdateReferenceImagesDialog.ScreenshotViewType.DIFF.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UpdateReferenceImagesDialog.ScreenshotViewType.REFERENCE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

