/*
 * Decompiled with CFR 0.152.
 */
package com.android.screenshottest.ui;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.awt.ComposePanel;
import com.android.screenshottest.ui.PreviewDetails;
import com.android.screenshottest.ui.PreviewItemPanel;
import com.android.screenshottest.ui.UpdateReferenceImagesDialog;
import com.android.tools.idea.testartifacts.instrumented.testsuite.view.ScreenshotAttributesView;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.images.editor.impl.ImageEditorManagerImpl;
import org.intellij.images.editor.impl.ImageEditorUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J \u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u000fH\u0002J\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\fH\u0002J2\u0010\u001b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/screenshottest/ui/PreviewDetailsPanel;", "Ljavax/swing/JPanel;", "<init>", "()V", "screenshotAttributesView", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/view/ScreenshotAttributesView;", "multiplePreviewsPanel", "singlePreviewPanel", "displayPreviews", "", "previewsToShow", "", "Lcom/android/screenshottest/ui/PreviewDetails;", "imagePanelMap", "", "", "Lcom/android/screenshottest/ui/PreviewItemPanel;", "viewType", "Lcom/android/screenshottest/ui/UpdateReferenceImagesDialog$ScreenshotViewType;", "previewToolbar", "Landroidx/compose/ui/awt/ComposePanel;", "displaySinglePreviewDetails", "previewData", "createImageViewerPanel", "Ljavax/swing/JComponent;", "imagePath", "updateScreenshotAttributesView", "displayMultiplePreviews", "intellij.android.screenshot-test"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPreviewDetailsPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreviewDetailsPanel.kt\ncom/android/screenshottest/ui/PreviewDetailsPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,221:1\n1869#2,2:222\n1491#2:224\n1516#2,3:225\n1519#2,3:235\n1869#2,2:239\n382#3,7:228\n216#4:238\n217#4:241\n*S KotlinDebug\n*F\n+ 1 PreviewDetailsPanel.kt\ncom/android/screenshottest/ui/PreviewDetailsPanel\n*L\n104#1:222,2\n186#1:224\n186#1:225,3\n186#1:235,3\n202#1:239,2\n186#1:228,7\n187#1:238\n187#1:241\n*E\n"})
public final class PreviewDetailsPanel
extends JPanel {
    @NotNull
    private final ScreenshotAttributesView screenshotAttributesView = new ScreenshotAttributesView();
    @NotNull
    private final JPanel multiplePreviewsPanel;
    @NotNull
    private final JPanel singlePreviewPanel;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public PreviewDetailsPanel() {
        super(new CardLayout());
        void $this$multiplePreviewsPanel_u24lambda_u240;
        JPanel jPanel;
        JPanel jPanel2 = jPanel = new JPanel();
        PreviewDetailsPanel previewDetailsPanel = this;
        boolean bl = false;
        $this$multiplePreviewsPanel_u24lambda_u240.setLayout(new BoxLayout((Container)$this$multiplePreviewsPanel_u24lambda_u240, 1));
        previewDetailsPanel.multiplePreviewsPanel = jPanel;
        this.singlePreviewPanel = new JPanel(new BorderLayout());
        this.add((Component)this.multiplePreviewsPanel, "MULTIPLE_PREVIEWS_PANEL");
        this.add((Component)this.singlePreviewPanel, "SINGLE_PREVIEW_PANEL");
    }

    public final void displayPreviews(@NotNull List<PreviewDetails> previewsToShow, @NotNull Map<String, PreviewItemPanel> imagePanelMap, @NotNull UpdateReferenceImagesDialog.ScreenshotViewType viewType, @Nullable ComposePanel previewToolbar) {
        Intrinsics.checkNotNullParameter(previewsToShow, (String)"previewsToShow");
        Intrinsics.checkNotNullParameter(imagePanelMap, (String)"imagePanelMap");
        Intrinsics.checkNotNullParameter((Object)((Object)viewType), (String)"viewType");
        LayoutManager layoutManager = this.getLayout();
        Intrinsics.checkNotNull((Object)layoutManager, (String)"null cannot be cast to non-null type java.awt.CardLayout");
        CardLayout cardLayout = (CardLayout)layoutManager;
        if (previewsToShow.size() == 1 && previewToolbar != null) {
            this.displaySinglePreviewDetails((PreviewDetails)CollectionsKt.first(previewsToShow), viewType, previewToolbar);
            cardLayout.show(this, "SINGLE_PREVIEW_PANEL");
        } else {
            this.displayMultiplePreviews(previewsToShow, imagePanelMap, viewType);
            cardLayout.show(this, "MULTIPLE_PREVIEWS_PANEL");
        }
    }

    private final void displaySinglePreviewDetails(PreviewDetails previewData, UpdateReferenceImagesDialog.ScreenshotViewType viewType, ComposePanel previewToolbar) {
        JBLabel jBLabel;
        this.singlePreviewPanel.removeAll();
        JPanel topContainerPanel = new JPanel(new BorderLayout());
        JBLabel $this$displaySinglePreviewDetails_u24lambda_u241 = jBLabel = new JBLabel(previewData.getPreviewName());
        boolean bl2 = false;
        $this$displaySinglePreviewDetails_u24lambda_u241.setFont($this$displaySinglePreviewDetails_u24lambda_u241.getFont().deriveFont(1, (float)$this$displaySinglePreviewDetails_u24lambda_u241.getFont().getSize() + 4.0f));
        $this$displaySinglePreviewDetails_u24lambda_u241.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JBLabel titleLabel = jBLabel;
        topContainerPanel.add((Component)titleLabel, "North");
        if (viewType == UpdateReferenceImagesDialog.ScreenshotViewType.ALL) {
            JPanel allImagesPanel = new JPanel(new GridLayout(1, 3, 10, 0));
            Object[] bl2 = new String[]{previewData.getSrcImagePath(), previewData.getDiffImagePath(), previewData.getDestImagePath()};
            List imagePaths = CollectionsKt.listOf((Object[])bl2);
            Iterable $this$forEach$iv = imagePaths;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String path = (String)element$iv;
                boolean bl3 = false;
                JComponent panel = this.createImageViewerPanel(path);
                allImagesPanel.add(panel);
            }
            topContainerPanel.add((Component)allImagesPanel, "Center");
        } else {
            String imagePath;
            JPanel imageContainer = new JPanel(new BorderLayout());
            topContainerPanel.add((Component)imageContainer, "Center");
            switch (WhenMappings.$EnumSwitchMapping$0[viewType.ordinal()]) {
                case 1: {
                    String string = previewData.getSrcImagePath();
                    break;
                }
                case 2: {
                    String string = previewData.getDiffImagePath();
                    break;
                }
                case 3: {
                    String string = previewData.getDestImagePath();
                    break;
                }
                default: {
                    String string = imagePath = null;
                }
            }
            if (imagePath != null && new File(imagePath).exists()) {
                Future future = ApplicationManager.getApplication().executeOnPooledThread(() -> PreviewDetailsPanel.displaySinglePreviewDetails$lambda$4(imagePath, imageContainer));
                Intrinsics.checkNotNull((Object)future);
            } else {
                imageContainer.add((Component)new JBLabel("Image not available.", 0), "Center");
            }
        }
        topContainerPanel.add((Component)previewToolbar, "South");
        JComponent detailsPanel = this.screenshotAttributesView.getComponent();
        this.updateScreenshotAttributesView(previewData);
        JBSplitter splitter = new JBSplitter(true, 0.5f);
        splitter.setFirstComponent((JComponent)topContainerPanel);
        splitter.setSecondComponent(detailsPanel);
        this.singlePreviewPanel.add((Component)splitter, "Center");
        this.singlePreviewPanel.revalidate();
        this.singlePreviewPanel.repaint();
    }

    private final JComponent createImageViewerPanel(String imagePath) {
        JPanel panel = new JPanel(new BorderLayout());
        if (imagePath != null && new File(imagePath).exists()) {
            Future future = ApplicationManager.getApplication().executeOnPooledThread(() -> PreviewDetailsPanel.createImageViewerPanel$lambda$6(imagePath, panel));
            Intrinsics.checkNotNull((Object)future);
        } else {
            panel.add((Component)new JBLabel("Image not available.", 0), "Center");
        }
        return panel;
    }

    private final void updateScreenshotAttributesView(PreviewDetails previewData) {
        String string = previewData.getDiffPercent();
        Double diffPercent = string != null ? StringsKt.toDoubleOrNull((String)string) : null;
        this.screenshotAttributesView.updateData(previewData.getDestImagePath(), previewData.getSrcImagePath(), previewData.getMethodName(), previewData.getClassName(), previewData.getTestResult(), diffPercent);
    }

    /*
     * WARNING - void declaration
     */
    private final void displayMultiplePreviews(List<PreviewDetails> previewsToShow, Map<String, PreviewItemPanel> imagePanelMap, UpdateReferenceImagesDialog.ScreenshotViewType viewType) {
        Map previewsByFunction;
        void $this$groupByTo$iv$iv;
        this.multiplePreviewsPanel.removeAll();
        Iterable $this$groupBy$iv = previewsToShow;
        boolean $i$f$groupBy = false;
        Object object = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            PreviewDetails it = (PreviewDetails)element$iv$iv;
            boolean bl3 = false;
            String key$iv$iv = it.getMethodName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$forEach$iv = previewsByFunction = destination$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            JBScrollPane jBScrollPane;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = (Map.Entry)object.next();
            boolean bl = false;
            String function = (String)entry.getKey();
            List previews = (List)entry.getValue();
            String string = function;
            if (string == null) {
                string = "Unnamed Function";
            }
            JBLabel bl3 = new JBLabel(string);
            Object $this$displayMultiplePreviews_u24lambda_u2413_u24lambda_u248 = bl3;
            boolean bl4 = false;
            $this$displayMultiplePreviews_u24lambda_u2413_u24lambda_u248.setFont($this$displayMultiplePreviews_u24lambda_u2413_u24lambda_u248.getFont().deriveFont(1, (float)$this$displayMultiplePreviews_u24lambda_u2413_u24lambda_u248.getFont().getSize() + 2.0f));
            $this$displayMultiplePreviews_u24lambda_u2413_u24lambda_u248.setBorder(BorderFactory.createEmptyBorder(15, 5, 5, 5));
            $this$displayMultiplePreviews_u24lambda_u2413_u24lambda_u248.setAlignmentX(0.0f);
            JBLabel functionNameLabel = bl3;
            this.multiplePreviewsPanel.add((Component)functionNameLabel);
            Object $this$displayMultiplePreviews_u24lambda_u2413_u24lambda_u249 = $this$displayMultiplePreviews_u24lambda_u2413_u24lambda_u248 = new JPanel(new FlowLayout(0, 10, 0));
            boolean bl5 = false;
            ((JComponent)$this$displayMultiplePreviews_u24lambda_u2413_u24lambda_u249).setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 20));
            Object horizontalPreviewsPanel = $this$displayMultiplePreviews_u24lambda_u2413_u24lambda_u248;
            Iterable $this$forEach$iv2 = previews;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                PreviewItemPanel panel;
                PreviewDetails previewData = (PreviewDetails)element$iv2;
                boolean bl6 = false;
                if (imagePanelMap.get(previewData.getTestId()) == null) continue;
                boolean bl7 = false;
                panel.showImageForView(viewType);
                ((Container)horizontalPreviewsPanel).add(panel);
            }
            JBScrollPane $this$displayMultiplePreviews_u24lambda_u2413_u24lambda_u2412 = jBScrollPane = new JBScrollPane((Component)horizontalPreviewsPanel);
            boolean bl8 = false;
            $this$displayMultiplePreviews_u24lambda_u2413_u24lambda_u2412.setHorizontalScrollBarPolicy(30);
            $this$displayMultiplePreviews_u24lambda_u2413_u24lambda_u2412.setVerticalScrollBarPolicy(21);
            $this$displayMultiplePreviews_u24lambda_u2413_u24lambda_u2412.setBorder(null);
            $this$displayMultiplePreviews_u24lambda_u2413_u24lambda_u2412.setAlignmentX(0.0f);
            JBScrollPane horizontalScrollPane = jBScrollPane;
            this.multiplePreviewsPanel.add((Component)horizontalScrollPane);
        }
        this.multiplePreviewsPanel.revalidate();
        this.multiplePreviewsPanel.repaint();
    }

    private static final void displaySinglePreviewDetails$lambda$4$lambda$3(BufferedImage $image, JPanel $imageContainer) {
        ImageEditorUI imageEditorUI = ImageEditorManagerImpl.createImageEditorUI((BufferedImage)$image);
        Intrinsics.checkNotNullExpressionValue((Object)imageEditorUI, (String)"createImageEditorUI(...)");
        ImageEditorUI editor = imageEditorUI;
        $imageContainer.add((Component)editor, "Center");
        $imageContainer.revalidate();
        $imageContainer.repaint();
    }

    private static final void displaySinglePreviewDetails$lambda$4(String $imagePath, JPanel $imageContainer) {
        BufferedImage image = ImageIO.read(new File($imagePath));
        ApplicationManager.getApplication().invokeLater(() -> PreviewDetailsPanel.displaySinglePreviewDetails$lambda$4$lambda$3(image, $imageContainer));
    }

    private static final void createImageViewerPanel$lambda$6$lambda$5(BufferedImage $image, JPanel $panel) {
        ImageEditorUI imageEditorUI = ImageEditorManagerImpl.createImageEditorUI((BufferedImage)$image);
        Intrinsics.checkNotNullExpressionValue((Object)imageEditorUI, (String)"createImageEditorUI(...)");
        ImageEditorUI editor = imageEditorUI;
        $panel.add((Component)editor, "Center");
        $panel.revalidate();
        $panel.repaint();
    }

    private static final void createImageViewerPanel$lambda$6(String $imagePath, JPanel $panel) {
        BufferedImage image = ImageIO.read(new File($imagePath));
        ApplicationManager.getApplication().invokeLater(() -> PreviewDetailsPanel.createImageViewerPanel$lambda$6$lambda$5(image, $panel));
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[UpdateReferenceImagesDialog.ScreenshotViewType.values().length];
            try {
                nArray[UpdateReferenceImagesDialog.ScreenshotViewType.NEW.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UpdateReferenceImagesDialog.ScreenshotViewType.DIFF.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UpdateReferenceImagesDialog.ScreenshotViewType.REFERENCE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

