/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.directaccess.client.cli.action;

import com.google.cloud.devicestreaming.v1.DeviceSession;
import com.google.services.firebase.directaccess.client.cli.DirectAccessCliSettings;
import com.google.services.firebase.directaccess.client.cli.ShowUsageException;
import com.google.services.firebase.directaccess.client.cli.action.DirectAccessAction;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lcom/google/services/firebase/directaccess/client/cli/action/DescribeReservationAction;", "Lcom/google/services/firebase/directaccess/client/cli/action/DirectAccessAction;", "settings", "Lcom/google/services/firebase/directaccess/client/cli/DirectAccessCliSettings;", "<init>", "(Lcom/google/services/firebase/directaccess/client/cli/DirectAccessCliSettings;)V", "consumeArgs", "", "run", "Companion", "directaccess-client"})
public final class DescribeReservationAction
extends DirectAccessAction {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public DescribeReservationAction(@NotNull DirectAccessCliSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
    }

    @Override
    public void consumeArgs() {
    }

    @Override
    public void run() {
        StateFlow<DeviceSession> stateFlow2;
        if (((CharSequence)this.getReservationName()).length() == 0) {
            throw new ShowUsageException("--reservation-name=<reservation name> required to describe a reservation");
        }
        try {
            stateFlow2 = this.getReservationManager().fetchReservationFlow(this.getReservationName());
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() == Status.NOT_FOUND.getCode()) {
                throw new NoSuchElementException("Could not find reservation with name " + this.getReservationName());
            }
            throw e;
        }
        StateFlow<DeviceSession> reservationFlow = stateFlow2;
        this.getOutputStream().println(reservationFlow.getValue());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052&\u0010\u0006\u001a\"\u0012\u0004\u0012\u00020\b\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u0002`\f0\u0007j\u0002`\r\u00a8\u0006\u000e"}, d2={"Lcom/google/services/firebase/directaccess/client/cli/action/DescribeReservationAction$Companion;", "", "<init>", "()V", "register", "", "map", "", "", "Lkotlin/Function1;", "Lcom/google/services/firebase/directaccess/client/cli/DirectAccessCliSettings;", "Lcom/google/services/firebase/directaccess/client/cli/action/DirectAccessAction;", "Lcom/google/services/firebase/directaccess/client/cli/ActionMapValue;", "Lcom/google/services/firebase/directaccess/client/cli/ActionMap;", "directaccess-client"})
    public static final class Companion {
        private Companion() {
        }

        public final void register(@NotNull Map<String, Function1<DirectAccessCliSettings, DirectAccessAction>> map2) {
            Intrinsics.checkNotNullParameter(map2, (String)"map");
            map2.put("describe", (Function1<DirectAccessCliSettings, DirectAccessAction>)((Function1)Companion::register$lambda$0));
        }

        private static final DirectAccessAction register$lambda$0(DirectAccessCliSettings settings) {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            return new DescribeReservationAction(settings);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

