/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.directaccess;

import androidx.compose.runtime.internal.StabilityInferred;
import com.google.api.services.cloudresourcemanager.v3.model.TestIamPermissionsResponse;
import com.google.common.annotations.VisibleForTesting;
import com.google.gct.directaccess.CloudProjectEntry;
import com.google.gct.directaccess.DirectAccessPermissionStatusKt;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u0000 \u000e2\u00020\u0001:\u0006\t\n\u000b\f\r\u000eB\u0017\b\u0004\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u0082\u0001\u0005\u000f\u0010\u0011\u0012\u0013\u00a8\u0006\u0014"}, d2={"Lcom/google/gct/directaccess/DirectAccessPermissionStatus;", "", "missingPermissions", "", "", "<init>", "(Ljava/util/Set;)V", "getMissingPermissions", "()Ljava/util/Set;", "Unknown", "MissingServiceUse", "None", "Viewer", "Full", "Companion", "Lcom/google/gct/directaccess/DirectAccessPermissionStatus$Full;", "Lcom/google/gct/directaccess/DirectAccessPermissionStatus$MissingServiceUse;", "Lcom/google/gct/directaccess/DirectAccessPermissionStatus$None;", "Lcom/google/gct/directaccess/DirectAccessPermissionStatus$Unknown;", "Lcom/google/gct/directaccess/DirectAccessPermissionStatus$Viewer;", "directaccess"})
@StabilityInferred(parameters=0)
public abstract sealed class DirectAccessPermissionStatus {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<String> missingPermissions;
    public static final int $stable = 8;

    private DirectAccessPermissionStatus(Set<String> missingPermissions) {
        this.missingPermissions = missingPermissions;
    }

    @NotNull
    public final Set<String> getMissingPermissions() {
        return this.missingPermissions;
    }

    public /* synthetic */ DirectAccessPermissionStatus(Set missingPermissions, DefaultConstructorMarker $constructor_marker) {
        this(missingPermissions);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0002\u0010\t\u001a\u00020\nH\u0001\u00a2\u0006\u0002\b\u000bJ \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u0012"}, d2={"Lcom/google/gct/directaccess/DirectAccessPermissionStatus$Companion;", "", "<init>", "()V", "parseFrom", "Lcom/google/gct/directaccess/DirectAccessPermissionStatus;", "permissions", "", "", "isDefaultApiEnabled", "", "parseFrom$directaccess", "getTestIamPermissionsResponse", "Lcom/google/api/services/cloudresourcemanager/v3/model/TestIamPermissionsResponse;", "cloudProject", "Lcom/google/gct/directaccess/CloudProjectEntry;", "applyUserProject", "checkDirectAccessPermission", "directaccess"})
    @SourceDebugExtension(value={"SMAP\nDirectAccessPermissionStatus.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirectAccessPermissionStatus.kt\ncom/google/gct/directaccess/DirectAccessPermissionStatus$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,186:1\n24#2:187\n24#2:188\n*S KotlinDebug\n*F\n+ 1 DirectAccessPermissionStatus.kt\ncom/google/gct/directaccess/DirectAccessPermissionStatus$Companion\n*L\n152#1:187\n158#1:188\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        @NotNull
        public final DirectAccessPermissionStatus parseFrom$directaccess(@NotNull Set<String> permissions, boolean isDefaultApiEnabled) {
            Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
            if (isDefaultApiEnabled) {
                if (permissions.isEmpty()) {
                    return new None(DirectAccessPermissionStatusKt.getNEW_FULL_PERMISSIONS_SET());
                }
                Set missingPermissions = SetsKt.minus(DirectAccessPermissionStatusKt.getNEW_FULL_PERMISSIONS_SET(), (Iterable)permissions);
                return missingPermissions.isEmpty() ? (DirectAccessPermissionStatus)new Full() : (missingPermissions.contains("serviceusage.services.use") ? (DirectAccessPermissionStatus)new MissingServiceUse(missingPermissions) : (missingPermissions.containsAll((Collection)DirectAccessPermissionStatusKt.getNEW_ADMIN_PERMISSIONS_SET()) ? (DirectAccessPermissionStatus)new None(missingPermissions) : (permissions.containsAll((Collection)DirectAccessPermissionStatusKt.getNEW_VIEWER_PERMISSIONS_SET()) ? (DirectAccessPermissionStatus)new Viewer(missingPermissions) : (DirectAccessPermissionStatus)new Unknown(missingPermissions))));
            }
            if (permissions.isEmpty()) {
                return new None(DirectAccessPermissionStatusKt.getFULL_PERMISSIONS_SET());
            }
            Set missingPermissions = SetsKt.minus(DirectAccessPermissionStatusKt.getFULL_PERMISSIONS_SET(), (Iterable)permissions);
            return missingPermissions.isEmpty() ? (DirectAccessPermissionStatus)new Full() : (missingPermissions.contains("serviceusage.services.use") ? (DirectAccessPermissionStatus)new MissingServiceUse(missingPermissions) : (missingPermissions.containsAll((Collection)DirectAccessPermissionStatusKt.getADMIN_PERMISSIONS_SET()) ? (DirectAccessPermissionStatus)new None(missingPermissions) : (permissions.containsAll((Collection)DirectAccessPermissionStatusKt.getVIEWER_PERMISSIONS_SET()) ? (DirectAccessPermissionStatus)new Viewer(missingPermissions) : (DirectAccessPermissionStatus)new Unknown(missingPermissions))));
        }

        public static /* synthetic */ DirectAccessPermissionStatus parseFrom$directaccess$default(Companion companion, Set set, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.parseFrom$directaccess(set, bl);
        }

        private final TestIamPermissionsResponse getTestIamPermissionsResponse(CloudProjectEntry cloudProject, boolean applyUserProject, boolean isDefaultApiEnabled) {
            Set<String> fullPermissionsSet = isDefaultApiEnabled ? DirectAccessPermissionStatusKt.getNEW_FULL_PERMISSIONS_SET() : DirectAccessPermissionStatusKt.getFULL_PERMISSIONS_SET();
            TestIamPermissionsResponse testIamPermissionsResponse = DirectAccessPermissionStatusKt.checkPermissions(fullPermissionsSet, cloudProject, applyUserProject);
            if (testIamPermissionsResponse == null) {
                throw new IOException("Got null response");
            }
            return testIamPermissionsResponse;
        }

        @NotNull
        public final DirectAccessPermissionStatus checkDirectAccessPermission(@NotNull CloudProjectEntry cloudProject, boolean isDefaultApiEnabled) {
            TestIamPermissionsResponse response;
            List list;
            TestIamPermissionsResponse testIamPermissionsResponse;
            boolean $i$f$thisLogger;
            Companion $this$thisLogger$iv;
            TestIamPermissionsResponse testIamPermissionsResponse2;
            Intrinsics.checkNotNullParameter((Object)cloudProject, (String)"cloudProject");
            try {
                testIamPermissionsResponse2 = this.getTestIamPermissionsResponse(cloudProject, true, isDefaultApiEnabled);
            }
            catch (IOException e) {
                $this$thisLogger$iv = this;
                $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(Companion.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Cloud Resource Manager API may not be enabled.", (Throwable)e);
                testIamPermissionsResponse2 = null;
            }
            if ((testIamPermissionsResponse = testIamPermissionsResponse2) == null) {
                try {
                    testIamPermissionsResponse2 = this.getTestIamPermissionsResponse(cloudProject, false, isDefaultApiEnabled);
                }
                catch (IOException e) {
                    $this$thisLogger$iv = this;
                    $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.warn("Could not fetch permissions for user " + cloudProject.getUser() + " for project " + cloudProject.getName() + ": " + e.getMessage());
                    return new None(DirectAccessPermissionStatusKt.getFULL_PERMISSIONS_SET());
                }
                testIamPermissionsResponse = testIamPermissionsResponse2;
            }
            if ((list = (response = testIamPermissionsResponse).getPermissions()) == null) {
                list = CollectionsKt.emptyList();
            }
            List permissions = list;
            return this.parseFrom$directaccess(CollectionsKt.toSet((Iterable)permissions), isDefaultApiEnabled);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/google/gct/directaccess/DirectAccessPermissionStatus$Full;", "Lcom/google/gct/directaccess/DirectAccessPermissionStatus;", "<init>", "()V", "directaccess"})
    @StabilityInferred(parameters=0)
    public static final class Full
    extends DirectAccessPermissionStatus {
        public static final int $stable = 8;

        public Full() {
            super(SetsKt.emptySet(), null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/google/gct/directaccess/DirectAccessPermissionStatus$MissingServiceUse;", "Lcom/google/gct/directaccess/DirectAccessPermissionStatus;", "missingPermissions", "", "", "<init>", "(Ljava/util/Set;)V", "directaccess"})
    @StabilityInferred(parameters=0)
    public static final class MissingServiceUse
    extends DirectAccessPermissionStatus {
        public static final int $stable = 8;

        public MissingServiceUse(@NotNull Set<String> missingPermissions) {
            Intrinsics.checkNotNullParameter(missingPermissions, (String)"missingPermissions");
            super(missingPermissions, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/google/gct/directaccess/DirectAccessPermissionStatus$None;", "Lcom/google/gct/directaccess/DirectAccessPermissionStatus;", "missingPermissions", "", "", "<init>", "(Ljava/util/Set;)V", "directaccess"})
    @StabilityInferred(parameters=0)
    public static final class None
    extends DirectAccessPermissionStatus {
        public static final int $stable = 8;

        public None(@NotNull Set<String> missingPermissions) {
            Intrinsics.checkNotNullParameter(missingPermissions, (String)"missingPermissions");
            super(missingPermissions, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/google/gct/directaccess/DirectAccessPermissionStatus$Unknown;", "Lcom/google/gct/directaccess/DirectAccessPermissionStatus;", "missingPermissions", "", "", "<init>", "(Ljava/util/Set;)V", "directaccess"})
    @StabilityInferred(parameters=0)
    public static final class Unknown
    extends DirectAccessPermissionStatus {
        public static final int $stable = 8;

        public Unknown(@NotNull Set<String> missingPermissions) {
            Intrinsics.checkNotNullParameter(missingPermissions, (String)"missingPermissions");
            super(missingPermissions, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/google/gct/directaccess/DirectAccessPermissionStatus$Viewer;", "Lcom/google/gct/directaccess/DirectAccessPermissionStatus;", "missingPermissions", "", "", "<init>", "(Ljava/util/Set;)V", "directaccess"})
    @StabilityInferred(parameters=0)
    public static final class Viewer
    extends DirectAccessPermissionStatus {
        public static final int $stable = 8;

        public Viewer(@NotNull Set<String> missingPermissions) {
            Intrinsics.checkNotNullParameter(missingPermissions, (String)"missingPermissions");
            super(missingPermissions, null);
        }
    }
}

