/*
 * Decompiled with CFR 0.152.
 */
package com.google.targetsdkversionassistant.compiler;

import com.android.tools.idea.assistant.DefaultTutorialBundle;
import com.android.tools.idea.assistant.datamodel.StepData;
import com.android.tools.idea.assistant.datamodel.StepElementData;
import com.android.tools.idea.assistant.datamodel.StepElementType;
import com.google.targetsdkversionassistant.compiler.CompiledStep;
import com.google.targetsdkversionassistant.compiler.CompilerKt;
import com.google.targetsdkversionassistant.compiler.StepElement;
import com.google.targetsdkversionassistant.dsl.Code;
import com.google.targetsdkversionassistant.dsl.Element;
import com.google.targetsdkversionassistant.dsl.Filtered;
import com.google.targetsdkversionassistant.dsl.FilteredStep;
import com.google.targetsdkversionassistant.dsl.Image;
import com.google.targetsdkversionassistant.dsl.Java;
import com.google.targetsdkversionassistant.dsl.Kotlin;
import com.google.targetsdkversionassistant.dsl.Lift;
import com.google.targetsdkversionassistant.dsl.Ordering;
import com.google.targetsdkversionassistant.dsl.Par;
import com.google.targetsdkversionassistant.dsl.Raw;
import com.google.targetsdkversionassistant.dsl.RelevanceOnly;
import com.google.targetsdkversionassistant.dsl.Seq;
import com.google.targetsdkversionassistant.dsl.Shell;
import com.google.targetsdkversionassistant.dsl.Step;
import com.google.targetsdkversionassistant.dsl.Text;
import com.google.targetsdkversionassistant.dsl.Xml;
import com.google.targetsdkversionassistant.filter.FilterService;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B7\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\u0013J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\u0015H\u0002J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/google/targetsdkversionassistant/compiler/Compiler;", "", "knownFilters", "", "", "filterResults", "", "Lcom/google/targetsdkversionassistant/filter/FilterService$FilterResult;", "throwOnMissingFilter", "", "<init>", "(Ljava/util/Set;Ljava/util/Map;Z)V", "compileOrdering", "", "Lcom/android/tools/idea/assistant/datamodel/StepData;", "o", "Lcom/google/targetsdkversionassistant/dsl/Ordering;", "compileStep", "step", "Lcom/google/targetsdkversionassistant/dsl/Step;", "compileFilteredStep", "Lcom/google/targetsdkversionassistant/dsl/FilteredStep;", "compileElement", "Lcom/android/tools/idea/assistant/datamodel/StepElementData;", "element", "Lcom/google/targetsdkversionassistant/dsl/Element;", "targetsdkversion-upgrade-assistant"})
@SourceDebugExtension(value={"SMAP\nCompiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Compiler.kt\ncom/google/targetsdkversionassistant/compiler/Compiler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,187:1\n1374#2:188\n1460#2,5:189\n1374#2:194\n1460#2,5:195\n1563#2:200\n1634#2,3:201\n1563#2:204\n1634#2,3:205\n1563#2:208\n1634#2,3:209\n*S KotlinDebug\n*F\n+ 1 Compiler.kt\ncom/google/targetsdkversionassistant/compiler/Compiler\n*L\n61#1:188\n61#1:189,5\n62#1:194\n62#1:195,5\n68#1:200\n68#1:201,3\n81#1:204\n81#1:205,3\n94#1:208\n94#1:209,3\n*E\n"})
public final class Compiler {
    @NotNull
    private final Set<String> knownFilters;
    @NotNull
    private final Map<String, FilterService.FilterResult> filterResults;
    private final boolean throwOnMissingFilter;

    public Compiler(@NotNull Set<String> knownFilters, @NotNull Map<String, ? extends FilterService.FilterResult> filterResults2, boolean throwOnMissingFilter) {
        Intrinsics.checkNotNullParameter(knownFilters, (String)"knownFilters");
        Intrinsics.checkNotNullParameter(filterResults2, (String)"filterResults");
        this.knownFilters = knownFilters;
        this.filterResults = filterResults2;
        this.throwOnMissingFilter = throwOnMissingFilter;
    }

    public /* synthetic */ Compiler(Set set, Map map, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        this(set, map, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<StepData> compileOrdering(@NotNull Ordering o) {
        List list;
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        Ordering ordering = o;
        if (ordering instanceof Lift) {
            list = CollectionsKt.listOfNotNull((Object)this.compileStep(((Lift)o).getStep()));
        } else if (ordering instanceof Par) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = ((Par)o).getKids();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Ordering p0 = (Ordering)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = this.compileOrdering(p0);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else if (ordering instanceof Seq) {
            Iterable $this$flatMap$iv = ((Seq)o).getKids();
            boolean $i$f$flatMap = false;
            Iterable $this$flatMapTo$iv$iv = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Ordering p0 = (Ordering)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = this.compileOrdering(p0);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final StepData compileStep(@NotNull Step step) {
        StepData stepData;
        Intrinsics.checkNotNullParameter((Object)step, (String)"step");
        Step step2 = step;
        if (step2 instanceof Raw) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = ((Raw)step).getElements();
            String string = ((Raw)step).getLabel();
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Element element = (Element)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.compileElement((Element)it));
            }
            List list = (List)destination$iv$iv;
            String string2 = string;
            stepData = new CompiledStep(string2, list);
        } else if (step2 instanceof FilteredStep) {
            stepData = this.compileFilteredStep((FilteredStep)step);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return stepData;
    }

    /*
     * WARNING - void declaration
     */
    private final StepData compileFilteredStep(FilteredStep step) {
        StepData stepData;
        if (this.knownFilters.contains(step.getFilter())) {
            CompiledStep compiledStep;
            if (Intrinsics.areEqual((Object)this.filterResults.get(step.getFilter()), (Object)FilterService.FilterResult.Irrelevant.INSTANCE)) {
                compiledStep = null;
            } else {
                List list;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = step.getElements();
                String string = step.getLabel();
                boolean $i$f$map22 = false;
                void var5_9 = $this$map$iv;
                Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                    void it;
                    Element element = (Element)item$iv$iv2;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.compileElement((Element)it));
                }
                List $i$f$map22 = (List)destination$iv$iv;
                boolean bl = false;
                destination$iv$iv = step;
                if (destination$iv$iv instanceof Filtered) {
                    list = CollectionsKt.plus((Collection)((Collection)it), (Object)CompilerKt.verifyAction(((Filtered)step).getFilter()));
                } else if (destination$iv$iv instanceof RelevanceOnly) {
                    list = it;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                List list2 = list;
                String string2 = string;
                compiledStep = new CompiledStep(string2, list2);
            }
            stepData = compiledStep;
        } else {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            if (this.throwOnMissingFilter) {
                throw new FilterService.UnknownFilterException(step.getFilter());
            }
            Iterable iterable = step.getElements();
            String string = step.getLabel();
            boolean $i$f$map = false;
            void it = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                Element item$iv$iv2 = (Element)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.compileElement((Element)it2));
            }
            List list = (List)destination$iv$iv;
            String string3 = string;
            stepData = new CompiledStep(string3, list);
        }
        return stepData;
    }

    @NotNull
    public final StepElementData compileElement(@NotNull Element element) {
        StepElementData stepElementData;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Element element2 = element;
        if (element2 instanceof Text) {
            stepElementData = new StepElement(StepElementType.SECTION, null, null, ((Text)element).getBody(), null, null, null, 118, null);
        } else if (element2 instanceof Image) {
            stepElementData = new StepElement(StepElementType.IMAGE, null, null, null, null, new DefaultTutorialBundle.Image(((Image)element).getSource(), ((Image)element).getDescription(), ((Image)element).getHeight(), ((Image)element).getWidth()), null, 94, null);
        } else if (element2 instanceof Code) {
            LanguageFileType languageFileType;
            String string = ((Code)element).getBody();
            Code code = (Code)element;
            if (code instanceof Java) {
                languageFileType = (LanguageFileType)JavaFileType.INSTANCE;
            } else if (code instanceof Kotlin) {
                languageFileType = (LanguageFileType)KotlinFileType.INSTANCE;
            } else if (code instanceof Shell) {
                languageFileType = FileTypes.PLAIN_TEXT;
            } else if (code instanceof Xml) {
                languageFileType = (LanguageFileType)XmlFileType.INSTANCE;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            stepElementData = new StepElement(StepElementType.CODE, string, (FileType)languageFileType, null, null, null, null, 120, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return stepElementData;
    }

    public Compiler() {
        this(null, null, false, 7, null);
    }
}

