/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.doxygen.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.doxygen.psi.DxDocTag;
import com.jetbrains.cidr.doxygen.psi.DxParam;
import com.jetbrains.cidr.doxygen.psi.DxParamId;
import com.jetbrains.cidr.doxygen.psi.DxTypes;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class DxPsiImplUtil {
    public static final String UNKNOWN = "<unknown>";

    @NotNull
    public static String getName(@NotNull DxDocTag docTag) {
        int idx;
        String name;
        if (docTag == null) {
            DxPsiImplUtil.$$$reportNull$$$0(0);
        }
        if ((name = DxPsiImplUtil.getOriginalName(docTag)).startsWith("\\") || name.startsWith("@")) {
            name = name.substring(1);
        }
        if ((idx = name.indexOf(123)) != -1) {
            name = name.substring(0, idx);
        }
        String string = name;
        if (string == null) {
            DxPsiImplUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    @NonNls
    public static String getOriginalName(@NotNull DxDocTag docTag) {
        ASTNode tagName;
        if (docTag == null) {
            DxPsiImplUtil.$$$reportNull$$$0(2);
        }
        return (tagName = docTag.getNode().findChildByType(DxTypes.TAG_NAME)) != null ? tagName.getText() : UNKNOWN;
    }

    @NotNull
    public static String getName(@NotNull DxParamId element) {
        if (element == null) {
            DxPsiImplUtil.$$$reportNull$$$0(3);
        }
        String string = element.getText();
        if (string == null) {
            DxPsiImplUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static PsiElement setName(@NotNull DxParamId element, @NotNull String newName) {
        ASTNode node;
        if (element == null) {
            DxPsiImplUtil.$$$reportNull$$$0(5);
        }
        if (newName == null) {
            DxPsiImplUtil.$$$reportNull$$$0(6);
        }
        if ((node = element.getNode().findChildByType(DxTypes.TAG_PARAM)) instanceof LeafElement) {
            ((LeafElement)node).replaceWithText(newName);
            DxParamId dxParamId = element;
            if (dxParamId == null) {
                DxPsiImplUtil.$$$reportNull$$$0(7);
            }
            return dxParamId;
        }
        throw new IncorrectOperationException();
    }

    @Nullable
    public static PsiElement getNameIdentifier(@NotNull DxParamId element) {
        ASTNode node;
        if (element == null) {
            DxPsiImplUtil.$$$reportNull$$$0(8);
        }
        return (node = element.getNode().findChildByType(DxTypes.TAG_PARAM)) != null ? node.getPsi() : null;
    }

    @NotNull
    public static List<String> getOptions(@NotNull PsiElement element) {
        ASTNode tagName;
        if (element == null) {
            DxPsiImplUtil.$$$reportNull$$$0(9);
        }
        if ((tagName = element.getNode().findChildByType(DxTypes.TAG_OPTION)) != null) {
            List<String> list = DxPsiImplUtil.extractOptions(tagName);
            if (list == null) {
                DxPsiImplUtil.$$$reportNull$$$0(10);
            }
            return list;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            DxPsiImplUtil.$$$reportNull$$$0(11);
        }
        return list;
    }

    public static @Unmodifiable List<String> extractOptions(@NotNull ASTNode tagName) {
        if (tagName == null) {
            DxPsiImplUtil.$$$reportNull$$$0(12);
        }
        String text = tagName.getText().trim();
        text = StringUtil.substringAfter((String)text, (String)"[");
        text = StringUtil.substringBefore((String)text, (String)"]");
        return ContainerUtil.map((Collection)StringUtil.split((String)text, (String)","), s -> {
            if ((s = s.trim()).startsWith("*")) {
                s = StringUtil.substringAfter((String)s, (String)"*");
            }
            if (s.endsWith("*")) {
                s = StringUtil.substringBefore((String)s, (String)"*");
            }
            return s.trim();
        });
    }

    public static String getName(@NotNull DxParam element) {
        DxParamId id;
        if (element == null) {
            DxPsiImplUtil.$$$reportNull$$$0(13);
        }
        boolean hasEllipsis = element.getNode().findChildByType(DxTypes.ELLIPSIS) != null;
        Object name = "";
        if (hasEllipsis) {
            name = "...";
        }
        if ((id = element.getParamId()) != null) {
            name = (String)name + id.getName();
        }
        return name;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 7, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docTag";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/doxygen/psi/impl/DxPsiImplUtil";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/doxygen/psi/impl/DxPsiImplUtil";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "setName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 11: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalName";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNameIdentifier";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getOptions";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "extractOptions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 7, 10, 11 -> new IllegalStateException(string);
        };
    }
}

