/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.tracer.agent;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

class TraceProfile {
    private final MethodSet start = new MethodSet();
    private final MethodSet trace = new MethodSet();
    private final MethodSet flush = new MethodSet();
    private String outputFile = this.getDefaultOutputPath();
    private final Set<String> annotations;
    private String jvmArgs;
    private boolean traceAgent;

    public TraceProfile(String configFile) {
        this.jvmArgs = TraceProfile.initJvmArgs(configFile);
        this.annotations = new HashSet<String>();
        this.annotations.add("Lcom/android/annotations/Trace;");
        if (configFile == null || !Files.exists(Paths.get(configFile, new String[0]), new LinkOption[0])) {
            return;
        }
        try (BufferedReader br = new BufferedReader(new FileReader(configFile));){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.trim().isEmpty() || line.trim().startsWith("#")) continue;
                int i = line.indexOf(58);
                if (i == -1) {
                    throw new IllegalArgumentException("Malformed line: " + line);
                }
                String key = line.substring(0, i);
                Object value = line.substring(i + 1).trim();
                if (key.equals("Trace")) {
                    this.trace.add((String)value);
                    continue;
                }
                if (key.equals("Flush")) {
                    this.trace.add((String)value);
                    this.flush.add((String)value);
                    continue;
                }
                if (key.equals("Start")) {
                    this.trace.add((String)value);
                    this.start.add((String)value);
                    continue;
                }
                if (key.equals("Output")) {
                    this.outputFile = value;
                    continue;
                }
                if (key.equals("OutputEnvVar")) {
                    String outputDir = System.getenv((String)value);
                    if (outputDir == null || outputDir.isEmpty()) {
                        throw new RuntimeException("OutputEnvVar specified in trace file, but value not set.");
                    }
                    this.outputFile = new File(outputDir, "report.json").getPath();
                    continue;
                }
                if (key.equals("Annotation")) {
                    value = "L" + ((String)value).replaceAll("\\.", "/") + ";";
                    this.annotations.add((String)value);
                    continue;
                }
                if (!key.equals("Trace-Agent")) continue;
                this.traceAgent = Boolean.valueOf((String)value);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getDefaultOutputPath() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.indexOf("win") >= 0) {
            String tmp = System.getProperty("java.io.tmpdir");
            return new File(tmp, "report.json").getAbsolutePath();
        }
        return "/tmp/report.json";
    }

    private static String initJvmArgs(String path) {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        List<String> jvmArgs = runtimeMXBean.getInputArguments();
        for (String arg : jvmArgs) {
            if (!arg.startsWith("-javaagent:") || !arg.contains("trace_agent.jar")) continue;
            String value = arg.substring(11);
            int ix = value.indexOf(61);
            String agent = value;
            Object param = null;
            if (ix != -1) {
                agent = value.substring(0, ix);
                param = value.substring(ix + 1);
            }
            if (!Objects.equals(path, param)) continue;
            param = param != null ? "=" + String.valueOf(Paths.get((String)param, new String[0]).toAbsolutePath()) : "";
            return "-javaagent:" + String.valueOf(Paths.get(agent, new String[0]).toAbsolutePath()) + (String)param;
        }
        return "";
    }

    public boolean shouldTransform(String className) {
        return !this.annotations.isEmpty() || this.trace.containsClass(className) || this.flush.containsClass(className) || this.start.containsClass(className);
    }

    public boolean shouldInstrument(String annotation) {
        return this.annotations.contains(annotation);
    }

    public boolean shouldInstrument(String className, String method) {
        return this.trace.contains(className, method);
    }

    public boolean shouldFlush(String className, String method) {
        return this.flush.contains(className, method);
    }

    public boolean start(String className, String method) {
        return this.start.contains(className, method);
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public String getJvmArgs() {
        return this.jvmArgs;
    }

    public boolean traceAgent() {
        return this.traceAgent;
    }

    private static class MethodSet {
        private final Map<String, Set<String>> classes;
        private final Map<String, Set<String>> packages = new HashMap<String, Set<String>>();

        public MethodSet() {
            this.classes = new HashMap<String, Set<String>>();
        }

        void add(String spec) {
            int j = spec.indexOf("::");
            String className = spec;
            String methodName = "*";
            boolean exact = true;
            if (j != -1) {
                className = spec.substring(0, j);
                methodName = spec.substring(j + 2);
            }
            if (className.endsWith(".*")) {
                exact = false;
                className = className.substring(0, className.length() - 2);
            }
            className = className.replaceAll("\\.", "/");
            if (exact) {
                this.classes.computeIfAbsent(className, s -> new HashSet()).add(methodName);
            } else {
                this.packages.computeIfAbsent(className, s -> new HashSet()).add(methodName);
            }
        }

        boolean contains(String className, String methodName) {
            String pkg;
            Set<String> packageMethods;
            Set<String> classMethods = this.classes.get(className);
            if (classMethods != null && (classMethods.contains(methodName) || classMethods.contains("*"))) {
                return true;
            }
            int ix = className.lastIndexOf(47);
            return ix != -1 && (packageMethods = this.packages.get(pkg = className.substring(0, ix))) != null && (packageMethods.contains(methodName) || packageMethods.contains("*"));
        }

        boolean containsClass(String className) {
            if (this.classes.get(className) != null) {
                return true;
            }
            int ix = className.lastIndexOf(47);
            if (ix != -1) {
                String pkg = className.substring(0, ix);
                return this.packages.get(pkg) != null;
            }
            return false;
        }
    }
}

