/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.util;

import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.rendering.parsers.PsiXmlFile;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.TargetSelectionMode;
import com.android.tools.idea.util.CommonAndroidUtil;
import com.android.tools.rendering.AndroidXmlFiles;
import com.android.tools.rendering.HtmlLinkManager;
import com.android.utils.HtmlBuilder;
import com.intellij.CommonBundle;
import com.intellij.execution.RunManager;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.lang.java.JavaParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.java.IKeywordElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBHtmlPane;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidFacetProperties;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.LinkHandler;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidUtils
extends CommonAndroidUtil {
    @NonNls
    public static final String NAMESPACE_KEY = "android";
    @NonNls
    public static final String SYSTEM_RESOURCE_PACKAGE = "android";
    @NonNls
    public static final String VIEW_CLASS_NAME = "android.view.View";
    @NonNls
    public static final String APPLICATION_CLASS_NAME = "android.app.Application";
    @NonNls
    public static final String ACTIVITY_BASE_CLASS_NAME = "android.app.Activity";
    @NonNls
    public static final String R_CLASS_NAME = "R";
    @NonNls
    public static final String MANIFEST_CLASS_NAME = "Manifest";
    @NonNls
    public static final String LAUNCH_ACTION_NAME = "android.intent.action.MAIN";
    @NonNls
    public static final String LAUNCH_CATEGORY_NAME = "android.intent.category.LAUNCHER";
    @NonNls
    public static final String LEANBACK_LAUNCH_CATEGORY_NAME = "android.intent.category.LEANBACK_LAUNCHER";
    @NonNls
    public static final String DEFAULT_CATEGORY_NAME = "android.intent.category.DEFAULT";
    @NonNls
    public static final String INSTRUMENTATION_RUNNER_BASE_CLASS = "android.app.Instrumentation";
    @NonNls
    public static final String SERVICE_CLASS_NAME = "android.app.Service";
    @NonNls
    public static final String RECEIVER_CLASS_NAME = "android.content.BroadcastReceiver";
    @NonNls
    public static final String PROVIDER_CLASS_NAME = "android.content.ContentProvider";
    @NonNls
    public static final String TAG_LINEAR_LAYOUT = "LinearLayout";
    private static final int PACKAGE_LENGTH_LIMIT = 100;

    private AndroidUtils() {
    }

    public boolean isAndroidProject(@NotNull Project project) {
        return ProjectSystemUtil.getProjectSystem(project).isAndroidProject();
    }

    @Nullable
    public static <T extends DomElement> T loadDomElement(@NotNull Module module, @NotNull VirtualFile file, @NotNull Class<T> aClass) {
        return AndroidUtils.loadDomElement(module.getProject(), file, aClass);
    }

    @Nullable
    public static <T extends DomElement> T loadDomElement(@NotNull Project project, @NotNull VirtualFile file, @NotNull Class<T> aClass) {
        return (T)((DomElement)ApplicationManager.getApplication().runReadAction(() -> {
            if (project.isDisposed() || !file.isValid()) {
                return null;
            }
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            if (psiFile instanceof XmlFile) {
                return AndroidUtils.loadDomElementWithReadPermission(project, (XmlFile)psiFile, aClass);
            }
            return null;
        }));
    }

    @Nullable
    public static <T extends DomElement> T loadDomElementWithReadPermission(@NotNull Project project, @NotNull XmlFile xmlFile, @NotNull Class<T> aClass) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ProgressManager.checkCanceled();
        DomManager domManager = DomManager.getDomManager((Project)project);
        ProgressManager.checkCanceled();
        DomFileElement element = domManager.getFileElement(xmlFile, aClass);
        return (T)(element == null ? null : element.getRootElement());
    }

    public static boolean isAbstract(@NotNull PsiClass c) {
        return c.isInterface() || c.hasModifierProperty("abstract");
    }

    @Nullable
    public static Module getAndroidModule(ConfigurationContext context) {
        Module module = context.getModule();
        if (module == null || AndroidFacet.getInstance((Module)module) == null) {
            return null;
        }
        return module;
    }

    public static VirtualFile createChildDirectoryIfNotExist(Project project, VirtualFile parent, String name2) throws IOException {
        VirtualFile child = parent.findChild(name2);
        return child == null ? parent.createChildDirectory((Object)project, name2) : child;
    }

    @NotNull
    public static String getSimpleNameByRelativePath(@NotNull String relativePath) {
        int index = (relativePath = FileUtil.toSystemIndependentName((String)relativePath)).lastIndexOf(47);
        if (index < 0) {
            return relativePath;
        }
        return relativePath.substring(index + 1);
    }

    @Nullable
    public static String getUnqualifiedName(@NotNull String qualifiedName) {
        int start2 = qualifiedName.lastIndexOf(46);
        if (start2 == -1 || start2 + 1 == qualifiedName.length()) {
            return null;
        }
        return qualifiedName.substring(start2 + 1);
    }

    public static void setUpAndroidFacetConfiguration(@NotNull Module module, @NotNull AndroidFacetConfiguration androidFacetConfiguration, @NotNull String baseDirectoryPath) {
        String s = AndroidRootUtil.getPathRelativeToModuleDir(module, baseDirectoryPath);
        if (s == null || s.isEmpty()) {
            return;
        }
        AndroidFacetProperties properties = androidFacetConfiguration.getState();
        properties.GEN_FOLDER_RELATIVE_PATH_APT = "/" + s + properties.GEN_FOLDER_RELATIVE_PATH_APT;
        properties.GEN_FOLDER_RELATIVE_PATH_AIDL = "/" + s + properties.GEN_FOLDER_RELATIVE_PATH_AIDL;
        properties.MANIFEST_FILE_RELATIVE_PATH = "/" + s + properties.MANIFEST_FILE_RELATIVE_PATH;
        properties.RES_FOLDER_RELATIVE_PATH = "/" + s + properties.RES_FOLDER_RELATIVE_PATH;
        properties.ASSETS_FOLDER_RELATIVE_PATH = "/" + s + properties.ASSETS_FOLDER_RELATIVE_PATH;
        properties.LIBS_FOLDER_RELATIVE_PATH = "/" + s + properties.LIBS_FOLDER_RELATIVE_PATH;
        properties.PROGUARD_LOGS_FOLDER_RELATIVE_PATH = "/" + s + properties.PROGUARD_LOGS_FOLDER_RELATIVE_PATH;
        properties.RES_OVERLAY_FOLDERS.replaceAll(overlayFolder -> "/" + s + overlayFolder);
    }

    @Nullable
    public static TargetSelectionMode getDefaultTargetSelectionMode(@NotNull Project project, @NotNull ConfigurationType type, @NonNls ConfigurationType alternativeType) {
        AndroidRunConfigurationBase runConfig;
        RunManager runManager = RunManager.getInstance((Project)project);
        List configurations = runManager.getConfigurationsList(type);
        TargetSelectionMode alternative = null;
        if (!configurations.isEmpty()) {
            for (RunConfiguration configuration2 : configurations) {
                if (!(configuration2 instanceof AndroidRunConfigurationBase)) continue;
                runConfig = (AndroidRunConfigurationBase)configuration2;
                alternative = runConfig.getDeployTargetContext().getTargetSelectionMode();
            }
        }
        if (alternative != null) {
            return alternative;
        }
        configurations = runManager.getConfigurationsList(alternativeType);
        if (!configurations.isEmpty()) {
            for (RunConfiguration configuration2 : configurations) {
                if (!(configuration2 instanceof AndroidRunConfigurationBase)) continue;
                runConfig = (AndroidRunConfigurationBase)configuration2;
                return runConfig.getDeployTargetContext().getTargetSelectionMode();
            }
        }
        return null;
    }

    public static boolean equalIgnoringDelimiters(@NotNull String s1, @NotNull String s2) {
        if (s1.length() != s2.length()) {
            return false;
        }
        int n = s1.length();
        for (int i = 0; i < n; ++i) {
            char c1 = s1.charAt(i);
            char c2 = s2.charAt(i);
            if (!Character.isLetterOrDigit(c1) && !Character.isLetterOrDigit(c2) || c1 == c2) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkNewPassword(JPasswordField passwordField, JPasswordField confirmedPasswordField) throws CommitStepException {
        char[] password = passwordField.getPassword();
        char[] confirmedPassword = confirmedPasswordField.getPassword();
        try {
            AndroidUtils.checkPassword(password);
            if (password.length < 6) {
                throw new CommitStepException(AndroidBundle.message("android.export.package.incorrect.password.length", new Object[0]));
            }
            if (!Arrays.equals(password, confirmedPassword)) {
                throw new CommitStepException(AndroidBundle.message("android.export.package.passwords.not.match.error", new Object[0]));
            }
        }
        finally {
            Arrays.fill(password, '\u0000');
            Arrays.fill(confirmedPassword, '\u0000');
        }
    }

    public static void checkPassword(char[] password) throws CommitStepException {
        if (password.length == 0) {
            throw new CommitStepException(AndroidBundle.message("android.export.package.specify.password.error", new Object[0]));
        }
    }

    public static void reportError(@NotNull Project project, @NotNull String message) {
        AndroidUtils.reportError(project, message, CommonBundle.getErrorTitle());
    }

    public static void reportError(@NotNull Project project, @NotNull String message, @NotNull String title2) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw new IncorrectOperationException(message);
        }
        Messages.showErrorDialog((Project)project, (String)message, (String)title2);
    }

    @NotNull
    private static String createOpenStackUrl(@NotNull String className, @NotNull String methodName, @NotNull String fileName, int lineNumber) {
        return "open:" + className + "#" + methodName + ";" + fileName + ":" + lineNumber;
    }

    private static HtmlBuilder getClickableStackTrace(Throwable throwable, HtmlBuilder builder) {
        int indent = 2;
        builder.addHtml(StringUtil.replace((String)throwable.toString(), (String)"\n", (String)"<BR/>")).newline();
        StackTraceElement[] frames = throwable.getStackTrace();
        for (int i = 0; i < frames.length; ++i) {
            StackTraceElement frame = frames[i];
            String className = frame.getClassName();
            String methodName = frame.getMethodName();
            builder.addNbsps(indent);
            builder.add("at ").add(className).add(".").add(methodName);
            String fileName = frame.getFileName();
            if (fileName != null && !fileName.isEmpty()) {
                int lineNumber = frame.getLineNumber();
                String location = fileName + ":" + lineNumber;
                String url = AndroidUtils.createOpenStackUrl(className, methodName, fileName, lineNumber);
                builder.add("(").addLink(location, url).add(")");
            }
            builder.newline();
        }
        return builder;
    }

    public static void showStackStace(@Nullable Module module, @NotNull Throwable[] throwables, PsiFile file, HtmlLinkManager linkManager) {
        final LinkHandler hyperlinkListener = new LinkHandler(linkManager, null, module, file);
        Project project = module.getProject();
        HtmlBuilder htmlBuilder = new HtmlBuilder();
        htmlBuilder.openHtmlBody();
        for (Throwable t : throwables) {
            if (htmlBuilder.toString().length() > 0) {
                htmlBuilder.add("\n\n");
            }
            htmlBuilder = AndroidUtils.getClickableStackTrace(t, htmlBuilder);
        }
        htmlBuilder.closeHtmlBody();
        final HtmlBuilder finalHtmlBuilder = htmlBuilder;
        DialogWrapper wrapper = new DialogWrapper(project, false){
            {
                super(project, canBeParent);
                this.init();
                this.setSize(1000, 700);
            }

            protected Action @NotNull [] createActions() {
                return new Action[]{this.getCancelAction()};
            }

            protected void createDefaultActions() {
                super.createDefaultActions();
                this.myCancelAction.putValue("Name", "Close");
            }

            protected JComponent createCenterPanel() {
                JPanel contentPanel = new JPanel(new BorderLayout());
                JBHtmlPane descriptionEditorPane = new JBHtmlPane();
                descriptionEditorPane.addHyperlinkListener(e -> {
                    hyperlinkListener.hyperlinkUpdate(e);
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        this.close(0);
                    }
                });
                contentPanel.add((Component)descriptionEditorPane, "North");
                contentPanel.add(ScrollPaneFactory.createScrollPane((Component)descriptionEditorPane));
                descriptionEditorPane.setText(finalHtmlBuilder.getHtml());
                return contentPanel;
            }
        };
        wrapper.setTitle("Stack Trace");
        wrapper.show();
    }

    public static boolean isValidAndroidPackageName(@NotNull String name2) {
        return AndroidUtils.validateAndroidPackageName(name2) == null;
    }

    public static boolean isValidJavaPackageName(@NotNull String name2) {
        int index = 0;
        while (true) {
            int index1;
            if ((index1 = name2.indexOf(46, index)) < 0) {
                index1 = name2.length();
            }
            if (!AndroidUtils.isIdentifier(name2.substring(index, index1))) {
                return false;
            }
            if (index1 == name2.length()) {
                return true;
            }
            index = index1 + 1;
        }
    }

    @Nullable
    public static String validateAndroidPackageName(@NotNull String name2) {
        if (name2.isEmpty()) {
            return "Package name is missing";
        }
        String packageManagerCheck = AndroidUtils.validateName(name2);
        if (packageManagerCheck != null) {
            return packageManagerCheck;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        int index = 0;
        while (true) {
            String error;
            int index1;
            if ((index1 = name2.indexOf(46, index)) < 0) {
                index1 = name2.length();
            }
            if ((error = AndroidUtils.isReservedKeyword(name2.substring(index, index1))) != null) {
                return error;
            }
            if (index1 == name2.length()) break;
            index = index1 + 1;
        }
        return null;
    }

    @Nullable
    public static String validatePackageName(@Nullable String packageName) {
        String string = packageName = packageName == null ? "" : packageName;
        if (packageName.length() >= 100) {
            return AndroidBundle.message("android.wizard.module.package.too.long", new Object[0]);
        }
        return AndroidUtils.validateAndroidPackageName(packageName);
    }

    @Nullable
    public static String isReservedKeyword(@NotNull String string) {
        Lexer lexer = LazyHolder.JAVA_LEXER;
        lexer.start((CharSequence)string);
        if (lexer.getTokenType() != JavaTokenType.IDENTIFIER) {
            if (lexer.getTokenType() instanceof IKeywordElementType) {
                return "Package names cannot contain Java keywords like '" + string + "'";
            }
            if (string.isEmpty()) {
                return "Package segments must be of non-zero length";
            }
            return string + " is not a valid identifier";
        }
        return null;
    }

    @Nullable
    private static String validateName(String name2) {
        int N = name2.length();
        boolean hasSep = false;
        boolean front = true;
        for (int i = 0; i < N; ++i) {
            char c = name2.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                front = false;
                continue;
            }
            if (c >= '0' && c <= '9' || c == '_') {
                if (!front) continue;
                if (c == '_') {
                    return "The character '_' cannot be the first character in a package segment";
                }
                return "A digit cannot be the first character in a package segment";
            }
            if (c == '.') {
                hasSep = true;
                front = true;
                continue;
            }
            return "The character '" + c + "' is not allowed in Android application package names";
        }
        return hasSep ? null : "The package must have at least one '.' separator";
    }

    public static boolean isIdentifier(@NotNull String candidate) {
        return StringUtil.isJavaIdentifier((String)candidate) && !PsiUtil.isKeyword((String)candidate, (LanguageLevel)LanguageLevel.JDK_1_5);
    }

    public static boolean isPackagePrefix(@NotNull String prefix, @NotNull String name2) {
        return name2.equals(prefix) || name2.startsWith(prefix + ".");
    }

    @NotNull
    public static List<String> urlsToOsPaths(@NotNull List<String> urls, @Nullable String sdkHomeCanonicalPath) {
        if (urls.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> result2 = new ArrayList<String>(urls.size());
        for (String url : urls) {
            if (sdkHomeCanonicalPath != null) {
                url = StringUtil.replace((String)url, (String)"%MODULE_SDK_HOME%", (String)sdkHomeCanonicalPath);
            }
            result2.add(FileUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)url)));
        }
        return result2;
    }

    @Nullable
    public static String getDeclaredContextFqcn(@NotNull Module module, @NotNull XmlFile xmlFile) {
        return AndroidXmlFiles.getDeclaredContextFqcn(ProjectSystemUtil.getModuleSystem(module).getPackageName(), new PsiXmlFile(xmlFile));
    }

    @Nullable
    public static PsiClass getContextClass(@NotNull Module module, @NotNull XmlFile xmlFile) {
        String fqn = AndroidUtils.getDeclaredContextFqcn(module, xmlFile);
        if (fqn != null) {
            Project project = module.getProject();
            return JavaPsiFacade.getInstance((Project)project).findClass(fqn, GlobalSearchScope.allScope((Project)project));
        }
        return null;
    }

    private static class LazyHolder {
        static final Lexer JAVA_LEXER = JavaParserDefinition.createLexer((LanguageLevel)LanguageLevel.JDK_1_5);

        private LazyHolder() {
        }
    }
}

