/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

@State(name="AndroidEditors", storages={@Storage(value="androidEditors.xml")})
public class AndroidEditorSettings
implements PersistentStateComponent<MyState> {
    public static final double MIN_MAGNIFY_SENSITIVITY = 0.1;
    public static final double MAX_MAGNIFY_SENSITIVITY = 2.1;
    public static final double DEFAULT_MAGNIFY_SENSITIVITY = 1.1;
    public static final EditorMode DEFAULT_PREFERRED_RESOURCE_EDITOR_MODE = EditorMode.DESIGN;
    public static final EditorMode DEFAULT_PREFERRED_CODE_EDITOR_MODE = EditorMode.CODE;
    public static final LayoutType DEFAULT_PREFERRED_PREVIEW_LAYOUT_TYPE = LayoutType.GRID;
    private GlobalState myGlobalState = new GlobalState();

    public static AndroidEditorSettings getInstance() {
        return (AndroidEditorSettings)ApplicationManager.getApplication().getService(AndroidEditorSettings.class);
    }

    @NotNull
    public GlobalState getGlobalState() {
        return this.myGlobalState;
    }

    public MyState getState() {
        MyState state2 = new MyState();
        state2.setState(this.myGlobalState);
        return state2;
    }

    public void loadState(@NotNull MyState state2) {
        this.myGlobalState = state2.getState();
    }

    public static class GlobalState {
        @NotNull
        private EditorMode myPreferredEditorMode = DEFAULT_PREFERRED_CODE_EDITOR_MODE;
        @NotNull
        private EditorMode myPreferredResourcesEditorMode = DEFAULT_PREFERRED_RESOURCE_EDITOR_MODE;
        @NotNull
        private LayoutType myPreferredLayoutType = DEFAULT_PREFERRED_PREVIEW_LAYOUT_TYPE;
        private double myMagnifySensitivity = 1.1;
        private boolean myPreviewEssentialsModeEnabled = false;
        private boolean myShowSplitViewForPreviewFiles = true;

        public EditorMode getPreferredEditorMode() {
            return this.myPreferredEditorMode;
        }

        public void setPreferredEditorMode(EditorMode preferredEditorMode) {
            this.myPreferredEditorMode = preferredEditorMode;
        }

        public EditorMode getPreferredResourcesEditorMode() {
            return this.myPreferredResourcesEditorMode;
        }

        public void setPreferredResourcesEditorMode(EditorMode preferredResourcesEditorMode) {
            this.myPreferredResourcesEditorMode = preferredResourcesEditorMode;
        }

        public boolean getShowSplitViewForPreviewFiles() {
            return this.myShowSplitViewForPreviewFiles;
        }

        public void setShowSplitViewForPreviewFiles(boolean showSplitViewForPreviewFiles) {
            this.myShowSplitViewForPreviewFiles = showSplitViewForPreviewFiles;
        }

        public void setPreferredPreviewLayoutMode(LayoutType preferredLayoutType) {
            this.myPreferredLayoutType = preferredLayoutType;
        }

        public LayoutType getPreferredPreviewLayoutMode() {
            return this.myPreferredLayoutType;
        }

        public double getMagnifySensitivity() {
            return this.myMagnifySensitivity;
        }

        public void setMagnifySensitivity(double magnifySensitivity) {
            this.myMagnifySensitivity = magnifySensitivity;
        }

        public boolean isPreviewEssentialsModeEnabled() {
            return this.myPreviewEssentialsModeEnabled;
        }

        public void setPreviewEssentialsModeEnabled(boolean previewEssentialsModeEnabled) {
            this.myPreviewEssentialsModeEnabled = previewEssentialsModeEnabled;
        }
    }

    public static class MyState {
        private GlobalState myGlobalState = new GlobalState();

        public GlobalState getState() {
            return this.myGlobalState;
        }

        public void setState(GlobalState state2) {
            this.myGlobalState = state2;
        }
    }

    public static enum EditorMode {
        CODE("Code", AllIcons.General.LayoutEditorOnly),
        SPLIT("Split", AllIcons.General.LayoutEditorPreview),
        DESIGN("Design", AllIcons.General.LayoutPreviewOnly);

        @NotNull
        private final String myDisplayName;
        @NotNull
        private final Icon myIcon;

        private EditorMode(String displayName, Icon icon) {
            this.myDisplayName = displayName;
            this.myIcon = icon;
        }

        @NotNull
        public String getDisplayName() {
            return this.myDisplayName;
        }

        @NotNull
        public Icon getIcon() {
            return this.myIcon;
        }
    }

    public static enum LayoutType {
        GRID("Grid"),
        GALLERY("Focus");

        @NotNull
        private final String myDisplayName;

        private LayoutType(String displayName) {
            this.myDisplayName = displayName;
        }

        @NotNull
        public String getDisplayName() {
            return this.myDisplayName;
        }
    }
}

