/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring.namespaces;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.gradle.dsl.android.model.android.AndroidModelUtilsKt;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.projectsystem.SourceProviderManager;
import com.android.tools.idea.res.AndroidDependenciesCache;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.android.tools.res.LocalResourceRepository;
import com.android.tools.res.ResourceNamespacing;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMigration;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.impl.migration.PsiMigrationManager;
import com.intellij.psi.impl.source.xml.SchemaPrefixReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.ui.UsageViewDescriptorAdapter;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.text.StringKt;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.WrappingConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.android.dom.converters.AndroidResourceReference;
import org.jetbrains.android.dom.converters.AttrNameConverter;
import org.jetbrains.android.dom.converters.ResourceReferenceConverter;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.refactoring.AndroidRefactoringUtilKt;
import org.jetbrains.android.refactoring.namespaces.CodeUsageInfo;
import org.jetbrains.android.refactoring.namespaces.DomValueUsageInfo;
import org.jetbrains.android.refactoring.namespaces.MigrateToResourceNamespacesKt;
import org.jetbrains.android.refactoring.namespaces.NamespacesRefactoringsUtilKt;
import org.jetbrains.android.refactoring.namespaces.ResourceUsageInfo;
import org.jetbrains.android.refactoring.namespaces.StyleItemUsageInfo;
import org.jetbrains.android.refactoring.namespaces.XmlAttributeUsageInfo;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0006\u001a\u0014 \t*\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\b0\u0007\u00a2\u0006\u0002\b\bH\u0016J\u0015\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000fH\u0014\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0003H\u0002J\u001b\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0014\u00a2\u0006\u0002\u0010\u001dJ\u0018\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0007H\u0002J \u0010\"\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u0007H\u0002J\u001c\u0010%\u001a\u00020&2\u0012\u0010'\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0(H\u0014J\u001b\u0010)\u001a\u00020*2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0014\u00a2\u0006\u0002\u0010+R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00030\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \t*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/android/refactoring/namespaces/MigrateToResourceNamespacesProcessor;", "Lcom/intellij/refactoring/BaseRefactoringProcessor;", "invokingFacet", "Lorg/jetbrains/android/facet/AndroidFacet;", "<init>", "(Lorg/jetbrains/android/facet/AndroidFacet;)V", "getCommandName", "", "Lorg/jetbrains/annotations/Nls;", "kotlin.jvm.PlatformType", "allFacets", "", "elementFactory", "Lcom/intellij/psi/XmlElementFactory;", "findUsages", "", "Lcom/intellij/usageView/UsageInfo;", "()[Lcom/intellij/usageView/UsageInfo;", "findResUsages", "", "Lorg/jetbrains/android/refactoring/namespaces/ResourceUsageInfo;", "findManifestUsages", "findXmlUsages", "xmlFile", "Lcom/intellij/psi/xml/XmlFile;", "currentFacet", "performRefactoring", "", "usages", "([Lcom/intellij/usageView/UsageInfo;)V", "findOrCreateNamespacePrefix", "tag", "Lcom/intellij/psi/xml/XmlTag;", "inferredPackage", "addXmlnsDeclaration", "prefix", "uri", "preprocessUsages", "", "refUsages", "Lcom/intellij/openapi/util/Ref;", "createUsageViewDescriptor", "Lcom/intellij/usageView/UsageViewDescriptor;", "([Lcom/intellij/usageView/UsageInfo;)Lcom/intellij/usageView/UsageViewDescriptor;", "intellij.android.projectSystem.gradle"})
@SourceDebugExtension(value={"SMAP\nMigrateToResourceNamespaces.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MigrateToResourceNamespaces.kt\norg/jetbrains/android/refactoring/namespaces/MigrateToResourceNamespacesProcessor\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,452:1\n37#2:453\n36#2,3:454\n13537#3,2:457\n13539#3:460\n1310#3,2:466\n1#4:459\n1878#5,3:461\n66#6,2:464\n*S KotlinDebug\n*F\n+ 1 MigrateToResourceNamespaces.kt\norg/jetbrains/android/refactoring/namespaces/MigrateToResourceNamespacesProcessor\n*L\n192#1:453\n192#1:454,3\n326#1:457,2\n326#1:460\n420#1:466,2\n386#1:461,3\n412#1:464,2\n*E\n"})
public final class MigrateToResourceNamespacesProcessor
extends BaseRefactoringProcessor {
    @NotNull
    private final AndroidFacet invokingFacet;
    @NotNull
    private final List<AndroidFacet> allFacets;
    private final XmlElementFactory elementFactory;

    public MigrateToResourceNamespacesProcessor(@NotNull AndroidFacet invokingFacet) {
        Intrinsics.checkNotNullParameter((Object)invokingFacet, (String)"invokingFacet");
        super(invokingFacet.getModule().getProject());
        this.invokingFacet = invokingFacet;
        List<AndroidFacet> list = AndroidDependenciesCache.getAllAndroidDependencies(this.invokingFacet.getModule(), true);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getAllAndroidDependencies(...)");
        this.allFacets = CollectionsKt.plus((Collection)list, (Object)this.invokingFacet);
        this.elementFactory = XmlElementFactory.getInstance((Project)this.myProject);
    }

    public String getCommandName() {
        return AndroidBundle.message("android.refactoring.migrateto.namespaces.title", new Object[0]);
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        progressIndicator.setText(AndroidBundle.message("android.refactoring.migrateto.namespaces.progress.analyze.xml", new Object[0]));
        List result2 = new ArrayList();
        CollectionsKt.addAll((Collection)result2, (Iterable)this.findResUsages());
        progressIndicator.setText(AndroidBundle.message("android.refactoring.migrateto.namespaces.progress.analyze.manifest", new Object[0]));
        CollectionsKt.addAll((Collection)result2, (Iterable)this.findManifestUsages());
        progressIndicator.setText(AndroidBundle.message("android.refactoring.migrateto.namespaces.progress.analyze.code", new Object[0]));
        CollectionsKt.addAll((Collection)result2, (Iterable)NamespacesRefactoringsUtilKt.findUsagesOfRClassesFromModule(this.invokingFacet));
        progressIndicator.setText(AndroidBundle.message("android.refactoring.migrateto.namespaces.progress.inferring", new Object[0]));
        progressIndicator.setText2(null);
        NamespacesRefactoringsUtilKt.inferPackageNames(result2, progressIndicator);
        progressIndicator.setText(null);
        Collection $this$toTypedArray$iv = result2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new ResourceUsageInfo[0]);
    }

    private final Collection<ResourceUsageInfo> findResUsages() {
        List result2 = new ArrayList();
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        PsiManager psiManager2 = psiManager;
        for (AndroidFacet facet : this.allFacets) {
            StudioResourceRepositoryManager repositoryManager;
            Intrinsics.checkNotNullExpressionValue((Object)StudioResourceRepositoryManager.getInstance(facet), (String)"getInstance(...)");
            if (repositoryManager.getNamespacing() != ResourceNamespacing.DISABLED) continue;
            for (VirtualFile resourceDir : repositoryManager.getModuleResources().getResourceDirs()) {
                VfsUtil.processFilesRecursively((VirtualFile)resourceDir, arg_0 -> MigrateToResourceNamespacesProcessor.findResUsages$lambda$1(arg_0 -> MigrateToResourceNamespacesProcessor.findResUsages$lambda$0(psiManager2, result2, this, facet, arg_0), arg_0));
            }
        }
        return result2;
    }

    private final Collection<ResourceUsageInfo> findManifestUsages() {
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        PsiManager psiManager2 = psiManager;
        List result2 = new ArrayList();
        for (AndroidFacet facet : this.allFacets) {
            Collection collection2 = result2;
            Intrinsics.checkNotNull((Object)facet);
            CollectionsKt.addAll((Collection)collection2, (Sequence)SequencesKt.flatMap((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence(SourceProviderManager.Companion.getInstance(facet).getSources().getManifestFiles()), arg_0 -> MigrateToResourceNamespacesProcessor.findManifestUsages$lambda$2(psiManager2, arg_0)), arg_0 -> MigrateToResourceNamespacesProcessor.findManifestUsages$lambda$3(this, facet, arg_0)));
        }
        return result2;
    }

    private final Collection<ResourceUsageInfo> findXmlUsages(XmlFile xmlFile, AndroidFacet currentFacet) {
        ProgressManager.checkCanceled();
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        progressIndicator.setText2(xmlFile.getVirtualFile().getPath());
        List result2 = new ArrayList();
        DomManager domManager = DomManager.getDomManager((Project)this.myProject);
        LocalResourceRepository<VirtualFile> localResourceRepository = StudioResourceRepositoryManager.getModuleResources(currentFacet);
        Intrinsics.checkNotNullExpressionValue(localResourceRepository, (String)"getModuleResources(...)");
        LocalResourceRepository<VirtualFile> moduleRepo = localResourceRepository;
        xmlFile.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(domManager, result2, moduleRepo){
            final /* synthetic */ DomManager $domManager;
            final /* synthetic */ List<ResourceUsageInfo> $result;
            final /* synthetic */ LocalResourceRepository<VirtualFile> $moduleRepo;
            {
                this.$domManager = $domManager;
                this.$result = $result;
                this.$moduleRepo = $moduleRepo;
            }

            public void visitXmlTag(XmlTag tag) {
                Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
                DomElement domElement = this.$domManager.getDomElement(tag);
                if (domElement instanceof GenericDomValue) {
                    this.handleGenericDomValue((GenericDomValue)domElement, (XmlElement)tag);
                }
                super.visitXmlTag(tag);
            }

            public void visitXmlAttribute(XmlAttribute attribute2) {
                Intrinsics.checkNotNullParameter((Object)attribute2, (String)"attribute");
                GenericAttributeValue domElement = this.$domManager.getDomElement(attribute2);
                if (domElement instanceof GenericDomValue) {
                    if (Intrinsics.areEqual((Object)attribute2.getNamespace(), (Object)"http://schemas.android.com/apk/res-auto")) {
                        ((Collection)this.$result).add(new XmlAttributeUsageInfo(attribute2));
                    }
                    this.handleGenericDomValue((GenericDomValue)domElement, (XmlElement)attribute2);
                }
                super.visitXmlAttribute(attribute2);
            }

            private final void handleGenericDomValue(GenericDomValue<?> domValue, XmlElement sourceXmlElement) {
                block8: {
                    String string;
                    XmlElement psiElement;
                    block10: {
                        block9: {
                            Converter converter;
                            block7: {
                                Converter converter2 = WrappingConverter.getDeepestConverter((Converter)domValue.getConverter(), domValue);
                                XmlElement xmlElement = DomUtil.getValueElement(domValue);
                                if (xmlElement == null) {
                                    return;
                                }
                                psiElement = xmlElement;
                                converter = converter2;
                                if (!(converter instanceof ResourceReferenceConverter)) break block7;
                                for (PsiReference reference : psiElement.getReferences()) {
                                    String name2;
                                    ResourceType resourceType;
                                    ResourceValue resourceValue;
                                    if (!(reference instanceof AndroidResourceReference)) continue;
                                    Intrinsics.checkNotNullExpressionValue((Object)((AndroidResourceReference)reference).getResourceValue(), (String)"getResourceValue(...)");
                                    if (resourceValue.getPackage() != null) continue;
                                    String string2 = resourceValue.getResourceType();
                                    if ((string2 != null ? StringsKt.startsWith$default((CharSequence)string2, (char)'+', (boolean)false, (int)2, null) : false) || StringKt.nullize((String)resourceValue.getResourceName(), (boolean)true) == null || resourceValue.getType() == null || !MigrateToResourceNamespacesProcessor.access$findXmlUsages$referenceNeedsRewriting(this.$moduleRepo, resourceType, name2)) continue;
                                    ((Collection)this.$result).add(new DomValueUsageInfo(resourceValue, (ResourceReferenceConverter)converter2, reference, sourceXmlElement));
                                }
                                break block8;
                            }
                            if (!(converter instanceof AttrNameConverter)) break block8;
                            string = domValue.getStringValue();
                            if (string == null) break block9;
                            String p0 = string;
                            boolean bl = false;
                            ResourceUrl resourceUrl = ResourceUrl.parseAttrReference((String)p0);
                            string = resourceUrl;
                            if (resourceUrl != null) break block10;
                        }
                        return;
                    }
                    String url = string;
                    if (((ResourceUrl)url).namespace == null) {
                        ResourceType resourceType = ((ResourceUrl)url).type;
                        Intrinsics.checkNotNullExpressionValue((Object)resourceType, (String)"type");
                        String string3 = ((ResourceUrl)url).name;
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"name");
                        if (MigrateToResourceNamespacesProcessor.access$findXmlUsages$referenceNeedsRewriting(this.$moduleRepo, resourceType, string3)) {
                            Collection collection2 = this.$result;
                            PsiElement $this$parentOfType_u24default$iv = (PsiElement)psiElement;
                            boolean withSelf$iv = false;
                            boolean $i$f$parentOfType = false;
                            PsiElement psiElement2 = PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, XmlAttribute.class, (boolean)true);
                            Intrinsics.checkNotNull((Object)psiElement2);
                            collection2.add(new StyleItemUsageInfo((XmlAttribute)psiElement2, (ResourceUrl)url));
                        }
                    }
                }
            }
        });
        progressIndicator.setText2(null);
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        progressIndicator.setIndeterminate(false);
        progressIndicator.setText(AndroidBundle.message("android.refactoring.migrateto.nontransitiverclass.progress.rewriting", new Object[0]));
        PsiMigration psiMigration = PsiMigrationManager.getInstance((Project)this.myProject).startMigration();
        Intrinsics.checkNotNullExpressionValue((Object)psiMigration, (String)"startMigration(...)");
        PsiMigration psiMigration2 = psiMigration;
        try {
            double totalUsages = usages.length;
            UsageInfo[] $this$forEachIndexed$iv = usages;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (UsageInfo usageInfo : $this$forEachIndexed$iv) {
                void usageInfo2;
                int n = index$iv++;
                UsageInfo usageInfo3 = usageInfo;
                int index = n;
                boolean bl = false;
                if (!(usageInfo2 instanceof ResourceUsageInfo)) {
                    throw new IllegalStateException(("Don't know how to handle " + usageInfo2.getClass().getName() + ".").toString());
                }
                if (((ResourceUsageInfo)usageInfo2).getInferredPackage() == null) continue;
                ResourceUsageInfo resourceUsageInfo = (ResourceUsageInfo)usageInfo2;
                if (resourceUsageInfo instanceof DomValueUsageInfo) {
                    XmlElement xmlElement;
                    String newStringValue;
                    XmlTag xmlTag;
                    XmlElement xmlElement2 = ((DomValueUsageInfo)usageInfo2).getXmlElement();
                    XmlElement xmlElement3 = xmlElement2;
                    if (xmlElement3 instanceof XmlTag) {
                        xmlTag = (XmlTag)xmlElement2;
                    } else {
                        if (!(xmlElement3 instanceof XmlAttribute)) continue;
                        xmlTag = ((XmlAttribute)xmlElement2).getParent();
                    }
                    XmlTag tag = xmlTag;
                    Intrinsics.checkNotNull((Object)tag);
                    String string = this.findOrCreateNamespacePrefix(tag, inferredPackage);
                    ResourceValue resourceValue = ((DomValueUsageInfo)usageInfo2).getResourceValue();
                    String string2 = ((DomValueUsageInfo)usageInfo2).getConverter().convertToString(ResourceValue.referenceTo(resourceValue.getPrefix(), string, resourceValue.getResourceType(), resourceValue.getResourceName()));
                    if (string2 == null) {
                        string2 = newStringValue = "";
                    }
                    if ((xmlElement = xmlElement2) instanceof XmlTag) {
                        ((XmlTag)xmlElement2).getValue().setText(newStringValue);
                    } else {
                        if (!(xmlElement instanceof XmlAttribute)) throw new IllegalStateException(("Don't know how to handle " + xmlElement2).toString());
                        ((XmlAttribute)xmlElement2).setValue(newStringValue);
                    }
                } else if (resourceUsageInfo instanceof XmlAttributeUsageInfo) {
                    Object object;
                    block21: {
                        XmlAttribute element;
                        PsiElement psiElement = ((XmlAttributeUsageInfo)usageInfo2).getElement();
                        if ((psiElement instanceof XmlAttribute ? (XmlAttribute)psiElement : null) == null) continue;
                        element = element;
                        XmlTag xmlTag = element.getParent();
                        Intrinsics.checkNotNullExpressionValue((Object)xmlTag, (String)"getParent(...)");
                        prefix = this.findOrCreateNamespacePrefix(xmlTag, inferredPackage);
                        PsiReference[] psiReferenceArray = element.getReferences();
                        Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
                        for (Object object2 : (Object[])psiReferenceArray) {
                            PsiReference it = (PsiReference)object2;
                            boolean bl2 = false;
                            if (!(it instanceof SchemaPrefixReference)) continue;
                            object = object2;
                            break block21;
                        }
                        object = null;
                    }
                    PsiReference psiReference = (PsiReference)object;
                    if (psiReference != null) {
                        psiReference.handleElementRename(prefix);
                    }
                } else if (resourceUsageInfo instanceof StyleItemUsageInfo) {
                    XmlTag tag = ((StyleItemUsageInfo)usageInfo2).getXmlAttribute().getParent();
                    Intrinsics.checkNotNull((Object)tag);
                    prefix = this.findOrCreateNamespacePrefix(tag, inferredPackage);
                    ResourceUrl resourceUrl = ResourceUrl.create((String)prefix, (ResourceType)ResourceType.ATTR, (String)((StyleItemUsageInfo)usageInfo2).getName());
                    ((StyleItemUsageInfo)usageInfo2).getXmlAttribute().setValue(resourceUrl.getQualifiedName());
                } else if (resourceUsageInfo instanceof CodeUsageInfo) {
                    ((CodeUsageInfo)usageInfo2).updateClassReference(psiMigration2);
                }
                progressIndicator.setFraction((double)(index + 1) / totalUsages);
            }
        }
        finally {
            psiMigration2.finish();
        }
        progressIndicator.setText("Updating Gradle build files...");
        progressIndicator.setFraction(0.0);
        ProjectBuildModel projectBuildModel = ProjectBuildModel.get(this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)projectBuildModel, (String)"get(...)");
        ProjectBuildModel projectBuildModel2 = projectBuildModel;
        double totalFacets = this.allFacets.size();
        Iterable $this$forEachIndexed$iv = this.allFacets;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object t : $this$forEachIndexed$iv) {
            GradleBuildModel moduleBuildModel;
            void facet;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            AndroidFacet index = (AndroidFacet)t;
            int index2 = n;
            boolean bl = false;
            if (projectBuildModel2.getModuleBuildModel(facet.getModule()) == null) continue;
            AndroidModelUtilsKt.android(moduleBuildModel).aaptOptions().namespaced().setValue(true);
            moduleBuildModel.applyChanges();
            progressIndicator.setFraction((double)(index2 + 1) / totalFacets);
        }
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        AndroidRefactoringUtilKt.syncBeforeFinishingRefactoring(project, GradleSyncStats.Trigger.TRIGGER_REFACTOR_MIGRATE_TO_RESOURCE_NAMESPACES, null);
    }

    private final String findOrCreateNamespacePrefix(XmlTag tag, String inferredPackage) {
        String string = tag.getPrefixByNamespace("http://schemas.android.com/apk/res/" + inferredPackage);
        if (string == null) {
            MigrateToResourceNamespacesProcessor $this$findOrCreateNamespacePrefix_u24lambda_u248 = this;
            boolean bl = false;
            Object newPrefix = null;
            newPrefix = MigrateToResourceNamespacesKt.access$choosePrefix(inferredPackage);
            String string2 = tag.getNamespaceByPrefix((String)newPrefix);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getNamespaceByPrefix(...)");
            if (((CharSequence)string2).length() > 0) {
                int i = 2;
                while (true) {
                    String string3 = tag.getNamespaceByPrefix("" + newPrefix + i);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getNamespaceByPrefix(...)");
                    if (!(((CharSequence)string3).length() > 0)) break;
                    ++i;
                }
                newPrefix = "" + newPrefix + i;
            }
            PsiElement $this$parentOfType_u24default$iv = (PsiElement)tag;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            XmlDocument xmlDocument = (XmlDocument)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, XmlDocument.class, (boolean)true);
            if (xmlDocument != null && (xmlDocument = xmlDocument.getRootTag()) != null) {
                XmlDocument it = xmlDocument;
                boolean bl2 = false;
                $this$findOrCreateNamespacePrefix_u24lambda_u248.addXmlnsDeclaration((XmlTag)it, (String)newPrefix, "http://schemas.android.com/apk/res/" + inferredPackage);
            }
            string = newPrefix;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final void addXmlnsDeclaration(XmlTag tag, String prefix, String uri) {
        Object v2;
        XmlTag xmlTag;
        PsiElement psiElement;
        block1: {
            void $this$firstOrNull$iv;
            PsiElement psiElement2 = (PsiElement)this.elementFactory.createAttribute("xmlns:" + prefix, uri, (PsiElement)tag);
            XmlAttribute[] xmlAttributeArray = tag.getAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)xmlAttributeArray, (String)"getAttributes(...)");
            Object[] objectArray = xmlAttributeArray;
            psiElement = psiElement2;
            xmlTag = tag;
            boolean $i$f$firstOrNull = false;
            for (void element$iv : $this$firstOrNull$iv) {
                XmlAttribute it = (XmlAttribute)element$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it.getNamespacePrefix(), (Object)"xmlns"))) continue;
                v2 = element$iv;
                break block1;
            }
            v2 = null;
        }
        Object var13_13 = v2;
        xmlTag.addBefore(psiElement, (PsiElement)var13_13);
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        boolean bl;
        Intrinsics.checkNotNullParameter(refUsages, (String)"refUsages");
        Object object = refUsages.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        if (!(((Object[])object).length == 0)) {
            bl = true;
        } else {
            Messages.showInfoMessage((Project)this.myProject, (String)"No cross-namespace resource references found", (String)AndroidBundle.message("android.refactoring.migrateto.namespaces.title", new Object[0]));
            bl = false;
        }
        return bl;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        return (UsageViewDescriptor)new UsageViewDescriptorAdapter(){

            public PsiElement[] getElements() {
                Intrinsics.checkNotNullExpressionValue((Object)PsiElement.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                return PsiElement.EMPTY_ARRAY;
            }

            public String getProcessedElementsHeader() {
                return AndroidBundle.message("android.refactoring.migrateto.resourceview.header", new Object[0]);
            }
        };
    }

    private static final boolean findResUsages$lambda$0(PsiManager $psiManager, List $result, MigrateToResourceNamespacesProcessor this$0, AndroidFacet $facet, VirtualFile vf) {
        PsiFile psiFile;
        if (FileTypeRegistry.getInstance().isFileOfType(vf, (FileType)XmlFileType.INSTANCE) && (psiFile = $psiManager.findFile(vf)) instanceof XmlFile) {
            Collection collection2 = $result;
            XmlFile xmlFile = (XmlFile)psiFile;
            Intrinsics.checkNotNull((Object)$facet);
            CollectionsKt.addAll((Collection)collection2, (Iterable)this$0.findXmlUsages(xmlFile, $facet));
        }
        return true;
    }

    private static final boolean findResUsages$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final XmlFile findManifestUsages$lambda$2(PsiManager $psiManager, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        PsiFile psiFile = $psiManager.findFile(it);
        return psiFile instanceof XmlFile ? (XmlFile)psiFile : null;
    }

    private static final Sequence findManifestUsages$lambda$3(MigrateToResourceNamespacesProcessor this$0, AndroidFacet $facet, XmlFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Intrinsics.checkNotNull((Object)$facet);
        return CollectionsKt.asSequence((Iterable)this$0.findXmlUsages(it, $facet));
    }

    private static final boolean findXmlUsages$referenceNeedsRewriting(LocalResourceRepository<VirtualFile> moduleRepo, ResourceType resourceType, String name2) {
        return !moduleRepo.hasResources(ResourceNamespace.RES_AUTO, resourceType, name2);
    }

    public static final /* synthetic */ boolean access$findXmlUsages$referenceNeedsRewriting(LocalResourceRepository moduleRepo, ResourceType resourceType, String name2) {
        return MigrateToResourceNamespacesProcessor.findXmlUsages$referenceNeedsRewriting(moduleRepo, resourceType, name2);
    }
}

