/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring.namespaces;

import com.android.resources.ResourceType;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMigration;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.android.refactoring.AndroidRefactoringUtil;
import org.jetbrains.android.refactoring.namespaces.ResourceUsageInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.refactoring.helper.KotlinOptimizeImportsRefactoringHelper;
import org.jetbrains.kotlin.idea.references.KtSimpleNameReference;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/android/refactoring/namespaces/CodeUsageInfo;", "Lorg/jetbrains/android/refactoring/namespaces/ResourceUsageInfo;", "fieldReferenceExpression", "Lcom/intellij/psi/PsiElement;", "classReference", "Lcom/intellij/psi/PsiReference;", "resourceType", "Lcom/android/resources/ResourceType;", "name", "", "<init>", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiReference;Lcom/android/resources/ResourceType;Ljava/lang/String;)V", "getClassReference", "()Lcom/intellij/psi/PsiReference;", "getResourceType", "()Lcom/android/resources/ResourceType;", "getName", "()Ljava/lang/String;", "updateClassReference", "", "psiMigration", "Lcom/intellij/psi/PsiMigration;", "isKotlinOptimizerCall", "", "getFile", "Lcom/intellij/psi/PsiFile;", "intellij.android.projectSystem.gradle"})
@SourceDebugExtension(value={"SMAP\nNamespacesRefactoringsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NamespacesRefactoringsUtil.kt\norg/jetbrains/android/refactoring/namespaces/CodeUsageInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,283:1\n1563#2:284\n1634#2,3:285\n1761#2,3:288\n*S KotlinDebug\n*F\n+ 1 NamespacesRefactoringsUtil.kt\norg/jetbrains/android/refactoring/namespaces/CodeUsageInfo\n*L\n125#1:284\n125#1:285,3\n126#1:288,3\n*E\n"})
public final class CodeUsageInfo
extends ResourceUsageInfo {
    @NotNull
    private final PsiReference classReference;
    @NotNull
    private final ResourceType resourceType;
    @NotNull
    private final String name;

    public CodeUsageInfo(@NotNull PsiElement fieldReferenceExpression, @NotNull PsiReference classReference, @NotNull ResourceType resourceType, @NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)fieldReferenceExpression, (String)"fieldReferenceExpression");
        Intrinsics.checkNotNullParameter((Object)classReference, (String)"classReference");
        Intrinsics.checkNotNullParameter((Object)resourceType, (String)"resourceType");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        super(fieldReferenceExpression);
        this.classReference = classReference;
        this.resourceType = resourceType;
        this.name = name2;
    }

    @NotNull
    public final PsiReference getClassReference() {
        return this.classReference;
    }

    @Override
    @NotNull
    public ResourceType getResourceType() {
        return this.resourceType;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    public final void updateClassReference(@NotNull PsiMigration psiMigration) {
        Intrinsics.checkNotNullParameter((Object)psiMigration, (String)"psiMigration");
        PsiReference reference = this.classReference;
        Project project = this.classReference.getElement().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        String string = this.getInferredPackage();
        if (string == null) {
            return;
        }
        String string2 = IdeResourcesUtil.packageToRClass(string);
        GlobalSearchScope globalSearchScope = reference.getElement().getResolveScope();
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getResolveScope(...)");
        PsiClass newRClass = AndroidRefactoringUtil.findOrCreateClass(project, psiMigration, string2, globalSearchScope);
        PsiElement psiElement = reference instanceof KtSimpleNameReference ? ((KtSimpleNameReference)reference).bindToElement((PsiElement)newRClass, KtSimpleNameReference.ShorteningMode.NO_SHORTENING) : reference.bindToElement((PsiElement)newRClass);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isKotlinOptimizerCall() {
        boolean bl;
        block4: {
            void $this$mapTo$iv$iv;
            StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
            Iterable $this$map$iv = ArraysKt.take((Object[])stackTraceElementArray, (int)5);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                StackTraceElement stackTraceElement = (StackTraceElement)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl2 = false;
                collection2.add(it.getClassName());
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(KotlinOptimizeImportsRefactoringHelper.class).getQualifiedName(), (Object)it)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Nullable
    public PsiFile getFile() {
        return this.classReference.getElement().getLanguage() instanceof KotlinLanguage && this.isKotlinOptimizerCall() ? null : super.getFile();
    }
}

