/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.intentions;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.configurations.Configuration;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.configurations.ConfigurationFileUtil;
import com.android.tools.idea.configurations.ConfigurationForFile;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.DefaultLintQuickFix;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.ui.designer.EditorDesignSurface;
import com.android.utils.Pair;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.codeInsight.intention.AbstractIntentionAction;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.actions.ElementCreator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.android.actions.CreateResourceDirectoryDialog;
import org.jetbrains.android.actions.ElementCreatingValidator;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OverrideResourceAction
extends AbstractIntentionAction {
    @VisibleForTesting
    @Nullable
    public static String ourTargetFolderName;

    @Nls
    @NotNull
    private static String getActionName(@NlsSafe @Nullable String folder) {
        return AndroidBundle.message("android.override.resource.in.intention.text", folder != null ? folder : AndroidBundle.message("android.other.configuration", new Object[0]));
    }

    @NotNull
    public String getText() {
        return OverrideResourceAction.getActionName(null);
    }

    public boolean startInWriteAction() {
        return false;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (file instanceof XmlFile && file.isValid() && AndroidFacet.getInstance((PsiElement)file) != null) {
            ResourceFolderType folderType = IdeResourcesUtil.getFolderType(file);
            if (folderType == null) {
                return false;
            }
            if (folderType != ResourceFolderType.VALUES) {
                return true;
            }
            return this.isAvailable(OverrideResourceAction.getValueTag(editor, file), file);
        }
        return false;
    }

    public boolean isAvailable(@Nullable XmlTag tag, PsiFile file) {
        if (file instanceof XmlFile && file.isValid() && AndroidFacet.getInstance((PsiElement)file) != null) {
            ResourceFolderType folderType = IdeResourcesUtil.getFolderType(file);
            if (folderType == null) {
                return false;
            }
            if (folderType != ResourceFolderType.VALUES) {
                return true;
            }
            if (tag != null && tag.getAttributeValue("name") != null) {
                return IdeResourcesUtil.getResourceTypeForResourceTag(tag) != null;
            }
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        ResourceFolderType folderType = IdeResourcesUtil.getFolderType(file);
        if (folderType == null) {
            return;
        }
        if (folderType != ResourceFolderType.VALUES) {
            OverrideResourceAction.forkResourceFile((XmlFile)file, null, true);
        } else if (editor != null) {
            OverrideResourceAction.forkResourceValue(project, editor, file, null, true);
        }
    }

    private static void forkResourceValue(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @Nullable PsiDirectory dir, boolean open2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        XmlTag tag = OverrideResourceAction.getValueTag(editor, file);
        if (tag == null) {
            return;
        }
        OverrideResourceAction.forkResourceValue(project, tag, file, dir, open2);
    }

    @Nullable
    private static PsiDirectory findRes(@NotNull PsiFile file) {
        PsiDirectory resourceFolder = file.getParent();
        return resourceFolder == null ? null : resourceFolder.getParent();
    }

    public static void forkResourceValue(@NotNull Project project, @NotNull XmlTag tag, @NotNull PsiFile file, @Nullable PsiDirectory dir, boolean open2) {
        PsiDirectory resFolder = OverrideResourceAction.findRes(file);
        if (resFolder == null) {
            return;
        }
        String name2 = tag.getAttributeValue("name");
        ResourceType type = IdeResourcesUtil.getResourceTypeForResourceTag(tag);
        if (name2 == null || type == null) {
            return;
        }
        if (dir == null) {
            dir = OverrideResourceAction.selectFolderDir(project, resFolder.getVirtualFile(), ResourceFolderType.VALUES);
        }
        if (dir != null) {
            String value2 = IdeResourcesUtil.getTextContent(tag).trim();
            OverrideResourceAction.createValueResource(project, resFolder, file, dir, name2, value2, type, tag.getText(), open2);
        }
    }

    @Nullable
    private static XmlTag getEditorTag(Editor editor, PsiFile file) {
        int offset = editor.getCaretModel().getOffset();
        PsiElement psiElement = file.findElementAt(offset);
        if (psiElement != null) {
            return (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)psiElement, XmlTag.class, (boolean)false);
        }
        return null;
    }

    @Nullable
    private static XmlTag getValueTag(Editor editor, PsiFile file) {
        return OverrideResourceAction.getValueTag(OverrideResourceAction.getEditorTag(editor, file));
    }

    @Nullable
    public static XmlTag getValueTag(@Nullable XmlTag tag) {
        XmlTag current = null;
        if (tag != null) {
            XmlTag parentParent;
            current = tag;
            XmlTag parent = current.getParentTag();
            while (parent != null && (parentParent = parent.getParentTag()) != null) {
                current = parent;
                parent = parentParent;
            }
        }
        return current;
    }

    private static void createValueResource(@NotNull Project project, @NotNull PsiDirectory resDir, @NotNull PsiFile file, @NotNull PsiDirectory resourceSubdir, @NotNull String resName, @NotNull String value2, @NotNull ResourceType type, @NotNull String oldTagText, boolean open2) {
        String filename = file.getName();
        List<String> dirNames = Collections.singletonList(resourceSubdir.getName());
        AtomicReference openAfter = new AtomicReference();
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{file}).withName("Override Resource " + resName).run(() -> {
            XmlTag tag;
            ArrayList elements = Lists.newArrayListWithExpectedSize((int)1);
            IdeResourcesUtil.createValueResource(project, resDir.getVirtualFile(), resName, type, filename, dirNames, value2, elements);
            if (elements.size() == 1 && (tag = ((ResourceElement)elements.get(0)).getXmlTag()) != null && tag.isValid()) {
                try {
                    XmlTag tagFromText = XmlElementFactory.getInstance((Project)tag.getProject()).createTagFromText((CharSequence)oldTagText);
                    PsiElement replaced = tag.replace((PsiElement)tagFromText);
                    openAfter.set(replaced);
                }
                catch (IncorrectOperationException e) {
                    openAfter.set(tag);
                }
            }
        });
        PsiElement tag = (PsiElement)openAfter.get();
        if (open2 && tag != null) {
            NavigationUtil.openFileWithPsiElement((PsiElement)tag, (boolean)true, (boolean)true);
        }
    }

    public static void forkResourceFile(@NotNull EditorDesignSurface surface, @Nullable String newFolder, boolean open2) {
        for (Configuration configuration2 : surface.getConfigurations()) {
            if (configuration2 == null) {
                assert (false);
                return;
            }
            VirtualFile file = ConfigurationFileUtil.getVirtualFile(configuration2);
            if (file == null) {
                assert (false);
                return;
            }
            Project project = ConfigurationManager.getFromConfiguration(configuration2).getProject();
            PsiFile psiFile = AndroidPsiUtils.getPsiFileSafely((Project)project, (VirtualFile)file);
            XmlFile xmlFile = (XmlFile)psiFile;
            ResourceFolderType folderType = IdeResourcesUtil.getFolderType((PsiFile)xmlFile);
            if (folderType == null) {
                folderType = ResourceFolderType.LAYOUT;
            }
            OverrideResourceAction.forkResourceFile(project, folderType, file, xmlFile, newFolder, configuration2, open2);
        }
    }

    public static void forkResourceFile(@NotNull XmlFile xmlFile, @Nullable String myNewFolder, boolean open2) {
        VirtualFile file = xmlFile.getVirtualFile();
        if (file == null) {
            return;
        }
        Module module = AndroidPsiUtils.getModuleSafely((PsiElement)xmlFile);
        if (module == null) {
            return;
        }
        ResourceFolderType folderType = IdeResourcesUtil.getFolderType((PsiFile)xmlFile);
        if (folderType == null || folderType == ResourceFolderType.VALUES) {
            return;
        }
        ConfigurationForFile configuration2 = null;
        AndroidFacet facet = AndroidFacet.getInstance((Module)module);
        if (facet != null) {
            configuration2 = ConfigurationManager.getOrCreateInstance(module).getConfiguration(file);
        }
        OverrideResourceAction.forkResourceFile(module.getProject(), folderType, file, xmlFile, myNewFolder, configuration2, open2);
    }

    private static void forkResourceFile(@NotNull Project project, @NotNull ResourceFolderType folderType, @NotNull VirtualFile file, @Nullable XmlFile xmlFile, @Nullable String myNewFolder, @Nullable Configuration configuration2, boolean open2) {
        FolderConfiguration folderConfig;
        if (myNewFolder == null) {
            VirtualFile parentFolder = file.getParent();
            assert (parentFolder != null);
            VirtualFile res2 = parentFolder.getParent();
            folderConfig = OverrideResourceAction.selectFolderConfig(project, res2, folderType);
        } else {
            folderConfig = FolderConfiguration.getConfigForFolder((String)myNewFolder);
        }
        if (folderConfig == null) {
            return;
        }
        Pair result2 = (Pair)WriteCommandAction.writeCommandAction((Project)project).withName("Add Resource").compute(() -> {
            String folderName = folderConfig.getFolderName(folderType);
            try {
                VirtualFile existing;
                VirtualFile parentFolder = file.getParent();
                assert (parentFolder != null);
                VirtualFile res2 = parentFolder.getParent();
                VirtualFile newParentFolder = res2.findChild(folderName);
                if (newParentFolder == null) {
                    try {
                        newParentFolder = res2.createChildDirectory((Object)res2, folderName);
                    }
                    catch (IncorrectOperationException e) {
                        String message = String.format("Could not create folder %1$s in %2$s, Reason:\n%3$s", folderName, res2.getPath(), e.getMessage());
                        return Pair.of((Object)message, null);
                    }
                }
                if ((existing = newParentFolder.findChild(file.getName())) != null && existing.exists()) {
                    String message = String.format("File 'res/%1$s/%2$s' already exists!", folderName, file.getName());
                    return Pair.of((Object)message, null);
                }
                String text2 = xmlFile != null && xmlFile.isValid() ? xmlFile.getText() : StreamUtil.readText((InputStream)file.getInputStream(), (String)"UTF-8");
                VirtualFile newFile = newParentFolder.createChildData((Object)newParentFolder, file.getName());
                VfsUtil.saveText((VirtualFile)newFile, (String)text2);
                return Pair.of(null, (Object)newFile);
            }
            catch (IOException e2) {
                String message = String.format("Failed to create File 'res/%1$s/%2$s' : %3$s", folderName, file.getName(), e2.getMessage());
                return Pair.of((Object)message, null);
            }
        });
        String error = (String)result2.getFirst();
        VirtualFile newFile = (VirtualFile)result2.getSecond();
        if (error != null) {
            ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Project)project, (String)error, (String)"Create Resource"));
        } else {
            if (configuration2 != null) {
                ConfigurationManager configurationManager = ConfigurationManager.getFromConfiguration(configuration2);
                configurationManager.createSimilar(newFile, file);
            }
            if (open2) {
                OpenFileDescriptor descriptor2 = new OpenFileDescriptor(project, newFile, -1);
                FileEditorManager.getInstance((Project)project).openEditor(descriptor2, true);
            }
        }
    }

    @Nullable
    public static PsiDirectory selectFolderDir(Project project, VirtualFile res2, ResourceFolderType folderType) {
        PsiDirectory directory = PsiManager.getInstance((Project)project).findDirectory(res2);
        if (directory == null) {
            return null;
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && ourTargetFolderName != null) {
            PsiDirectory subDirectory = directory.findSubdirectory(ourTargetFolderName);
            if (subDirectory != null) {
                return subDirectory;
            }
            Computable createDirComputable = () -> directory.createSubdirectory(ourTargetFolderName);
            return (PsiDirectory)ApplicationManager.getApplication().runWriteAction(createDirComputable);
        }
        CreateResourceDirectoryDialog dialog2 = new CreateResourceDirectoryDialog(project, null, folderType, directory, null, resDirectory -> new ResourceDirectorySelector(project, resDirectory), true);
        dialog2.setTitle("Select Resource Directory");
        if (!dialog2.showAndGet()) {
            return null;
        }
        PsiElement[] createdElements = dialog2.getCreatedElements();
        if (createdElements.length > 0) {
            return (PsiDirectory)createdElements[0];
        }
        return null;
    }

    @Nullable
    public static FolderConfiguration selectFolderConfig(Project project, VirtualFile res2, ResourceFolderType folderType) {
        PsiDirectory dir = OverrideResourceAction.selectFolderDir(project, res2, folderType);
        if (dir != null) {
            return FolderConfiguration.getConfigForFolder((String)dir.getName());
        }
        return null;
    }

    public static LintIdeQuickFix createFix(@Nullable String folder) {
        return new OverrideElementFix(folder);
    }

    private static class OverrideElementFix
    extends DefaultLintQuickFix {
        private final String myFolder;

        private OverrideElementFix(@Nullable String folder) {
            super(OverrideResourceAction.getActionName(folder));
            this.myFolder = folder;
        }

        public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
            ResourceFolderType folderType;
            PsiFile file = startElement.getContainingFile();
            if (file instanceof XmlFile && (folderType = IdeResourcesUtil.getFolderType(file)) != null) {
                if (folderType != ResourceFolderType.VALUES) {
                    OverrideResourceAction.forkResourceFile((XmlFile)file, this.myFolder, true);
                } else {
                    XmlTag tag = OverrideResourceAction.getValueTag((XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class, (boolean)false));
                    if (tag != null) {
                        PsiDirectory resFolder;
                        PsiDirectory dir = null;
                        if (this.myFolder != null && (resFolder = OverrideResourceAction.findRes(file)) != null && (dir = resFolder.findSubdirectory(this.myFolder)) == null) {
                            dir = resFolder.createSubdirectory(this.myFolder);
                        }
                        OverrideResourceAction.forkResourceValue(startElement.getProject(), tag, file, dir, true);
                    }
                }
            }
        }

        public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
            return true;
        }
    }

    private static class ResourceDirectorySelector
    extends ElementCreator
    implements ElementCreatingValidator {
        private final PsiDirectory myDirectory;
        private PsiElement[] myCreatedElements = PsiElement.EMPTY_ARRAY;

        public ResourceDirectorySelector(Project project, PsiDirectory directory) {
            super(project, "Select Resource Directory");
            this.myDirectory = directory;
        }

        public boolean checkInput(String inputString) {
            return ResourceFolderType.getFolderType((String)inputString) != null && FolderConfiguration.getConfigForFolder((String)inputString) != null;
        }

        public PsiElement[] create(String newName) throws Exception {
            PsiDirectory subdirectory = this.myDirectory.findSubdirectory(newName);
            if (subdirectory == null) {
                subdirectory = this.myDirectory.createSubdirectory(newName);
            }
            return new PsiElement[]{subdirectory};
        }

        public String getActionName(String newName) {
            return "Select Resource Directory";
        }

        public boolean canClose(String inputString) {
            PsiDirectory subdirectory = this.myDirectory.findSubdirectory(inputString);
            if (subdirectory != null) {
                this.myCreatedElements = new PsiDirectory[]{subdirectory};
                return true;
            }
            this.myCreatedElements = this.tryCreate(inputString);
            return this.myCreatedElements.length > 0;
        }

        @Override
        @NotNull
        public final PsiElement[] getCreatedElements() {
            return this.myCreatedElements;
        }
    }
}

