/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.intentions;

import com.google.common.collect.Iterables;
import com.intellij.codeInsight.intention.AbstractIntentionAction;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.ide.util.TreeJavaClassChooserDialog;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.Locale;
import org.jetbrains.android.dom.converters.OnClickConverter;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.intentions.GenerateUtilsKt;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidTreeClassChooserFactory;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPsiFactory;

public class AndroidCreateOnClickHandlerAction
extends AbstractIntentionAction
implements HighPriorityAction {
    @NotNull
    public String getText() {
        return AndroidBundle.message("create.on.click.handler.intention.text", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (editor == null || !(file instanceof XmlFile)) {
            return false;
        }
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)file);
        if (facet == null) {
            return false;
        }
        XmlAttributeValue attrValue = AndroidCreateOnClickHandlerAction.getXmlAttributeValue(file, editor);
        if (attrValue == null) {
            return false;
        }
        PsiElement parent = attrValue.getParent();
        if (!(parent instanceof XmlAttribute)) {
            return false;
        }
        GenericAttributeValue domValue = DomManager.getDomManager((Project)project).getDomElement((XmlAttribute)parent);
        if (domValue == null || !(domValue.getConverter() instanceof OnClickConverter)) {
            return false;
        }
        String methodName = attrValue.getValue();
        return methodName != null && StringUtil.isJavaIdentifier((String)methodName);
    }

    @Nullable
    private static XmlAttributeValue getXmlAttributeValue(PsiFile file, Editor editor) {
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        return element != null ? (XmlAttributeValue)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttributeValue.class) : null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiClass selectedClass;
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)file);
        assert (facet != null);
        XmlAttributeValue attrValue = AndroidCreateOnClickHandlerAction.getXmlAttributeValue(file, editor);
        assert (attrValue != null);
        String methodName = attrValue.getValue();
        assert (methodName != null);
        GenericAttributeValue domValue = DomManager.getDomManager((Project)project).getDomElement((XmlAttribute)attrValue.getParent());
        assert (domValue != null);
        OnClickConverter converter = (OnClickConverter)domValue.getConverter();
        PsiClass activityBaseClass = JavaPsiFacade.getInstance((Project)project).findClass("android.app.Activity", facet.getModule().getModuleWithDependenciesAndLibrariesScope(false));
        if (activityBaseClass == null) {
            return;
        }
        GlobalSearchScope scope = facet.getModule().getModuleScope(false);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            Ref selClassRef = Ref.create();
            ClassInheritorsSearch.search((PsiClass)activityBaseClass, (SearchScope)scope, (boolean)true, (boolean)true, (boolean)false).forEach(psiClass -> {
                if (!psiClass.isInterface() && !psiClass.hasModifierProperty("abstract")) {
                    selClassRef.set(psiClass);
                    return false;
                }
                return true;
            });
            selectedClass = (PsiClass)selClassRef.get();
        } else {
            TreeJavaClassChooserDialog chooser = AndroidTreeClassChooserFactory.INSTANCE.createInheritanceClassChooser(project, "Choose Activity to Create the Method", scope, activityBaseClass, null, aClass -> !converter.findHandlerMethod(aClass, methodName));
            chooser.showDialog();
            selectedClass = chooser.getSelected();
        }
        if (selectedClass != null) {
            AndroidCreateOnClickHandlerAction.addHandlerMethodAndNavigate(project, selectedClass, methodName, converter.getDefaultMethodParameterType(selectedClass));
        }
    }

    @NotNull
    private static String suggestVarName(@NotNull String type) {
        for (int i = type.length() - 1; i >= 0; --i) {
            char c = type.charAt(i);
            if (!Character.isUpperCase(c)) continue;
            return type.substring(i).toLowerCase(Locale.US);
        }
        return "o";
    }

    @Nullable
    public static PsiMethod addHandlerMethod(@NotNull Project project, @NotNull PsiClass psiClass, @NotNull String methodName, @NotNull String methodParamType) {
        PsiFile file = psiClass.getContainingFile();
        if (file == null) {
            return null;
        }
        String varName = AndroidCreateOnClickHandlerAction.suggestVarName(methodParamType);
        Language language = psiClass.getLanguage();
        if (language.is((Language)JavaLanguage.INSTANCE)) {
            PsiElementFactory factory2 = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            PsiMethod method2 = (PsiMethod)psiClass.add((PsiElement)factory2.createMethodFromText("public void " + methodName + "(" + methodParamType + " " + varName + ") {}", (PsiElement)psiClass));
            PsiMethod method1 = (PsiMethod)CodeStyleManager.getInstance((Project)project).reformat((PsiElement)method2);
            method1 = (PsiMethod)JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)method1);
            return (PsiMethod)method2.replace((PsiElement)method1);
        }
        if (language.is((Language)KotlinLanguage.INSTANCE)) {
            if (!(psiClass instanceof KtLightClass)) {
                return null;
            }
            KtClassOrObject origin = (KtClassOrObject)((KtLightClass)psiClass).getKotlinOrigin();
            if (origin == null) {
                return null;
            }
            KtNamedFunction namedFunction = new KtPsiFactory(origin.getProject()).createFunction("fun " + methodName + "(" + varName + ": " + methodParamType + ") {}");
            KtDeclaration anchor = (KtDeclaration)Iterables.getLast((Iterable)origin.getDeclarations(), null);
            GenerateUtilsKt.insertMembersAfterAndReformat(null, origin, namedFunction, (PsiElement)anchor);
        }
        return null;
    }

    public static void addHandlerMethodAndNavigate(@NotNull Project project, @NotNull PsiClass psiClass, @NotNull String methodName, @NotNull String methodParamType) {
        if (!AndroidUtils.isIdentifier(methodName)) {
            Messages.showErrorDialog((Project)project, (String)String.format("%1$s is not a valid Java identifier/method name.", methodName), (String)"Invalid Name");
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            PsiJavaToken lBrace;
            PsiFile javaFile;
            PsiMethod method2 = AndroidCreateOnClickHandlerAction.addHandlerMethod(project, psiClass, methodName, methodParamType);
            if (method2 == null) {
                return;
            }
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                PsiNavigateUtil.navigate((PsiElement)method2);
            }
            if ((javaFile = method2.getContainingFile()) == null) {
                return;
            }
            Editor javaEditor = PsiEditorUtil.findEditor((PsiElement)method2);
            if (javaEditor == null) {
                return;
            }
            PsiCodeBlock body = method2.getBody();
            if (body != null && (lBrace = body.getLBrace()) != null) {
                javaEditor.getCaretModel().moveToOffset(lBrace.getTextRange().getEndOffset());
            }
        });
    }
}

