/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.intentions;

import com.android.ide.common.gradle.Component;
import com.android.ide.common.repository.GoogleMavenArtifactId;
import com.android.tools.idea.gradle.dependencies.DependenciesHelper;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencySpec;
import com.android.tools.idea.gradle.repositories.RepositoryUrlManager;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.intellij.codeInsight.intention.AbstractIntentionAction;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.components.JBList;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.JList;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public class AndroidAddLibraryDependencyAction
extends AbstractIntentionAction
implements HighPriorityAction {
    @NotNull
    public String getText() {
        return AndroidBundle.message("add.dependency.intention.text", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Nullable
    private static Module getModule(@NotNull Project project, @NotNull PsiFile file) {
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        return index.getModuleForFile(file.getVirtualFile());
    }

    @NotNull
    private static ImmutableCollection<Component> findAllDependencies(@NotNull GradleBuildModel buildModel) {
        HashSet existingDependencies = Sets.newHashSet();
        Project project = buildModel.getProject();
        for (ArtifactDependencyModel dependency : buildModel.dependencies().artifacts()) {
            ProgressManager.checkCanceled();
            GoogleMavenArtifactId id2 = GoogleMavenArtifactId.find((String)dependency.group().toString(), (String)dependency.name().toString());
            if (id2 == null) continue;
            existingDependencies.add(id2);
        }
        ImmutableList.Builder dependenciesBuilder = ImmutableList.builder();
        RepositoryUrlManager repositoryUrlManager = RepositoryUrlManager.get();
        for (GoogleMavenArtifactId id3 : GoogleMavenArtifactId.getEntries()) {
            Component resolvedComponent;
            ProgressManager.checkCanceled();
            if (existingDependencies.contains(id3) || (resolvedComponent = repositoryUrlManager.resolveDependency(id3.getDependency("+"), project, null)) == null) continue;
            dependenciesBuilder.add((Object)resolvedComponent);
        }
        return dependenciesBuilder.build();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if ((file instanceof GroovyFile || file instanceof KtFile) && (file.getName().endsWith("gradle") || file.getName().endsWith("gradle.kts"))) {
            return AndroidFacet.getInstance((PsiElement)file) != null;
        }
        return false;
    }

    private static void addDependency(@NotNull Project project, @NotNull ProjectBuildModel projectModel, @NotNull GradleBuildModel buildModel, @NotNull Component component) {
        ArtifactDependencySpec newDependency = ArtifactDependencySpec.create(component.getName(), component.getGroup(), component.getVersion().toString());
        String compactNotation = newDependency.compactNotation();
        DependenciesHelper.withModel(projectModel).addDependency("implementation", compactNotation, buildModel);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        Module module = AndroidAddLibraryDependencyAction.getModule(project, file);
        ProjectBuildModel projectModel = ProjectBuildModel.get(project);
        GradleBuildModel buildModel = projectModel.getModuleBuildModel(module);
        if (buildModel == null) {
            return;
        }
        ImmutableCollection dependencies2 = (ImmutableCollection)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> AndroidAddLibraryDependencyAction.findAllDependencies(buildModel), "Finding Dependencies", true, project);
        if (dependencies2.isEmpty()) {
            return;
        }
        JBList list = new JBList((Collection)dependencies2);
        JBPopup popup = new PopupChooserBuilder((JList)list).setItemChosenCallback(new Runnable(){
            final /* synthetic */ JList val$list;
            final /* synthetic */ Project val$project;
            final /* synthetic */ ProjectBuildModel val$projectModel;
            final /* synthetic */ GradleBuildModel val$buildModel;
            {
                this.val$list = jList;
                this.val$project = project;
                this.val$projectModel = projectBuildModel;
                this.val$buildModel = gradleBuildModel;
            }

            @Override
            public void run() {
                for (Component selectedValue : this.val$list.getSelectedValuesList()) {
                    if (selectedValue == null) {
                        return;
                    }
                    AndroidAddLibraryDependencyAction.addDependency(this.val$project, this.val$projectModel, this.val$buildModel, selectedValue);
                }
                WriteCommandAction.runWriteCommandAction((Project)this.val$project, this.val$projectModel::applyChanges);
            }
        }).createPopup();
        popup.showInBestPositionFor(editor);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

