/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections;

import com.android.tools.idea.res.IdeResourcesUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.ConvertSwitchToIfIntention;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiCaseLabelElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ipp.switchtoif.ReplaceSwitchWithIfIntention;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.inspections.AndroidNonConstantResIdsInSwitchInspectionKt;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0016J\r\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/android/inspections/AndroidNonConstantResIdsInSwitchInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "getGroupDisplayName", "", "Lorg/jetbrains/annotations/Nls;", "getDisplayName", "getShortName", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "resolvesToNonFinalResourceField", "caseValue", "Lcom/intellij/psi/PsiCaseLabelElement;", "MyQuickFix", "intellij.android.core"})
public final class AndroidNonConstantResIdsInSwitchInspection
extends LocalInspectionTool {
    @NotNull
    public String getGroupDisplayName() {
        String string = AndroidBundle.message("android.inspections.group.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = AndroidBundle.message("android.inspections.non.constant.res.ids.in.switch.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getShortName() {
        return "AndroidNonConstantResIdsInSwitch";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (PsiElementVisitor)new JavaElementVisitor(this, holder){
            final /* synthetic */ AndroidNonConstantResIdsInSwitchInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            /*
             * WARNING - void declaration
             */
            public void visitSwitchLabelStatement(PsiSwitchLabelStatement statement) {
                Collection destination$iv$iv;
                void $this$getParentOfType$iv;
                Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
                AndroidFacet androidFacet = AndroidFacet.getInstance((PsiElement)((PsiElement)statement));
                if (androidFacet == null) {
                    return;
                }
                AndroidFacet facet = androidFacet;
                if (((AndroidFacetConfiguration)facet.getConfiguration()).isAppProject()) {
                    return;
                }
                PsiElement psiElement = (PsiElement)statement;
                boolean strict$iv = true;
                boolean $i$f$getParentOfType = false;
                PsiSwitchStatement psiSwitchStatement = (PsiSwitchStatement)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, PsiSwitchStatement.class, (boolean)strict$iv);
                if (psiSwitchStatement == null) {
                    return;
                }
                PsiSwitchStatement switchStatement = psiSwitchStatement;
                if (!ReplaceSwitchWithIfIntention.canProcess((PsiSwitchStatement)switchStatement)) {
                    return;
                }
                PsiCaseLabelElement[] psiCaseLabelElementArray = statement.getCaseLabelElementList();
                if (psiCaseLabelElementArray != null && (psiCaseLabelElementArray = psiCaseLabelElementArray.getElements()) != null) {
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    PsiCaseLabelElement[] psiCaseLabelElementArray2 = psiCaseLabelElementArray;
                    AndroidNonConstantResIdsInSwitchInspection androidNonConstantResIdsInSwitchInspection = this.this$0;
                    boolean $i$f$filter = false;
                    void var11_12 = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    int n = ((void)$this$filterTo$iv$iv).length;
                    for (int i = 0; i < n; ++i) {
                        void element$iv$iv;
                        void p0 = element$iv$iv = $this$filterTo$iv$iv[i];
                        boolean bl = false;
                        if (!AndroidNonConstantResIdsInSwitchInspection.access$resolvesToNonFinalResourceField(androidNonConstantResIdsInSwitchInspection, (PsiCaseLabelElement)p0)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                } else {
                    return;
                }
                List problemCaseLabels = (List)destination$iv$iv;
                for (PsiCaseLabelElement caseLabel : problemCaseLabels) {
                    LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new MyQuickFix()};
                    this.$holder.registerProblem((PsiElement)caseLabel, AndroidBundle.message("android.inspections.non.constant.res.ids.in.switch.message", new Object[0]), localQuickFixArray);
                }
            }
        };
    }

    private final boolean resolvesToNonFinalResourceField(PsiCaseLabelElement caseValue) {
        PsiReferenceExpression psiReferenceExpression = caseValue instanceof PsiReferenceExpression ? (PsiReferenceExpression)caseValue : null;
        PsiElement psiElement = psiReferenceExpression != null ? psiReferenceExpression.resolve() : null;
        PsiField psiField = psiElement instanceof PsiField ? (PsiField)psiElement : null;
        if (psiField == null) {
            return false;
        }
        PsiField resolvedField = psiField;
        if (!IdeResourcesUtil.isResourceField(resolvedField)) {
            return false;
        }
        PsiModifierList psiModifierList = resolvedField.getModifierList();
        if (psiModifierList == null) {
            return true;
        }
        PsiModifierList modifierList = psiModifierList;
        return !modifierList.hasModifierProperty("final");
    }

    public static final /* synthetic */ boolean access$resolvesToNonFinalResourceField(AndroidNonConstantResIdsInSwitchInspection $this, PsiCaseLabelElement caseValue) {
        return $this.resolvesToNonFinalResourceField(caseValue);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/android/inspections/AndroidNonConstantResIdsInSwitchInspection$MyQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "<init>", "()V", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.android.core"})
    @SourceDebugExtension(value={"SMAP\nAndroidNonConstantResIdsInSwitchInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidNonConstantResIdsInSwitchInspection.kt\norg/jetbrains/android/inspections/AndroidNonConstantResIdsInSwitchInspection$MyQuickFix\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,83:1\n196#2:84\n1#3:85\n*S KotlinDebug\n*F\n+ 1 AndroidNonConstantResIdsInSwitchInspection.kt\norg/jetbrains/android/inspections/AndroidNonConstantResIdsInSwitchInspection$MyQuickFix\n*L\n75#1:84\n*E\n"})
    private static final class MyQuickFix
    implements LocalQuickFix {
        @NotNull
        public String getFamilyName() {
            return AndroidNonConstantResIdsInSwitchInspectionKt.access$getQuickFixName();
        }

        /*
         * WARNING - void declaration
         */
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            block1: {
                void $this$getParentOfType$iv;
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                PsiElement psiElement = descriptor2.getPsiElement();
                if (psiElement == null) break block1;
                PsiElement psiElement2 = psiElement;
                boolean strict$iv = true;
                boolean $i$f$getParentOfType = false;
                PsiSwitchStatement psiSwitchStatement = (PsiSwitchStatement)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, PsiSwitchStatement.class, (boolean)strict$iv);
                if (psiSwitchStatement != null) {
                    PsiSwitchStatement p0 = psiSwitchStatement;
                    boolean bl = false;
                    ConvertSwitchToIfIntention.doProcessIntention((PsiSwitchStatement)p0);
                }
            }
        }
    }
}

