/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.layout;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlElementsGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.android.dom.AndroidAnyAttributeDescriptor;
import org.jetbrains.android.dom.AndroidDomElementDescriptorProvider;
import org.jetbrains.android.dom.layout.AndroidLayoutNSDescriptor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\t\u001a\u00020\nH\u0016J\u001d\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00000\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u001e\u0010\u0010\u001a\u0004\u0018\u00010\u00022\b\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000eH\u0016J\u001d\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016\u00a2\u0006\u0002\u0010\u0015J \u0010\u0016\u001a\u0004\u0018\u00010\u00142\n\b\u0001\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u000f\u0010\u001b\u001a\t\u0018\u00010\u001c\u00a2\u0006\u0002\b\u001dH\u0016J\n\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\t\u0010 \u001a\u00020!H\u0096\u0001J\u0011\u0010\"\u001a\n $*\u0004\u0018\u00010#0#H\u0096\u0001J\u001b\u0010%\u001a\u0014 $*\t\u0018\u00010\u0018\u00a2\u0006\u0002\b&0\u0018\u00a2\u0006\u0002\b&H\u0097\u0001J\u0015\u0010'\u001a\u000e\u0018\u00010\u0018\u00a2\u0006\u0002\b\u001d\u00a2\u0006\u0002\b(H\u0097\u0001J\u001b\u0010)\u001a\u0014 $*\t\u0018\u00010\u0018\u00a2\u0006\u0002\b*0\u0018\u00a2\u0006\u0002\b*H\u0097\u0001J+\u0010)\u001a\u0014 $*\t\u0018\u00010\u0018\u00a2\u0006\u0002\b&0\u0018\u00a2\u0006\u0002\b&2\u000e\u0010+\u001a\n $*\u0004\u0018\u00010#0#H\u0097\u0001J\u001b\u0010,\u001a\u0014 $*\t\u0018\u00010\u0018\u00a2\u0006\u0002\b&0\u0018\u00a2\u0006\u0002\b&H\u0097\u0001J\u0015\u0010-\u001a\u000e\u0018\u00010.\u00a2\u0006\u0002\b\u001d\u00a2\u0006\u0002\b(H\u0097\u0001J\u0019\u0010/\u001a\u0002002\u000e\u0010+\u001a\n $*\u0004\u0018\u00010#0#H\u0096\u0001R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\b\u00a8\u00061"}, d2={"Lorg/jetbrains/android/dom/layout/LayoutElementDescriptor;", "Lcom/intellij/psi/meta/PsiPresentableMetaData;", "Lcom/intellij/xml/XmlElementDescriptor;", "delegate", "<init>", "(Lcom/intellij/xml/XmlElementDescriptor;)V", "isContainer", "", "()Z", "getNSDescriptor", "Lorg/jetbrains/android/dom/layout/AndroidLayoutNSDescriptor;", "getElementsDescriptors", "", "context", "Lcom/intellij/psi/xml/XmlTag;", "(Lcom/intellij/psi/xml/XmlTag;)[Lorg/jetbrains/android/dom/layout/LayoutElementDescriptor;", "getElementDescriptor", "childTag", "contextTag", "getAttributesDescriptors", "Lcom/intellij/xml/XmlAttributeDescriptor;", "(Lcom/intellij/psi/xml/XmlTag;)[Lcom/intellij/xml/XmlAttributeDescriptor;", "getAttributeDescriptor", "attributeName", "", "attribute", "Lcom/intellij/psi/xml/XmlAttribute;", "getIcon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/Nullable;", "getTypeName", "", "getContentType", "", "getDeclaration", "Lcom/intellij/psi/PsiElement;", "kotlin.jvm.PlatformType", "getDefaultName", "Lorg/jetbrains/annotations/NonNls;", "getDefaultValue", "Lkotlin/jvm/internal/EnhancedNullability;", "getName", "Lcom/intellij/openapi/util/NlsSafe;", "p0", "getQualifiedName", "getTopGroup", "Lcom/intellij/xml/XmlElementsGroup;", "init", "", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nLayoutElementDescriptors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LayoutElementDescriptors.kt\norg/jetbrains/android/dom/layout/LayoutElementDescriptor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,176:1\n11228#2:177\n11563#2,3:178\n37#3:181\n36#3,3:182\n*S KotlinDebug\n*F\n+ 1 LayoutElementDescriptors.kt\norg/jetbrains/android/dom/layout/LayoutElementDescriptor\n*L\n88#1:177\n88#1:178,3\n89#1:181\n89#1:182,3\n*E\n"})
public class LayoutElementDescriptor
implements PsiPresentableMetaData,
XmlElementDescriptor {
    @NotNull
    private final XmlElementDescriptor delegate;
    private final boolean isContainer;

    public LayoutElementDescriptor(@NotNull XmlElementDescriptor delegate2) {
        Intrinsics.checkNotNullParameter((Object)delegate2, (String)"delegate");
        this.delegate = delegate2;
        this.isContainer = true;
    }

    protected boolean isContainer() {
        return this.isContainer;
    }

    @NotNull
    public AndroidLayoutNSDescriptor getNSDescriptor() {
        return AndroidLayoutNSDescriptor.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public LayoutElementDescriptor[] getElementsDescriptors(@Nullable XmlTag context) {
        void $this$mapTo$iv$iv;
        if (context == null) {
            return new LayoutElementDescriptor[0];
        }
        XmlElementDescriptor[] xmlElementDescriptorArray = this.delegate.getElementsDescriptors(context);
        Intrinsics.checkNotNullExpressionValue((Object)xmlElementDescriptorArray, (String)"getElementsDescriptors(...)");
        Object[] $this$map$iv = xmlElementDescriptorArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            XmlElementDescriptor xmlElementDescriptor = (XmlElementDescriptor)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection2.add(new LayoutElementDescriptor((XmlElementDescriptor)it));
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new LayoutElementDescriptor[0]);
    }

    @Nullable
    public XmlElementDescriptor getElementDescriptor(@Nullable XmlTag childTag, @Nullable XmlTag contextTag) {
        XmlElementDescriptor xmlElementDescriptor = this.delegate.getElementDescriptor(childTag, contextTag);
        if (xmlElementDescriptor == null) {
            return null;
        }
        XmlElementDescriptor fromDelegate = xmlElementDescriptor;
        return new LayoutElementDescriptor(fromDelegate);
    }

    @NotNull
    public XmlAttributeDescriptor[] getAttributesDescriptors(@Nullable XmlTag context) {
        XmlAttributeDescriptor[] xmlAttributeDescriptorArray = this.delegate.getAttributesDescriptors(context);
        if (xmlAttributeDescriptorArray == null) {
            return new XmlAttributeDescriptor[0];
        }
        XmlAttributeDescriptor[] descriptors = xmlAttributeDescriptorArray;
        int layoutWidthIndex = -1;
        int layoutHeightIndex = -1;
        int n = descriptors.length;
        for (int i = 0; i < n; ++i) {
            String name2 = descriptors[i].getName();
            if (Intrinsics.areEqual((Object)"layout_width", (Object)name2)) {
                layoutWidthIndex = i;
                continue;
            }
            if (!Intrinsics.areEqual((Object)"layout_height", (Object)name2)) continue;
            layoutHeightIndex = i;
        }
        if (layoutWidthIndex >= 0 && layoutHeightIndex >= 0 && layoutWidthIndex > layoutHeightIndex) {
            Object[] result2 = (XmlAttributeDescriptor[])descriptors.clone();
            ArrayUtil.swap((Object[])result2, (int)layoutWidthIndex, (int)layoutHeightIndex);
            return result2;
        }
        return descriptors;
    }

    @Nullable
    public XmlAttributeDescriptor getAttributeDescriptor(@NonNls @Nullable String attributeName, @Nullable XmlTag context) {
        XmlAttributeDescriptor xmlAttributeDescriptor = this.delegate.getAttributeDescriptor(attributeName, context);
        if (xmlAttributeDescriptor == null) {
            String string = attributeName;
            Intrinsics.checkNotNull((Object)string);
            xmlAttributeDescriptor = new AndroidAnyAttributeDescriptor(string);
        }
        return xmlAttributeDescriptor;
    }

    @Nullable
    public XmlAttributeDescriptor getAttributeDescriptor(@NotNull XmlAttribute attribute2) {
        Intrinsics.checkNotNullParameter((Object)attribute2, (String)"attribute");
        XmlAttributeDescriptor xmlAttributeDescriptor = this.delegate.getAttributeDescriptor(attribute2);
        if (xmlAttributeDescriptor == null) {
            xmlAttributeDescriptor = new AndroidAnyAttributeDescriptor(attribute2.getName());
        }
        return xmlAttributeDescriptor;
    }

    @Nullable
    public Icon getIcon() {
        return AndroidDomElementDescriptorProvider.getIconForViewTag(this.getName());
    }

    @Nullable
    public Void getTypeName() {
        return null;
    }

    public PsiElement getDeclaration() {
        return this.delegate.getDeclaration();
    }

    @NonNls
    public String getName(PsiElement p0) {
        return this.delegate.getName(p0);
    }

    @NlsSafe
    public String getName() {
        return this.delegate.getName();
    }

    public void init(PsiElement p0) {
        this.delegate.init(p0);
    }

    @NonNls
    public String getQualifiedName() {
        return this.delegate.getQualifiedName();
    }

    @NonNls
    public String getDefaultName() {
        return this.delegate.getDefaultName();
    }

    @Nullable
    public XmlElementsGroup getTopGroup() {
        return this.delegate.getTopGroup();
    }

    public int getContentType() {
        return this.delegate.getContentType();
    }

    @Nullable
    public String getDefaultValue() {
        return this.delegate.getDefaultValue();
    }
}

