/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.HashSet;
import org.jetbrains.android.inspections.AndroidMissingOnClickHandlerInspection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OnClickConverter
extends Converter<String>
implements CustomReferenceConverter<String> {
    private static final String DEFAULT_MENU_ITEM_CLASS = "android.view.MenuItem";
    private static final String ABS_MENU_ITEM_CLASS = "com.actionbarsherlock.view.MenuItem";
    public static final OnClickConverter CONVERTER_FOR_LAYOUT = new OnClickConverter(){

        @Override
        @NotNull
        public String getDefaultMethodParameterType(@NotNull PsiClass parentClass) {
            return "android.view.View";
        }

        @Override
        protected boolean isAllowedMethodParameterType(@NotNull String type) {
            return "android.view.View".equals(type);
        }

        @Override
        @NotNull
        public String getShortParameterName() {
            return "View";
        }
    };
    public static final OnClickConverter CONVERTER_FOR_MENU = new OnClickConverter(){

        @Override
        @NotNull
        public String getDefaultMethodParameterType(@NotNull PsiClass parentClass) {
            Project project = parentClass.getProject();
            PsiClass watsonClass = JavaPsiFacade.getInstance((Project)project).findClass("android.support.v4.app.Watson", GlobalSearchScope.projectScope((Project)project));
            return watsonClass != null && parentClass.isInheritor(watsonClass, true) ? OnClickConverter.ABS_MENU_ITEM_CLASS : OnClickConverter.DEFAULT_MENU_ITEM_CLASS;
        }

        @Override
        protected boolean isAllowedMethodParameterType(@NotNull String type) {
            return OnClickConverter.DEFAULT_MENU_ITEM_CLASS.equals(type) || OnClickConverter.ABS_MENU_ITEM_CLASS.equals(type);
        }

        @Override
        @NotNull
        public String getShortParameterName() {
            return "MenuItem";
        }
    };

    @NotNull
    public abstract String getDefaultMethodParameterType(@NotNull PsiClass var1);

    protected abstract boolean isAllowedMethodParameterType(@NotNull String var1);

    @NotNull
    public abstract String getShortParameterName();

    @NotNull
    public PsiReference[] createReferences(GenericDomValue<String> value2, PsiElement element, ConvertContext context) {
        int length = element.getTextLength();
        if (length > 1) {
            return new PsiReference[]{new MyReference((XmlAttributeValue)element, new TextRange(1, length - 1))};
        }
        return PsiReference.EMPTY_ARRAY;
    }

    public String fromString(@Nullable @NonNls String s, @NotNull ConvertContext context) {
        return s;
    }

    public String toString(@Nullable String s, @NotNull ConvertContext context) {
        return s;
    }

    public boolean checkSignature(@NotNull PsiMethod method2) {
        if (!PsiTypes.voidType().equals((Object)method2.getReturnType())) {
            return false;
        }
        if (method2.hasModifierProperty("static") || method2.hasModifierProperty("abstract") || !method2.hasModifierProperty("public")) {
            return false;
        }
        PsiClass aClass = method2.getContainingClass();
        if (aClass == null || aClass.isInterface()) {
            return false;
        }
        PsiParameter[] parameters2 = method2.getParameterList().getParameters();
        if (parameters2.length != 1) {
            return false;
        }
        PsiType paramType = parameters2[0].getType();
        if (!(paramType instanceof PsiClassType)) {
            return false;
        }
        PsiClass paramClass = ((PsiClassType)paramType).resolve();
        if (paramClass == null) {
            return false;
        }
        String paramClassName = paramClass.getQualifiedName();
        return paramClassName != null && this.isAllowedMethodParameterType(paramClassName);
    }

    public boolean findHandlerMethod(@NotNull PsiClass psiClass, @NotNull String methodName) {
        PsiMethod[] methods2;
        for (PsiMethod method2 : methods2 = psiClass.findMethodsByName(methodName, false)) {
            if (!this.checkSignature(method2)) continue;
            return true;
        }
        return false;
    }

    private static LookupElement createLookupElement(PsiMethod method2) {
        LookupElementBuilder builder = LookupElementBuilder.create((Object)method2, (String)method2.getName()).withIcon(method2.getIcon(1)).withPresentableText(method2.getName());
        PsiClass containingClass = method2.getContainingClass();
        return containingClass != null ? builder.withTailText(" (" + containingClass.getQualifiedName() + ")") : builder;
    }

    public class MyReference
    extends PsiPolyVariantReferenceBase<XmlAttributeValue> {
        private MyReference(XmlAttributeValue value2, TextRange range) {
            super((PsiElement)value2, range, true);
        }

        @NotNull
        public ResolveResult[] multiResolve(boolean incompleteCode) {
            return ResolveCache.getInstance((Project)((XmlAttributeValue)this.myElement).getProject()).resolveWithCaching((PsiPolyVariantReference)this, (ResolveCache.PolyVariantResolver)new ResolveCache.PolyVariantResolver<MyReference>(){

                @NotNull
                public ResolveResult[] resolve(@NotNull MyReference myReference, boolean incompleteCode) {
                    return MyReference.this.resolveInner();
                }
            }, false, incompleteCode);
        }

        @NotNull
        private ResolveResult[] resolveInner() {
            String methodName = ((XmlAttributeValue)this.myElement).getValue();
            if (methodName == null) {
                return ResolveResult.EMPTY_ARRAY;
            }
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myElement);
            if (module == null) {
                return ResolveResult.EMPTY_ARRAY;
            }
            Project project = ((XmlAttributeValue)this.myElement).getProject();
            PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)project);
            PsiMethod[] methods2 = cache.getMethodsByName(methodName, module.getModuleWithDependenciesScope());
            if (methods2.length == 0) {
                return ResolveResult.EMPTY_ARRAY;
            }
            PsiClass activityBaseClass = JavaPsiFacade.getInstance((Project)project).findClass("android.app.Activity", module.getModuleWithDependenciesAndLibrariesScope(false));
            if (activityBaseClass == null) {
                return ResolveResult.EMPTY_ARRAY;
            }
            ArrayList<MyResolveResult> result2 = new ArrayList<MyResolveResult>();
            ArrayList<MyResolveResult> resultsWithMistake = new ArrayList<MyResolveResult>();
            for (PsiMethod method2 : methods2) {
                PsiClass parentClass = method2.getContainingClass();
                if (parentClass == null || !parentClass.isInheritor(activityBaseClass, true)) continue;
                if (OnClickConverter.this.checkSignature(method2)) {
                    result2.add(new MyResolveResult((PsiElement)method2, true));
                    continue;
                }
                resultsWithMistake.add(new MyResolveResult((PsiElement)method2, false));
            }
            return !result2.isEmpty() ? result2.toArray(ResolveResult.EMPTY_ARRAY) : resultsWithMistake.toArray(ResolveResult.EMPTY_ARRAY);
        }

        @NotNull
        public Object[] getVariants() {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myElement);
            if (module == null) {
                return ResolveResult.EMPTY_ARRAY;
            }
            PsiClass activityClass = AndroidMissingOnClickHandlerInspection.findActivityClass(module);
            if (activityClass == null) {
                return EMPTY_ARRAY;
            }
            final ArrayList result2 = new ArrayList();
            final HashSet methodNames = new HashSet();
            ClassInheritorsSearch.search((PsiClass)activityClass, (SearchScope)module.getModuleWithDependenciesScope(), (boolean)true).forEach((Processor)new Processor<PsiClass>(){

                public boolean process(PsiClass c) {
                    for (PsiMethod method2 : c.getMethods()) {
                        if (!OnClickConverter.this.checkSignature(method2) || !methodNames.add(method2.getName())) continue;
                        result2.add(OnClickConverter.createLookupElement(method2));
                    }
                    return true;
                }
            });
            return ArrayUtil.toObjectArray(result2);
        }

        @NotNull
        public OnClickConverter getConverter() {
            return OnClickConverter.this;
        }
    }

    public static class MyResolveResult
    extends PsiElementResolveResult {
        private final boolean myHasCorrectSignature;

        public MyResolveResult(@NotNull PsiElement element, boolean hasCorrectSignature) {
            super(element);
            this.myHasCorrectSignature = hasCorrectSignature;
        }

        public boolean hasCorrectSignature() {
            return this.myHasCorrectSignature;
        }
    }
}

