/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.ModuleSystemUtil;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.gradle.GradleProjectSystem;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.android.exportSignedPackage.ExportSignedPackageWizard;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class GenerateSignedAppBundleOrApkAction
extends AnAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public GenerateSignedAppBundleOrApkAction() {
        super(AndroidBundle.message("android.generate.signed.app.bundle.or.apk.action.text", new Object[0]));
    }

    @VisibleForTesting
    static boolean allowBundleSigning(@Nullable Project project) {
        return project != null;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        assert (project != null);
        List<AndroidFacet> facets = ProjectSystemUtil.getAndroidFacets(project).stream().filter(facet -> ((AndroidFacetConfiguration)facet.getConfiguration()).isAppProject()).collect(Collectors.toList());
        assert (!facets.isEmpty());
        ExportSignedPackageWizard wizard2 = new ExportSignedPackageWizard(project, facets);
        wizard2.show();
    }

    private static boolean hasAtLeastOneApp(@NotNull Project project) {
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            if (ModuleSystemUtil.androidProjectType(module) != AndroidModuleSystem.Type.TYPE_APP) continue;
            return true;
        }
        return false;
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        boolean enabled = project != null && GenerateSignedAppBundleOrApkAction.hasAtLeastOneApp(project) && ProjectSystemUtil.getProjectSystem(project) instanceof GradleProjectSystem;
        e.getPresentation().setEnabledAndVisible(enabled);
        if (enabled) {
            e.getPresentation().setText(AndroidBundle.message("android.generate.signed.app.bundle.or.apk.action.text", new Object[0]));
        }
    }
}

