/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.resources.ResourceType;
import com.android.tools.idea.AndroidPsiUtils;
import com.intellij.ide.EssentialHighlightingMode;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.android.AndroidResourceExternalAnnotatorBase;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidJavaResourceExternalAnnotator
extends AndroidResourceExternalAnnotatorBase {
    @Override
    @Nullable
    protected AndroidResourceExternalAnnotatorBase.FileAnnotationInfo collectInformation(@NotNull PsiFile file, @NotNull Editor editor) {
        if (EssentialHighlightingMode.INSTANCE.isEnabled()) {
            return null;
        }
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)file);
        if (facet == null) {
            return null;
        }
        final AndroidResourceExternalAnnotatorBase.FileAnnotationInfo annotationInfo = new AndroidResourceExternalAnnotatorBase.FileAnnotationInfo(facet, file, editor);
        file.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(this){

            public void visitReferenceElement(@NotNull PsiJavaCodeReferenceElement element) {
                ResourceType type = AndroidPsiUtils.getResourceType((PsiElement)element);
                if (type == ResourceType.COLOR || type == ResourceType.DRAWABLE || type == ResourceType.MIPMAP) {
                    AndroidPsiUtils.ResourceReferenceType referenceType = AndroidPsiUtils.getResourceReferenceType((PsiElement)element);
                    ResourceNamespace namespace = referenceType == AndroidPsiUtils.ResourceReferenceType.FRAMEWORK ? ResourceNamespace.ANDROID : ResourceNamespace.RES_AUTO;
                    String name2 = AndroidPsiUtils.getResourceName((PsiElement)element);
                    ResourceReference reference = new ResourceReference(namespace, type, name2);
                    annotationInfo.getElements().add(new AndroidResourceExternalAnnotatorBase.FileAnnotationInfo.AnnotatableElement(reference, (PsiElement)element));
                }
            }
        });
        if (annotationInfo.getElements().isEmpty()) {
            return null;
        }
        return annotationInfo;
    }
}

