/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.ResourcesUtil;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.Density;
import com.android.resources.ResourceType;
import com.android.tools.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.android.tools.idea.ui.resourcechooser.common.ResourcePickerSources;
import com.android.tools.idea.ui.resourcechooser.util.ResourceChooserHelperKt;
import com.android.tools.idea.ui.resourcemanager.rendering.MultipleColorIcon;
import com.android.tools.res.FileResourceReader;
import com.android.tools.res.LocalResourceRepository;
import com.android.utils.HashCodes;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Consumer;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBScalableIcon;
import java.awt.Color;
import java.awt.MouseInfo;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.xmlpull.v1.XmlPullParser;

public class AndroidAnnotatorUtil {
    static final int MAX_ICON_FILE_SIZE = 20000;
    private static final String SET_COLOR_COMMAND_NAME = "Change Color";
    private static final int ICON_SIZE = 8;

    @Nullable
    public static VirtualFile resolveDrawableFile(@NotNull ResourceValue resourceValue, @NotNull ResourceResolver resourceResolver, @NotNull AndroidFacet facet) {
        Project project = facet.getModule().getProject();
        VirtualFile file = IdeResourcesUtil.resolveDrawable((RenderResources)resourceResolver, resourceValue, project);
        if (file != null && file.getPath().endsWith(".xml")) {
            file = AndroidAnnotatorUtil.pickRenderableFileFromXML(file, resourceResolver, project, facet, resourceValue);
        }
        return AndroidAnnotatorUtil.pickSmallestDpiFile(file);
    }

    @VisibleForTesting
    @Nullable
    public static XmlPullParser createXmlPullParser(@NotNull VirtualFile resourceFile) throws IOException {
        try {
            byte[] contents = resourceFile.contentsToByteArray();
            return FileResourceReader.createXmlPullParser(contents);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    @Nullable
    private static VirtualFile pickRenderableFileFromXML(@NotNull VirtualFile file, @NotNull ResourceResolver resourceResolver, @NotNull Project project, @NotNull AndroidFacet facet, @NotNull ResourceValue resourceValue) {
        try {
            String source2;
            String tagName;
            XmlPullParser parser = AndroidAnnotatorUtil.createXmlPullParser(file);
            if (parser == null) {
                return null;
            }
            if (parser.nextTag() != 2) {
                return null;
            }
            switch (tagName = parser.getName()) {
                case "vector": {
                    LocalResourceRepository<VirtualFile> resourceRepository = StudioResourceRepositoryManager.getAppResources(facet);
                    List items = resourceRepository.getResources(resourceValue.getNamespace(), resourceValue.getResourceType(), resourceValue.getName());
                    for (ResourceItem item : items) {
                        Density density;
                        FolderConfiguration configuration2 = item.getConfiguration();
                        DensityQualifier densityQualifier = configuration2.getDensityQualifier();
                        if (densityQualifier == null || (density = densityQualifier.getValue()) == null || !density.isValidValueForDevice()) continue;
                        return IdeResourcesUtil.getSourceAsVirtualFile(item);
                    }
                    return file;
                }
                case "bitmap": 
                case "nine-patch": {
                    source2 = parser.getAttributeValue("http://schemas.android.com/apk/res/android", "src");
                    break;
                }
                case "clip": 
                case "inset": 
                case "scale": {
                    source2 = parser.getAttributeValue("http://schemas.android.com/apk/res/android", "drawable");
                    break;
                }
                default: {
                    return file;
                }
            }
            if (source2 == null) {
                return null;
            }
            ResourceValue resValue = resourceResolver.findResValue(source2, resourceValue.isFramework());
            return resValue == null ? null : IdeResourcesUtil.resolveDrawable((RenderResources)resourceResolver, resValue, project);
        }
        catch (Throwable ignore) {
            return null;
        }
    }

    @Nullable
    public static VirtualFile pickSmallestDpiFile(@Nullable VirtualFile resourceFile) {
        if (resourceFile != null && resourceFile.exists()) {
            VirtualFile smallest = AndroidAnnotatorUtil.findSmallestDpiVersion(resourceFile);
            if (smallest != null) {
                return smallest;
            }
            long length = resourceFile.getLength();
            if (length < 20000L) {
                return resourceFile;
            }
        }
        return null;
    }

    @Nullable
    private static VirtualFile findSmallestDpiVersion(@NotNull VirtualFile bitmap) {
        VirtualFile parentFile = bitmap.getParent();
        if (parentFile == null) {
            return null;
        }
        VirtualFile resFolder = parentFile.getParent();
        if (resFolder == null) {
            return null;
        }
        String parentName = parentFile.getName();
        FolderConfiguration config = FolderConfiguration.getConfigForFolder((String)parentName);
        if (config == null) {
            return null;
        }
        DensityQualifier qualifier = config.getDensityQualifier();
        if (qualifier == null) {
            return null;
        }
        Density density = qualifier.getValue();
        if (density != null && density.isValidValueForDevice()) {
            String fileName = bitmap.getName();
            Density[] densities = Density.values();
            int i = densities.length;
            while (--i >= 0) {
                String folderName;
                VirtualFile folder;
                Density d = densities[i];
                if (!d.isValidValueForDevice() || (folder = resFolder.findChild(folderName = parentName.replace(density.getResourceValue(), d.getResourceValue()))) == null || (bitmap = folder.findChild(fileName)) == null) continue;
                if (bitmap.getLength() > 20000L) {
                    return null;
                }
                return bitmap;
            }
        }
        return null;
    }

    @Nullable
    public static Configuration pickConfiguration(@NotNull PsiFile file, @NotNull AndroidFacet facet) {
        VirtualFile nearestConfigurationFile;
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        ConfigurationManager configurationManager = ConfigurationManager.getOrCreateInstance(facet.getModule());
        if (!(file instanceof XmlFile)) {
            nearestConfigurationFile = IdeResourcesUtil.pickAnyLayoutFile(facet);
            if (nearestConfigurationFile == null) {
                return Configuration.create(configurationManager, FolderConfiguration.createDefault());
            }
        } else {
            nearestConfigurationFile = virtualFile;
        }
        return configurationManager.getConfiguration(nearestConfigurationFile);
    }

    @NotNull
    public static FileType getFileType(@NotNull PsiElement element) {
        return (FileType)ApplicationManager.getApplication().runReadAction(() -> {
            PsiFile file = element.getContainingFile();
            if (file != null) {
                return file.getFileType();
            }
            return UnknownFileType.INSTANCE;
        });
    }

    @Nullable
    private static String convertResourceAttributeToIdentifier(@NotNull String colorAttributeValue, @NotNull ResourceType resourceType) {
        int nameStartIndex = colorAttributeValue.lastIndexOf(47);
        if (nameStartIndex == -1) {
            return null;
        }
        String resourceName = colorAttributeValue.substring(nameStartIndex + 1);
        if (resourceName.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        if (colorAttributeValue.startsWith("@android:")) {
            builder.append("android.");
        }
        return builder.append("R.").append(resourceType.getName()).append(".").append(resourceName).toString();
    }

    public static PsiElement setJavaOrKotlinAttribute(@NotNull PsiElement psiElement, @NotNull String attributeValue, @NotNull ResourceType resourceType) {
        String resourceIdentifier = AndroidAnnotatorUtil.convertResourceAttributeToIdentifier(attributeValue, resourceType);
        if (resourceIdentifier == null) {
            return psiElement;
        }
        if (psiElement instanceof PsiReferenceExpression) {
            PsiExpression expression = PsiElementFactory.getInstance((Project)psiElement.getProject()).createExpressionFromText(resourceIdentifier, psiElement);
            return psiElement.replace((PsiElement)expression);
        }
        KtExpression expression = new KtPsiFactory(psiElement.getProject()).createExpression(resourceIdentifier);
        return psiElement.getParent().replace((PsiElement)expression).getLastChild();
    }

    public static PsiElement setXmlAttribute(@NotNull PsiElement element, @NotNull String attributeValue) {
        XmlAttribute xmlAttribute;
        if (element instanceof XmlTag) {
            XmlTagValue xmlTagValue = ((XmlTag)element).getValue();
            xmlTagValue.setText(attributeValue);
        } else if (element instanceof XmlAttributeValue && (xmlAttribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttribute.class)) != null) {
            xmlAttribute.setValue(attributeValue);
            return xmlAttribute.getValueElement();
        }
        return element;
    }

    public static class SetAttributeConsumer
    implements Consumer<String> {
        private PsiElement myElement;
        private final Consumer<String> myAttributeConsumer;
        private final ResourceType myResourceType;

        public SetAttributeConsumer(PsiElement psiElement, ResourceType resourceType) {
            this.myElement = psiElement;
            this.myResourceType = resourceType;
            this.myAttributeConsumer = this.createSetAttributeTask();
        }

        @VisibleForTesting
        @NotNull
        public PsiElement getElement() {
            return this.myElement;
        }

        public void consume(String s) {
            this.myAttributeConsumer.consume((Object)s);
        }

        @NotNull
        private Consumer<String> createSetAttributeTask() {
            return attributeValue -> {
                PsiElement psiElement = this.myElement;
                if (psiElement instanceof PsiReferenceExpression || psiElement instanceof KtNameReferenceExpression) {
                    this.myElement = AndroidAnnotatorUtil.setJavaOrKotlinAttribute(psiElement, attributeValue, this.myResourceType);
                } else if (psiElement != null) {
                    this.myElement = AndroidAnnotatorUtil.setXmlAttribute(psiElement, attributeValue);
                }
            };
        }
    }

    public static class ColorRenderer
    extends GutterIconRenderer {
        @NotNull
        private final PsiElement myElement;
        @NotNull
        private final Project myProject;
        @Nullable
        private final Color myColor;
        @NotNull
        private final ResourceResolver myResolver;
        @Nullable
        private final ResourceValue myResourceValue;
        private final Consumer<String> mySetColorTask;
        private final boolean myIncludeClickAction;
        private final boolean myHasCustomColor;
        private final AndroidFacet myFacet;
        private final Icon myIcon;

        public ColorRenderer(@NotNull PsiElement element, @Nullable Color color, @NotNull ResourceResolver resolver, @Nullable ResourceValue resourceValue, boolean hasCustomColor, @NotNull AndroidFacet facet) {
            this.myElement = element;
            this.myProject = element.getProject();
            this.myColor = color;
            this.myResolver = resolver;
            this.myResourceValue = resourceValue;
            this.myFacet = facet;
            this.myIncludeClickAction = true;
            this.myHasCustomColor = hasCustomColor;
            this.mySetColorTask = new SetAttributeConsumer(element, ResourceType.COLOR);
            this.myIcon = this.buildIcon();
        }

        @NotNull
        public Icon getIcon() {
            return this.myIcon;
        }

        @NotNull
        private Icon buildIcon() {
            if (this.myResourceValue != null && this.myElement.isValid()) {
                List<Color> colors = IdeResourcesUtil.resolveMultipleColors((RenderResources)this.myResolver, this.myResourceValue, this.myFacet.getModule().getProject());
                if (!colors.isEmpty()) {
                    MultipleColorIcon icon = new MultipleColorIcon();
                    icon.setColors(colors);
                    int scaledIconSize = JBUIScale.scale((int)8);
                    icon.setWidth(scaledIconSize);
                    icon.setHeight(scaledIconSize);
                    return icon;
                }
                return JBUIScale.scaleIcon((JBScalableIcon)EmptyIcon.create((int)8));
            }
            Color color = this.getCurrentColor();
            return color == null ? JBUIScale.scaleIcon((JBScalableIcon)EmptyIcon.create((int)8)) : JBUIScale.scaleIcon((JBScalableIcon)new ColorIcon(8, color));
        }

        @Nullable
        private Color getCurrentColor() {
            if (this.myColor != null) {
                return this.myColor;
            }
            if (this.myElement.isValid()) {
                if (this.myElement instanceof XmlTag) {
                    return ResourcesUtil.parseColor((String)((XmlTag)this.myElement).getValue().getText());
                }
                if (this.myElement instanceof XmlAttributeValue) {
                    return ResourcesUtil.parseColor((String)((XmlAttributeValue)this.myElement).getValue());
                }
            }
            return null;
        }

        public AnAction getClickAction() {
            if (!this.myIncludeClickAction) {
                return null;
            }
            return new AnAction(){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
                    if (file == null) {
                        return;
                    }
                    AndroidFacet facet = AndroidFacet.getInstance((PsiElement)file);
                    if (facet == null) {
                        return;
                    }
                    Configuration configuration2 = AndroidAnnotatorUtil.pickConfiguration(file, facet);
                    Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
                    if (editor != null && configuration2 != null) {
                        this.openColorPicker(this.getCurrentColor(), configuration2);
                    }
                }
            };
        }

        @TestOnly
        @NotNull
        public PsiElement getElement() {
            return this.myElement;
        }

        private void openColorPicker(@Nullable Color currentColor, @NotNull Configuration configuration2) {
            ArrayList<ResourcePickerSources> pickerSources = new ArrayList<ResourcePickerSources>();
            pickerSources.add(ResourcePickerSources.PROJECT);
            pickerSources.add(ResourcePickerSources.ANDROID);
            pickerSources.add(ResourcePickerSources.LIBRARY);
            if (AndroidAnnotatorUtil.getFileType(this.myElement) == XmlFileType.INSTANCE) {
                pickerSources.add(ResourcePickerSources.THEME_ATTR);
            }
            ResourceChooserHelperKt.createAndShowColorPickerPopup(currentColor, this.myResourceValue, configuration2, pickerSources, null, MouseInfo.getPointerInfo().getLocation(), (Function1<? super Color, Unit>)(this.myHasCustomColor ? color -> {
                this.setColorToAttribute((Color)color);
                return null;
            } : null), (Function1<? super String, Unit>)((Function1)resourceString -> {
                this.setColorStringAttribute((String)resourceString);
                return null;
            }));
        }

        private void setColorToAttribute(@NotNull Color color) {
            this.setColorStringAttribute(ResourcesUtil.colorToString((Color)color));
        }

        private void setColorStringAttribute(@NotNull String colorString) {
            ApplicationManager.getApplication().invokeLater(() -> WriteCommandAction.runWriteCommandAction((Project)this.myProject, (String)AndroidAnnotatorUtil.SET_COLOR_COMMAND_NAME, null, () -> this.mySetColorTask.consume((Object)colorString), (PsiFile[])new PsiFile[0]), this.myProject.getDisposed());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            ColorRenderer that = (ColorRenderer)((Object)o);
            if (!Objects.equals(this.myColor, that.myColor)) {
                return false;
            }
            return this.myElement.equals((Object)that.myElement);
        }

        public int hashCode() {
            return HashCodes.mix((int)this.myElement.hashCode(), (int)Objects.hashCode(this.myColor));
        }
    }
}

