/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.studio.samples;

import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.observable.expressions.value.TransformOptionalExpression;
import com.android.tools.idea.observable.ui.TextProperty;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.tools.idea.wizard.ui.deprecated.StudioWizardStepPanel;
import com.android.utils.HtmlBuilder;
import com.appspot.gsamplesindex.samplesindex.model.Sample;
import com.appspot.gsamplesindex.samplesindex.model.SampleCollection;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.gct.studio.samples.SampleImportTreeManager;
import com.google.gct.studio.samples.SampleModel;
import com.google.gct.studio.samples.SamplePreviewPanel;
import com.google.gct.studio.samples.SampleSetupStep;
import com.google.gct.studio.samples.SamplesBrowserBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

public class SampleBrowserStep
extends ModelWizardStep<SampleModel> {
    private final SampleCollection mySampleList;
    private final SampleSetupStep mySampleSetupStep;
    private final StudioWizardStepPanel myStudioPanel;
    private final ValidatorPanel myValidatorPanel;
    private final ListenerManager myListeners = new ListenerManager();
    private final BindingsManager myBindings = new BindingsManager();
    private Tree mySampleTree;
    private SampleImportTreeManager mySampleTreeManager;
    private JPanel myPanel;
    private JEditorPane myDescriptionPane;
    private SearchTextField mySearchBox;
    private SamplePreviewPanel mySamplePreviewPanel;
    private JBScrollPane mySamplePreviewScrollPanel;
    private JPanel myDescriptionPanel;
    private JSplitPane mySplitPane;

    public SampleBrowserStep(@NotNull SampleModel model, @NotNull SampleCollection sampleList) {
        super(model, SamplesBrowserBundle.message("sample.browser.title", new Object[0]));
        this.setupUI();
        this.mySampleList = sampleList;
        this.mySampleTreeManager = new SampleImportTreeManager(this.mySampleTree, this.mySampleList);
        this.myValidatorPanel = new ValidatorPanel((Disposable)this, (JComponent)this.myPanel);
        this.myStudioPanel = new StudioWizardStepPanel((JPanel)this.myValidatorPanel, SamplesBrowserBundle.message("sample.browser.description", new Object[0]));
        this.mySampleSetupStep = new SampleSetupStep(model);
        GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)this.mySplitPane);
        this.myDescriptionPane = SwingHelper.createHtmlViewer((boolean)false, null, null, null);
        this.myDescriptionPane.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
        this.myDescriptionPanel.add(this.myDescriptionPane);
        this.mySamplePreviewScrollPanel.getVerticalScrollBar().setUnitIncrement(16);
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        return this.myStudioPanel;
    }

    @Override
    public JComponent getPreferredFocusComponent() {
        return this.mySearchBox;
    }

    @Override
    @NotNull
    protected Collection<? extends ModelWizardStep<?>> createDependentSteps() {
        return Lists.newArrayList((Object[])new SampleSetupStep[]{this.mySampleSetupStep});
    }

    @Override
    protected void onWizardStarting(final @NotNull ModelWizard.Facade wizard2) {
        final OptionalProperty<Sample> sample = ((SampleModel)this.getModel()).sample();
        sample.setNullableValue(this.mySampleTreeManager.getSelectedSample());
        this.mySampleTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                sample.setNullableValue(SampleBrowserStep.this.mySampleTreeManager.getSelectedSample());
            }
        });
        DoubleClickListener treeDoubleClicked = new DoubleClickListener(this){

            protected boolean onDoubleClick(MouseEvent event) {
                return wizard2.goForward();
            }
        };
        treeDoubleClicked.installOn((Component)this.mySampleTree);
        this.myListeners.listenAndFire(sample, () -> {
            Sample sampleValue = (Sample)((Object)((Object)sample.getValueOrNull()));
            this.mySamplePreviewPanel.setSample(sampleValue);
            this.mySampleSetupStep.setUrl(sampleValue != null ? sampleValue.getCloneUrl() : "");
        });
        StringValueProperty htmlDesc = new StringValueProperty();
        this.myBindings.bind(htmlDesc, new TransformOptionalExpression<Sample, String>(this, "", sample){

            @Override
            @NotNull
            protected String transform(@NotNull Sample sample) {
                HtmlBuilder description2 = new HtmlBuilder();
                if (sample.getDescription() != null) {
                    description2.addHtml(sample.getDescription());
                } else {
                    description2.add(SamplesBrowserBundle.message("sample.browser.no.description", new Object[0]));
                }
                description2.newlineIfNecessary().newline();
                description2.add("Tags: ");
                description2.add(StringUtil.join(sample.getCategories(), (String)","));
                description2.newlineIfNecessary().newline();
                StringBuilder urlBuilder = new StringBuilder();
                String cloneUrl = sample.getCloneUrl();
                String path = sample.getPath();
                urlBuilder.append(cloneUrl);
                if (!Strings.isNullOrEmpty((String)path)) {
                    urlBuilder.append(cloneUrl.endsWith("/") ? "" : "/");
                    urlBuilder.append("tree/master/");
                    urlBuilder.append(SampleModel.trimSlashes(path));
                }
                description2.addLink(SamplesBrowserBundle.message("sample.browse.source", new Object[0]), urlBuilder.toString());
                return description2.getHtml();
            }
        });
        this.myListeners.listenAndFire(htmlDesc, () -> SwingHelper.setHtml((JEditorPane)this.myDescriptionPane, (String)((String)htmlDesc.get()), (Color)UIUtil.getLabelForeground()));
        TextProperty searchValue = new TextProperty((JTextComponent)this.mySearchBox.getTextEditor());
        this.myListeners.listenAndFire(searchValue, keyword -> this.mySampleTreeManager.filterTree((String)keyword));
        this.myValidatorPanel.registerValidator(sample, (Validator)new Validator<Optional<Sample>>(){

            @NotNull
            public Validator.Result validate(@NotNull Optional<Sample> sample) {
                if (SampleBrowserStep.this.mySampleTreeManager.isEmpty()) {
                    return new Validator.Result(Validator.Severity.ERROR, SamplesBrowserBundle.message("sample.browser.empty", new Object[0]));
                }
                if (!sample.isPresent()) {
                    return new Validator.Result(Validator.Severity.ERROR, SamplesBrowserBundle.message("sample.browser.please.select", new Object[0]));
                }
                return Validator.Result.OK;
            }
        }, new ObservableValue[0]);
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        return this.myValidatorPanel.hasErrors().not();
    }

    @Override
    public void dispose() {
        this.myBindings.releaseAll();
        this.myListeners.releaseAll();
    }

    private void setupUI() {
        this.myPanel = new JPanel();
        this.myPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.mySplitPane = new JSplitPane();
        this.mySplitPane.setDividerSize(8);
        this.mySplitPane.setResizeWeight(0.5);
        this.myPanel.add((Component)this.mySplitPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null, 0, false));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.mySplitPane.setLeftComponent(panel1);
        this.mySearchBox = new SearchTextField();
        this.mySearchBox.setToolTipText("Search by Name or Key Word");
        panel1.add((Component)this.mySearchBox, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 0, null, null, null, 0, false));
        JBScrollPane jBScrollPane1 = new JBScrollPane();
        jBScrollPane1.setEnabled(true);
        panel1.add((Component)jBScrollPane1, new GridConstraints(1, 0, 1, 1, 0, 3, 5, 5, null, null, null, 0, false));
        this.mySampleTree = new Tree();
        jBScrollPane1.setViewportView((Component)this.mySampleTree);
        this.mySamplePreviewScrollPanel = new JBScrollPane();
        this.mySamplePreviewScrollPanel.setHorizontalScrollBarPolicy(31);
        this.mySamplePreviewScrollPanel.setVerticalScrollBarPolicy(20);
        this.mySplitPane.setRightComponent((Component)this.mySamplePreviewScrollPanel);
        JPanel panel2 = new JPanel();
        panel2.setLayout(new GridBagLayout());
        this.mySamplePreviewScrollPanel.setViewportView((Component)panel2);
        panel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10), null, 0, 0, null, null));
        this.myDescriptionPanel = new JPanel();
        this.myDescriptionPanel.setLayout(new BorderLayout(0, 0));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 11;
        gbc.fill = 2;
        panel2.add((Component)this.myDescriptionPanel, gbc);
        this.mySamplePreviewPanel = new SamplePreviewPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(10, 0, 0, 0);
        panel2.add((Component)this.mySamplePreviewPanel, gbc);
    }
}

