/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.login2;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Messages;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.regex.Pattern;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;

public class GoogleLoginUtils {
    public static final Logger LOG = Logger.getInstance(GoogleLoginUtils.class);
    public static final int DEFAULT_PICTURE_SIZE = 96;
    private static final Pattern FIFE_AVATAR_URL = Pattern.compile("lh.*(googleusercontent|google)\\.com");

    @NotNull
    public static URL appendSizeParameter(@NotNull String url) {
        try {
            URIBuilder uriBuilder = new URIBuilder(url);
            if (FIFE_AVATAR_URL.matcher(url).find() && (url.contains("/a/") || url.contains("/a-"))) {
                Object urlPath = uriBuilder.getPath();
                int optionsIndex = ((String)urlPath).lastIndexOf(61);
                urlPath = optionsIndex < 0 ? (String)urlPath + "=" : (String)urlPath + "-";
                urlPath = (String)urlPath + "s96-c";
                uriBuilder.setPath((String)urlPath);
            } else {
                uriBuilder.addParameter("sz", String.valueOf(96));
            }
            return uriBuilder.build().toURL();
        }
        catch (MalformedURLException | URISyntaxException exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    public static void showErrorDialog(@NotNull String message, @NotNull String title2) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            Messages.showErrorDialog((String)message, (String)title2);
        } else {
            ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((String)message, (String)title2), ModalityState.defaultModalityState());
        }
    }
}

