/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.login2;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.flags.StudioFlags;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.CredentialRefreshListener;
import com.google.api.client.auth.oauth2.TokenErrorResponse;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.auth.oauth2.GoogleTokenResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.json.webtoken.JsonWebSignature;
import com.google.gct.login2.GoogleLoginService;
import com.google.gct.login2.GoogleLoginState;
import com.google.gct.login2.GoogleLoginStateKt;
import com.google.gct.login2.LoginFeature;
import com.google.gct.login2.OAuthScope;
import com.google.gct.login2.OAuthServer;
import com.google.gct.login2.OAuthServerKt;
import com.google.gct.login2.PreferredUser;
import com.google.gct.login2.StudioClientInfo;
import com.google.gct.login2.common.AuthorizationCodeHolder;
import com.google.gct.login2.common.LoginCallbackHandler;
import com.google.gct.login2.common.OAuthDataStore;
import com.google.gct.login2.common.UiFacade;
import com.google.gct.login2.settings.GoogleLoginApplicationSettings;
import com.google.wireless.android.sdk.stats.GoogleLoginPluginEvent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000{\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006*\u0001\u001c\b\u0007\u0018\u0000 52\u00020\u0001:\u000245B1\b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rB?\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\u0004\b\f\u0010\u0013J\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0012J\u0006\u0010\u001f\u001a\u00020 J\b\u0010\"\u001a\u0004\u0018\u00010\u000bJ\b\u0010#\u001a\u0004\u0018\u00010$J\u0006\u0010%\u001a\u00020 J\b\u0010&\u001a\u0004\u0018\u00010'J*\u0010(\u001a\u00020$2\b\u0010)\u001a\u0004\u0018\u00010\u000b2\u0006\u0010*\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020 H\u0002J\f\u0010.\u001a\u00020'*\u00020\u0018H\u0002J\u001e\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u0016\u00102\u001a\u0002002\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001d\u00a8\u00066"}, d2={"Lcom/google/gct/login2/GoogleLoginState;", "", "transport", "Lcom/google/api/client/http/HttpTransport;", "uiFacade", "Lcom/google/gct/login2/common/UiFacade;", "oAuthServer", "Lcom/google/gct/login2/OAuthServer;", "settings", "Lcom/google/gct/login2/settings/GoogleLoginApplicationSettings;", "email", "", "<init>", "(Lcom/google/api/client/http/HttpTransport;Lcom/google/gct/login2/common/UiFacade;Lcom/google/gct/login2/OAuthServer;Lcom/google/gct/login2/settings/GoogleLoginApplicationSettings;Ljava/lang/String;)V", "authResponse", "Lcom/google/api/client/googleapis/auth/oauth2/GoogleTokenResponse;", "features", "", "Lcom/google/gct/login2/LoginFeature;", "(Lcom/google/api/client/http/HttpTransport;Lcom/google/gct/login2/common/UiFacade;Lcom/google/gct/login2/OAuthServer;Lcom/google/gct/login2/settings/GoogleLoginApplicationSettings;Lcom/google/api/client/googleapis/auth/oauth2/GoogleTokenResponse;Ljava/util/Set;)V", "getEmail", "()Ljava/lang/String;", "oAuthData", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/google/gct/login2/GoogleLoginState$OAuthData;", "notificationGroup", "Lcom/intellij/notification/NotificationGroup;", "tokenRefreshListener", "com/google/gct/login2/GoogleLoginState$tokenRefreshListener$1", "Lcom/google/gct/login2/GoogleLoginState$tokenRefreshListener$1;", "getAllowedFeatures", "isLoggedIn", "", "feature", "fetchAccessToken", "getCredential", "Lcom/google/api/client/auth/oauth2/Credential;", "logOut", "makeOAuthDataStore", "Lcom/google/gct/login2/common/OAuthDataStore;", "makeCredential", "accessToken", "refreshToken", "accessTokenExpiryTimeInSeconds", "", "is1pFlow", "toOAuthDataStore", "updateUserCredentials", "", "tokenResponse", "showSessionExpiredNotification", "featureContext", "OAuthData", "Companion", "google-login"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nGoogleLoginState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoogleLoginState.kt\ncom/google/gct/login2/GoogleLoginState\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,329:1\n1#2:330\n*E\n"})
public final class GoogleLoginState {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HttpTransport transport;
    @NotNull
    private final UiFacade uiFacade;
    @NotNull
    private final OAuthServer oAuthServer;
    @NotNull
    private final GoogleLoginApplicationSettings settings;
    @NotNull
    private final String email;
    @NotNull
    private final AtomicReference<OAuthData> oAuthData;
    @NotNull
    private final NotificationGroup notificationGroup;
    @NotNull
    private final tokenRefreshListener.1 tokenRefreshListener;
    public static final int $stable = 8;
    @NotNull
    private static final JsonFactory jsonFactory = (JsonFactory)new GsonFactory();

    @VisibleForTesting
    public GoogleLoginState(@NotNull HttpTransport transport, @NotNull UiFacade uiFacade, @NotNull OAuthServer oAuthServer, @NotNull GoogleLoginApplicationSettings settings, @NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
        Intrinsics.checkNotNullParameter((Object)uiFacade, (String)"uiFacade");
        Intrinsics.checkNotNullParameter((Object)oAuthServer, (String)"oAuthServer");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        this.transport = transport;
        this.uiFacade = uiFacade;
        this.oAuthServer = oAuthServer;
        this.settings = settings;
        this.email = email;
        this.oAuthData = new AtomicReference<Object>(null);
        NotificationGroup notificationGroup = NotificationGroup.Companion.findRegisteredGroup("Google Login");
        if (notificationGroup == null) {
            throw new IllegalStateException("No Google Login group registered.".toString());
        }
        this.notificationGroup = notificationGroup;
        this.tokenRefreshListener = new CredentialRefreshListener(this){
            final /* synthetic */ GoogleLoginState this$0;
            {
                this.this$0 = $receiver;
            }

            public void onTokenResponse(Credential credential, TokenResponse tokenResponse) {
                Intrinsics.checkNotNullParameter((Object)credential, (String)"credential");
                Intrinsics.checkNotNullParameter((Object)tokenResponse, (String)"tokenResponse");
            }

            public void onTokenErrorResponse(Credential credential, TokenErrorResponse tokenErrorResponse) {
                Intrinsics.checkNotNullParameter((Object)credential, (String)"credential");
                GoogleLoginStateKt.access$getLogger().warn("Error on token refresh: " + tokenErrorResponse);
                OAuthData oAuthData = GoogleLoginState.access$getOAuthData$p(this.this$0).getAndSet(null);
                if (oAuthData == null) {
                    return;
                }
                OAuthData lastOAuthData = oAuthData;
                GoogleLoginState.access$showSessionExpiredNotification(this.this$0, lastOAuthData.getAllowedFeatures());
            }
        };
    }

    @NotNull
    public final String getEmail() {
        return this.email;
    }

    public GoogleLoginState(@NotNull HttpTransport transport, @NotNull UiFacade uiFacade, @NotNull OAuthServer oAuthServer, @NotNull GoogleLoginApplicationSettings settings, @NotNull GoogleTokenResponse authResponse, @NotNull Set<? extends LoginFeature> features) {
        Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
        Intrinsics.checkNotNullParameter((Object)uiFacade, (String)"uiFacade");
        Intrinsics.checkNotNullParameter((Object)oAuthServer, (String)"oAuthServer");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)authResponse, (String)"authResponse");
        Intrinsics.checkNotNullParameter(features, (String)"features");
        String string = authResponse.getIdToken();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdToken(...)");
        JsonWebSignature jsonWebSignature = GoogleLoginState.Companion.parseIdToken(string);
        Object object = jsonWebSignature != null ? jsonWebSignature.getPayload().get((Object)"email") : null;
        String string2 = object instanceof String ? (String)object : null;
        if (string2 == null) {
            throw new Exception("Didn't receive email in JWT");
        }
        this(transport, uiFacade, oAuthServer, settings, string2);
        this.updateUserCredentials(authResponse, features);
    }

    @NotNull
    public final Set<LoginFeature> getAllowedFeatures() {
        Object object = this.oAuthData.get();
        if (object == null || (object = ((OAuthData)object).getAllowedFeatures()) == null) {
            object = SetsKt.emptySet();
        }
        return object;
    }

    public final boolean isLoggedIn(@NotNull LoginFeature feature) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Object object = this.oAuthData.get();
        return object != null && (object = ((OAuthData)object).getAllowedFeatures()) != null ? object.contains(feature) : false;
    }

    public final boolean isLoggedIn() {
        return this.oAuthData.get() != null;
    }

    @Nullable
    public final String fetchAccessToken() {
        OAuthData oAuthData = this.oAuthData.get();
        if (oAuthData == null) {
            return null;
        }
        OAuthData lastOAuthData = oAuthData;
        Credential credential = lastOAuthData.getCredential();
        if (credential.getExpiresInSeconds() <= 30L) {
            lastOAuthData.getCredential().refreshToken();
        }
        return credential.getAccessToken();
    }

    @Nullable
    public final Credential getCredential() {
        OAuthData oAuthData = this.oAuthData.get();
        return oAuthData != null ? oAuthData.getCredential() : null;
    }

    public final boolean logOut() {
        boolean status2 = true;
        try {
            this.oAuthData.updateAndGet(arg_0 -> GoogleLoginState.logOut$lambda$0(this, arg_0));
        }
        catch (IOException e) {
            GoogleLoginStateKt.access$getLogger().warn((Throwable)e);
            status2 = false;
            this.oAuthData.set(null);
        }
        return status2;
    }

    @Nullable
    public final OAuthDataStore makeOAuthDataStore() {
        OAuthData oAuthData = this.oAuthData.get();
        return oAuthData != null ? this.toOAuthDataStore(oAuthData) : null;
    }

    private final Credential makeCredential(String accessToken, String refreshToken, long accessTokenExpiryTimeInSeconds, boolean is1pFlow) {
        GoogleCredential.Builder builder;
        GoogleCredential.Builder $this$makeCredential_u24lambda_u241 = builder = new GoogleCredential.Builder();
        boolean bl = false;
        $this$makeCredential_u24lambda_u241.setTokenServerEncodedUrl(OAuthServerKt.getTokenUrl());
        $this$makeCredential_u24lambda_u241.setJsonFactory(jsonFactory);
        $this$makeCredential_u24lambda_u241.setTransport(this.transport);
        $this$makeCredential_u24lambda_u241.setClientSecrets(StudioClientInfo.Companion.getInstance().getGoogleClientSecrets(is1pFlow));
        $this$makeCredential_u24lambda_u241.addRefreshListener((CredentialRefreshListener)this.tokenRefreshListener);
        GoogleCredential googleCredential = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)googleCredential, (String)"build(...)");
        Credential cred = (Credential)googleCredential;
        cred.setAccessToken(accessToken);
        cred.setRefreshToken(refreshToken);
        cred.setExpiresInSeconds(Long.valueOf(accessTokenExpiryTimeInSeconds));
        return cred;
    }

    private final OAuthDataStore toOAuthDataStore(OAuthData $this$toOAuthDataStore) {
        return new OAuthDataStore(this.email, $this$toOAuthDataStore.getCredential().getRefreshToken(), $this$toOAuthDataStore.is1pFlow(), $this$toOAuthDataStore.getAllowedFeatures());
    }

    private final void updateUserCredentials(GoogleTokenResponse tokenResponse, Set<? extends LoginFeature> features) {
        String string = tokenResponse.getAccessToken();
        String string2 = tokenResponse.getRefreshToken();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getRefreshToken(...)");
        Long l = tokenResponse.getExpiresInSeconds();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getExpiresInSeconds(...)");
        long l2 = ((Number)l).longValue();
        Object t = StudioFlags.USE_1P_LOGIN_UI.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        Credential credential = this.makeCredential(string, string2, l2, (Boolean)t);
        Object t2 = StudioFlags.USE_1P_LOGIN_UI.get();
        Intrinsics.checkNotNullExpressionValue(t2, (String)"get(...)");
        OAuthData newOAuthData = new OAuthData(credential, features, (Boolean)t2);
        this.oAuthData.updateAndGet(arg_0 -> GoogleLoginState.updateUserCredentials$lambda$3(newOAuthData, this, arg_0));
    }

    private final void showSessionExpiredNotification(Set<? extends LoginFeature> featureContext) {
        String features = CollectionsKt.joinToString$default((Iterable)featureContext, (CharSequence)",", null, null, (int)0, null, GoogleLoginState::showSessionExpiredNotification$lambda$4, (int)30, null);
        this.notificationGroup.createNotification("Authentication error", "Your session (for " + features + ") has expired. Please sign in again", NotificationType.WARNING).addAction((AnAction)NotificationAction.createExpiring((String)"Sign in...", (arg_0, arg_1) -> GoogleLoginState.showSessionExpiredNotification$lambda$6((arg_0, arg_1) -> GoogleLoginState.showSessionExpiredNotification$lambda$5(this, featureContext, arg_0, arg_1), arg_0, arg_1))).notify(null);
    }

    private static final OAuthData logOut$lambda$0(GoogleLoginState this$0, OAuthData old) {
        if (old == null) {
            return null;
        }
        OAuthServer oAuthServer = this$0.oAuthServer;
        String string = old.getCredential().getAccessToken();
        if (string == null) {
            string = old.getCredential().getRefreshToken();
        }
        String string2 = string;
        Intrinsics.checkNotNull((Object)string2);
        oAuthServer.revokeToken(string2);
        return null;
    }

    private static final OAuthData updateUserCredentials$lambda$3(OAuthData $newOAuthData, GoogleLoginState this$0, OAuthData it) {
        OAuthData oAuthData;
        OAuthData it2 = oAuthData = $newOAuthData;
        boolean bl = false;
        this$0.settings.saveIncrementalOAuthData(this$0.toOAuthDataStore(it2));
        return oAuthData;
    }

    private static final CharSequence showSessionExpiredNotification$lambda$4(LoginFeature it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getKey();
    }

    private static final Unit showSessionExpiredNotification$lambda$5(GoogleLoginState this$0, Set $featureContext, AnActionEvent anActionEvent, Notification notification) {
        GoogleLoginService googleLoginService = GoogleLoginService.Companion.getInstance();
        PreferredUser.User user = new PreferredUser.User(this$0.email);
        GoogleLoginPluginEvent.LoginType loginType = GoogleLoginPluginEvent.LoginType.AUTH_ERROR_NOTIFICATION_LOGIN;
        GoogleLoginService.logInBlocking$default(googleLoginService, $featureContext, loginType, user, false, null, 24, null);
        return Unit.INSTANCE;
    }

    private static final void showSessionExpiredNotification$lambda$6(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ void access$showSessionExpiredNotification(GoogleLoginState $this, Set featureContext) {
        $this.showSessionExpiredNotification(featureContext);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J@\u0010\u0006\u001a\u0004\u0018\u00010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J.\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u0018\u001a\n \u001a*\u0004\u0018\u00010\u00190\u00192\u0006\u0010\u001b\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/google/gct/login2/GoogleLoginState$Companion;", "", "<init>", "()V", "jsonFactory", "Lcom/google/api/client/json/JsonFactory;", "loginAndCreate", "Lcom/google/gct/login2/GoogleLoginState;", "features", "", "Lcom/google/gct/login2/LoginFeature;", "preferredUser", "", "transport", "Lcom/google/api/client/http/HttpTransport;", "uiFacade", "Lcom/google/gct/login2/common/UiFacade;", "oAuthServer", "Lcom/google/gct/login2/OAuthServer;", "settings", "Lcom/google/gct/login2/settings/GoogleLoginApplicationSettings;", "createFromPersistence", "oAuthDataStore", "Lcom/google/gct/login2/common/OAuthDataStore;", "parseIdToken", "Lcom/google/api/client/json/webtoken/JsonWebSignature;", "kotlin.jvm.PlatformType", "idTokenString", "google-login"})
    @SourceDebugExtension(value={"SMAP\nGoogleLoginState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoogleLoginState.kt\ncom/google/gct/login2/GoogleLoginState$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,329:1\n1374#2:330\n1460#2,5:331\n1563#2:336\n1634#2,3:337\n1617#2,9:340\n1869#2:349\n1870#2:351\n1626#2:352\n1#3:350\n1#3:353\n*S KotlinDebug\n*F\n+ 1 GoogleLoginState.kt\ncom/google/gct/login2/GoogleLoginState$Companion\n*L\n268#1:330\n268#1:331,5\n268#1:336\n268#1:337,3\n275#1:340,9\n275#1:349\n275#1:351\n275#1:352\n275#1:350\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final GoogleLoginState loginAndCreate(@NotNull Set<? extends LoginFeature> features, @Nullable String preferredUser, @NotNull HttpTransport transport, @NotNull UiFacade uiFacade, @NotNull OAuthServer oAuthServer, @NotNull GoogleLoginApplicationSettings settings) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Object object;
            Iterable $this$mapTo$iv$iv;
            void $this$map$iv;
            Object list$iv$iv;
            LoginFeature it;
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter(features, (String)"features");
            Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
            Intrinsics.checkNotNullParameter((Object)uiFacade, (String)"uiFacade");
            Intrinsics.checkNotNullParameter((Object)oAuthServer, (String)"oAuthServer");
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            Set featuresRequired = SetsKt.plus(features, (Iterable)LoginFeature.Companion.getEnforcedFeatures());
            Iterable $this$flatMap$iv = featuresRequired;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (LoginFeature)element$iv$iv;
                boolean bl = false;
                list$iv$iv = it.getOAuthScopes();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$flatMapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                list$iv$iv = (OAuthScope)((Object)item$iv$iv);
                object = destination$iv$iv;
                boolean bl = false;
                object.add(((OAuthScope)((Object)it)).getScope());
            }
            List scopesRequired = (List)destination$iv$iv;
            Ref.ObjectRef loginState = new Ref.ObjectRef();
            $this$mapTo$iv$iv = featuresRequired;
            String string = preferredUser;
            Collection collection2 = scopesRequired;
            object = uiFacade;
            boolean $i$f$mapNotNull = false;
            void $i$f$mapTo22 = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                LoginCallbackHandler it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                LoginFeature it2 = (LoginFeature)element$iv$iv;
                boolean bl2 = false;
                if (it2.getHandler() == null) continue;
                boolean bl3 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List list = (List)destination$iv$iv2;
            boolean success = object.interactWithBrowser(collection2, string, list, (Function1<? super AuthorizationCodeHolder, ? extends Credential>)((Function1)arg_0 -> Companion.loginAndCreate$lambda$4(oAuthServer, transport, uiFacade, settings, featuresRequired, loginState, arg_0)));
            return success ? (GoogleLoginState)loginState.element : null;
        }

        @NotNull
        public final GoogleLoginState createFromPersistence(@NotNull OAuthDataStore oAuthDataStore, @NotNull HttpTransport transport, @NotNull UiFacade uiFacade, @NotNull OAuthServer oAuthServer, @NotNull GoogleLoginApplicationSettings settings) {
            GoogleLoginState googleLoginState;
            Intrinsics.checkNotNullParameter((Object)oAuthDataStore, (String)"oAuthDataStore");
            Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
            Intrinsics.checkNotNullParameter((Object)uiFacade, (String)"uiFacade");
            Intrinsics.checkNotNullParameter((Object)oAuthServer, (String)"oAuthServer");
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            GoogleLoginState $this$createFromPersistence_u24lambda_u245 = googleLoginState = new GoogleLoginState(transport, uiFacade, oAuthServer, settings, oAuthDataStore.getUserEmail());
            boolean bl = false;
            String string = oAuthDataStore.getRefreshToken();
            if (string != null) {
                String refreshToken = string;
                Credential credential = $this$createFromPersistence_u24lambda_u245.makeCredential(null, refreshToken, 0L, oAuthDataStore.is1pFlow());
                $this$createFromPersistence_u24lambda_u245.oAuthData.set(new OAuthData(credential, oAuthDataStore.getAllowedFeatures(), oAuthDataStore.is1pFlow()));
            }
            return googleLoginState;
        }

        private final JsonWebSignature parseIdToken(String idTokenString) {
            return JsonWebSignature.parse((JsonFactory)((JsonFactory)new GsonFactory()), (String)idTokenString);
        }

        private static final Credential loginAndCreate$lambda$4(OAuthServer $oAuthServer, HttpTransport $transport, UiFacade $uiFacade, GoogleLoginApplicationSettings $settings, Set $featuresRequired, Ref.ObjectRef $loginState, AuthorizationCodeHolder authorizationCodeHolder) {
            GoogleLoginState googleLoginState;
            Intrinsics.checkNotNullParameter((Object)authorizationCodeHolder, (String)"authorizationCodeHolder");
            GoogleTokenResponse authResponse = $oAuthServer.getToken(authorizationCodeHolder);
            GoogleLoginState it = googleLoginState = new GoogleLoginState($transport, $uiFacade, $oAuthServer, $settings, authResponse, $featuresRequired);
            boolean bl = false;
            $loginState.element = it;
            return googleLoginState.getCredential();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\bH\u00c6\u0003J-\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/google/gct/login2/GoogleLoginState$OAuthData;", "", "credential", "Lcom/google/api/client/auth/oauth2/Credential;", "allowedFeatures", "", "Lcom/google/gct/login2/LoginFeature;", "is1pFlow", "", "<init>", "(Lcom/google/api/client/auth/oauth2/Credential;Ljava/util/Set;Z)V", "getCredential", "()Lcom/google/api/client/auth/oauth2/Credential;", "getAllowedFeatures", "()Ljava/util/Set;", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "google-login"})
    @StabilityInferred(parameters=0)
    public static final class OAuthData {
        @NotNull
        private final Credential credential;
        @NotNull
        private final Set<LoginFeature> allowedFeatures;
        private final boolean is1pFlow;
        public static final int $stable = 8;

        public OAuthData(@NotNull Credential credential, @NotNull Set<? extends LoginFeature> allowedFeatures, boolean is1pFlow) {
            Intrinsics.checkNotNullParameter((Object)credential, (String)"credential");
            Intrinsics.checkNotNullParameter(allowedFeatures, (String)"allowedFeatures");
            this.credential = credential;
            this.allowedFeatures = allowedFeatures;
            this.is1pFlow = is1pFlow;
        }

        @NotNull
        public final Credential getCredential() {
            return this.credential;
        }

        @NotNull
        public final Set<LoginFeature> getAllowedFeatures() {
            return this.allowedFeatures;
        }

        public final boolean is1pFlow() {
            return this.is1pFlow;
        }

        @NotNull
        public final Credential component1() {
            return this.credential;
        }

        @NotNull
        public final Set<LoginFeature> component2() {
            return this.allowedFeatures;
        }

        public final boolean component3() {
            return this.is1pFlow;
        }

        @NotNull
        public final OAuthData copy(@NotNull Credential credential, @NotNull Set<? extends LoginFeature> allowedFeatures, boolean is1pFlow) {
            Intrinsics.checkNotNullParameter((Object)credential, (String)"credential");
            Intrinsics.checkNotNullParameter(allowedFeatures, (String)"allowedFeatures");
            return new OAuthData(credential, allowedFeatures, is1pFlow);
        }

        public static /* synthetic */ OAuthData copy$default(OAuthData oAuthData, Credential credential, Set set2, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                credential = oAuthData.credential;
            }
            if ((n & 2) != 0) {
                set2 = oAuthData.allowedFeatures;
            }
            if ((n & 4) != 0) {
                bl = oAuthData.is1pFlow;
            }
            return oAuthData.copy(credential, set2, bl);
        }

        @NotNull
        public String toString() {
            return "OAuthData(credential=" + this.credential + ", allowedFeatures=" + this.allowedFeatures + ", is1pFlow=" + this.is1pFlow + ")";
        }

        public int hashCode() {
            int result2 = this.credential.hashCode();
            result2 = result2 * 31 + ((Object)this.allowedFeatures).hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.is1pFlow);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OAuthData)) {
                return false;
            }
            OAuthData oAuthData = (OAuthData)other;
            if (!Intrinsics.areEqual((Object)this.credential, (Object)oAuthData.credential)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.allowedFeatures, oAuthData.allowedFeatures)) {
                return false;
            }
            return this.is1pFlow == oAuthData.is1pFlow;
        }
    }
}

