/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.sdk;

import com.android.prefs.AndroidLocationsProvider;
import com.android.prefs.AndroidLocationsSingleton;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.DeviceManager;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.sdk.AndroidSdkPath;
import com.android.tools.sdk.DeviceManagers;
import com.android.tools.sdk.LoggerProgressIndicator;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidSdkData {
    private final DeviceManager myDeviceManager;
    private static final ConcurrentMap<String, SoftReference<AndroidSdkData>> ourCache = Maps.newConcurrentMap();
    private final AndroidSdkHandler mySdkHandler;

    @Nullable
    public static AndroidSdkData getSdkData(@NotNull File sdkLocation) {
        return AndroidSdkData.getSdkData(sdkLocation, false);
    }

    @Nullable
    public static AndroidSdkData getSdkData(@NotNull File sdkLocation, boolean forceReparse) {
        return AndroidSdkData.getSdkData(sdkLocation, forceReparse, true);
    }

    @NotNull
    public static AndroidSdkData getSdkDataWithoutValidityCheck(@NotNull File sdkLocation) {
        return Objects.requireNonNull(AndroidSdkData.getSdkData(sdkLocation, false, false));
    }

    @Nullable
    private static AndroidSdkData getSdkData(@NotNull File sdkLocation, boolean forceReparse, boolean checkValidity) {
        SoftReference cachedRef;
        String canonicalPath;
        try {
            canonicalPath = sdkLocation.getCanonicalPath();
        }
        catch (IOException ignore) {
            if (checkValidity) {
                return null;
            }
            canonicalPath = sdkLocation.getPath();
        }
        if (!forceReparse && (cachedRef = (SoftReference)ourCache.get(canonicalPath)) != null) {
            AndroidSdkData cachedData = (AndroidSdkData)cachedRef.get();
            if (cachedData == null) {
                ourCache.remove(canonicalPath, cachedRef);
            } else {
                return cachedData;
            }
        }
        File canonicalLocation = new File(canonicalPath);
        if (checkValidity && !AndroidSdkPath.isValid(canonicalLocation)) {
            return null;
        }
        AndroidSdkData sdkData = new AndroidSdkData(canonicalLocation);
        ourCache.put(canonicalPath, new SoftReference<AndroidSdkData>(sdkData));
        return sdkData;
    }

    @Nullable
    public static AndroidSdkData getSdkData(@NotNull String sdkPath) {
        return AndroidSdkData.getSdkData(new File(sdkPath));
    }

    private AndroidSdkData(@NotNull File localSdk) {
        this.mySdkHandler = AndroidSdkHandler.getInstance((AndroidLocationsProvider)AndroidLocationsSingleton.INSTANCE, (Path)localSdk.toPath());
        this.myDeviceManager = DeviceManagers.getDeviceManager(this.mySdkHandler);
    }

    @NotNull
    public Path getLocation() {
        Path location = this.mySdkHandler.getLocation();
        assert (location != null);
        return location;
    }

    @NotNull
    public File getLocationFile() {
        return this.mySdkHandler.getLocation().toFile();
    }

    @Deprecated
    @NotNull
    public String getPath() {
        return this.getLocation().toString();
    }

    @Nullable
    public BuildToolInfo getLatestBuildTool(boolean allowPreview) {
        return this.mySdkHandler.getLatestBuildTool((ProgressIndicator)new LoggerProgressIndicator(this.getClass()), allowPreview);
    }

    @NotNull
    public IAndroidTarget[] getTargets() {
        Collection<IAndroidTarget> targets = this.getTargetCollection();
        return targets.toArray(new IAndroidTarget[0]);
    }

    @NotNull
    private Collection<IAndroidTarget> getTargetCollection() {
        LoggerProgressIndicator progress2 = new LoggerProgressIndicator(this.getClass());
        return this.mySdkHandler.getAndroidTargetManager((ProgressIndicator)progress2).getTargets((ProgressIndicator)progress2);
    }

    @NotNull
    public IAndroidTarget[] getTargets(boolean includeAddOns) {
        Collection<IAndroidTarget> targets = this.getTargetCollection();
        ArrayList<IAndroidTarget> result2 = new ArrayList<IAndroidTarget>();
        if (!includeAddOns) {
            for (IAndroidTarget target2 : targets) {
                if (!target2.isPlatform()) continue;
                result2.add(target2);
            }
        } else {
            result2.addAll(targets);
        }
        return result2.toArray(new IAndroidTarget[0]);
    }

    private static boolean targetHasId(@NotNull IAndroidTarget target2, @NotNull String id2) {
        return id2.equals(target2.getVersion().getApiString()) || id2.equals(target2.getVersionName());
    }

    @Nullable
    public IAndroidTarget findTargetByApiLevel(@NotNull String apiLevel) {
        for (IAndroidTarget target2 : this.getTargets()) {
            if (!AndroidSdkData.targetHasId(target2, apiLevel)) continue;
            return target2;
        }
        return null;
    }

    @Nullable
    public IAndroidTarget findTargetByHashString(@NotNull String hashString) {
        LoggerProgressIndicator progress2 = new LoggerProgressIndicator(this.getClass());
        return this.mySdkHandler.getAndroidTargetManager((ProgressIndicator)progress2).getTargetFromHashString(hashString, (ProgressIndicator)progress2);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        AndroidSdkData sdkData = (AndroidSdkData)obj;
        return this.getLocation().normalize().toAbsolutePath().toString().equals(sdkData.getLocation().normalize().toAbsolutePath().toString());
    }

    public int hashCode() {
        return this.getLocation().normalize().toAbsolutePath().toString().hashCode();
    }

    @NotNull
    public DeviceManager getDeviceManager() {
        return this.myDeviceManager;
    }

    @NotNull
    public AndroidSdkHandler getSdkHandler() {
        return this.mySdkHandler;
    }
}

