/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.res;

import com.android.ide.common.rendering.api.AssetRepository;
import com.android.tools.res.AssetFileOpener;
import com.android.tools.res.FileResourceReader;
import com.android.tools.res.ResourceFiles;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\"\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/res/AssetRepositoryBase;", "Lcom/android/ide/common/rendering/api/AssetRepository;", "assetFileOpener", "Lcom/android/tools/res/AssetFileOpener;", "<init>", "(Lcom/android/tools/res/AssetFileOpener;)V", "isSupported", "", "isFileResource", "path", "", "openNonAsset", "Ljava/io/InputStream;", "cookie", "", "mode", "openAsset", "intellij.android.render-resources"})
public final class AssetRepositoryBase
extends AssetRepository {
    @NotNull
    private final AssetFileOpener assetFileOpener;

    public AssetRepositoryBase(@NotNull AssetFileOpener assetFileOpener) {
        Intrinsics.checkNotNullParameter((Object)assetFileOpener, (String)"assetFileOpener");
        this.assetFileOpener = assetFileOpener;
    }

    public boolean isSupported() {
        return true;
    }

    public boolean isFileResource(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return ResourceFiles.isResourceFile(path);
    }

    @Nullable
    public InputStream openNonAsset(int cookie, @NotNull String path, int mode) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (StringsKt.startsWith$default((String)path, (String)"apk:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)path, (String)"jar:", (boolean)false, (int)2, null)) {
            return new ByteArrayInputStream(FileResourceReader.readBytes(path));
        }
        return this.assetFileOpener.openNonAssetFile(path);
    }

    @Nullable
    public InputStream openAsset(@NotNull String path, int mode) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.assetFileOpener.openAssetFile(path);
    }
}

