/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rendering.parsers;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceFolderType;
import com.android.tools.rendering.parsers.RenderXmlAttribute;
import com.android.tools.rendering.parsers.RenderXmlFile;
import com.android.tools.rendering.parsers.RenderXmlTag;
import com.android.tools.rendering.parsers.XmlParser;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.io.File;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\t\u0010\rB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\u000eJ\u001c\u0010\"\u001a\u0004\u0018\u00010\u00052\u0006\u0010#\u001a\u00020\u00052\b\u0010$\u001a\u0004\u0018\u00010\u0005H\u0016J\b\u0010%\u001a\u00020&H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0012R\u0014\u0010\u001e\u001a\u00020\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006'"}, d2={"Lcom/android/tools/rendering/parsers/RenderXmlFileSnapshot;", "Lcom/android/tools/rendering/parsers/RenderXmlFile;", "project", "Lcom/intellij/openapi/project/Project;", "name", "", "folderType", "Lcom/android/resources/ResourceFolderType;", "fileContent", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/android/resources/ResourceFolderType;Ljava/lang/String;)V", "filePath", "Lcom/android/ide/common/util/PathString;", "(Lcom/intellij/openapi/project/Project;Lcom/android/ide/common/util/PathString;)V", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getName", "()Ljava/lang/String;", "getFolderType", "()Lcom/android/resources/ResourceFolderType;", "rootTag", "Lcom/android/tools/rendering/parsers/RenderXmlTag;", "getRootTag", "()Lcom/android/tools/rendering/parsers/RenderXmlTag;", "isValid", "", "()Z", "relativePath", "getRelativePath", "resourceNamespace", "Lcom/android/ide/common/rendering/api/ResourceNamespace;", "getResourceNamespace", "()Lcom/android/ide/common/rendering/api/ResourceNamespace;", "getRootTagAttribute", "attribute", "namespace", "get", "Lcom/intellij/psi/PsiFile;", "intellij.android.rendering"})
@SourceDebugExtension(value={"SMAP\nRenderXmlFileSnapshot.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenderXmlFileSnapshot.kt\ncom/android/tools/rendering/parsers/RenderXmlFileSnapshot\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,58:1\n1#2:59\n*E\n"})
public final class RenderXmlFileSnapshot
implements RenderXmlFile {
    @NotNull
    private final Project project;
    @NotNull
    private final String name;
    @Nullable
    private final ResourceFolderType folderType;
    @NotNull
    private final RenderXmlTag rootTag;
    private final boolean isValid;
    @NotNull
    private final String relativePath;
    @NotNull
    private final ResourceNamespace resourceNamespace;

    public RenderXmlFileSnapshot(@NotNull Project project, @NotNull String name2, @Nullable ResourceFolderType folderType, @NotNull String fileContent) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)fileContent, (String)"fileContent");
        this.project = project;
        this.name = name2;
        this.folderType = folderType;
        this.rootTag = XmlParser.parseRootTag(fileContent);
        this.isValid = true;
        this.relativePath = this.getName();
        ResourceNamespace resourceNamespace = ResourceNamespace.RES_AUTO;
        Intrinsics.checkNotNullExpressionValue((Object)resourceNamespace, (String)"RES_AUTO");
        this.resourceNamespace = resourceNamespace;
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public ResourceFolderType getFolderType() {
        return this.folderType;
    }

    public RenderXmlFileSnapshot(@NotNull Project project, @NotNull PathString filePath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        String string = filePath.getFileName();
        String string2 = filePath.getParentFileName();
        Intrinsics.checkNotNull((Object)string2);
        ResourceFolderType resourceFolderType = ResourceFolderType.getFolderType((String)string2);
        File file = filePath.toFile();
        Intrinsics.checkNotNull((Object)file);
        this(project, string, resourceFolderType, new String(FilesKt.readBytes((File)file), Charsets.UTF_8));
    }

    public RenderXmlFileSnapshot(@NotNull Project project, @NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        this(project, new PathString(filePath));
    }

    @Override
    @NotNull
    public RenderXmlTag getRootTag() {
        return this.rootTag;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    @NotNull
    public String getRelativePath() {
        return this.relativePath;
    }

    @Override
    @NotNull
    public ResourceNamespace getResourceNamespace() {
        return this.resourceNamespace;
    }

    @Override
    @Nullable
    public String getRootTagAttribute(@NotNull String attribute2, @Nullable String namespace) {
        Object object;
        Object object2;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)attribute2, (String)"attribute");
                object2 = namespace;
                if (object2 == null) break block2;
                String it = object2;
                boolean bl = false;
                RenderXmlAttribute renderXmlAttribute = this.getRootTag().getAttribute(namespace, attribute2);
                object2 = renderXmlAttribute;
                if (renderXmlAttribute != null) break block3;
            }
            object2 = this.getRootTag().getAttribute(attribute2);
        }
        return (object = object2) != null ? object.getValue() : null;
    }

    @Override
    @NotNull
    public PsiFile get() {
        throw new NotImplementedError("Getting PsiFile from XmlFileSnapshot is not supported.");
    }
}

