/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rendering.imagepool;

import com.android.tools.rendering.imagepool.ImagePool;
import com.android.tools.rendering.imagepool.ImagePoolImpl;
import com.android.tools.rendering.imagepool.NonPooledImage;
import java.awt.image.BufferedImage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImagePoolFactory {
    private static final ImagePool NO_POOL_INSTANCE = new ImagePool(){

        @Override
        @NotNull
        public ImagePool.Image create(int w, int h, int type) {
            return NonPooledImage.create(w, h, type);
        }

        @Override
        @NotNull
        public ImagePool.Image copyOf(@Nullable BufferedImage origin) {
            return origin != null ? NonPooledImage.copyOf(origin) : NULL_POOLED_IMAGE;
        }

        @Override
        @Nullable
        public ImagePool.Stats getStats() {
            return null;
        }

        @Override
        public void dispose() {
        }
    };

    private ImagePoolFactory() {
    }

    @NotNull
    public static ImagePool createImagePool() {
        return new ImagePoolImpl(new int[]{50, 500, 1000, 1500, 2000, 5000}, (w, h) -> type -> {
            if (w * h < 1000) {
                return 0;
            }
            return 50000000 / (w * h);
        });
    }

    @NotNull
    public static ImagePool getNonPooledPool() {
        return NO_POOL_INSTANCE;
    }
}

