/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rendering.classloading;

import com.android.tools.rendering.classloading.HierarchicalTimeCounter;
import com.android.tools.rendering.classloading.ModuleClassLoaderDiagnosticsWrite;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.concurrent.atomic.LongAdder;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001:\u0001$B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001fR\u0014\u0010\"\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u001f\u00a8\u0006%"}, d2={"Lcom/android/tools/rendering/classloading/ModuleClassLoadedDiagnosticsImpl;", "Lcom/android/tools/rendering/classloading/ModuleClassLoaderDiagnosticsWrite;", "<init>", "()V", "totalLoadTimeCounterMs", "Lcom/android/tools/rendering/classloading/HierarchicalTimeCounter;", "totalFindTimeCounterMs", "totalLoadTimeMs", "Ljava/util/concurrent/atomic/LongAdder;", "totalFindTimeMs", "totalClassesFound", "totalRewriteTimeMs", "foundClasses", "Ljava/util/PriorityQueue;", "Lcom/android/tools/rendering/classloading/ModuleClassLoadedDiagnosticsImpl$ClassFoundReport;", "classLoadStart", "", "fqn", "", "classLoadedEnd", "timeMs", "", "classFindStart", "classFindEnd", "wasFoud", "", "classRewritten", "length", "", "classesFound", "getClassesFound", "()J", "accumulatedFindTimeMs", "getAccumulatedFindTimeMs", "accumulatedRewriteTimeMs", "getAccumulatedRewriteTimeMs", "ClassFoundReport", "intellij.android.rendering"})
@VisibleForTesting
public final class ModuleClassLoadedDiagnosticsImpl
implements ModuleClassLoaderDiagnosticsWrite {
    @NotNull
    private final HierarchicalTimeCounter totalLoadTimeCounterMs = new HierarchicalTimeCounter();
    @NotNull
    private final HierarchicalTimeCounter totalFindTimeCounterMs = new HierarchicalTimeCounter();
    @NotNull
    private final LongAdder totalLoadTimeMs = new LongAdder();
    @NotNull
    private final LongAdder totalFindTimeMs = new LongAdder();
    @NotNull
    private final LongAdder totalClassesFound = new LongAdder();
    @NotNull
    private final LongAdder totalRewriteTimeMs = new LongAdder();
    @NotNull
    private final PriorityQueue<ClassFoundReport> foundClasses = new PriorityQueue<Object>(100, Comparator.comparing(arg_0 -> ModuleClassLoadedDiagnosticsImpl.foundClasses$lambda$1(ModuleClassLoadedDiagnosticsImpl::foundClasses$lambda$0, arg_0)));

    @Override
    public void classLoadStart(@NotNull String fqn) {
        Intrinsics.checkNotNullParameter((Object)fqn, (String)"fqn");
        this.totalLoadTimeCounterMs.start(fqn);
    }

    @Override
    public void classLoadedEnd(@NotNull String fqn, long timeMs) {
        Intrinsics.checkNotNullParameter((Object)fqn, (String)"fqn");
        try {
            this.totalLoadTimeMs.add(this.totalLoadTimeCounterMs.end(fqn, timeMs));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public void classFindStart(@NotNull String fqn) {
        Intrinsics.checkNotNullParameter((Object)fqn, (String)"fqn");
        this.totalFindTimeCounterMs.start(fqn);
    }

    @Override
    public void classFindEnd(@NotNull String fqn, boolean wasFoud, long timeMs) {
        Intrinsics.checkNotNullParameter((Object)fqn, (String)"fqn");
        try {
            this.totalFindTimeMs.add(this.totalFindTimeCounterMs.end(fqn, timeMs));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.totalClassesFound.increment();
        this.foundClasses.add(new ClassFoundReport(fqn, timeMs));
    }

    @Override
    public void classRewritten(@NotNull String fqn, int length, long timeMs) {
        Intrinsics.checkNotNullParameter((Object)fqn, (String)"fqn");
        this.totalRewriteTimeMs.add(timeMs);
    }

    @Override
    public long getClassesFound() {
        return this.totalClassesFound.sum();
    }

    @Override
    public long getAccumulatedFindTimeMs() {
        return this.totalFindTimeMs.sum();
    }

    @Override
    public long getAccumulatedRewriteTimeMs() {
        return this.totalRewriteTimeMs.sum();
    }

    private static final Long foundClasses$lambda$0(ClassFoundReport it) {
        return it.getTimeMs();
    }

    private static final Long foundClasses$lambda$1(Function1 $tmp0, Object p0) {
        return (Long)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/rendering/classloading/ModuleClassLoadedDiagnosticsImpl$ClassFoundReport;", "", "fqn", "", "timeMs", "", "<init>", "(Ljava/lang/String;J)V", "getFqn", "()Ljava/lang/String;", "getTimeMs", "()J", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.android.rendering"})
    private static final class ClassFoundReport {
        @NotNull
        private final String fqn;
        private final long timeMs;

        public ClassFoundReport(@NotNull String fqn, long timeMs) {
            Intrinsics.checkNotNullParameter((Object)fqn, (String)"fqn");
            this.fqn = fqn;
            this.timeMs = timeMs;
        }

        @NotNull
        public final String getFqn() {
            return this.fqn;
        }

        public final long getTimeMs() {
            return this.timeMs;
        }

        @NotNull
        public final String component1() {
            return this.fqn;
        }

        public final long component2() {
            return this.timeMs;
        }

        @NotNull
        public final ClassFoundReport copy(@NotNull String fqn, long timeMs) {
            Intrinsics.checkNotNullParameter((Object)fqn, (String)"fqn");
            return new ClassFoundReport(fqn, timeMs);
        }

        public static /* synthetic */ ClassFoundReport copy$default(ClassFoundReport classFoundReport, String string, long l, int n, Object object) {
            if ((n & 1) != 0) {
                string = classFoundReport.fqn;
            }
            if ((n & 2) != 0) {
                l = classFoundReport.timeMs;
            }
            return classFoundReport.copy(string, l);
        }

        @NotNull
        public String toString() {
            return "ClassFoundReport(fqn=" + this.fqn + ", timeMs=" + this.timeMs + ")";
        }

        public int hashCode() {
            int result2 = this.fqn.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.timeMs);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ClassFoundReport)) {
                return false;
            }
            ClassFoundReport classFoundReport = (ClassFoundReport)other;
            if (!Intrinsics.areEqual((Object)this.fqn, (Object)classFoundReport.fqn)) {
                return false;
            }
            return this.timeMs == classFoundReport.timeMs;
        }
    }
}

