/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.property.ptable.impl;

import com.android.tools.property.ptable.impl.PTablePosition;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JTable;
import javax.swing.LayoutFocusTraversalPolicy;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0016J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u0017\u001a\u00020\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\fH\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/property/ptable/impl/PTableFocusTraversalPolicy;", "Ljavax/swing/LayoutFocusTraversalPolicy;", "table", "Ljavax/swing/JTable;", "acceptFocus", "Lkotlin/Function0;", "", "<init>", "(Ljavax/swing/JTable;Lkotlin/jvm/functions/Function0;)V", "getTable", "()Ljavax/swing/JTable;", "getComponentAfter", "Ljava/awt/Component;", "aContainer", "Ljava/awt/Container;", "aComponent", "getComponentBefore", "editNextEditableCell", "forwards", "getFocusCandidateFromNewlyCreatedEditor", "getFirstComponent", "getLastComponent", "getDefaultComponent", "accept", "intellij.android.layout-ui"})
public final class PTableFocusTraversalPolicy
extends LayoutFocusTraversalPolicy {
    @NotNull
    private final JTable table;
    @NotNull
    private final Function0<Boolean> acceptFocus;

    public PTableFocusTraversalPolicy(@NotNull JTable table2, @NotNull Function0<Boolean> acceptFocus) {
        Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
        Intrinsics.checkNotNullParameter(acceptFocus, (String)"acceptFocus");
        this.table = table2;
        this.acceptFocus = acceptFocus;
    }

    @NotNull
    public final JTable getTable() {
        return this.table;
    }

    @Override
    @Nullable
    public Component getComponentAfter(@NotNull Container aContainer, @NotNull Component aComponent) {
        Intrinsics.checkNotNullParameter((Object)aContainer, (String)"aContainer");
        Intrinsics.checkNotNullParameter((Object)aComponent, (String)"aComponent");
        if (!this.table.isEditing()) {
            return null;
        }
        Component after = super.getComponentAfter(aContainer, aComponent);
        if (after != null && !Intrinsics.areEqual((Object)after, (Object)this.table)) {
            return after;
        }
        return this.editNextEditableCell(true);
    }

    @Override
    @Nullable
    public Component getComponentBefore(@NotNull Container aContainer, @NotNull Component aComponent) {
        Intrinsics.checkNotNullParameter((Object)aContainer, (String)"aContainer");
        Intrinsics.checkNotNullParameter((Object)aComponent, (String)"aComponent");
        if (!this.table.isEditing()) {
            return null;
        }
        Component before = super.getComponentBefore(aContainer, aComponent);
        if (before != null && !Intrinsics.areEqual((Object)before, (Object)this.table)) {
            return before;
        }
        return this.editNextEditableCell(false);
    }

    private final Component editNextEditableCell(boolean forwards) {
        if (!this.table.isVisible()) {
            return null;
        }
        int rows = this.table.getRowCount();
        int columns2 = this.table.getColumnCount();
        int selectedRow = this.table.hasFocus() ? this.table.getSelectedRow() : -1;
        PTablePosition pos = this.table.isEditing() ? new PTablePosition(this.table.getEditingRow(), this.table.getEditingColumn(), rows, columns2) : (!forwards ? new PTablePosition(rows, 0, rows, columns2) : (selectedRow >= 0 ? new PTablePosition(selectedRow - 1, columns2 - 1, rows, columns2) : new PTablePosition(-1, columns2 - 1, rows, columns2)));
        while (pos.next(forwards)) {
            Component component;
            if (!this.table.isCellEditable(pos.getRow(), pos.getColumn())) continue;
            this.table.setRowSelectionInterval(pos.getRow(), pos.getRow());
            if (!this.table.editCellAt(pos.getRow(), pos.getColumn()) || (component = this.getFocusCandidateFromNewlyCreatedEditor(forwards)) == null) continue;
            return component;
        }
        return null;
    }

    private final Component getFocusCandidateFromNewlyCreatedEditor(boolean forwards) {
        if (forwards) {
            return super.getFirstComponent(this.table);
        }
        return super.getLastComponent(this.table);
    }

    @Override
    @Nullable
    public Component getFirstComponent(@NotNull Container aContainer) {
        Intrinsics.checkNotNullParameter((Object)aContainer, (String)"aContainer");
        return this.editNextEditableCell(true);
    }

    @Override
    @Nullable
    public Component getLastComponent(@NotNull Container aContainer) {
        Intrinsics.checkNotNullParameter((Object)aContainer, (String)"aContainer");
        return this.editNextEditableCell(false);
    }

    @Override
    @Nullable
    public Component getDefaultComponent(@NotNull Container aContainer) {
        Intrinsics.checkNotNullParameter((Object)aContainer, (String)"aContainer");
        return (Boolean)this.acceptFocus.invoke() != false ? this.getFirstComponent(aContainer) : null;
    }

    @Override
    protected boolean accept(@Nullable Component aComponent) {
        if (Intrinsics.areEqual((Object)aComponent, (Object)this.table)) {
            return false;
        }
        return super.accept(aComponent);
    }
}

