/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.property.panel.impl.ui;

import com.android.tools.property.panel.impl.support.HtmlUtilKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.AbstractExpandableItemsHandler;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u000b\u0010\fR$\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/property/panel/impl/ui/ExpandableLabel;", "Ljavax/swing/JLabel;", "<init>", "()V", "expandableLabelHandler", "Lcom/android/tools/property/panel/impl/ui/ExpandableLabel$ExpandableLabelHandler;", "htmlText", "", "value", "", "showEllipsis", "setShowEllipsis", "(Z)V", "actualText", "getActualText", "()Ljava/lang/String;", "setActualText", "(Ljava/lang/String;)V", "updateText", "", "repaint", "r", "Ljava/awt/Rectangle;", "ExpandableLabelHandler", "intellij.android.layout-ui"})
public final class ExpandableLabel
extends JLabel {
    @NotNull
    private final ExpandableLabelHandler expandableLabelHandler = new ExpandableLabelHandler(this);
    @NotNull
    private String htmlText = "";
    private boolean showEllipsis = true;
    @NotNull
    private String actualText = "";

    private final void setShowEllipsis(boolean value2) {
        this.showEllipsis = value2;
        this.updateText();
    }

    @NotNull
    public final String getActualText() {
        return this.actualText;
    }

    public final void setActualText(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.actualText = value2;
        this.htmlText = ((CharSequence)value2).length() == 0 ? "" : HtmlUtilKt.toHtmlString(value2);
        this.updateText();
    }

    private final void updateText() {
        super.setText(this.showEllipsis ? this.actualText : this.htmlText);
    }

    @Override
    public void repaint(@NotNull Rectangle r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        super.repaint(r);
        this.setShowEllipsis(!this.expandableLabelHandler.isShowing());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0014J$\u0010\u000b\u001a\u0016\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0018\u00010\fj\u0004\u0018\u0001`\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0014J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0002H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/property/panel/impl/ui/ExpandableLabel$ExpandableLabelHandler;", "Lcom/intellij/ui/AbstractExpandableItemsHandler;", "Lcom/android/tools/property/panel/impl/ui/ExpandableLabel;", "component", "<init>", "(Lcom/android/tools/property/panel/impl/ui/ExpandableLabel;)V", "renderer", "Ljavax/swing/JLabel;", "getCellKeyForPoint", "point", "Ljava/awt/Point;", "getCellRendererAndBounds", "Lcom/intellij/openapi/util/Pair;", "Ljava/awt/Component;", "Ljava/awt/Rectangle;", "Lcom/android/tools/property/panel/impl/ui/ComponentBounds;", "key", "isPaintBorder", "", "doFillBackground", "", "height", "", "width", "g", "Ljava/awt/Graphics2D;", "computeBackgroundColor", "Ljava/awt/Color;", "computeOverlayBounds", "intellij.android.layout-ui"})
    private static final class ExpandableLabelHandler
    extends AbstractExpandableItemsHandler<ExpandableLabel, ExpandableLabel> {
        @NotNull
        private final JLabel renderer;

        public ExpandableLabelHandler(@NotNull ExpandableLabel component) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            super((JComponent)component);
            this.renderer = new JLabel();
        }

        @NotNull
        protected ExpandableLabel getCellKeyForPoint(@NotNull Point point) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            JComponent jComponent = this.myComponent;
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"myComponent");
            return (ExpandableLabel)jComponent;
        }

        @Nullable
        protected Pair<Component, Rectangle> getCellRendererAndBounds(@NotNull ExpandableLabel key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            if (key.getPreferredSize().width <= key.getWidth()) {
                return null;
            }
            if (!ApplicationManager.getApplication().isActive()) {
                return null;
            }
            this.renderer.setText(key.getText());
            this.renderer.setIcon(key.getIcon());
            this.renderer.setFont(key.getFont());
            this.renderer.setForeground(key.getForeground());
            key.setShowEllipsis(false);
            return Pair.create((Object)this.renderer, (Object)this.computeOverlayBounds(key));
        }

        protected boolean isPaintBorder() {
            return false;
        }

        protected void doFillBackground(int height, int width, @NotNull Graphics2D g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Color color = this.computeBackgroundColor();
            if (color == null) {
                return;
            }
            g.setColor(color);
            g.fillRect(0, 0, width, height);
        }

        private final Color computeBackgroundColor() {
            JComponent jComponent = this.myComponent;
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"myComponent");
            Component component = jComponent;
            while (!component.isOpaque()) {
                Container container = component.getParent();
                if (container == null) {
                    return null;
                }
                component = container;
            }
            return component.getBackground();
        }

        private final Rectangle computeOverlayBounds(ExpandableLabel key) {
            Rectangle bounds = new Rectangle(0, 0, key.getPreferredSize().width, key.getHeight());
            bounds.width += JBUI.scale((int)6);
            return bounds;
        }
    }
}

