/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.property.panel.impl.ui;

import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.property.panel.impl.model.CollapsibleLabelModel;
import com.android.tools.property.panel.impl.support.HtmlUtilKt;
import com.android.tools.property.panel.impl.ui.ExpandableLabel;
import com.android.tools.property.panel.impl.ui.FocusableActionButton;
import com.android.tools.property.panel.impl.ui.IconWithFocusBorder;
import com.android.tools.property.ptable.ColumnFraction;
import com.android.tools.property.ptable.ColumnFractionChangeHandler;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.impl.ToolbarUpdater;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001?B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u00102\u001a\u000203H\u0016J\u0010\u00104\u001a\u0002032\u0006\u00105\u001a\u000206H\u0014J\u0010\u00107\u001a\u0002032\u0006\u00105\u001a\u000206H\u0002J\u0010\u00108\u001a\u0002032\u0006\u00109\u001a\u00020#H\u0002J\b\u0010:\u001a\u000203H\u0002J\b\u0010;\u001a\u000203H\u0002J\u0016\u0010<\u001a\u00020\n2\f\u0010=\u001a\b\u0012\u0004\u0012\u0002030>H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010$\u001a\u0004\u0018\u00010\u00168F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0013\u0010'\u001a\u0004\u0018\u00010(8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R(\u0010-\u001a\u0004\u0018\u00010,2\b\u0010+\u001a\u0004\u0018\u00010,8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b.\u0010/\"\u0004\b0\u00101\u00a8\u0006@"}, d2={"Lcom/android/tools/property/panel/impl/ui/CollapsibleLabelPanel;", "Ljavax/swing/JPanel;", "model", "Lcom/android/tools/property/panel/impl/model/CollapsibleLabelModel;", "fontSize", "Lcom/intellij/util/ui/UIUtil$FontSize;", "fontStyle", "", "actions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "nameColumnFraction", "Lcom/android/tools/property/ptable/ColumnFraction;", "<init>", "(Lcom/android/tools/property/panel/impl/model/CollapsibleLabelModel;Lcom/intellij/util/ui/UIUtil$FontSize;ILjava/util/List;Lcom/android/tools/property/ptable/ColumnFraction;)V", "getModel", "()Lcom/android/tools/property/panel/impl/model/CollapsibleLabelModel;", "label", "Lcom/android/tools/property/panel/impl/ui/ExpandableLabel;", "getLabel", "()Lcom/android/tools/property/panel/impl/ui/ExpandableLabel;", "valueWithTrailingEllipsis", "", "valueWithoutEllipsis", "expandAction", "collapseAction", "activateAction", "expandButton", "Lcom/android/tools/property/panel/impl/ui/IconWithFocusBorder;", "actionButtons", "", "Lcom/android/tools/property/panel/impl/ui/FocusableActionButton;", "resizeHandler", "Lcom/android/tools/property/ptable/ColumnFractionChangeHandler;", "initialized", "", "text", "getText", "()Ljava/lang/String;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "value", "Ljavax/swing/border/Border;", "innerBorder", "getInnerBorder", "()Ljavax/swing/border/Border;", "setInnerBorder", "(Ljavax/swing/border/Border;)V", "updateUI", "", "paintComponent", "g", "Ljava/awt/Graphics;", "paintResizeNibs", "onResizeModeChange", "newResizeMode", "toggle", "valueChanged", "createAction", "operation", "Lkotlin/Function0;", "ButtonPanel", "intellij.android.layout-ui"})
@SourceDebugExtension(value={"SMAP\nCollapsibleLabelPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CollapsibleLabelPanel.kt\ncom/android/tools/property/panel/impl/ui/CollapsibleLabelPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,213:1\n1869#2,2:214\n1#3:216\n*S KotlinDebug\n*F\n+ 1 CollapsibleLabelPanel.kt\ncom/android/tools/property/panel/impl/ui/CollapsibleLabelPanel\n*L\n116#1:214,2\n*E\n"})
public final class CollapsibleLabelPanel
extends JPanel {
    @NotNull
    private final CollapsibleLabelModel model;
    @NotNull
    private final UIUtil.FontSize fontSize;
    private final int fontStyle;
    @NotNull
    private final ColumnFraction nameColumnFraction;
    @NotNull
    private final ExpandableLabel label;
    @NotNull
    private final String valueWithTrailingEllipsis;
    @NotNull
    private final String valueWithoutEllipsis;
    @NotNull
    private final AnAction expandAction;
    @NotNull
    private final AnAction collapseAction;
    @NotNull
    private final AnAction activateAction;
    @NotNull
    private final IconWithFocusBorder expandButton;
    @NotNull
    private final List<FocusableActionButton> actionButtons;
    @NotNull
    private final ColumnFractionChangeHandler resizeHandler;
    private boolean initialized;

    public CollapsibleLabelPanel(@NotNull CollapsibleLabelModel model, @NotNull UIUtil.FontSize fontSize, int fontStyle, @NotNull List<? extends AnAction> actions2, @NotNull ColumnFraction nameColumnFraction) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)fontSize, (String)"fontSize");
        Intrinsics.checkNotNullParameter(actions2, (String)"actions");
        Intrinsics.checkNotNullParameter((Object)nameColumnFraction, (String)"nameColumnFraction");
        super(new BorderLayout());
        this.model = model;
        this.fontSize = fontSize;
        this.fontStyle = fontStyle;
        this.nameColumnFraction = nameColumnFraction;
        this.label = new ExpandableLabel();
        this.valueWithTrailingEllipsis = this.model.getName();
        this.valueWithoutEllipsis = HtmlUtilKt.toHtmlString(this.model.getName());
        this.expandAction = this.createAction((Function0<Unit>)((Function0)() -> CollapsibleLabelPanel.expandAction$lambda$0(this)));
        this.collapseAction = this.createAction((Function0<Unit>)((Function0)() -> CollapsibleLabelPanel.collapseAction$lambda$1(this)));
        this.activateAction = this.createAction((Function0<Unit>)((Function0)() -> CollapsibleLabelPanel.activateAction$lambda$2(this)));
        this.expandButton = new IconWithFocusBorder((Function0<? extends AnAction>)((Function0)() -> CollapsibleLabelPanel.expandButton$lambda$4(this)), (Function0<? extends AnAction>)((Function0)() -> CollapsibleLabelPanel.expandButton$lambda$6(this)), (Function0<? extends AnAction>)((Function0)() -> CollapsibleLabelPanel.expandButton$lambda$8(this)));
        this.actionButtons = new ArrayList();
        this.resizeHandler = new ColumnFractionChangeHandler(this.nameColumnFraction, (Function0<Integer>)((Function0)() -> CollapsibleLabelPanel.resizeHandler$lambda$9(this)), (Function0<Integer>)((Function0)() -> CollapsibleLabelPanel.resizeHandler$lambda$10(this)), (Function0<Integer>)((Function0)CollapsibleLabelPanel::resizeHandler$lambda$11), (Function1<? super Boolean, Unit>)((Function1)new Function1<Boolean, Unit>((Object)this){

            public final void invoke(boolean p0) {
                CollapsibleLabelPanel.access$onResizeModeChange((CollapsibleLabelPanel)this.receiver, p0);
            }
        }));
        this.setBackground((Color)StudioColorsKt.getSecondaryPanelBackground());
        this.label.setActualText(this.model.getName());
        this.label.setFont(UIUtil.getLabelFont((UIUtil.FontSize)this.fontSize));
        if (this.fontStyle != 0) {
            this.label.setFont(this.label.getFont().deriveFont(this.fontStyle));
        }
        this.expandButton.setBorder((Border)JBUI.Borders.emptyRight((int)2));
        this.add((Component)((Object)this.expandButton), "West");
        this.add((Component)this.label, "Center");
        this.model.addValueChangedListener(() -> CollapsibleLabelPanel._init_$lambda$12(this));
        if (!((Collection)actions2).isEmpty()) {
            ButtonPanel buttonPanel = new ButtonPanel();
            Iterable $this$forEach$iv = actions2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AnAction it = (AnAction)element$iv;
                boolean bl = false;
                FocusableActionButton button = new FocusableActionButton(it);
                buttonPanel.add((Component)((Object)button));
                this.actionButtons.add(button);
            }
            this.add((Component)buttonPanel, "East");
            new ToolbarUpdater(){

                protected void updateActionsImpl(boolean forced) {
                    if (!ApplicationManager.getApplication().isDisposed()) {
                        Iterable $this$forEach$iv = actionButtons;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            FocusableActionButton it = (FocusableActionButton)((Object)element$iv);
                            boolean bl = false;
                            it.update();
                        }
                    }
                }
            };
        }
        this.label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event.getClickCount() > 1) {
                    this.toggle();
                }
            }
        });
        this.label.addMouseListener(this.resizeHandler);
        this.label.addMouseMotionListener(this.resizeHandler);
        this.valueChanged();
        this.initialized = true;
    }

    public /* synthetic */ CollapsibleLabelPanel(CollapsibleLabelModel collapsibleLabelModel, UIUtil.FontSize fontSize, int n, List list, ColumnFraction columnFraction, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n2 & 0x10) != 0) {
            columnFraction = new ColumnFraction(0.0f, false, 3, null);
        }
        this(collapsibleLabelModel, fontSize, n, list, columnFraction);
    }

    @NotNull
    public final CollapsibleLabelModel getModel() {
        return this.model;
    }

    @NotNull
    public final ExpandableLabel getLabel() {
        return this.label;
    }

    @Nullable
    public final String getText() {
        return this.label.getText();
    }

    @Nullable
    public final Icon getIcon() {
        return this.expandButton.getIcon();
    }

    @Nullable
    public final Border getInnerBorder() {
        return this.label.getBorder();
    }

    public final void setInnerBorder(@Nullable Border value2) {
        this.label.setBorder(value2);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.initialized) {
            this.label.setFont(UIUtil.getLabelFont((UIUtil.FontSize)this.fontSize));
            if (this.fontStyle != 0) {
                this.label.setFont(this.label.getFont().deriveFont(this.fontStyle));
            }
        }
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        super.paintComponent(g);
        if (this.resizeHandler.getResizeMode()) {
            this.paintResizeNibs(g);
        }
    }

    private final void paintResizeNibs(Graphics g) {
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2 = (Graphics2D)graphics;
        g2.setColor((Color)StudioColorsKt.getSelectionBackground());
        int x = MathKt.roundToInt((float)((float)this.getWidth() * this.nameColumnFraction.getValue()));
        g2.drawLine(x, 0, x, this.getHeight());
        g2.dispose();
    }

    private final void onResizeModeChange(boolean newResizeMode) {
        this.label.setCursor(Cursor.getPredefinedCursor(newResizeMode ? 10 : 0));
        this.repaint();
    }

    private final void toggle() {
        this.model.setExpanded(!this.model.getExpanded());
    }

    private final void valueChanged() {
        block1: {
            Container revalidateParent = this.isVisible() != this.model.getVisible() ? this.getParent() : null;
            this.setVisible(this.model.getVisible());
            this.label.setVisible(this.isVisible());
            this.label.setText(this.model.getShowEllipses() ? this.valueWithTrailingEllipsis : this.valueWithoutEllipsis);
            this.label.setForeground(this.model.getEnabled() ? UIUtil.getLabelForeground() : UIUtil.getLabelDisabledForeground());
            this.expandButton.setIcon(this.model.getIcon());
            Container container = revalidateParent;
            if (container != null) {
                container.revalidate();
            }
            Container container2 = revalidateParent;
            if (container2 == null) break block1;
            container2.repaint();
        }
    }

    private final AnAction createAction(Function0<Unit> operation) {
        return new AnAction(operation){
            final /* synthetic */ Function0<Unit> $operation;
            {
                this.$operation = $operation;
            }

            public void actionPerformed(AnActionEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$operation.invoke();
            }
        };
    }

    private static final Unit expandAction$lambda$0(CollapsibleLabelPanel this$0) {
        this$0.model.setExpanded(true);
        return Unit.INSTANCE;
    }

    private static final Unit collapseAction$lambda$1(CollapsibleLabelPanel this$0) {
        this$0.model.setExpanded(false);
        return Unit.INSTANCE;
    }

    private static final Unit activateAction$lambda$2(CollapsibleLabelPanel this$0) {
        this$0.toggle();
        return Unit.INSTANCE;
    }

    private static final AnAction expandButton$lambda$4(CollapsibleLabelPanel this$0) {
        AnAction anAction;
        AnAction it = anAction = this$0.expandAction;
        boolean bl = false;
        return this$0.model.getExpandable() ? anAction : null;
    }

    private static final AnAction expandButton$lambda$6(CollapsibleLabelPanel this$0) {
        AnAction anAction;
        AnAction it = anAction = this$0.collapseAction;
        boolean bl = false;
        return this$0.model.getExpandable() ? anAction : null;
    }

    private static final AnAction expandButton$lambda$8(CollapsibleLabelPanel this$0) {
        AnAction anAction;
        AnAction it = anAction = this$0.activateAction;
        boolean bl = false;
        return this$0.model.getExpandable() ? anAction : null;
    }

    private static final int resizeHandler$lambda$9(CollapsibleLabelPanel this$0) {
        return this$0.label.getX();
    }

    private static final int resizeHandler$lambda$10(CollapsibleLabelPanel this$0) {
        return this$0.getWidth();
    }

    private static final int resizeHandler$lambda$11() {
        return 0;
    }

    private static final void _init_$lambda$12(CollapsibleLabelPanel this$0) {
        this$0.valueChanged();
    }

    public static final /* synthetic */ void access$onResizeModeChange(CollapsibleLabelPanel $this, boolean newResizeMode) {
        $this.onResizeModeChange(newResizeMode);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/property/panel/impl/ui/CollapsibleLabelPanel$ButtonPanel;", "Ljavax/swing/JPanel;", "<init>", "()V", "doLayout", "", "intellij.android.layout-ui"})
    private static final class ButtonPanel
    extends JPanel {
        public ButtonPanel() {
            super(new FlowLayout(1, JBUI.scale((int)2), 0));
        }

        @Override
        public void doLayout() {
            super.doLayout();
            Iterator iterator2 = ArrayIteratorKt.iterator((Object[])this.getComponents());
            while (iterator2.hasNext()) {
                Component component = (Component)iterator2.next();
                component.setLocation(component.getX(), Math.max((this.getHeight() - component.getHeight()) / 2, 0));
            }
        }
    }
}

