/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.property.panel.impl.ui;

import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.property.panel.api.ActionIconButton;
import com.android.tools.property.panel.api.HelpSupport;
import com.android.tools.property.panel.api.TableExpansionState;
import com.android.tools.property.panel.impl.model.BasePropertyEditorModel;
import com.android.tools.property.panel.impl.ui.IconWithFocusBorder;
import com.android.tools.property.panel.impl.ui.PropertyTooltip;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiDataProvider;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0018B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0012H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\u0004\u0018\u00010\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00060\u000eR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/property/panel/impl/ui/ActionButtonBinding;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "model", "Lcom/android/tools/property/panel/impl/model/BasePropertyEditorModel;", "editor", "Ljavax/swing/JComponent;", "<init>", "(Lcom/android/tools/property/panel/impl/model/BasePropertyEditorModel;Ljavax/swing/JComponent;)V", "actionButtonModel", "Lcom/android/tools/property/panel/api/ActionIconButton;", "getActionButtonModel", "()Lcom/android/tools/property/panel/api/ActionIconButton;", "actionButton", "Lcom/android/tools/property/panel/impl/ui/ActionButtonBinding$ButtonWithCustomTooltip;", "initialized", "", "requestFocus", "", "updateFromModel", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "updateUI", "ButtonWithCustomTooltip", "intellij.android.layout-ui"})
public final class ActionButtonBinding
extends JPanel
implements UiDataProvider {
    @NotNull
    private final BasePropertyEditorModel model;
    @NotNull
    private final JComponent editor;
    @NotNull
    private final ButtonWithCustomTooltip actionButton;
    private boolean initialized;

    public ActionButtonBinding(@NotNull BasePropertyEditorModel model, @NotNull JComponent editor) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        super(new BorderLayout());
        this.model = model;
        this.editor = editor;
        ActionIconButton actionIconButton = this.getActionButtonModel();
        this.actionButton = new ButtonWithCustomTooltip((AnAction)(actionIconButton != null ? actionIconButton.getAction() : null));
        this.add((Component)this.editor, "Center");
        this.add((Component)((Object)this.actionButton), "East");
        this.updateFromModel();
        this.model.addListener(() -> ActionButtonBinding._init_$lambda$0(this));
        this.setBackground((Color)StudioColorsKt.getSecondaryPanelBackground());
        this.initialized = true;
    }

    private final ActionIconButton getActionButtonModel() {
        return this.model.getProperty().getBrowseButton();
    }

    @Override
    public void requestFocus() {
        this.editor.requestFocus();
    }

    private final void updateFromModel() {
        ActionIconButton actionIconButton = this.getActionButtonModel();
        this.actionButton.setIcon(this.model.displayedIcon(actionIconButton != null ? actionIconButton.getActionIcon() : null));
        this.actionButton.setVisible(this.model.getTableExpansionState() == TableExpansionState.NORMAL);
        this.setBackground(this.model.displayedBackground((Color)StudioColorsKt.getSecondaryPanelBackground()));
        this.setVisible(this.model.getVisible());
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        sink.set(HelpSupport.Companion.getPROPERTY_ITEM(), (Object)this.model.getProperty());
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.initialized) {
            ActionIconButton actionIconButton = this.getActionButtonModel();
            this.actionButton.setIcon(actionIconButton != null ? actionIconButton.getActionIcon() : null);
        }
    }

    private static final void _init_$lambda$0(ActionButtonBinding this$0) {
        this$0.updateFromModel();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/android/tools/property/panel/impl/ui/ActionButtonBinding$ButtonWithCustomTooltip;", "Lcom/android/tools/property/panel/impl/ui/IconWithFocusBorder;", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "(Lcom/android/tools/property/panel/impl/ui/ActionButtonBinding;Lcom/intellij/openapi/actionSystem/AnAction;)V", "getToolTipText", "", "event", "Ljava/awt/event/MouseEvent;", "intellij.android.layout-ui"})
    private final class ButtonWithCustomTooltip
    extends IconWithFocusBorder {
        public ButtonWithCustomTooltip(AnAction action2) {
            super(null, null, () -> ButtonWithCustomTooltip._init_$lambda$0(action2), 3, null);
        }

        @Nullable
        public String getToolTipText(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Object object = event.getSource();
            JComponent jComponent = object instanceof JComponent ? (JComponent)object : null;
            if (jComponent == null) {
                jComponent = (JComponent)((Object)this);
            }
            JComponent component = jComponent;
            ActionIconButton actionIconButton = ActionButtonBinding.this.getActionButtonModel();
            PropertyTooltip.INSTANCE.setToolTip(component, actionIconButton != null && (actionIconButton = actionIconButton.getAction()) != null && (actionIconButton = actionIconButton.getTemplatePresentation()) != null ? actionIconButton.getDescription() : null);
            return null;
        }

        private static final AnAction _init_$lambda$0(AnAction $action) {
            return $action;
        }
    }
}

