/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.property.panel.api;

import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.property.panel.api.SelectedComponentModel;
import com.android.tools.property.panel.impl.ui.ExpandableLabel;
import com.android.tools.property.panel.impl.ui.PropertyTextField;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KFunction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\u000bH\u0016J\b\u0010\u000e\u001a\u00020\u000bH\u0002J\b\u0010\u000f\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/property/panel/api/SelectedComponentPanel;", "Ljavax/swing/JPanel;", "model", "Lcom/android/tools/property/panel/api/SelectedComponentModel;", "<init>", "(Lcom/android/tools/property/panel/api/SelectedComponentModel;)V", "left", "Lcom/android/tools/property/panel/impl/ui/ExpandableLabel;", "right", "listener", "Lkotlin/reflect/KFunction0;", "", "addNotify", "removeNotify", "updateAfterModelChange", "doLayout", "intellij.android.layout-ui"})
public final class SelectedComponentPanel
extends JPanel {
    @NotNull
    private final SelectedComponentModel model;
    @NotNull
    private final ExpandableLabel left;
    @NotNull
    private final ExpandableLabel right;
    @NotNull
    private final KFunction<Unit> listener;

    public SelectedComponentPanel(@NotNull SelectedComponentModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        super(new BorderLayout());
        this.model = model;
        this.left = new ExpandableLabel();
        this.right = new ExpandableLabel();
        this.listener = (KFunction)new Function0<Unit>((Object)this){

            public final void invoke() {
                SelectedComponentPanel.access$updateAfterModelChange((SelectedComponentPanel)this.receiver);
            }
        };
        this.setBackground((Color)StudioColorsKt.getSecondaryPanelBackground());
        PropertyTextField.Companion.addBorderAtTextFieldBorderSize(this);
        this.left.setForeground(UIUtil.getInactiveTextColor());
        this.add((Component)this.left, "West");
        this.add((Component)this.right, "East");
        this.updateAfterModelChange();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.model.addValueChangedListener(() -> SelectedComponentPanel.addNotify$lambda$0(this.listener));
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.model.removeValueChangedListener(() -> SelectedComponentPanel.removeNotify$lambda$1(this.listener));
    }

    private final void updateAfterModelChange() {
        this.left.setIcon(this.model.getIcon());
        this.left.setActualText(this.model.getDescription());
        this.right.setActualText(this.model.getId());
    }

    @Override
    public void doLayout() {
        super.doLayout();
        if (this.left.getX() + this.left.getWidth() > this.right.getX()) {
            Insets insets = this.getBorder().getBorderInsets(this);
            int halfWidth = Integer.max(0, (this.getWidth() - insets.left - insets.right) / 2);
            Rectangle leftBounds = this.left.getBounds();
            Rectangle rightBounds = this.right.getBounds();
            if (leftBounds.width < halfWidth) {
                rightBounds.width = halfWidth * 2 - leftBounds.width;
            } else if (rightBounds.width < halfWidth) {
                leftBounds.width = halfWidth * 2 - rightBounds.width;
            } else {
                leftBounds.width = halfWidth;
                rightBounds.width = halfWidth;
            }
            rightBounds.x = this.getWidth() - insets.right - rightBounds.width;
            this.left.setBounds(leftBounds);
            this.right.setBounds(rightBounds);
        }
    }

    private static final void addNotify$lambda$0(KFunction $tmp0) {
        ((Function0)$tmp0).invoke();
    }

    private static final void removeNotify$lambda$1(KFunction $tmp0) {
        ((Function0)$tmp0).invoke();
    }

    public static final /* synthetic */ void access$updateAfterModelChange(SelectedComponentPanel $this) {
        $this.updateAfterModelChange();
    }
}

