/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profgen;

import com.android.tools.profgen.DexFile;
import com.android.tools.profgen.DexHeader;
import com.android.tools.profgen.DexMethod;
import com.android.tools.profgen.DexPrototype;
import com.android.tools.profgen.EncodingKt;
import com.android.tools.profgen.Endian;
import com.android.tools.profgen.Span;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.CRC32;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0002\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0000\u001a \u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eH\u0002\u001a\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\tH\u0002\u001a\u0018\u0010\u0017\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\tH\u0002\u001a\u0018\u0010\u0018\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\tH\u0002\u001a\u0018\u0010\u0019\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\tH\u0002\u001a\u0018\u0010\u001a\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\tH\u0002\u001a&\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00072\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u0010H\u0002\u001a\u0012\u0010\u001d\u001a\u00020\u00152\b\u0010\u001e\u001a\u0004\u0018\u00010\u0003H\u0002\u001a\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0013\u001a\u00020\u000eH\u0002\u001a\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0003H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"HEADER_SIZE", "", "MAGIC_PREFIX", "", "MAGIC_SUFFIX", "ENDIAN_TAG_OFFSET", "MAGIC_SUPPORTED_VERSIONS", "", "parseDexFile", "Lcom/android/tools/profgen/DexFile;", "bytes", "", "name", "buffer", "Ljava/nio/ByteBuffer;", "checksum", "", "parseHeader", "Lcom/android/tools/profgen/DexHeader;", "src", "parseStringPool", "", "dexFile", "parseTypePool", "parsePrototypePool", "parseMethodPool", "parseClassDefinitionPool", "getTypeList", "offset", "checkMagic", "magic", "parseSpan", "Lcom/android/tools/profgen/Span;", "invalidDexFile", "", "message", "android.sdktools.profgen"})
@SourceDebugExtension(value={"SMAP\nDexFileParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DexFileParser.kt\ncom/android/tools/profgen/DexFileParserKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,253:1\n1#2:254\n*E\n"})
public final class DexFileParserKt {
    private static final int HEADER_SIZE = 112;
    @NotNull
    private static final String MAGIC_PREFIX = "dex\n";
    @NotNull
    private static final String MAGIC_SUFFIX = "\u0000";
    private static final int ENDIAN_TAG_OFFSET = 40;
    @NotNull
    private static final List<String> MAGIC_SUPPORTED_VERSIONS;

    @NotNull
    public static final DexFile parseDexFile(@NotNull byte[] bytes2, @NotNull String name2) {
        CRC32 cRC32;
        Intrinsics.checkNotNullParameter((Object)bytes2, (String)"bytes");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        CRC32 $this$parseDexFile_u24lambda_u240 = cRC32 = new CRC32();
        boolean bl = false;
        $this$parseDexFile_u24lambda_u240.update(bytes2);
        CRC32 crc32 = cRC32;
        long crc32Checksum = crc32.getValue();
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes2);
        Intrinsics.checkNotNull((Object)byteBuffer);
        return DexFileParserKt.parseDexFile(byteBuffer, crc32Checksum, name2);
    }

    @NotNull
    public static final DexFile parseDexFile(@NotNull ByteBuffer buffer, long checksum, @NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        DexHeader dexHeader = DexFileParserKt.parseHeader(buffer);
        DexFile dexFile = new DexFile(dexHeader, checksum, name2);
        DexFileParserKt.parseStringPool(buffer, dexFile);
        DexFileParserKt.parseTypePool(buffer, dexFile);
        DexFileParserKt.parsePrototypePool(buffer, dexFile);
        DexFileParserKt.parseMethodPool(buffer, dexFile);
        DexFileParserKt.parseClassDefinitionPool(buffer, dexFile);
        return dexFile;
    }

    private static final DexHeader parseHeader(ByteBuffer src) {
        Endian endian = Endian.Companion.forNumber(src.order(ByteOrder.LITTLE_ENDIAN).getInt(40));
        src.order(endian.getOrder());
        byte[] rawMagic = new byte[8];
        src.get(rawMagic);
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Charset charset2 = charset;
        String magic = new String(rawMagic, charset2);
        DexFileParserKt.checkMagic(magic);
        src.getInt();
        byte[] signature = new byte[20];
        src.get(signature);
        src.getInt();
        int headerSize = src.getInt();
        if (headerSize != 112) {
            DexFileParserKt.invalidDexFile("Header is wrong size. Got " + headerSize + ", Want 112");
            throw new KotlinNothingValueException();
        }
        src.getInt();
        DexFileParserKt.parseSpan(src);
        src.getInt();
        Span stringIds = DexFileParserKt.parseSpan(src);
        Span typeIds = DexFileParserKt.parseSpan(src);
        Span protoIds = DexFileParserKt.parseSpan(src);
        DexFileParserKt.parseSpan(src);
        Span methodIds = DexFileParserKt.parseSpan(src);
        Span classDefs = DexFileParserKt.parseSpan(src);
        Span data2 = DexFileParserKt.parseSpan(src);
        return new DexHeader(stringIds, typeIds, protoIds, methodIds, classDefs, data2);
    }

    private static final void parseStringPool(ByteBuffer buffer, DexFile dexFile) {
        buffer.position(dexFile.getHeader$android_sdktools_profgen().getStringIds().getOffset());
        ByteBuffer data2 = buffer.asReadOnlyBuffer().order(buffer.order());
        int n = dexFile.getHeader$android_sdktools_profgen().getStringIds().getSize();
        for (int i = 0; i < n; ++i) {
            int offset = buffer.getInt();
            data2.position(offset);
            Intrinsics.checkNotNull((Object)data2);
            int encodedSize = EncodingKt.getLeb128(data2);
            String result2 = EncodingKt.mutf8(data2, encodedSize);
            dexFile.getStringPool$android_sdktools_profgen().add(result2);
        }
    }

    private static final void parseTypePool(ByteBuffer buffer, DexFile dexFile) {
        buffer.position(dexFile.getHeader$android_sdktools_profgen().getTypeIds().getOffset());
        int n = dexFile.getHeader$android_sdktools_profgen().getTypeIds().getSize();
        for (int i = 0; i < n; ++i) {
            String type;
            int offset = buffer.getInt();
            Intrinsics.checkNotNullExpressionValue((Object)dexFile.getStringPool$android_sdktools_profgen().get(offset), (String)"get(...)");
            dexFile.getTypePool$android_sdktools_profgen().add(type);
        }
    }

    private static final void parsePrototypePool(ByteBuffer buffer, DexFile dexFile) {
        buffer.position(dexFile.getHeader$android_sdktools_profgen().getPrototypeIds().getOffset());
        ByteBuffer data2 = buffer.asReadOnlyBuffer().order(buffer.order());
        int n = dexFile.getHeader$android_sdktools_profgen().getPrototypeIds().getSize();
        for (int i = 0; i < n; ++i) {
            buffer.getInt();
            int returnTypeIdx = buffer.getInt();
            int parametersOffset = buffer.getInt();
            ArrayList<DexPrototype> arrayList = dexFile.getProtoPool$android_sdktools_profgen();
            String string = dexFile.getTypePool$android_sdktools_profgen().get(returnTypeIdx);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
            Intrinsics.checkNotNull((Object)data2);
            arrayList.add(new DexPrototype(string, DexFileParserKt.getTypeList(dexFile, data2, parametersOffset)));
        }
    }

    private static final void parseMethodPool(ByteBuffer buffer, DexFile dexFile) {
        buffer.position(dexFile.getHeader$android_sdktools_profgen().getMethodIds().getOffset());
        int n = dexFile.getHeader$android_sdktools_profgen().getMethodIds().getSize();
        for (int i = 0; i < n; ++i) {
            DexPrototype proto;
            String name2;
            String clsType;
            int classIdx = EncodingKt.getUshort(buffer);
            int protoIdx = EncodingKt.getUshort(buffer);
            int nameIdx = buffer.getInt();
            Intrinsics.checkNotNullExpressionValue((Object)dexFile.getTypePool$android_sdktools_profgen().get(classIdx), (String)"get(...)");
            Intrinsics.checkNotNullExpressionValue((Object)dexFile.getProtoPool$android_sdktools_profgen().get(protoIdx), (String)"get(...)");
            Intrinsics.checkNotNullExpressionValue((Object)dexFile.getStringPool$android_sdktools_profgen().get(nameIdx), (String)"get(...)");
            dexFile.getMethodPool$android_sdktools_profgen().add(new DexMethod(clsType, name2, proto));
        }
    }

    private static final void parseClassDefinitionPool(ByteBuffer buffer, DexFile dexFile) {
        buffer.position(dexFile.getHeader$android_sdktools_profgen().getClassDefs().getOffset());
        int n = dexFile.getHeader$android_sdktools_profgen().getClassDefs().getSize();
        for (int i = 0; i < n; ++i) {
            int methodIdx;
            int it;
            int it2;
            int classIdx = buffer.getInt();
            buffer.getInt();
            buffer.getInt();
            buffer.getInt();
            buffer.getInt();
            buffer.getInt();
            int classDataOffset = buffer.getInt();
            buffer.getInt();
            dexFile.getClassDefPool$android_sdktools_profgen()[i] = classIdx;
            if (classDataOffset == 0) continue;
            int oldPosition = buffer.position();
            buffer.position(classDataOffset);
            int staticFieldsSize = EncodingKt.getLeb128(buffer);
            int instanceFieldsSize = EncodingKt.getLeb128(buffer);
            int directMethodsSize = EncodingKt.getLeb128(buffer);
            int virtualMethodsSize = EncodingKt.getLeb128(buffer);
            int n2 = 0;
            while (n2 < staticFieldsSize) {
                it2 = n2++;
                boolean bl = false;
                EncodingKt.skipLeb128(buffer);
                EncodingKt.skipLeb128(buffer);
            }
            n2 = 0;
            while (n2 < instanceFieldsSize) {
                it2 = n2++;
                boolean bl = false;
                EncodingKt.skipLeb128(buffer);
                EncodingKt.skipLeb128(buffer);
            }
            int accumulator2 = 0;
            int n3 = 0;
            while (n3 < directMethodsSize) {
                it = n3++;
                boolean bl = false;
                methodIdx = EncodingKt.getLeb128(buffer);
                dexFile.getDefinedMethods$android_sdktools_profgen().add(accumulator2 += methodIdx);
                EncodingKt.skipLeb128(buffer);
                EncodingKt.skipLeb128(buffer);
            }
            accumulator2 = 0;
            n3 = 0;
            while (n3 < virtualMethodsSize) {
                it = n3++;
                boolean bl = false;
                methodIdx = EncodingKt.getLeb128(buffer);
                dexFile.getDefinedMethods$android_sdktools_profgen().add(accumulator2 += methodIdx);
                EncodingKt.skipLeb128(buffer);
                EncodingKt.skipLeb128(buffer);
            }
            buffer.position(oldPosition);
        }
    }

    private static final List<String> getTypeList(DexFile dexFile, ByteBuffer buffer, long offset) {
        if (offset == 0L) {
            return CollectionsKt.emptyList();
        }
        int listOffset = EncodingKt.toIntSaturated(offset);
        if (!dexFile.getHeader$android_sdktools_profgen().getData().includes(listOffset)) {
            DexFileParserKt.invalidDexFile("offset invalid: offset=" + offset + ", data=" + dexFile.getHeader$android_sdktools_profgen().getData());
            throw new KotlinNothingValueException();
        }
        buffer.position(listOffset);
        int size = buffer.getInt();
        List result2 = new ArrayList();
        for (int i = 0; i < size; ++i) {
            int typeId = EncodingKt.getUshort(buffer);
            String string = dexFile.getTypePool$android_sdktools_profgen().get(typeId);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
            result2.add(string);
        }
        return result2;
    }

    private static final void checkMagic(String magic) {
        if (magic == null || !StringsKt.startsWith$default((String)magic, (String)MAGIC_PREFIX, (boolean)false, (int)2, null) || !StringsKt.endsWith$default((String)magic, (String)MAGIC_SUFFIX, (boolean)false, (int)2, null)) {
            DexFileParserKt.invalidDexFile("Unexpected magic number: " + magic);
            throw new KotlinNothingValueException();
        }
        String string = magic.substring(4, magic.length() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String versionTag = string;
        if (!MAGIC_SUPPORTED_VERSIONS.contains(versionTag)) {
            DexFileParserKt.invalidDexFile("Unsupported DEX version tag: " + versionTag);
            throw new KotlinNothingValueException();
        }
    }

    private static final Span parseSpan(ByteBuffer src) {
        int size = src.getInt();
        int offset = src.getInt();
        return new Span(size, offset);
    }

    @NotNull
    public static final Void invalidDexFile(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        throw new IllegalStateException(message.toString());
    }

    static {
        Object[] objectArray = new String[]{"035", "037", "038", "039"};
        MAGIC_SUPPORTED_VERSIONS = CollectionsKt.listOf((Object[])objectArray);
    }
}

