/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.ui;

import com.android.tools.adtui.ImageComponent;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.ui.IconProperty;
import com.android.tools.idea.observable.ui.TextProperty;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import icons.StudioIllustrations;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;
import org.jetbrains.annotations.NotNull;

public final class StudioWizardLayout
implements ModelWizardDialog.CustomLayout {
    private static final JBColor STUDIO_LAYOUT_HEADER_COLOR = new JBColor(0x616161, 0x4B4B4B);
    public static final Dimension DEFAULT_MIN_SIZE = JBUI.size((int)600, (int)350);
    public static final Dimension DEFAULT_PREFERRED_SIZE = JBUI.size((int)900, (int)650);
    public static final JBInsets DEFAULT_BORDER_INSETS = JBUI.insets((int)24);
    private final BindingsManager myBindings = new BindingsManager();
    private JPanel myRootPanel;
    private JPanel myHeaderPanel;
    private JBLabel myTitleLabel;
    private ImageComponent myIcon;
    private JPanel myCenterPanel;
    private JLabel myStepIcon;

    public StudioWizardLayout() {
        this.setupUI();
        Icon icon = StudioIllustrations.Common.PRODUCT_ICON;
        this.myIcon.setPreferredSize(new Dimension(icon.getIconWidth(), icon.getIconHeight()));
        this.myIcon.setIcon(icon);
        this.myHeaderPanel.setBackground((Color)STUDIO_LAYOUT_HEADER_COLOR);
    }

    @Override
    @NotNull
    public JPanel decorate(@NotNull ModelWizard.TitleHeader titleHeader, @NotNull JPanel innerPanel) {
        this.myBindings.bind(new TextProperty((JLabel)this.myTitleLabel), titleHeader.title());
        this.myBindings.bind(new IconProperty(this.myStepIcon), titleHeader.stepIcon());
        this.myCenterPanel.add(innerPanel);
        return this.myRootPanel;
    }

    @Override
    public Dimension getDefaultPreferredSize() {
        return DEFAULT_PREFERRED_SIZE;
    }

    @Override
    public Dimension getDefaultMinSize() {
        return DEFAULT_MIN_SIZE;
    }

    public void dispose() {
        this.myBindings.releaseAll();
    }

    private void setupUI() {
        this.myRootPanel = new JPanel();
        this.myRootPanel.setLayout(new BorderLayout(0, 0));
        this.myHeaderPanel = new JPanel();
        this.myHeaderPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 8, 8, 8), 16, -1, false, true));
        this.myRootPanel.add((Component)this.myHeaderPanel, "North");
        this.myHeaderPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(20, 10, 20, 10), null, 0, 0, null, null));
        this.myIcon = new ImageComponent();
        this.myHeaderPanel.add((Component)this.myIcon, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 3, null, null, null, 0, false));
        this.myTitleLabel = new JBLabel();
        Font myTitleLabelFont = this.getFont(null, -1, 24, this.myTitleLabel.getFont());
        if (myTitleLabelFont != null) {
            this.myTitleLabel.setFont(myTitleLabelFont);
        }
        this.myTitleLabel.setForeground(new Color(-1));
        this.myTitleLabel.setText("(Wizard Title)");
        this.myHeaderPanel.add((Component)this.myTitleLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 4, 4, null, null, null, 0, false));
        this.myStepIcon = new JLabel();
        this.myStepIcon.setAlignmentX(0.5f);
        this.myStepIcon.setHorizontalAlignment(0);
        this.myStepIcon.setHorizontalTextPosition(0);
        this.myStepIcon.setName("right_icon");
        this.myStepIcon.setText("");
        this.myHeaderPanel.add((Component)this.myStepIcon, new GridConstraints(0, 2, 1, 1, 4, 0, 0, 0, new Dimension(60, 60), new Dimension(60, 60), new Dimension(60, 60), 0, false));
        this.myCenterPanel = new JPanel();
        this.myCenterPanel.setLayout(new BorderLayout(0, 0));
        this.myRootPanel.add((Component)this.myCenterPanel, "Center");
        this.myCenterPanel.setBorder(BorderFactory.createTitledBorder(JBUI.Borders.empty((Insets)DEFAULT_BORDER_INSETS), null, 0, 0, null, null));
    }

    private Font getFont(String fontName, int style, int size, Font currentFont) {
        Font testFont;
        if (currentFont == null) {
            return null;
        }
        String resultName = fontName == null ? currentFont.getName() : ((testFont = new Font(fontName, 0, 10)).canDisplay('a') && testFont.canDisplay('1') ? fontName : currentFont.getName());
        Font font = new Font(resultName, style >= 0 ? style : currentFont.getStyle(), size >= 0 ? size : currentFont.getSize());
        boolean isMac = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font fontWithFallback = isMac ? new Font(font.getFamily(), font.getStyle(), font.getSize()) : new StyleContext().getFont(font.getFamily(), font.getStyle(), font.getSize());
        return fontWithFallback instanceof FontUIResource ? fontWithFallback : new FontUIResource(fontWithFallback);
    }
}

