/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.whatsnew.assistant;

import com.android.tools.idea.whatsnew.assistant.WhatsNewBundleCreator;
import com.intellij.openapi.application.PathManager;
import com.intellij.util.PathUtil;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001c\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\u000e\u001a\u00020\tH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/whatsnew/assistant/WhatsNewURLProvider;", "", "<init>", "()V", "getWebConfig", "Ljava/net/URL;", "version", "", "getLocalConfig", "Ljava/nio/file/Path;", "getResourceFileAsStream", "Ljava/io/InputStream;", "bundleCreator", "Lcom/android/tools/idea/whatsnew/assistant/WhatsNewBundleCreator;", "getConfigCacheDir", "whats-new-assistant"})
public class WhatsNewURLProvider {
    @NotNull
    public URL getWebConfig(@NotNull String version2) {
        URL uRL;
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        try {
            uRL = new URL("https://developer.android.com/studio/releases/assistant/" + version2 + ".xml");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Could not get path for web WNA xml file");
        }
        return uRL;
    }

    @NotNull
    public Path getLocalConfig(@NotNull String version2) {
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        Path path = this.getConfigCacheDir().resolve(version2 + ".xml");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @Nullable
    public InputStream getResourceFileAsStream(@Nullable WhatsNewBundleCreator bundleCreator, @NotNull String version2) {
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        Object object = bundleCreator;
        return object != null && (object = object.getClass()) != null ? ((Class)object).getResourceAsStream("/whats-new-assistant.xml") : null;
    }

    private final Path getConfigCacheDir() {
        String[] stringArray = new String[]{"whatsnew"};
        Path path = Paths.get(PathUtil.getCanonicalPath((String)PathManager.getSystemPath()), stringArray);
        path.toFile().mkdirs();
        Intrinsics.checkNotNull((Object)path);
        return path;
    }
}

