/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard.deprecated;

import com.android.tools.idea.welcome.install.WizardException;
import com.android.tools.idea.welcome.wizard.FirstRunWizardTracker;
import com.android.tools.idea.welcome.wizard.deprecated.AbstractProgressStep;
import com.android.tools.idea.welcome.wizard.deprecated.LongRunningOperationPath;
import com.android.tools.idea.wizard.dynamic.AndroidStudioWizardPath;
import com.android.tools.idea.wizard.dynamic.DynamicWizardHost;
import com.google.wireless.android.sdk.stats.SetupWizardEvent;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class ConsolidatedProgressStep
extends AbstractProgressStep {
    private final AtomicBoolean myIsBusy = new AtomicBoolean(false);
    private final DynamicWizardHost myHost;
    private List<? extends AndroidStudioWizardPath> myPaths;

    public ConsolidatedProgressStep(@NotNull Disposable disposable, @NotNull DynamicWizardHost host, @NotNull FirstRunWizardTracker tracker) {
        super(disposable, "Downloading Components", tracker);
        this.myHost = host;
    }

    public void setPaths(@NotNull List<? extends AndroidStudioWizardPath> paths) {
        this.myPaths = paths;
    }

    @Override
    public boolean canGoNext() {
        return super.canGoNext() && !this.myIsBusy.get();
    }

    @Override
    protected void execute() {
        this.myIsBusy.set(true);
        this.myHost.runSensitiveOperation(this.getProgressIndicator(), true, new Runnable(){

            @Override
            public void run() {
                boolean wasSuccess = false;
                ConsolidatedProgressStep.this.myTracker.trackInstallingComponentsStarted();
                try {
                    ConsolidatedProgressStep.this.doLongRunningOperation(ConsolidatedProgressStep.this);
                    wasSuccess = true;
                }
                catch (WizardException e) {
                    Logger.getInstance(this.getClass()).error((Throwable)e);
                    ConsolidatedProgressStep.this.showConsole();
                    ConsolidatedProgressStep.this.print(e.getMessage() + "\n", ConsoleViewContentType.ERROR_OUTPUT);
                }
                finally {
                    if (ConsolidatedProgressStep.this.isCanceled()) {
                        ConsolidatedProgressStep.this.myTracker.trackInstallingComponentsFinished(SetupWizardEvent.SdkInstallationMetrics.SdkInstallationResult.CANCELED);
                    } else if (wasSuccess) {
                        ConsolidatedProgressStep.this.myTracker.trackInstallingComponentsFinished(SetupWizardEvent.SdkInstallationMetrics.SdkInstallationResult.SUCCESS);
                    } else {
                        ConsolidatedProgressStep.this.myTracker.trackInstallingComponentsFinished(SetupWizardEvent.SdkInstallationMetrics.SdkInstallationResult.ERROR);
                    }
                    ConsolidatedProgressStep.this.myIsBusy.set(false);
                }
            }
        });
    }

    private void doLongRunningOperation(@NotNull AbstractProgressStep progressStep2) throws WizardException {
        for (AndroidStudioWizardPath androidStudioWizardPath : this.myPaths) {
            if (progressStep2.isCanceled()) break;
            if (!(androidStudioWizardPath instanceof LongRunningOperationPath)) continue;
            ((LongRunningOperationPath)((Object)androidStudioWizardPath)).runLongOperation();
        }
    }

    @Override
    public boolean canGoPrevious() {
        return false;
    }

    @Override
    public boolean isStepVisible() {
        return this.myPaths != null && !this.myPaths.isEmpty();
    }

    @Override
    protected SetupWizardEvent.WizardStep.WizardStepKind getWizardStepKind() {
        return SetupWizardEvent.WizardStep.WizardStepKind.INSTALL_SDK;
    }
}

