/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.avdmanager.AccelerationErrorCode;
import com.android.tools.idea.avdmanager.AccelerationErrorSolution;
import com.android.tools.idea.avdmanager.ElevatedCommandLine;
import com.android.tools.idea.avdmanager.EmulatorAccelerationCheck;
import com.android.tools.idea.memorysettings.MemorySettingsUtil;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.welcome.install.AehdSdkComponentTreeNodeKt;
import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallableSdkComponentTreeNode;
import com.android.tools.idea.welcome.install.WizardException;
import com.google.wireless.android.sdk.stats.SetupWizardEvent;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Platform;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingAnsiEscapesAwareProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 .2\u00020\u0001:\u0002-.B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0004J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0014H\u0004J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u001c\u0010\u001f\u001a\u00020\u001a2\n\u0010 \u001a\u00060!j\u0002`\"2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010#\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u0014H\u0002J\u0018\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u0014H\u0002J\u0018\u0010'\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\u0012H\u0002J\u0018\u0010)\u001a\u00020\u00142\u0006\u0010*\u001a\u00020\u00142\u0006\u0010+\u001a\u00020\fH\u0004J\u0010\u0010,\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006/"}, d2={"Lcom/android/tools/idea/welcome/install/AehdSdkComponentTreeNode;", "Lcom/android/tools/idea/welcome/install/InstallableSdkComponentTreeNode;", "installationIntention", "Lcom/android/tools/idea/welcome/install/AehdSdkComponentTreeNode$InstallationIntention;", "<init>", "(Lcom/android/tools/idea/welcome/install/AehdSdkComponentTreeNode$InstallationIntention;)V", "value", "", "isInstallerSuccessfullyCompleted", "()Z", "requiredSdkPackages", "", "", "getRequiredSdkPackages", "()Ljava/util/List;", "sdkComponentsMetricKind", "Lcom/google/wireless/android/sdk/stats/SetupWizardEvent$SdkInstallationMetrics$SdkComponentKind;", "getInstallCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "sdk", "Ljava/io/File;", "getInstallerBaseCommandLine", "getUninstallCommandLine", "getWindowsBaseCommandLine", "source", "configure", "", "installContext", "Lcom/android/tools/idea/welcome/install/InstallContext;", "sdkHandler", "Lcom/android/sdklib/repository/AndroidSdkHandler;", "printExceptionMessage", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "configureForUninstall", "sdkRoot", "isInstalled", "context", "runInstaller", "commandLine", "ensureExistsAndIsExecutable", "path", "exeName", "getSourceLocation", "InstallationIntention", "InstallerInfo", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nAehdSdkComponentTreeNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AehdSdkComponentTreeNode.kt\ncom/android/tools/idea/welcome/install/AehdSdkComponentTreeNode\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,415:1\n1#2:416\n*E\n"})
public final class AehdSdkComponentTreeNode
extends InstallableSdkComponentTreeNode {
    @NotNull
    public static final InstallerInfo InstallerInfo = new InstallerInfo(null);
    @JvmField
    @NotNull
    public final InstallationIntention installationIntention;
    private boolean isInstallerSuccessfullyCompleted;
    @NotNull
    private static final AccelerationErrorSolution.SolutionCode installSolution = AccelerationErrorSolution.SolutionCode.INSTALL_AEHD;
    @NotNull
    private static final AccelerationErrorSolution.SolutionCode reinstallSolution = AccelerationErrorSolution.SolutionCode.REINSTALL_AEHD;
    @Nullable
    private static final AccelerationErrorCode incompatibleSystemError = !SystemInfo.isWindows ? AccelerationErrorCode.AEHD_REQUIRES_WINDOWS : null;
    @Nullable
    private static AccelerationErrorCode ourInitialCheck;

    public AehdSdkComponentTreeNode(@NotNull InstallationIntention installationIntention) {
        Intrinsics.checkNotNullParameter((Object)((Object)installationIntention), (String)"installationIntention");
        super("Performance (Android Emulator hypervisor driver)", "Enables a hardware-assisted virtualization engine (hypervisor) to speed up Android app emulation on your development computer. (Recommended)", installationIntention == InstallationIntention.INSTALL_WITH_UPDATES);
        this.installationIntention = installationIntention;
    }

    public final boolean isInstallerSuccessfullyCompleted() {
        return this.isInstallerSuccessfullyCompleted;
    }

    @NotNull
    public List<String> getRequiredSdkPackages() {
        return CollectionsKt.listOf((Object)"extras;google;Android_Emulator_Hypervisor_Driver");
    }

    @Override
    @NotNull
    public SetupWizardEvent.SdkInstallationMetrics.SdkComponentKind sdkComponentsMetricKind() {
        return SetupWizardEvent.SdkInstallationMetrics.SdkComponentKind.AEHD;
    }

    @NotNull
    protected GeneralCommandLine getInstallCommandLine(@NotNull File sdk) throws IOException, WizardException {
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        if (!InstallerInfo.canRun()) {
            boolean bl = false;
            String string = "Unsupported OS";
            throw new IllegalStateException(string.toString());
        }
        return this.getInstallerBaseCommandLine(sdk);
    }

    @NotNull
    protected final GeneralCommandLine getInstallerBaseCommandLine(@NotNull File sdk) throws WizardException, IOException {
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        if (!SystemInfo.isWindows) {
            throw new IllegalStateException("Unsupported OS");
        }
        return this.getWindowsBaseCommandLine(this.getSourceLocation(sdk));
    }

    @NotNull
    protected GeneralCommandLine getUninstallCommandLine(@NotNull File sdk) throws WizardException, IOException {
        GeneralCommandLine generalCommandLine;
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        GeneralCommandLine $this$getUninstallCommandLine_u24lambda_u241 = generalCommandLine = this.getInstallerBaseCommandLine(sdk);
        boolean bl = false;
        String[] stringArray = new String[]{"-u"};
        $this$getUninstallCommandLine_u24lambda_u241.addParameters(stringArray);
        return generalCommandLine;
    }

    @NotNull
    protected final GeneralCommandLine getWindowsBaseCommandLine(@NotNull File source2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        File batFile = new File(source2, "silent_install.bat");
        File file = FileUtil.createTempFile((String)"aehd_log", (String)".txt");
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempFile(...)");
        File logFile = file;
        String[] stringArray = new String[]{batFile.getAbsolutePath()};
        ElevatedCommandLine elevatedCommandLine = new ElevatedCommandLine(stringArray);
        stringArray = new String[]{"-log", logFile.getPath()};
        GeneralCommandLine generalCommandLine = elevatedCommandLine.withTempFilePrefix("aehd").withWorkDirectory(source2).withParameters(stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"withParameters(...)");
        return generalCommandLine;
    }

    @Override
    public void configure(@NotNull InstallContext installContext, @NotNull AndroidSdkHandler sdkHandler) {
        int n;
        AccelerationErrorSolution.SolutionCode solutionCode;
        File sdkRoot;
        Intrinsics.checkNotNullParameter((Object)installContext, (String)"installContext");
        Intrinsics.checkNotNullParameter((Object)sdkHandler, (String)"sdkHandler");
        Path path = sdkHandler.getLocation();
        File file = sdkRoot = path != null ? path.toFile() : null;
        if (sdkRoot == null) {
            installContext.print("Android Emulator hypervisor driver installer could not be run because SDK root isn't specified", ConsoleViewContentType.ERROR_OUTPUT);
            return;
        }
        if (this.installationIntention == InstallationIntention.UNINSTALL) {
            this.configureForUninstall(installContext, sdkRoot);
            return;
        }
        AccelerationErrorCode accelerationErrorCode = InstallerInfo.checkInstallation();
        AccelerationErrorSolution.SolutionCode solution = accelerationErrorCode.getSolution();
        if (accelerationErrorCode == AccelerationErrorCode.ALREADY_INSTALLED) {
            if (this.installationIntention == InstallationIntention.INSTALL_WITHOUT_UPDATES) {
                this.isInstallerSuccessfullyCompleted = true;
                return;
            }
            solution = reinstallSolution;
        }
        AccelerationErrorSolution.SolutionCode solutionCode2 = solutionCode = solution;
        int n2 = n = solutionCode2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[solutionCode2.ordinal()];
        if (solutionCode == installSolution || solutionCode == reinstallSolution) {
            try {
                GeneralCommandLine commandLine = this.getInstallCommandLine(sdkRoot);
                this.runInstaller(installContext, commandLine);
            }
            catch (WizardException e) {
                this.printExceptionMessage(e, installContext);
            }
            catch (IOException e) {
                this.printExceptionMessage(e, installContext);
            }
        } else if (n == 1) {
            String message = "Unable to install Android Emulator hypervisor driver\n" + accelerationErrorCode.getProblem() + "\n" + accelerationErrorCode.getSolutionMessage();
            installContext.print(message, ConsoleViewContentType.ERROR_OUTPUT);
        }
    }

    private final void printExceptionMessage(Exception e, InstallContext installContext) {
        Object message;
        AehdSdkComponentTreeNodeKt.access$getLOG().warn("Tried to install Android Emulator hypervisor driver on " + Platform.current().name() + " OS with " + MemorySettingsUtil.getMachineMemoryBytes() + " memory size", (Throwable)e);
        installContext.print("Unable to install Android Emulator hypervisor driver\n", ConsoleViewContentType.ERROR_OUTPUT);
        String string = e.getMessage();
        if (string == null) {
            string = "(unknown)";
        }
        if (!StringUtil.endsWithLineBreak((CharSequence)((CharSequence)(message = string)))) {
            message = (String)message + "\n";
        }
        installContext.print((String)message, ConsoleViewContentType.ERROR_OUTPUT);
    }

    private final void configureForUninstall(InstallContext installContext, File sdkRoot) {
        if (this.isInstalled(installContext, sdkRoot)) {
            try {
                GeneralCommandLine commandLine = this.getUninstallCommandLine(sdkRoot);
                this.runInstaller(installContext, commandLine);
            }
            catch (WizardException e) {
                this.printExceptionMessage(e, installContext);
            }
            catch (IOException e) {
                this.printExceptionMessage(e, installContext);
            }
        } else {
            installContext.print("Android Emulator hypervisor driver is not installed, so not proceeding with its uninstallation.", ConsoleViewContentType.NORMAL_OUTPUT);
            this.isInstallerSuccessfullyCompleted = true;
        }
    }

    private final boolean isInstalled(InstallContext context, File sdkRoot) {
        Function1 printError = arg_0 -> AehdSdkComponentTreeNode.isInstalled$lambda$2(context, arg_0);
        try {
            OSProcessHandler oSProcessHandler;
            GeneralCommandLine command = this.getInstallerBaseCommandLine(sdkRoot);
            command.addParameter("-v");
            OSProcessHandler $this$isInstalled_u24lambda_u243 = oSProcessHandler = new OSProcessHandler(command);
            boolean bl = false;
            $this$isInstalled_u24lambda_u243.startNotify();
            $this$isInstalled_u24lambda_u243.waitFor();
            Integer n = oSProcessHandler.getExitCode();
            return n != null && n == 0;
        }
        catch (ExecutionException exception) {
            printError.invoke((Object)exception);
        }
        catch (WizardException exception) {
            printError.invoke((Object)exception);
        }
        catch (IOException exception) {
            printError.invoke((Object)exception);
        }
        return false;
    }

    private final void runInstaller(InstallContext installContext, GeneralCommandLine commandLine) {
        try {
            ProgressIndicator progressIndicator;
            ProgressIndicator progressIndicator2 = progressIndicator = ProgressManager.getInstance().getProgressIndicator();
            if (progressIndicator2 != null) {
                ProgressIndicator progressIndicator3;
                ProgressIndicator $this$runInstaller_u24lambda_u244 = progressIndicator3 = progressIndicator2;
                boolean bl = false;
                $this$runInstaller_u24lambda_u244.setIndeterminate(true);
                $this$runInstaller_u24lambda_u244.setText(InstallerInfo.getRunningInstallerMessage());
            }
            installContext.print(InstallerInfo.getRunningInstallerMessage() + "\n", ConsoleViewContentType.SYSTEM_OUTPUT);
            CapturingAnsiEscapesAwareProcessHandler process2 = new CapturingAnsiEscapesAwareProcessHandler(commandLine);
            StringBuffer output = new StringBuffer();
            process2.addProcessListener((ProcessListener)new ProcessAdapter(output){
                final /* synthetic */ StringBuffer $output;
                {
                    this.$output = $output;
                }

                public void onTextAvailable(ProcessEvent event, Key<?> outputType) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                    this.$output.append(event.getText());
                    super.onTextAvailable(event, outputType);
                }
            });
            installContext.attachToProcess((ProcessHandler)process2);
            int exitCode2 = process2.runProcess().getExitCode();
            if (exitCode2 != 0) {
                String file;
                if (SystemInfo.isWindows && exitCode2 == 2) {
                    String rebootMessage = "Reboot required: Android Emulator hypervisor driver installation succeeded, however the installer reported that a reboot is required in order for the changes to take effect";
                    installContext.print(rebootMessage, ConsoleViewContentType.NORMAL_OUTPUT);
                    AccelerationErrorSolution.promptAndRebootAsync(rebootMessage, ModalityState.nonModal());
                    this.isInstallerSuccessfullyCompleted = true;
                    ProgressIndicator progressIndicator4 = progressIndicator;
                    if (progressIndicator4 != null) {
                        ProgressIndicator progressIndicator5;
                        ProgressIndicator $this$runInstaller_u24lambda_u245 = progressIndicator5 = progressIndicator4;
                        boolean bl = false;
                        $this$runInstaller_u24lambda_u245.setFraction(1.0);
                    }
                    return;
                }
                if (SystemInfo.isWindows && exitCode2 == 1223) {
                    installContext.print("Android Emulator hypervisor driver installation failed because the operation was cancelled. To install Android Emulator hypervisor driver, try the installer again. Make sure to click \"yes\" when the installer requests administrator privilege. This has to be done before the request times out.", ConsoleViewContentType.ERROR_OUTPUT);
                    this.isInstallerSuccessfullyCompleted = false;
                    ProgressIndicator progressIndicator6 = progressIndicator;
                    if (progressIndicator6 != null) {
                        ProgressIndicator rebootMessage;
                        ProgressIndicator $this$runInstaller_u24lambda_u246 = rebootMessage = progressIndicator6;
                        boolean bl = false;
                        $this$runInstaller_u24lambda_u246.setFraction(1.0);
                    }
                    return;
                }
                if (this.installationIntention == InstallationIntention.UNINSTALL) {
                    installContext.print("Android Emulator hypervisor driver uninstallation failed", ConsoleViewContentType.ERROR_OUTPUT);
                } else {
                    installContext.print("Android Emulator hypervisor driver installation failed. To install Android Emulator hypervisor driver follow the instructions found at: https://github.com/google/android-emulator-hypervisor-driver", ConsoleViewContentType.ERROR_OUTPUT);
                }
                Regex regex = new Regex("installation log:\\s*\"(.*)\"");
                String string = output.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                Object object = Regex.find$default((Regex)regex, (CharSequence)string, (int)0, (int)2, null);
                String string2 = object != null && (object = object.getGroupValues()) != null ? (String)object.get(1) : (file = null);
                if (file != null) {
                    installContext.print("Installer log is located at " + file, ConsoleViewContentType.ERROR_OUTPUT);
                    try {
                        installContext.print("Installer log contents:\n", ConsoleViewContentType.ERROR_OUTPUT);
                        installContext.print(FileUtil.loadFile((File)new File(file), (String)"UTF-16"), ConsoleViewContentType.NORMAL_OUTPUT);
                    }
                    catch (IOException e) {
                        installContext.print("Failed to read installer output log.\n", ConsoleViewContentType.ERROR_OUTPUT);
                    }
                }
                this.isInstallerSuccessfullyCompleted = false;
            } else {
                this.isInstallerSuccessfullyCompleted = true;
            }
            ProgressIndicator progressIndicator7 = progressIndicator;
            if (progressIndicator7 != null) {
                ProgressIndicator progressIndicator8;
                ProgressIndicator $this$runInstaller_u24lambda_u247 = progressIndicator8 = progressIndicator7;
                boolean bl = false;
                $this$runInstaller_u24lambda_u247.setFraction(1.0);
            }
        }
        catch (ExecutionException e) {
            installContext.print("Unable to run Android Emulator hypervisor driver installer: " + e.getMessage() + "\n", ConsoleViewContentType.ERROR_OUTPUT);
            AehdSdkComponentTreeNodeKt.access$getLOG().warn((Throwable)e);
        }
    }

    @NotNull
    protected final File ensureExistsAndIsExecutable(@NotNull File path, @NotNull String exeName) throws WizardException {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)exeName, (String)"exeName");
        File executable = new File(path, exeName);
        if (!executable.isFile()) {
            throw new WizardException("Installer executable is missing: " + executable.getAbsolutePath());
        }
        if (!executable.canExecute() && !executable.setExecutable(true)) {
            throw new WizardException("Unable to set execute permission bit on installer executable: " + executable.getAbsolutePath());
        }
        return executable;
    }

    private final File getSourceLocation(File sdk) {
        String[] stringArray = new String[]{"extras", "google", "Android_Emulator_Hypervisor_Driver"};
        return new File(sdk, FileUtil.join((String[])stringArray));
    }

    private static final Unit isInstalled$lambda$2(InstallContext $context, Exception exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        $context.print("Failed to determine whether Android Emulator hypervisor driver is installed: " + exception.getMessage(), ConsoleViewContentType.ERROR_OUTPUT);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tj\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/welcome/install/AehdSdkComponentTreeNode$InstallationIntention;", "", "<init>", "(Ljava/lang/String;I)V", "INSTALL_WITH_UPDATES", "INSTALL_WITHOUT_UPDATES", "CONFIGURE_ONLY", "UNINSTALL", "isInstall", "", "intellij.android.core"})
    public static final class InstallationIntention
    extends Enum<InstallationIntention> {
        public static final /* enum */ InstallationIntention INSTALL_WITH_UPDATES = new InstallationIntention();
        public static final /* enum */ InstallationIntention INSTALL_WITHOUT_UPDATES = new InstallationIntention();
        public static final /* enum */ InstallationIntention CONFIGURE_ONLY = new InstallationIntention();
        public static final /* enum */ InstallationIntention UNINSTALL = new InstallationIntention();
        private static final /* synthetic */ InstallationIntention[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public final boolean isInstall() {
            return this == INSTALL_WITHOUT_UPDATES || this == INSTALL_WITH_UPDATES;
        }

        public static InstallationIntention[] values() {
            return (InstallationIntention[])$VALUES.clone();
        }

        public static InstallationIntention valueOf(String value2) {
            return Enum.valueOf(InstallationIntention.class, value2);
        }

        @NotNull
        public static EnumEntries<InstallationIntention> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = installationIntentionArray = new InstallationIntention[]{InstallationIntention.INSTALL_WITH_UPDATES, InstallationIntention.INSTALL_WITHOUT_UPDATES, InstallationIntention.CONFIGURE_ONLY, InstallationIntention.UNINSTALL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0015\u001a\u00020\u000bJ\u0006\u0010\u0016\u001a\u00020\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/welcome/install/AehdSdkComponentTreeNode$InstallerInfo;", "", "<init>", "()V", "installSolution", "Lcom/android/tools/idea/avdmanager/AccelerationErrorSolution$SolutionCode;", "getInstallSolution", "()Lcom/android/tools/idea/avdmanager/AccelerationErrorSolution$SolutionCode;", "reinstallSolution", "getReinstallSolution", "incompatibleSystemError", "Lcom/android/tools/idea/avdmanager/AccelerationErrorCode;", "getIncompatibleSystemError", "()Lcom/android/tools/idea/avdmanager/AccelerationErrorCode;", "repoPackagePath", "", "getRepoPackagePath", "()Ljava/lang/String;", "runningInstallerMessage", "getRunningInstallerMessage", "ourInitialCheck", "checkInstallation", "canRun", "", "intellij.android.core"})
    @SourceDebugExtension(value={"SMAP\nAehdSdkComponentTreeNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AehdSdkComponentTreeNode.kt\ncom/android/tools/idea/welcome/install/AehdSdkComponentTreeNode$InstallerInfo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,415:1\n1#2:416\n*E\n"})
    public static final class InstallerInfo {
        private InstallerInfo() {
        }

        @NotNull
        public final AccelerationErrorSolution.SolutionCode getInstallSolution() {
            return installSolution;
        }

        @NotNull
        public final AccelerationErrorSolution.SolutionCode getReinstallSolution() {
            return reinstallSolution;
        }

        @Nullable
        public final AccelerationErrorCode getIncompatibleSystemError() {
            return incompatibleSystemError;
        }

        @NotNull
        public final String getRepoPackagePath() {
            return "extras;google;Android_Emulator_Hypervisor_Driver";
        }

        @NotNull
        public final String getRunningInstallerMessage() {
            return "Running Android Emulator hypervisor driver installer";
        }

        @NotNull
        public final AccelerationErrorCode checkInstallation() {
            AccelerationErrorCode accelerationErrorCode = this.getIncompatibleSystemError();
            if (accelerationErrorCode == null) {
                AndroidSdkHandler androidSdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
                Intrinsics.checkNotNullExpressionValue((Object)androidSdkHandler, (String)"tryToChooseSdkHandler(...)");
                accelerationErrorCode = EmulatorAccelerationCheck.checkAcceleration(androidSdkHandler);
            }
            return accelerationErrorCode;
        }

        public final boolean canRun() {
            AccelerationErrorCode accelerationErrorCode = ourInitialCheck;
            if (accelerationErrorCode == null) {
                AccelerationErrorCode accelerationErrorCode2;
                AccelerationErrorCode it = accelerationErrorCode2 = this.checkInstallation();
                boolean bl = false;
                ourInitialCheck = it;
                accelerationErrorCode = accelerationErrorCode2;
            }
            AccelerationErrorCode check2 = accelerationErrorCode;
            return switch (WhenMappings.$EnumSwitchMapping$0[check2.ordinal()]) {
                case 1, 2 -> {
                    if (this.getIncompatibleSystemError() == null) {
                        yield true;
                    }
                    yield false;
                }
                case 3 -> false;
                case 4 -> true;
                default -> {
                    AccelerationErrorSolution.SolutionCode var3_2 = check2.getSolution();
                    yield var3_2 == this.getInstallSolution() || var3_2 == this.getReinstallSolution();
                }
            };
        }

        public /* synthetic */ InstallerInfo(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[AccelerationErrorCode.values().length];
                try {
                    nArray[AccelerationErrorCode.NO_EMULATOR_INSTALLED.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AccelerationErrorCode.UNKNOWN_ERROR.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AccelerationErrorCode.NOT_ENOUGH_MEMORY.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AccelerationErrorCode.ALREADY_INSTALLED.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AccelerationErrorSolution.SolutionCode.values().length];
            try {
                nArray[AccelerationErrorSolution.SolutionCode.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

