/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wear.dwf.inspections;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.wear.dwf.WearDwfBundle;
import com.android.tools.idea.wear.dwf.dom.raw.configurations.ColorConfiguration;
import com.android.tools.idea.wear.dwf.dom.raw.configurations.UserConfigurationReference;
import com.android.tools.idea.wear.dwf.inspections.InvalidColorIndexInspectionKt;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.dom.WatchFaceUtilKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/wear/dwf/inspections/InvalidColorIndexXmlInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "getStaticDescription", "", "Lorg/jetbrains/annotations/Nls;", "isAvailableForFile", "", "file", "Lcom/intellij/psi/PsiFile;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "intellij.android.wear-dwf"})
public final class InvalidColorIndexXmlInspection
extends LocalInspectionTool {
    @NotNull
    public String getStaticDescription() {
        return WearDwfBundle.INSTANCE.message("inspection.invalid.color.index.description", new Object[0]);
    }

    public boolean isAvailableForFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!((Boolean)StudioFlags.WEAR_DECLARATIVE_WATCH_FACE_XML_EDITOR_SUPPORT.get()).booleanValue()) {
            return false;
        }
        XmlFile xmlFile = file instanceof XmlFile ? (XmlFile)file : null;
        if (xmlFile == null) {
            return false;
        }
        XmlFile watchFaceFile = xmlFile;
        return WatchFaceUtilKt.isDeclarativeWatchFaceFile(watchFaceFile);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        PsiFile psiFile = holder.getFile();
        XmlFile xmlFile = psiFile instanceof XmlFile ? (XmlFile)psiFile : null;
        if (xmlFile == null) {
            throw new IllegalStateException("Missing watch face file");
        }
        XmlFile watchFaceFile = xmlFile;
        Map colorConfigurationsById = InvalidColorIndexInspectionKt.access$getColorConfigurationsById(watchFaceFile);
        return (PsiElementVisitor)new XmlElementVisitor(holder, colorConfigurationsById){
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ Map<String, ColorConfiguration> $colorConfigurationsById;
            {
                this.$holder = $holder;
                this.$colorConfigurationsById = $colorConfigurationsById;
            }

            public void visitXmlAttributeValue(XmlAttributeValue xmlAttributeValue) {
                TextRange textRange;
                Intrinsics.checkNotNullParameter((Object)xmlAttributeValue, (String)"xmlAttributeValue");
                PsiReference psiReference = xmlAttributeValue.getReference();
                UserConfigurationReference userConfigurationReference = psiReference instanceof UserConfigurationReference ? (UserConfigurationReference)psiReference : null;
                if (userConfigurationReference == null) {
                    return;
                }
                UserConfigurationReference reference = userConfigurationReference;
                String string = reference.getColorIndex();
                if (string != null) {
                    Integer n;
                    String colorIndex = string;
                    boolean bl = false;
                    String string2 = xmlAttributeValue.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValue(...)");
                    Integer n2 = StringsKt.lastIndexOf$default((CharSequence)string2, (String)("." + colorIndex), (int)0, (boolean)false, (int)6, null);
                    int it = ((Number)n2).intValue();
                    boolean bl2 = false;
                    Integer n3 = n = it > -1 ? n2 : null;
                    if (n == null) {
                        textRange = null;
                    } else {
                        int it2 = ((Number)n).intValue();
                        boolean bl3 = false;
                        int colorIndexStartOffset = it2 + 2;
                        textRange = new TextRange(colorIndexStartOffset, colorIndexStartOffset + colorIndex.length());
                    }
                } else {
                    textRange = null;
                }
                TextRange colorIndexTextRange = textRange;
                InvalidColorIndexInspectionKt.access$visitReference(reference, this.$holder, colorIndexTextRange, this.$colorConfigurationsById);
            }
        };
    }
}

