/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater.configure;

import com.android.repository.api.Downloader;
import com.android.repository.api.ProgressRunner;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.SettingsController;
import com.android.repository.api.UpdatablePackage;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.repository.impl.meta.TypeDetails;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.observable.AbstractProperty;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.adapters.AdapterProperty;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.ui.TextProperty;
import com.android.tools.idea.progress.StudioProgressRunner;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.wizard.SetupSdkApplicationService;
import com.android.tools.idea.ui.ApplicationUtils;
import com.android.tools.idea.ui.validation.validators.PathValidator;
import com.android.tools.idea.updater.configure.CheckboxClickListener;
import com.android.tools.idea.updater.configure.PackageNodeModel;
import com.android.tools.idea.updater.configure.PlatformComponentsPanel;
import com.android.tools.idea.updater.configure.SdkUpdaterConfigurable;
import com.android.tools.idea.updater.configure.ToolComponentsPanel;
import com.android.tools.idea.updater.configure.UpdateSitesPanel;
import com.android.tools.idea.updater.configure.UpdaterTreeNode;
import com.android.tools.idea.welcome.install.SdkComponentInstaller;
import com.android.tools.idea.welcome.wizard.FirstRunWizardTracker;
import com.android.tools.sdk.AndroidPlatform;
import com.android.tools.sdk.AndroidSdkData;
import com.android.utils.FileUtils;
import com.android.utils.HtmlBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.SetupWizardEvent;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.dualView.TreeTableView;
import com.intellij.ui.table.SelectionProvider;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.accessibility.ScreenReader;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreeCellRenderer;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatforms;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkUpdaterConfigPanel
implements Disposable {
    private JPanel myRootPane;
    private JTextField mySdkLocationTextField;
    private JComboBox<File> mySdkLocationChooser;
    private JBLabel mySdkLocationLabel;
    private JPanel mySdkLocationPanel;
    private HyperlinkLabel myEditSdkLink;
    private HyperlinkLabel myCleanupDiskLink;
    private JBLabel mySdkErrorLabel;
    private PlatformComponentsPanel myPlatformComponentsPanel;
    private ToolComponentsPanel myToolComponentsPanel;
    private UpdateSitesPanel myUpdateSitesPanel;
    private JBTabbedPane myTabPane;
    private final Downloader myDownloader;
    private final SettingsController mySettings;
    private final SdkUpdaterConfigurable myConfigurable;
    private final OptionalValueProperty<File> mySelectedSdkLocation = new OptionalValueProperty();
    private final BindingsManager myBindingsManager = new BindingsManager();
    private final RepoManager.RepoLoadedListener myLocalUpdater = packages -> ApplicationManager.getApplication().invokeLater(() -> this.loadPackages(packages), ModalityState.any());
    private final RepoManager.RepoLoadedListener myRemoteUpdater = new RepoManager.RepoLoadedListener(){

        public void loaded(@NotNull RepositoryPackages packages) {
            ApplicationManager.getApplication().invokeLater(() -> {
                SdkUpdaterConfigPanel.this.loadPackages(packages);
                SdkUpdaterConfigPanel.this.myPlatformComponentsPanel.finishLoading();
                SdkUpdaterConfigPanel.this.myToolComponentsPanel.finishLoading();
            }, ModalityState.any());
        }
    };

    public SdkUpdaterConfigPanel(@Nullable Downloader downloader, @Nullable SettingsController settings, @NotNull SdkUpdaterConfigurable configurable) {
        this.setupUI();
        UsageTracker.log((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.SDK_MANAGER).setKind(AndroidStudioEvent.EventKind.SDK_MANAGER_LOADED));
        this.myConfigurable = configurable;
        this.myUpdateSitesPanel.setConfigurable(configurable);
        this.myDownloader = downloader;
        this.mySettings = settings;
        Collection<File> sdkLocations = SdkUpdaterConfigPanel.getSdkLocations();
        if (!sdkLocations.isEmpty()) {
            this.mySelectedSdkLocation.set((File)((Object)sdkLocations.stream().findFirst()));
        }
        this.mySelectedSdkLocation.addListener(() -> ApplicationManager.getApplication().invokeLater(this::reset));
        ((CardLayout)this.mySdkLocationPanel.getLayout()).show(this.mySdkLocationPanel, "SingleSdk");
        this.setUpSingleSdkChooser();
        this.setUpDiskCleanupLink();
        this.myBindingsManager.bindTwoWay(this.mySelectedSdkLocation, new AdapterProperty<String, Optional<File>>(this, (AbstractProperty)new TextProperty(this.mySdkLocationTextField), (Optional)this.mySelectedSdkLocation.get()){

            @Override
            @NotNull
            protected Optional<File> convertFromSourceType(@NotNull String value2) {
                if (value2.isEmpty()) {
                    return Optional.empty();
                }
                return Optional.of(new File(value2));
            }

            @Override
            @NotNull
            protected String convertFromDestType(@NotNull Optional<File> value2) {
                return value2.map(File::getPath).orElse("");
            }
        });
        this.myToolComponentsPanel.setConfigurable(this.myConfigurable);
        this.myPlatformComponentsPanel.setConfigurable(this.myConfigurable);
    }

    @Nullable
    File getSelectedSdkLocation() {
        return ((Optional)this.mySelectedSdkLocation.get()).orElse(null);
    }

    private void setupUI() {
        this.createUIComponents();
        this.myRootPane = new JPanel();
        this.myRootPane.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1));
        JBLabel jBLabel1 = new JBLabel();
        jBLabel1.setText("Manager for the Android SDK and Tools used by the IDE");
        this.myRootPane.add((Component)jBLabel1, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null, 0, false));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myRootPane.add((Component)panel1, new GridConstraints(1, 0, 1, 2, 8, 2, 3, 3, null, null, null, 0, false));
        this.mySdkLocationLabel = new JBLabel();
        this.mySdkLocationLabel.setEnabled(true);
        this.mySdkLocationLabel.setText("Android SDK Location:");
        panel1.add((Component)this.mySdkLocationLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null, 0, false));
        this.mySdkErrorLabel = new JBLabel();
        this.mySdkErrorLabel.setText("SDK Location must be set");
        this.mySdkErrorLabel.setVisible(false);
        panel1.add((Component)this.mySdkErrorLabel, new GridConstraints(1, 0, 1, 2, 8, 0, 0, 0, null, null, null, 0, false));
        this.mySdkLocationPanel = new JPanel();
        this.mySdkLocationPanel.setLayout(new CardLayout(0, 0));
        panel1.add((Component)this.mySdkLocationPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        JPanel panel2 = new JPanel();
        panel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.mySdkLocationPanel.add((Component)panel2, "SingleSdk");
        this.mySdkLocationTextField = new JTextField();
        panel2.add((Component)this.mySdkLocationTextField, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, new Dimension(400, -1), null, null, 0, false));
        this.myEditSdkLink = new HyperlinkLabel();
        panel2.add((Component)this.myEditSdkLink, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 3, null, null, null, 0, false));
        this.myCleanupDiskLink = new HyperlinkLabel();
        panel2.add((Component)this.myCleanupDiskLink, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 3, null, null, null, 0, false));
        JPanel panel3 = new JPanel();
        panel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.mySdkLocationPanel.add((Component)panel3, "MultiSdk");
        this.mySdkLocationChooser = new JComboBox();
        panel3.add(this.mySdkLocationChooser, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, null, null, null, 0, false));
        this.myTabPane = new JBTabbedPane();
        this.myRootPane.add((Component)this.myTabPane, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 5, null, new Dimension(200, 200), null, 0, false));
        JPanel panel4 = new JPanel();
        panel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myTabPane.addTab("SDK Platforms", (Component)panel4);
        this.myPlatformComponentsPanel = new PlatformComponentsPanel();
        panel4.add((Component)this.myPlatformComponentsPanel.getRootComponent(), new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        JPanel panel5 = new JPanel();
        panel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myTabPane.addTab("SDK Tools", (Component)panel5);
        this.myToolComponentsPanel = new ToolComponentsPanel();
        panel5.add((Component)this.myToolComponentsPanel.getRootComponent(), new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        JPanel panel6 = new JPanel();
        panel6.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myTabPane.addTab("SDK Update Sites", (Component)panel6);
        panel6.add((Component)this.myUpdateSitesPanel.getRootComponent(), new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
    }

    @NotNull
    private static Collection<File> getSdkLocations() {
        File androidHome = IdeSdks.getInstance().getAndroidSdkPath();
        if (androidHome != null) {
            return ImmutableList.of((Object)androidHome);
        }
        HashSet<File> locations = new HashSet<File>();
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            List facets = ProjectFacetManager.getInstance((Project)project).getFacets(AndroidFacet.ID);
            for (AndroidFacet facet : facets) {
                AndroidPlatform androidPlatform = AndroidPlatforms.getInstance(facet.getModule());
                AndroidSdkData sdkData = androidPlatform == null ? null : androidPlatform.getSdkData();
                if (sdkData == null) continue;
                locations.add(sdkData.getLocationFile());
            }
        }
        return locations;
    }

    private void setUpSingleSdkChooser() {
        this.myEditSdkLink.setHyperlinkText("Edit");
        this.myEditSdkLink.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(@NotNull HyperlinkEvent e) {
                boolean useDeprecatedWizard = (Boolean)StudioFlags.SDK_SETUP_MIGRATED_WIZARD_ENABLED.get() == false;
                SetupSdkApplicationService.getInstance().showSdkSetupWizard(SdkUpdaterConfigPanel.this.mySdkLocationTextField.getText(), (Function1<? super File, Unit>)((Function1)sdkLocation -> {
                    SdkUpdaterConfigPanel.this.onSdkLocationUpdated((File)sdkLocation);
                    return null;
                }), new SdkComponentInstaller(), new FirstRunWizardTracker(SetupWizardEvent.SetupWizardMode.SDK_SETUP, useDeprecatedWizard), useDeprecatedWizard);
            }
        });
        this.mySdkLocationTextField.setEditable(false);
    }

    private void onSdkLocationUpdated(File newSdkLocation) {
        File currentSdkLocation = IdeSdks.getInstance().getAndroidSdkPath();
        if (!FileUtil.filesEqual((File)currentSdkLocation, (File)newSdkLocation)) {
            SdkUpdaterConfigPanel.setAndroidSdkLocation(newSdkLocation);
        }
        this.mySelectedSdkLocation.setValue(newSdkLocation);
        this.refresh(false);
    }

    private void setUpDiskCleanupLink() {
        this.myCleanupDiskLink.setHyperlinkText("Optimize disk space");
        this.myCleanupDiskLink.addHyperlinkListener(e -> {
            HtmlBuilder cleanupMessageBuilder;
            File sdkLocation = this.getSelectedSdkLocation();
            if (sdkLocation == null) {
                return;
            }
            ImmutableSet SDK_DIRECTORIES_TO_CLEANUP = ImmutableSet.of((Object)".temp", (Object)".downloadIntermediates");
            try {
                cleanupMessageBuilder = (HtmlBuilder)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> SdkUpdaterConfigPanel.lambda$setUpDiskCleanupLink$3((Set)SDK_DIRECTORIES_TO_CLEANUP, sdkLocation), "Analyzing SDK Disk Space Utilization", true, null);
            }
            catch (ProcessCanceledException ex) {
                return;
            }
            if (cleanupMessageBuilder == null) {
                Messages.showInfoMessage((Component)this.myRootPane, (String)"The disk space utilized by this SDK is already optimized.", (String)"SDK Disk Space Utilization");
            } else if (SdkUpdaterConfigurable.confirmChange(cleanupMessageBuilder)) {
                ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> SdkUpdaterConfigPanel.lambda$setUpDiskCleanupLink$4((Set)SDK_DIRECTORIES_TO_CLEANUP, sdkLocation), "Deleting SDK Temporary Files", false, null);
            }
        });
    }

    public void dispose() {
        this.myBindingsManager.releaseAll();
    }

    private static void setAndroidSdkLocation(File sdkLocation) {
        ApplicationUtils.invokeWriteActionAndWait(ModalityState.any(), () -> IdeSdks.getInstance().setAndroidSdkPath(sdkLocation));
    }

    public JComponent getComponent() {
        return this.myRootPane;
    }

    public boolean isModified() {
        return this.myPlatformComponentsPanel.isModified() || this.myToolComponentsPanel.isModified() || this.myUpdateSitesPanel.isModified();
    }

    static void setTreeTableProperties(TreeTableView tt, UpdaterTreeNode.Renderer renderer2, ChangeListener listener2) {
        tt.setTreeCellRenderer((TreeCellRenderer)renderer2);
        new CheckboxClickListener(tt, renderer2).installOn((Component)tt);
        TreeUtil.installActions((JTree)tt.getTree());
        tt.getTree().setToggleClickCount(0);
        tt.getTree().setShowsRootHandles(true);
        SdkUpdaterConfigPanel.setTableProperties((JTable)tt, listener2);
    }

    static void setTableProperties(final @NotNull JTable table2, final @Nullable ChangeListener listener2) {
        assert (table2 instanceof SelectionProvider);
        ActionMap am = table2.getActionMap();
        final CycleAction forwardAction = new CycleAction(false);
        final CycleAction backwardAction = new CycleAction(true);
        if (!ScreenReader.isActive()) {
            am.put("selectPreviousColumnCell", backwardAction);
            am.put("selectNextColumnCell", forwardAction);
        }
        table2.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n' || e.getKeyChar() == ' ') {
                    Collection selection2 = ((SelectionProvider)table2).getSelection();
                    for (MultiStateRow node : selection2) {
                        node.cycleState();
                        table2.repaint();
                        if (listener2 == null) continue;
                        listener2.stateChanged(new ChangeEvent(node));
                    }
                }
            }
        });
        table2.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                if (e.getOppositeComponent() != null) {
                    table2.getSelectionModel().clearSelection();
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                JTable table22 = (JTable)e.getSource();
                if (table22.getSelectionModel().getMinSelectionIndex() != -1) {
                    return;
                }
                boolean traversalBackward = "TRAVERSAL_BACKWARD".equals(SdkUpdaterConfigPanel.getCause(e));
                if (traversalBackward) {
                    backwardAction.doAction(table22);
                } else {
                    forwardAction.doAction(table22);
                }
            }
        });
    }

    @Nullable
    private static String getCause(@NotNull FocusEvent event) {
        try {
            Method getCause = event.getClass().getDeclaredMethod("getCause", new Class[0]);
            Object enumValue = getCause.invoke((Object)event, new Object[0]);
            if (enumValue == null) {
                return null;
            }
            return enumValue.toString();
        }
        catch (ReflectiveOperationException ex) {
            Logger.getInstance(SdkUpdaterConfigPanel.class).warn((Throwable)ex);
            return null;
        }
    }

    protected static void resizeColumnsToFit(JTable table2) {
        TableColumnModel columnModel = table2.getColumnModel();
        for (int column2 = 1; column2 < table2.getColumnCount(); ++column2) {
            int width = 50;
            for (int row = 0; row < table2.getRowCount(); ++row) {
                TableCellRenderer renderer2 = table2.getCellRenderer(row, column2);
                Component comp = table2.prepareRenderer(renderer2, row, column2);
                width = Math.max(comp.getPreferredSize().width + 1, width);
            }
            columnModel.getColumn(column2).setPreferredWidth(width);
        }
    }

    public void refresh(boolean forceRemoteReload) {
        this.validate();
        Project[] projects = ProjectManager.getInstance().getOpenProjects();
        StudioProgressRunner progressRunner = new StudioProgressRunner(false, "Loading SDK", projects.length == 0 ? null : projects[0]);
        if (forceRemoteReload) {
            this.myPlatformComponentsPanel.startLoading();
            this.myToolComponentsPanel.startLoading();
            this.myConfigurable.getRepoManager().load(0L, this.myLocalUpdater, this.myRemoteUpdater, null, (ProgressRunner)progressRunner, this.myDownloader, this.mySettings);
        } else {
            this.myConfigurable.getRepoManager().load(0L, this.myLocalUpdater, null, null, (ProgressRunner)progressRunner, null, this.mySettings);
        }
    }

    private void validate() {
        Path nullableSdkPath = this.myConfigurable.getRepoManager().getLocalPath();
        @NotNull Path sdkLocation = nullableSdkPath == null ? Paths.get("", new String[0]) : nullableSdkPath;
        Validator.Result result2 = PathValidator.forAndroidSdkLocation().validate(sdkLocation);
        Validator.Severity severity = result2.getSeverity();
        if (severity == Validator.Severity.OK) {
            this.mySdkLocationLabel.setForeground(JBColor.foreground());
            this.mySdkErrorLabel.setVisible(false);
        } else {
            this.mySdkErrorLabel.setIcon(severity.getIcon());
            this.mySdkErrorLabel.setText(result2.getMessage());
            this.mySdkErrorLabel.setVisible(true);
        }
        boolean enabled = severity != Validator.Severity.ERROR;
        this.myPlatformComponentsPanel.setEnabled(enabled);
        this.myTabPane.setEnabled(enabled);
    }

    private void loadPackages(RepositoryPackages packages) {
        TreeMultimap platformPackages = TreeMultimap.create();
        TreeSet toolsPackages = Sets.newTreeSet();
        for (UpdatablePackage info : packages.getConsolidatedPkgs().values()) {
            RepoPackage p = info.getRepresentative();
            TypeDetails details = p.getTypeDetails();
            if (details instanceof DetailsTypes.ApiDetailsType) {
                platformPackages.put((Object)((DetailsTypes.ApiDetailsType)details).getAndroidVersion(), (Object)info);
                continue;
            }
            toolsPackages.add(info);
        }
        this.myPlatformComponentsPanel.setPackages((Multimap<AndroidVersion, UpdatablePackage>)platformPackages);
        this.myToolComponentsPanel.setPackages(toolsPackages);
    }

    public Collection<PackageNodeModel> getStates() {
        ArrayList<PackageNodeModel> result2 = new ArrayList<PackageNodeModel>();
        result2.addAll(this.myPlatformComponentsPanel.myStates);
        result2.addAll(this.myToolComponentsPanel.myStates);
        return result2;
    }

    public void reset() {
        this.refresh(true);
        Collection<File> sdkLocations = SdkUpdaterConfigPanel.getSdkLocations();
        if (sdkLocations.size() == 1) {
            this.mySdkLocationTextField.setText(sdkLocations.iterator().next().getPath());
        }
        if (sdkLocations.isEmpty()) {
            this.myCleanupDiskLink.setEnabled(false);
        } else {
            this.myCleanupDiskLink.setEnabled(true);
        }
        this.myPlatformComponentsPanel.reset();
        this.myToolComponentsPanel.reset();
        this.myUpdateSitesPanel.reset();
    }

    public void saveSources() {
        this.myUpdateSitesPanel.save();
    }

    public boolean areSourcesModified() {
        return this.myUpdateSitesPanel.isModified();
    }

    private void createUIComponents() {
        this.myUpdateSitesPanel = new UpdateSitesPanel(() -> this.refresh(true));
    }

    private static /* synthetic */ void lambda$setUpDiskCleanupLink$4(Set SDK_DIRECTORIES_TO_CLEANUP, File sdkLocation) {
        for (String cleanupDir : SDK_DIRECTORIES_TO_CLEANUP) {
            File cleanupDirFile = new File(sdkLocation, cleanupDir);
            FileUtil.delete((File)cleanupDirFile);
        }
    }

    private static /* synthetic */ HtmlBuilder lambda$setUpDiskCleanupLink$3(Set SDK_DIRECTORIES_TO_CLEANUP, File sdkLocation) throws RuntimeException {
        HtmlBuilder htmlBuilder = new HtmlBuilder();
        long totalSizeToCleanup = 0L;
        htmlBuilder.openHtmlBody();
        htmlBuilder.addHtml("The files under the following SDK locations can be safely cleaned up:").newline().beginList();
        for (String cleanupDir : SDK_DIRECTORIES_TO_CLEANUP) {
            File cleanupDirFile = new File(sdkLocation, cleanupDir);
            long size = 0L;
            for (File f : FileUtils.getAllFiles((File)cleanupDirFile)) {
                size += f.length();
            }
            if (size <= 0L) continue;
            htmlBuilder.listItem().addHtml(cleanupDirFile.getAbsolutePath() + " (" + new Storage(size).toUiString() + ") ");
            totalSizeToCleanup += size;
        }
        htmlBuilder.endList();
        htmlBuilder.addHtml("Do you want to proceed with deleting the specified files?");
        htmlBuilder.closeHtmlBody();
        if (totalSizeToCleanup > 0L) {
            return htmlBuilder;
        }
        return null;
    }

    private static class CycleAction
    extends AbstractAction {
        final boolean myBackward;

        CycleAction(boolean backward) {
            this.myBackward = backward;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.doAction((JTable)evt.getSource());
        }

        public void doAction(JTable table2) {
            int row;
            KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            ListSelectionModel selectionModel = table2.getSelectionModel();
            int n = row = this.myBackward ? selectionModel.getMinSelectionIndex() : selectionModel.getMaxSelectionIndex();
            if (row == -1 && this.myBackward) {
                row = table2.getRowCount();
            }
            if ((row += this.myBackward ? -1 : 1) < 0) {
                manager.focusPreviousComponent(table2);
            } else if (row >= table2.getRowCount()) {
                manager.focusNextComponent(table2);
            } else {
                selectionModel.setSelectionInterval(row, row);
                table2.setColumnSelectionInterval(1, 1);
                table2.scrollRectToVisible(table2.getCellRect(row, 1, true));
            }
            table2.repaint();
        }
    }

    public static interface MultiStateRow {
        public void cycleState();
    }
}

