/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater.configure;

import com.android.repository.api.RepoPackage;
import com.android.repository.api.UpdatablePackage;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.updater.configure.ApiLevelColumnInfo;
import com.android.tools.idea.updater.configure.DetailsTreeNode;
import com.android.tools.idea.updater.configure.DownloadStatusColumnInfo;
import com.android.tools.idea.updater.configure.PackageNodeModel;
import com.android.tools.idea.updater.configure.ParentTreeNode;
import com.android.tools.idea.updater.configure.RevisionColumnInfo;
import com.android.tools.idea.updater.configure.RootNode;
import com.android.tools.idea.updater.configure.SdkUpdaterConfigPanel;
import com.android.tools.idea.updater.configure.SdkUpdaterConfigurable;
import com.android.tools.idea.updater.configure.StatusColumnInfo;
import com.android.tools.idea.updater.configure.SummaryTreeNode;
import com.android.tools.idea.updater.configure.UpdaterTreeNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.dualView.TreeTableView;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.ui.treeStructure.treetable.TreeColumnInfo;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public class PlatformComponentsPanel {
    private static final String PLATFORM_DETAILS_CHECKBOX_SELECTED = "updater.configure.platform.details.checkbox.selected";
    private TreeTableView myPlatformSummaryTable;
    private TreeTableView myPlatformDetailTable;
    private JPanel myPlatformPanel;
    private JCheckBox myPlatformDetailsCheckbox;
    private JCheckBox myHideObsoletePackagesCheckbox;
    private JPanel myPlatformLoadingPanel;
    private JBLabel myPlatformLoadingLabel;
    private AsyncProcessIcon myPlatformLoadingIcon;
    private JPanel myRootPanel;
    private boolean myModified;
    @VisibleForTesting
    UpdaterTreeNode myPlatformDetailsRootNode;
    @VisibleForTesting
    UpdaterTreeNode myPlatformSummaryRootNode;
    Set<PackageNodeModel> myStates = Sets.newHashSet();
    private final Multimap<AndroidVersion, UpdatablePackage> myCurrentPackages = TreeMultimap.create();
    private final ChangeListener myModificationListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            PlatformComponentsPanel.this.refreshModified();
        }
    };
    private SdkUpdaterConfigurable myConfigurable;

    PlatformComponentsPanel() {
        this(PropertiesComponent.getInstance());
    }

    @VisibleForTesting
    PlatformComponentsPanel(@NotNull PropertiesComponent propertiesComponent) {
        this.setupUI();
        this.myPlatformSummaryTable.setColumnSelectionAllowed(false);
        this.myPlatformLoadingLabel.setForeground((Color)JBColor.GRAY);
        this.myPlatformDetailsCheckbox.setSelected(propertiesComponent.getBoolean(PLATFORM_DETAILS_CHECKBOX_SELECTED, false));
        this.myPlatformDetailsCheckbox.addActionListener(e -> {
            propertiesComponent.setValue(PLATFORM_DETAILS_CHECKBOX_SELECTED, this.myPlatformDetailsCheckbox.isSelected());
            this.updatePlatformTable();
        });
        this.updatePlatformTable();
        this.myHideObsoletePackagesCheckbox.addActionListener(e -> this.updatePlatformItems());
    }

    private void updatePlatformTable() {
        ((CardLayout)this.myPlatformPanel.getLayout()).show(this.myPlatformPanel, this.myPlatformDetailsCheckbox.isSelected() ? "details" : "summary");
    }

    private void updatePlatformItems() {
        this.myPlatformDetailsRootNode.removeAllChildren();
        this.myPlatformSummaryRootNode.removeAllChildren();
        this.myStates.clear();
        for (AndroidVersion version2 : ImmutableList.sortedCopyOf(AndroidVersion.API_LEVEL_ORDERING.reversed().thenComparing(Comparator.naturalOrder()), (Iterable)this.myCurrentPackages.keySet())) {
            SummaryTreeNode node;
            if (version2.getApiLevel() < 1) continue;
            HashSet versionNodes = Sets.newHashSet();
            ParentTreeNode marker = new ParentTreeNode(version2);
            for (UpdatablePackage info : this.myCurrentPackages.get((Object)version2)) {
                RepoPackage pkg = info.getRepresentative();
                if (pkg.obsolete() && this.myHideObsoletePackagesCheckbox.isSelected()) continue;
                PackageNodeModel model = new PackageNodeModel(info, false);
                this.myStates.add(model);
                DetailsTreeNode node2 = new DetailsTreeNode(model, this.myModificationListener, this.myConfigurable);
                marker.add(node2);
                versionNodes.add(node2);
            }
            if (marker.getChildCount() > 0) {
                this.myPlatformDetailsRootNode.add(marker);
            }
            if ((node = SummaryTreeNode.createNode(version2, versionNodes)) == null) continue;
            this.myPlatformSummaryRootNode.add(node);
        }
        this.refreshModified();
        SdkUpdaterConfigPanel.resizeColumnsToFit((JTable)this.myPlatformDetailTable);
        SdkUpdaterConfigPanel.resizeColumnsToFit((JTable)this.myPlatformSummaryTable);
        this.myPlatformDetailTable.updateUI();
        this.myPlatformSummaryTable.updateUI();
        TreeUtil.expandAll((JTree)this.myPlatformDetailTable.getTree());
        TreeUtil.expandAll((JTree)this.myPlatformSummaryTable.getTree());
    }

    public void startLoading() {
        this.myCurrentPackages.clear();
        this.myPlatformLoadingPanel.setVisible(true);
    }

    public void finishLoading() {
        this.updatePlatformItems();
        this.myPlatformLoadingPanel.setVisible(false);
    }

    private void createUIComponents() {
        UpdaterTreeNode.Renderer renderer2 = new UpdaterTreeNode.Renderer();
        this.myPlatformLoadingIcon = new AsyncProcessIcon("Loading...");
        this.myPlatformSummaryRootNode = new RootNode();
        this.myPlatformDetailsRootNode = new RootNode();
        ColumnInfo[] platformSummaryColumns = new ColumnInfo[]{new DownloadStatusColumnInfo(), new TreeColumnInfo("Name"), new ApiLevelColumnInfo(), new RevisionColumnInfo(), new StatusColumnInfo()};
        this.myPlatformSummaryTable = new TreeTableView(new ListTreeTableModelOnColumns((TreeNode)this.myPlatformSummaryRootNode, platformSummaryColumns));
        SdkUpdaterConfigPanel.setTreeTableProperties(this.myPlatformSummaryTable, renderer2, this.myModificationListener);
        ColumnInfo[] platformDetailColumns = new ColumnInfo[]{new DownloadStatusColumnInfo(), new TreeColumnInfo("Name"), new ApiLevelColumnInfo(), new RevisionColumnInfo(), new StatusColumnInfo()};
        this.myPlatformDetailTable = new TreeTableView(new ListTreeTableModelOnColumns((TreeNode)this.myPlatformDetailsRootNode, platformDetailColumns));
        SdkUpdaterConfigPanel.setTreeTableProperties(this.myPlatformDetailTable, renderer2, this.myModificationListener);
    }

    public void setPackages(@NotNull Multimap<AndroidVersion, UpdatablePackage> packages) {
        this.myCurrentPackages.clear();
        this.myCurrentPackages.putAll(packages);
        this.updatePlatformItems();
    }

    public boolean isModified() {
        return this.myModified;
    }

    public void refreshModified() {
        Enumeration<TreeNode> items = this.myPlatformDetailsRootNode.breadthFirstEnumeration();
        while (items.hasMoreElements()) {
            UpdaterTreeNode node = (UpdaterTreeNode)items.nextElement();
            if (node.getInitialState() == node.getCurrentState()) continue;
            this.myModified = true;
            return;
        }
        this.myModified = false;
    }

    public void reset() {
        Enumeration<TreeNode> children2 = this.myPlatformDetailsRootNode.breadthFirstEnumeration();
        while (children2.hasMoreElements()) {
            UpdaterTreeNode node = (UpdaterTreeNode)children2.nextElement();
            node.resetState();
        }
        this.refreshModified();
    }

    public void setEnabled(boolean enabled) {
        this.myPlatformDetailTable.setEnabled(enabled);
        this.myPlatformSummaryTable.setEnabled(enabled);
        this.myPlatformDetailsCheckbox.setEnabled(enabled);
    }

    public void setConfigurable(@NotNull SdkUpdaterConfigurable configurable) {
        this.myConfigurable = configurable;
    }

    private void setupUI() {
        this.createUIComponents();
        this.myRootPanel = new JPanel();
        this.myRootPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1));
        this.myRootPanel.add((Component)panel1, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.myPlatformDetailsCheckbox = new JCheckBox();
        this.myPlatformDetailsCheckbox.setText("Show Package Details");
        panel1.add((Component)this.myPlatformDetailsCheckbox, new GridConstraints(0, 3, 1, 1, 4, 0, 0, 0, null, null, null, 0, false));
        this.myPlatformLoadingPanel = new JPanel();
        this.myPlatformLoadingPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        panel1.add((Component)this.myPlatformLoadingPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.myPlatformLoadingLabel = new JBLabel();
        this.myPlatformLoadingLabel.setText("Looking for updates...");
        this.myPlatformLoadingPanel.add((Component)this.myPlatformLoadingLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null, 0, false));
        this.myPlatformLoadingPanel.add((Component)this.myPlatformLoadingIcon, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null, 0, false));
        this.myHideObsoletePackagesCheckbox = new JCheckBox();
        this.myHideObsoletePackagesCheckbox.setSelected(true);
        this.myHideObsoletePackagesCheckbox.setText("Hide Obsolete Packages");
        panel1.add((Component)this.myHideObsoletePackagesCheckbox, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        panel1.add((Component)spacer1, new GridConstraints(0, 1, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        JBLabel jBLabel1 = new JBLabel();
        jBLabel1.setText("<html>Each Android SDK Platform package includes the Android platform and sources pertaining to an API level by default. Once installed, the IDE will automatically check for updates. Check \"show package details\" to display individual SDK components.</html>");
        this.myRootPanel.add((Component)jBLabel1, new GridConstraints(0, 0, 1, 1, 8, 0, 5, 0, null, null, null, 0, false));
        this.myPlatformPanel = new JPanel();
        this.myPlatformPanel.setLayout(new CardLayout(0, 0));
        this.myRootPanel.add((Component)this.myPlatformPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 5, null, null, null, 0, false));
        JBScrollPane jBScrollPane1 = new JBScrollPane();
        this.myPlatformPanel.add((Component)jBScrollPane1, "summary");
        jBScrollPane1.setViewportView((Component)this.myPlatformSummaryTable);
        JBScrollPane jBScrollPane2 = new JBScrollPane();
        this.myPlatformPanel.add((Component)jBScrollPane2, "details");
        jBScrollPane2.setViewportView((Component)this.myPlatformDetailTable);
    }

    public JComponent getRootComponent() {
        return this.myRootPanel;
    }
}

