/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater.configure;

import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepositorySource;
import com.android.repository.api.RepositorySourceProvider;
import com.android.tools.idea.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.AndroidAuthenticator;
import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.OneTimeString;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0014J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001d\u001a\u00020\u0015H\u0002J\b\u0010\"\u001a\u00020#H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\b\u001a\t\u0018\u00010\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017R\u0013\u0010\u001e\u001a\u0004\u0018\u00010\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006$"}, d2={"Lcom/android/tools/idea/updater/configure/EditSourceDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "provider", "Lcom/android/repository/api/RepositorySourceProvider;", "existingSource", "Lcom/android/repository/api/RepositorySource;", "<init>", "(Lcom/android/repository/api/RepositorySourceProvider;Lcom/android/repository/api/RepositorySource;)V", "existingAuth", "Ljava/net/PasswordAuthentication;", "Lorg/jetbrains/annotations/Nullable;", "urlField", "Ljavax/swing/JTextField;", "nameField", "useAuthentication", "Lcom/intellij/ui/dsl/builder/Cell;", "Lcom/intellij/ui/components/JBCheckBox;", "loginField", "passwordField", "Ljavax/swing/JPasswordField;", "uiName", "", "getUiName", "()Ljava/lang/String;", "url", "getUrl", "doValidate", "Lcom/intellij/openapi/ui/ValidationInfo;", "getErrorMessage", "urlString", "credentials", "Lcom/intellij/credentialStore/Credentials;", "getCredentials", "()Lcom/intellij/credentialStore/Credentials;", "createCenterPanel", "Ljavax/swing/JComponent;", "intellij.android.sdkUpdates"})
@SourceDebugExtension(value={"SMAP\nEditSourceDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditSourceDialog.kt\ncom/android/tools/idea/updater/configure/EditSourceDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,116:1\n1#2:117\n*E\n"})
public final class EditSourceDialog
extends DialogWrapper {
    @NotNull
    private final RepositorySourceProvider provider;
    @Nullable
    private final RepositorySource existingSource;
    @Nullable
    private final PasswordAuthentication existingAuth;
    @NotNull
    private final JTextField urlField;
    @NotNull
    private final JTextField nameField;
    private Cell<? extends JBCheckBox> useAuthentication;
    @NotNull
    private final JTextField loginField;
    @NotNull
    private final JPasswordField passwordField;

    public EditSourceDialog(@NotNull RepositorySourceProvider provider, @Nullable RepositorySource existingSource) {
        String string;
        Object object;
        EditSourceDialog editSourceDialog;
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        super(null);
        this.provider = provider;
        this.existingSource = existingSource;
        EditSourceDialog editSourceDialog2 = this;
        RepositorySource repositorySource = this.existingSource;
        if (repositorySource != null) {
            RepositorySource repositorySource2 = repositorySource;
            editSourceDialog = editSourceDialog2;
            boolean bl = false;
            v2 = AndroidAuthenticator.getAuthentication(this.existingSource.getUrl());
            editSourceDialog2 = editSourceDialog;
        } else {
            v2 = editSourceDialog2.existingAuth = null;
        }
        if ((object = this.existingSource) == null || (object = object.getUrl()) == null) {
            object = "http://";
        }
        this.urlField = new JTextField((String)object);
        Object object2 = this.existingSource;
        if (object2 == null || (object2 = object2.getDisplayName()) == null) {
            object2 = "Custom Update Site";
        }
        this.nameField = new JTextField((String)object2);
        PasswordAuthentication passwordAuthentication = this.existingAuth;
        this.loginField = new JTextField(passwordAuthentication != null ? passwordAuthentication.getUserName() : null);
        EditSourceDialog editSourceDialog3 = this;
        PasswordAuthentication passwordAuthentication2 = this.existingAuth;
        if (passwordAuthentication2 != null) {
            PasswordAuthentication it = passwordAuthentication2;
            editSourceDialog = editSourceDialog3;
            boolean bl = false;
            char[] cArray = this.existingAuth.getPassword();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"getPassword(...)");
            string = new OneTimeString(cArray, 0, 0, true, 6, null).toString();
            editSourceDialog3 = editSourceDialog;
        } else {
            string = null;
        }
        String string2 = string;
        editSourceDialog3.passwordField = new JPasswordField(string2);
        this.setModal(true);
        this.urlField.addActionListener(arg_0 -> EditSourceDialog._init_$lambda$2(this, arg_0));
        this.urlField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.initValidation();
            }
        });
        this.init();
    }

    @NotNull
    public final String getUiName() {
        String string = this.nameField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    @NotNull
    public final String getUrl() {
        String string = this.urlField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        ValidationInfo validationInfo;
        String string = this.urlField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = this.getErrorMessage(string);
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            validationInfo = new ValidationInfo(it);
        } else {
            validationInfo = null;
        }
        return validationInfo;
    }

    private final String getErrorMessage(String urlString) {
        try {
            new URL(urlString);
        }
        catch (MalformedURLException e) {
            return "URL is invalid";
        }
        if (this.existingSource == null) {
            for (RepositorySource s : this.provider.getSources(null, (ProgressIndicator)new StudioLoggerProgressIndicator(((Object)((Object)this)).getClass()), false)) {
                if (!StringsKt.equals((String)urlString, (String)s.getUrl(), (boolean)true)) continue;
                return "An update site with this URL already exists";
            }
        }
        return null;
    }

    @Nullable
    public final Credentials getCredentials() {
        Cell<? extends JBCheckBox> cell = this.useAuthentication;
        if (cell == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"useAuthentication");
            cell = null;
        }
        if (((JBCheckBox)cell.getComponent()).isSelected()) {
            return new Credentials(this.loginField.getText(), this.passwordField.getPassword());
        }
        return null;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return (JComponent)BuilderKt.panel(arg_0 -> EditSourceDialog.createCenterPanel$lambda$10(this, arg_0));
    }

    private static final void _init_$lambda$2(EditSourceDialog this$0, ActionEvent it) {
        this$0.initValidation();
    }

    private static final Unit createCenterPanel$lambda$10$lambda$4(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Row.comment$default((Row)$this$row, (String)"Please enter the Name and URL of the addon.xml for the update site", (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$10$lambda$5(EditSourceDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.nameField).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$10$lambda$6(EditSourceDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.urlField).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$10$lambda$7(EditSourceDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.useAuthentication = ButtonKt.selected((Cell)$this$row.checkBox("Use Authentication"), (this$0.existingAuth != null ? 1 : 0) != 0);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$10$lambda$8(EditSourceDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.loginField).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$10$lambda$9(EditSourceDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.passwordField).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$10(EditSourceDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, EditSourceDialog::createCenterPanel$lambda$10$lambda$4, (int)1, null);
        $this$panel.row("Name:", arg_0 -> EditSourceDialog.createCenterPanel$lambda$10$lambda$5(this$0, arg_0));
        $this$panel.row("URL:", arg_0 -> EditSourceDialog.createCenterPanel$lambda$10$lambda$6(this$0, arg_0));
        Panel.row$default((Panel)$this$panel, null, arg_0 -> EditSourceDialog.createCenterPanel$lambda$10$lambda$7(this$0, arg_0), (int)1, null);
        Row row = $this$panel.row("Login:", arg_0 -> EditSourceDialog.createCenterPanel$lambda$10$lambda$8(this$0, arg_0));
        Cell<? extends JBCheckBox> cell = this$0.useAuthentication;
        if (cell == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"useAuthentication");
            cell = null;
        }
        row.enabledIf(ButtonKt.getSelected(cell));
        Row row2 = $this$panel.row("Password:", arg_0 -> EditSourceDialog.createCenterPanel$lambda$10$lambda$9(this$0, arg_0));
        Cell<? extends JBCheckBox> cell2 = this$0.useAuthentication;
        if (cell2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"useAuthentication");
            cell2 = null;
        }
        row2.enabledIf(ButtonKt.getSelected(cell2));
        return Unit.INSTANCE;
    }
}

