/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater;

import com.android.repository.api.Downloader;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.SettingsController;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.progress.RepoProgressIndicatorAdapter;
import com.android.tools.idea.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.updater.UpdatablePackage;
import com.android.tools.idea.updater.UpdateInfoDialog;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.intellij.ide.externalComponents.ExternalComponentSource;
import com.intellij.ide.externalComponents.UpdatableExternalComponent;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkComponentSource
implements ExternalComponentSource {
    public static String NAME = "Android SDK";
    public static final String PREVIEW_CHANNEL = "Preview Channel";
    public static final String STABLE_CHANNEL = "Stable Channel";
    private RepositoryPackages myPackages;
    private static final StudioLoggerProgressIndicator LOGGER = new StudioLoggerProgressIndicator(SdkComponentSource.class);

    private void initIfNecessary(@Nullable com.intellij.openapi.progress.ProgressIndicator indicator) {
        RepoManager mgr = this.getRepoManager();
        Object progress2 = indicator != null ? new RepoProgressIndicatorAdapter(indicator) : LOGGER;
        mgr.loadSynchronously(TimeUnit.MINUTES.toMillis(1L), (ProgressIndicator)progress2, this.getDownloader(), this.getSettingsController());
        this.myPackages = mgr.getPackages();
    }

    @VisibleForTesting
    @NotNull
    SettingsController getSettingsController() {
        return StudioSettingsController.getInstance();
    }

    @VisibleForTesting
    @NotNull
    Downloader getDownloader() {
        return new StudioDownloader();
    }

    @VisibleForTesting
    @NotNull
    RepoManager getRepoManager() {
        return AndroidSdks.getInstance().tryToChooseSdkHandler().getRepoManager((ProgressIndicator)LOGGER);
    }

    public void installUpdates(@NotNull Collection<UpdatableExternalComponent> request) {
        ArrayList<RemotePackage> packages = new ArrayList<RemotePackage>();
        for (UpdatableExternalComponent p : request) {
            packages.add((RemotePackage)p.getKey());
        }
        new UpdateInfoDialog(true, packages).show();
    }

    @NotNull
    public Collection<UpdatableExternalComponent> getAvailableVersions(@Nullable com.intellij.openapi.progress.ProgressIndicator indicator, @Nullable UpdateSettings updateSettings2) {
        List sdks;
        if (!IdeInfo.getInstance().isAndroidStudio() && (sdks = AndroidSdks.getInstance().getAllAndroidSdks()).isEmpty()) {
            return Collections.emptyList();
        }
        return this.getComponents(indicator, updateSettings2, true);
    }

    @NotNull
    public Collection<UpdatableExternalComponent> getCurrentVersions() {
        return this.getComponents(null, null, false);
    }

    @NotNull
    private Collection<UpdatableExternalComponent> getComponents(@Nullable com.intellij.openapi.progress.ProgressIndicator indicator, @Nullable UpdateSettings settings, boolean remote) {
        ArrayList<UpdatableExternalComponent> result2 = new ArrayList<UpdatableExternalComponent>();
        this.initIfNecessary(indicator);
        ImmutableSet ignored = settings != null ? Sets.newHashSet((Iterable)settings.getIgnoredBuildNumbers()) : ImmutableSet.of();
        for (com.android.repository.api.UpdatablePackage p : this.myPackages.getConsolidatedPkgs().values()) {
            if (remote) {
                RemotePackage remotePackage;
                if (!p.hasRemote() || ignored.contains(SdkComponentSource.getPackageRevisionId((RepoPackage)(remotePackage = p.getRemote())))) continue;
                result2.add(new UpdatablePackage((RepoPackage)remotePackage));
                continue;
            }
            if (!p.hasLocal()) continue;
            result2.add(new UpdatablePackage((RepoPackage)p.getLocal()));
        }
        return result2;
    }

    @NotNull
    static String getPackageRevisionId(@NotNull RepoPackage p) {
        return String.format("%1$s#%2$s", p.getPath(), p.getVersion().toString());
    }

    @NotNull
    public String getName() {
        return NAME;
    }

    @NotNull
    public Collection<? extends Pair<String, String>> getStatuses() {
        return Collections.emptyList();
    }

    @Nullable
    public List<String> getAllChannels() {
        return ImmutableList.of((Object)STABLE_CHANNEL, (Object)PREVIEW_CHANNEL);
    }

    public boolean isEnabled() {
        return AndroidSdkUtils.isAndroidSdkManagerEnabled();
    }
}

