/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.screenrecording;

import com.android.tools.idea.ui.AndroidAdbUiBundle;
import com.android.tools.idea.ui.save.SaveConfiguration;
import com.android.tools.idea.ui.save.SaveConfigurationResolver;
import com.android.tools.idea.ui.screenrecording.DeviceScreenRecordingSettings;
import com.android.tools.idea.ui.screenrecording.DeviceScreenRecordingSettingsPage;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.ComboBoxKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldKt;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.IntRange;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0018\u001a\u00020\u0019H\u0014J\b\u0010\u001a\u001a\u00020\u0013H\u0014J\b\u0010\u001b\u001a\u00020\u0013H\u0014J\b\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010\u001e\u001a\u00020\u001dH\u0002J\u0015\u0010\u001f\u001a\u00070\u0013\u00a2\u0006\u0002\b 2\u0006\u0010!\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/android/tools/idea/ui/screenrecording/ScreenRecorderOptionsDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "emulatorRecordingAvailable", "", "apiLevel", "", "<init>", "(Lcom/intellij/openapi/project/Project;ZI)V", "settings", "Lcom/android/tools/idea/ui/screenrecording/DeviceScreenRecordingSettings;", "saveConfig", "Lcom/android/tools/idea/ui/save/SaveConfiguration;", "recordingLengthField", "Ljavax/swing/JEditorPane;", "saveConfigResolver", "Lcom/android/tools/idea/ui/save/SaveConfigurationResolver;", "saveLocation", "", "getSaveLocation", "()Ljava/lang/String;", "saveLocationText", "fileExtension", "createCenterPanel", "Ljavax/swing/JComponent;", "getDimensionServiceKey", "getHelpId", "createDefaultActions", "", "configureSave", "getMaxRecordingLengthText", "Lorg/jetbrains/annotations/Nls;", "forEmulator", "Companion", "intellij.android.adb.ui"})
@SourceDebugExtension(value={"SMAP\nScreenRecorderOptionsDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScreenRecorderOptionsDialog.kt\ncom/android/tools/idea/ui/screenrecording/ScreenRecorderOptionsDialog\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,131:1\n30#2,2:132\n*S KotlinDebug\n*F\n+ 1 ScreenRecorderOptionsDialog.kt\ncom/android/tools/idea/ui/screenrecording/ScreenRecorderOptionsDialog\n*L\n49#1:132,2\n*E\n"})
public final class ScreenRecorderOptionsDialog
extends DialogWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private final boolean emulatorRecordingAvailable;
    private final int apiLevel;
    @NotNull
    private final DeviceScreenRecordingSettings settings;
    @NotNull
    private final SaveConfiguration saveConfig;
    private JEditorPane recordingLengthField;
    @NotNull
    private final SaveConfigurationResolver saveConfigResolver;
    private JEditorPane saveLocationText;
    @NotNull
    private String fileExtension;
    @NotNull
    private static final String SCREEN_RECORDER_DIMENSIONS_KEY = "ScreenRecorderOptionsDialog";

    public ScreenRecorderOptionsDialog(@NotNull Project project, boolean emulatorRecordingAvailable, int apiLevel) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.project = project;
        this.emulatorRecordingAvailable = emulatorRecordingAvailable;
        this.apiLevel = apiLevel;
        this.settings = DeviceScreenRecordingSettings.Companion.getInstance();
        this.saveConfig = this.settings.getSaveConfig();
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<SaveConfigurationResolver> serviceClass$iv = SaveConfigurationResolver.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.saveConfigResolver = (SaveConfigurationResolver)object;
        this.fileExtension = "mp4";
        this.setTitle(AndroidAdbUiBundle.message("screenrecord.options.title", new Object[0]));
        this.init();
    }

    private final String getSaveLocation() {
        return this.saveConfigResolver.expandSaveLocation(this.saveConfig.getSaveLocation());
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return (JComponent)BuilderKt.panel(arg_0 -> ScreenRecorderOptionsDialog.createCenterPanel$lambda$12(this, arg_0));
    }

    @NotNull
    protected String getDimensionServiceKey() {
        return SCREEN_RECORDER_DIMENSIONS_KEY;
    }

    @NotNull
    protected String getHelpId() {
        return "org.jetbrains.android.r/studio-ui/am-video.html";
    }

    protected void createDefaultActions() {
        super.createDefaultActions();
        this.getOKAction().putValue("Name", AndroidAdbUiBundle.message("screenrecord.options.ok.button.text", new Object[0]));
    }

    private final void configureSave() {
        ShowSettingsUtil.getInstance().showSettingsDialog(this.project, DeviceScreenRecordingSettingsPage.class, arg_0 -> ScreenRecorderOptionsDialog.configureSave$lambda$14(arg_0 -> ScreenRecorderOptionsDialog.configureSave$lambda$13(this, arg_0), arg_0));
        JEditorPane jEditorPane = this.saveLocationText;
        if (jEditorPane == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"saveLocationText");
            jEditorPane = null;
        }
        jEditorPane.setText(this.getSaveLocation());
        this.pack();
    }

    private final String getMaxRecordingLengthText(boolean forEmulator) {
        int maxLength = forEmulator || this.apiLevel >= 34 ? 30 : 3;
        Object[] objectArray = new Object[]{maxLength};
        return AndroidAdbUiBundle.message("screenrecord.options.info", objectArray);
    }

    private static final Unit createCenterPanel$lambda$12$lambda$1$lambda$0(ScreenRecorderOptionsDialog this$0, JEditorPane $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        this$0.recordingLengthField = $this$applyToComponent;
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$12$lambda$1(ScreenRecorderOptionsDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Row.text$default((Row)$this$row, (String)this$0.getMaxRecordingLengthText(this$0.emulatorRecordingAvailable && this$0.settings.getUseEmulatorRecordingWhenAvailable()), (int)0, null, (int)6, null).applyToComponent(arg_0 -> ScreenRecorderOptionsDialog.createCenterPanel$lambda$12$lambda$1$lambda$0(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$12$lambda$2(ScreenRecorderOptionsDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        TextFieldKt.bindIntText((Cell)Row.intTextField$default((Row)$this$row, (IntRange)new IntRange(1, 32), null, (int)2, null).widthGroup("text_boxes").align((Align)AlignX.LEFT.INSTANCE), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(this$0.settings){

            public Object get() {
                return ((DeviceScreenRecordingSettings)this.receiver).getBitRateMbps();
            }

            public void set(Object value2) {
                ((DeviceScreenRecordingSettings)this.receiver).setBitRateMbps(((Number)value2).intValue());
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Integer createCenterPanel$lambda$12$lambda$5$lambda$3(ScreenRecorderOptionsDialog this$0) {
        return MathKt.roundToInt((double)(this$0.settings.getScale() * (double)100));
    }

    private static final Unit createCenterPanel$lambda$12$lambda$5$lambda$4(ScreenRecorderOptionsDialog this$0, Integer it) {
        Integer n = it;
        this$0.settings.setScale((double)(n != null ? n : 100) / 100.0);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$12$lambda$5(ScreenRecorderOptionsDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Object[] objectArray = new Integer[]{100, 75, 50, 37, 25};
        ComboBoxKt.bindItem((Cell)Row.comboBox$default((Row)$this$row, (Collection)CollectionsKt.listOf((Object[])objectArray), null, (int)2, null).widthGroup("text_boxes").align((Align)AlignX.LEFT.INSTANCE), () -> ScreenRecorderOptionsDialog.createCenterPanel$lambda$12$lambda$5$lambda$3(this$0), arg_0 -> ScreenRecorderOptionsDialog.createCenterPanel$lambda$12$lambda$5$lambda$4(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$12$lambda$6(ScreenRecorderOptionsDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(AndroidAdbUiBundle.message("screenrecord.options.show.taps", new Object[0])), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(this$0.settings){

            public Object get() {
                return ((DeviceScreenRecordingSettings)this.receiver).getShowTaps();
            }

            public void set(Object value2) {
                ((DeviceScreenRecordingSettings)this.receiver).setShowTaps((Boolean)value2);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$12$lambda$8$lambda$7(ScreenRecorderOptionsDialog this$0, JBCheckBox it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.fileExtension = it.isSelected() ? "webm" : "mp4";
        JEditorPane jEditorPane = this$0.recordingLengthField;
        if (jEditorPane == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"recordingLengthField");
            jEditorPane = null;
        }
        jEditorPane.setText(this$0.getMaxRecordingLengthText(it.isSelected()));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$12$lambda$8(ScreenRecorderOptionsDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(AndroidAdbUiBundle.message("screenrecord.options.use.emulator.recording", new Object[0])), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(this$0.settings){

            public Object get() {
                return ((DeviceScreenRecordingSettings)this.receiver).getUseEmulatorRecordingWhenAvailable();
            }

            public void set(Object value2) {
                ((DeviceScreenRecordingSettings)this.receiver).setUseEmulatorRecordingWhenAvailable((Boolean)value2);
            }
        })).onChanged(arg_0 -> ScreenRecorderOptionsDialog.createCenterPanel$lambda$12$lambda$8$lambda$7(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$12$lambda$11$lambda$9(ScreenRecorderOptionsDialog this$0, JEditorPane $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        this$0.saveLocationText = $this$applyToComponent;
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$12$lambda$11$lambda$10(ScreenRecorderOptionsDialog this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.configureSave();
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$12$lambda$11(ScreenRecorderOptionsDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Row.text$default((Row)$this$row, (String)AndroidAdbUiBundle.message("screenrecord.options.save.directory", new Object[0]), (int)0, null, (int)6, null);
        Row.text$default((Row)$this$row, (String)this$0.getSaveLocation(), (int)0, null, (int)6, null).applyToComponent(arg_0 -> ScreenRecorderOptionsDialog.createCenterPanel$lambda$12$lambda$11$lambda$9(this$0, arg_0));
        $this$row.link(AndroidAdbUiBundle.message("configure.save.link.text", new Object[0]), arg_0 -> ScreenRecorderOptionsDialog.createCenterPanel$lambda$12$lambda$11$lambda$10(this$0, arg_0)).align((Align)AlignX.RIGHT.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$12(ScreenRecorderOptionsDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> ScreenRecorderOptionsDialog.createCenterPanel$lambda$12$lambda$1(this$0, arg_0), (int)1, null);
        $this$panel.row(AndroidAdbUiBundle.message("screenrecord.options.bit.rate", new Object[0]), arg_0 -> ScreenRecorderOptionsDialog.createCenterPanel$lambda$12$lambda$2(this$0, arg_0));
        $this$panel.row(AndroidAdbUiBundle.message("screenrecord.options.resolution", new Object[0]), arg_0 -> ScreenRecorderOptionsDialog.createCenterPanel$lambda$12$lambda$5(this$0, arg_0));
        Row.contextHelp$default((Row)Panel.row$default((Panel)$this$panel, null, arg_0 -> ScreenRecorderOptionsDialog.createCenterPanel$lambda$12$lambda$6(this$0, arg_0), (int)1, null), (String)AndroidAdbUiBundle.message("screenrecord.options.show.taps.tooltip", new Object[0]), null, (int)2, null);
        if (this$0.emulatorRecordingAvailable) {
            Row.contextHelp$default((Row)Panel.row$default((Panel)$this$panel, null, arg_0 -> ScreenRecorderOptionsDialog.createCenterPanel$lambda$12$lambda$8(this$0, arg_0), (int)1, null), (String)AndroidAdbUiBundle.message("screenrecord.options.use.emulator.recording.tooltip", new Object[0]), null, (int)2, null);
        }
        Panel.row$default((Panel)$this$panel, null, arg_0 -> ScreenRecorderOptionsDialog.createCenterPanel$lambda$12$lambda$11(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit configureSave$lambda$13(ScreenRecorderOptionsDialog this$0, DeviceScreenRecordingSettingsPage it) {
        it.setFileExtension(this$0.fileExtension);
        return Unit.INSTANCE;
    }

    private static final void configureSave$lambda$14(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/ui/screenrecording/ScreenRecorderOptionsDialog$Companion;", "", "<init>", "()V", "SCREEN_RECORDER_DIMENSIONS_KEY", "", "Lorg/jetbrains/annotations/NonNls;", "intellij.android.adb.ui"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

