/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.screenrecording;

import com.android.adblib.AdbDeviceServices;
import com.android.adblib.AdbDeviceServicesKt;
import com.android.adblib.AdbSession;
import com.android.adblib.DeviceSelector;
import com.android.adblib.ShellCommandOutput;
import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.adblib.AdbLibApplicationService;
import com.android.tools.idea.concurrency.CoroutineUtilsKt;
import com.android.tools.idea.ui.AndroidAdbUiBundle;
import com.android.tools.idea.ui.DisplayInfoKeys;
import com.android.tools.idea.ui.DisplayInfoProvider;
import com.android.tools.idea.ui.screenrecording.DeviceScreenRecordingSettings;
import com.android.tools.idea.ui.screenrecording.EmulatorConsoleRecordingProvider;
import com.android.tools.idea.ui.screenrecording.ScreenRecorder;
import com.android.tools.idea.ui.screenrecording.ScreenRecorderAction;
import com.android.tools.idea.ui.screenrecording.ScreenRecorderActionKt;
import com.android.tools.idea.ui.screenrecording.ScreenRecorderOptions;
import com.android.tools.idea.ui.screenrecording.ScreenRecorderOptionsDialog;
import com.android.tools.idea.ui.screenrecording.ScreenRecordingParameters;
import com.android.tools.idea.ui.screenrecording.ShellCommandRecordingProvider;
import com.intellij.ide.ActivityTracker;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import icons.StudioIcons;
import io.ktor.util.collections.ConcurrentSetKt;
import java.awt.Dimension;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Arrays;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroupCollection;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineExceptionHandler;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 02\u00020\u0001:\u00010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J<\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0003J(\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0082@\u00a2\u0006\u0002\u0010\"J&\u0010#\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\b2\u0006\u0010$\u001a\u00020\bH\u0082@\u00a2\u0006\u0002\u0010%J&\u0010&\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\b2\u0006\u0010'\u001a\u00020(H\u0082@\u00a2\u0006\u0002\u0010)J\u001e\u0010*\u001a\u00020(2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\bH\u0082@\u00a2\u0006\u0002\u0010+J\u0018\u0010,\u001a\u00020-2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020/H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/android/tools/idea/ui/screenrecording/ScreenRecorderAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "recordingInProgress", "", "", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "startRecordingAsync", "options", "Lcom/android/tools/idea/ui/screenrecording/DeviceScreenRecordingSettings;", "params", "Lcom/android/tools/idea/ui/screenrecording/ScreenRecordingParameters;", "displayId", "", "displayInfoProvider", "Lcom/android/tools/idea/ui/DisplayInfoProvider;", "avdFolder", "Ljava/nio/file/Path;", "project", "Lcom/intellij/openapi/project/Project;", "getDeviceScreenSize", "Ljava/awt/Dimension;", "adbSession", "Lcom/android/adblib/AdbSession;", "serialNumber", "(Lcom/android/adblib/AdbSession;Ljava/lang/String;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "execute", "command", "(Lcom/android/adblib/AdbSession;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setShowTouch", "isEnabled", "", "(Lcom/android/adblib/AdbSession;Ljava/lang/String;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isShowTouchEnabled", "(Lcom/android/adblib/AdbSession;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "coroutineExceptionHandler", "Lkotlinx/coroutines/CoroutineExceptionHandler;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "Companion", "intellij.android.adb.ui"})
@SourceDebugExtension(value={"SMAP\nScreenRecorderAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScreenRecorderAction.kt\ncom/android/tools/idea/ui/screenrecording/ScreenRecorderAction\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 CoroutineExceptionHandler.kt\nkotlinx/coroutines/CoroutineExceptionHandlerKt\n*L\n1#1,220:1\n24#2:221\n47#3,4:222\n*S KotlinDebug\n*F\n+ 1 ScreenRecorderAction.kt\ncom/android/tools/idea/ui/screenrecording/ScreenRecorderAction\n*L\n55#1:221\n184#1:222,4\n*E\n"})
public final class ScreenRecorderAction
extends DumbAwareAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @NotNull
    private final Set<String> recordingInProgress;
    public static final int MAX_RECORDING_DURATION_MINUTES = 30;
    public static final int MAX_RECORDING_DURATION_MINUTES_LEGACY = 3;
    @NotNull
    private static final String REMOTE_PATH = "/sdcard/screen-recording-%d.mp4";
    @NotNull
    private static final Regex WM_SIZE_OUTPUT_REGEX = new Regex("(?<width>\\d+)x(?<height>\\d+)");
    @NotNull
    private static final String EMU_TMP_FILENAME = "tmp.webm";
    private static final Duration COMMAND_TIMEOUT = Duration.ofSeconds(2L);

    public ScreenRecorderAction() {
        super(AndroidAdbUiBundle.message("screenrecord.action.title", new Object[0]), AndroidAdbUiBundle.message("screenrecord.action.description", new Object[0]), StudioIcons.Common.VIDEO_CAPTURE);
        ScreenRecorderAction $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(ScreenRecorderAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.recordingInProgress = ConcurrentSetKt.ConcurrentSet();
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ScreenRecordingParameters params2 = (ScreenRecordingParameters)event.getData(ScreenRecordingParameters.Companion.getDATA_KEY());
        Project project = event.getProject();
        event.getPresentation().setEnabled(params2 != null && project != null && ScreenRecorderActionKt.access$isRecordingSupported(params2, project) && !this.recordingInProgress.contains(params2.getSerialNumber()));
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ScreenRecordingParameters screenRecordingParameters = (ScreenRecordingParameters)event.getData(ScreenRecordingParameters.Companion.getDATA_KEY());
        if (screenRecordingParameters == null) {
            return;
        }
        ScreenRecordingParameters params2 = screenRecordingParameters;
        Integer n = (Integer)event.getData(DisplayInfoKeys.DISPLAY_ID_KEY);
        int displayId = n != null ? n : 0;
        DisplayInfoProvider displayInfoProvider2 = (DisplayInfoProvider)event.getData(DisplayInfoKeys.DISPLAY_INFO_PROVIDER_KEY);
        Project project = event.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        Path avdFolder = params2.getAvdFolder();
        ScreenRecorderOptionsDialog dialog2 = new ScreenRecorderOptionsDialog(project2, avdFolder != null, params2.getFeatureLevel());
        if (dialog2.showAndGet()) {
            DeviceScreenRecordingSettings settings = DeviceScreenRecordingSettings.Companion.getInstance();
            Path avdFolderForRecording = settings.getUseEmulatorRecordingWhenAvailable() ? avdFolder : null;
            this.startRecordingAsync(settings, params2, displayId, displayInfoProvider2, avdFolderForRecording, project2);
        }
    }

    @UiThread
    private final void startRecordingAsync(DeviceScreenRecordingSettings options, ScreenRecordingParameters params2, int displayId, DisplayInfoProvider displayInfoProvider2, Path avdFolder, Project project) {
        AdbSession adbSession = AdbLibApplicationService.Companion.getInstance().getSession();
        String serialNumber = params2.getSerialNumber();
        this.recordingInProgress.add(serialNumber);
        Disposable disposableParent = params2.getRecordingLifetimeDisposable();
        CoroutineScope coroutineScope = CoroutineUtilsKt.createCoroutineScope$default((Disposable)disposableParent, null, null, (int)3, null);
        CoroutineExceptionHandler exceptionHandler = this.coroutineExceptionHandler(project, coroutineScope);
        BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)((CoroutineContext)exceptionHandler), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, adbSession, serialNumber, displayInfoProvider2, displayId, avdFolder, params2, options, disposableParent, project, null){
            boolean Z$0;
            Object L$0;
            Object L$1;
            int I$0;
            int label;
            final /* synthetic */ ScreenRecorderAction this$0;
            final /* synthetic */ AdbSession $adbSession;
            final /* synthetic */ String $serialNumber;
            final /* synthetic */ DisplayInfoProvider $displayInfoProvider;
            final /* synthetic */ int $displayId;
            final /* synthetic */ Path $avdFolder;
            final /* synthetic */ ScreenRecordingParameters $params;
            final /* synthetic */ DeviceScreenRecordingSettings $options;
            final /* synthetic */ Disposable $disposableParent;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$adbSession = $adbSession;
                this.$serialNumber = $serialNumber;
                this.$displayInfoProvider = $displayInfoProvider;
                this.$displayId = $displayId;
                this.$avdFolder = $avdFolder;
                this.$params = $params;
                this.$options = $options;
                this.$disposableParent = $disposableParent;
                this.$project = $project;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var11_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = ScreenRecorderAction.access$isShowTouchEnabled(this.this$0, this.$adbSession, this.$serialNumber, (Continuation)this);
                        if (v0 == var11_2) {
                            return var11_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        showTouchEnabled = (Boolean)v0;
                        v1 = this.$displayInfoProvider;
                        if (v1 != null && (v1 = v1.getDisplaySize(this.$displayId)) != null) ** GOTO lbl27
                        this.Z$0 = showTouchEnabled;
                        this.label = 2;
                        v2 = ScreenRecorderAction.access$getDeviceScreenSize(this.this$0, this.$adbSession, this.$serialNumber, this.$displayId, (Continuation)this);
                        if (v2 == var11_2) {
                            return var11_2;
                        }
                        ** GOTO lbl26
                    }
                    case 2: {
                        showTouchEnabled = this.Z$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl26:
                        // 2 sources

                        v1 = (Dimension)v2;
lbl27:
                        // 2 sources

                        size = v1;
                        v3 = this.$avdFolder;
                        emulatorRecordingFile = v3 != null ? v3.resolve("tmp.webm") : null;
                        timeLimitSec = emulatorRecordingFile != null || this.$params.getFeatureLevel() >= 34 ? 1800 : 0;
                        recorderOptions = this.$options.toScreenRecorderOptions(this.$displayId, size, timeLimitSec);
                        if (recorderOptions.getShowTouches() != showTouchEnabled) {
                            this.L$0 = emulatorRecordingFile;
                            this.L$1 = recorderOptions;
                            this.Z$0 = showTouchEnabled;
                            this.I$0 = timeLimitSec;
                            this.label = 3;
                            v4 = ScreenRecorderAction.access$setShowTouch(this.this$0, this.$adbSession, this.$serialNumber, recorderOptions.getShowTouches(), (Continuation)this);
                            if (v4 == var11_2) {
                                return var11_2;
                            }
                        }
                        ** GOTO lbl50
                    }
                    case 3: {
                        timeLimitSec = this.I$0;
                        showTouchEnabled = this.Z$0;
                        recorderOptions = (ScreenRecorderOptions)this.L$1;
                        emulatorRecordingFile = (Path)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
lbl50:
                        // 3 sources

                        if (emulatorRecordingFile == null) {
                            var9_8 = "/sdcard/screen-recording-%d.mp4";
                            var10_9 = new Object[]{Boxing.boxLong((long)System.currentTimeMillis())};
                            v5 = String.format(var9_8, Arrays.copyOf(var10_9, var10_9.length));
                            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"format(...)");
                            v6 = new ShellCommandRecordingProvider(this.$disposableParent, this.$serialNumber, v5, recorderOptions, this.$adbSession);
                        } else {
                            v6 = new EmulatorConsoleRecordingProvider(this.$disposableParent, this.$serialNumber, emulatorRecordingFile, recorderOptions, this.$adbSession);
                        }
                        recodingProvider = v6;
                        timeLimit = timeLimitSec > 0 ? timeLimitSec : 180;
                        recorder = new ScreenRecorder(this.$project, recodingProvider, this.$params.getDeviceName());
                        this.L$0 = recorderOptions;
                        this.L$1 = null;
                        this.Z$0 = showTouchEnabled;
                        this.label = 4;
                        v7 = recorder.recordScreen(timeLimit, (Continuation<? super Unit>)((Continuation)this));
                        ** if (v7 != var11_2) goto lbl69
lbl68:
                        // 1 sources

                        return var11_2;
lbl69:
                        // 1 sources

                        ** GOTO lbl77
                    }
                    case 4: {
                        showTouchEnabled = this.Z$0;
                        recorderOptions = (ScreenRecorderOptions)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v7 = $result;
lbl77:
                        // 2 sources

                        ScreenRecorderAction.access$getRecordingInProgress$p(this.this$0).remove(this.$serialNumber);
                        ActivityTracker.getInstance().inc();
                        if (recorderOptions.getShowTouches() == showTouchEnabled) break;
                        this.L$0 = null;
                        this.label = 5;
                        v8 = ScreenRecorderAction.access$setShowTouch(this.this$0, this.$adbSession, this.$serialNumber, showTouchEnabled != false, (Continuation)this);
                        if (v8 == var11_2) {
                            return var11_2;
                        }
                        break;
                    }
                    case 5: {
                        ResultKt.throwOnFailure((Object)$result);
                        v8 = $result;
                        break;
                    }
                }
                catch (Throwable var7_11) {
                    ScreenRecorderAction.access$getRecordingInProgress$p(this.this$0).remove(this.$serialNumber);
                    ActivityTracker.getInstance().inc();
                    if (recorderOptions.getShowTouches() != showTouchEnabled) {
                        this.L$0 = var7_11;
                        this.L$1 = null;
                        this.label = 6;
                        v9 = ScreenRecorderAction.access$setShowTouch(this.this$0, this.$adbSession, this.$serialNumber, showTouchEnabled != false, (Continuation)this);
                        if (v9 == var11_2) {
                            return var11_2;
                        }
                    }
                    ** GOTO lbl107
                }
                {
                    case 6: {
                        var7_12 = (Throwable)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v9 = $result;
lbl107:
                        // 2 sources

                        throw var7_12;
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    /*
     * Unable to fully structure code
     */
    private final Object getDeviceScreenSize(AdbSession var1_1, String var2_2, int var3_3, Continuation<? super Dimension> $completion) {
        if (!($completion instanceof getDeviceScreenSize.1)) ** GOTO lbl-1000
        var11_5 = $completion;
        if ((var11_5.label & -2147483648) != 0) {
            var11_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ ScreenRecorderAction this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ScreenRecorderAction.access$getDeviceScreenSize(this.this$0, null, null, 0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var12_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                displaySelector = displayId == false ? "" : " -d " + (int)displayId;
                $continuation.label = 1;
                v0 = this.execute((AdbSession)adbSession, (String)serialNumber, "wm size" + (String)displaySelector, (Continuation<? super String>)$continuation);
                ** if (v0 != var12_7) goto lbl19
lbl18:
                // 1 sources

                return var12_7;
lbl19:
                // 1 sources

                ** GOTO lbl25
            }
            case 1: {
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl25:
                    // 2 sources

                    if ((matchResult = Regex.find$default((Regex)ScreenRecorderAction.WM_SIZE_OUTPUT_REGEX, (CharSequence)(out = (String)v0), (int)0, (int)2, null)) == null) {
                        this.logger.warn("Unexpected output from 'wm size': " + out);
                        return null;
                    }
                    width = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult.getGroups(), (String)"width");
                    height = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult.getGroups(), (String)"height");
                    if (width == null || height == null) {
                        this.logger.warn("Unexpected output from 'wm size': " + out);
                        return null;
                    }
                    return new Dimension(Integer.parseInt(width.getValue()), Integer.parseInt(height.getValue()));
                }
                catch (Exception e) {
                    this.logger.warn("Failed to get device screen size.", (Throwable)e);
                    return null;
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object execute(AdbSession var1_1, String var2_2, String var3_3, Continuation<? super String> $completion) {
        if (!($completion instanceof execute.1)) ** GOTO lbl-1000
        var7_5 = $completion;
        if ((var7_5.label & -2147483648) != 0) {
            var7_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ ScreenRecorderAction this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ScreenRecorderAction.access$execute(this.this$0, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var8_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = adbSession.getDeviceServices();
                v1 = DeviceSelector.Companion.fromSerialNumber((String)serialNumber);
                var5_8 = ScreenRecorderAction.COMMAND_TIMEOUT;
                Intrinsics.checkNotNullExpressionValue((Object)var5_8, (String)"COMMAND_TIMEOUT");
                $continuation.label = 1;
                v2 = AdbDeviceServicesKt.shellAsText$default((AdbDeviceServices)v0, (DeviceSelector)v1, (String)command, null, (Duration)var5_8, (int)0, (Continuation)$continuation, (int)20, null);
                if (v2 == var8_7) {
                    return var8_7;
                }
                ** GOTO lbl24
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl24:
                // 2 sources

                return ((ShellCommandOutput)v2).getStdout();
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object setShowTouch(AdbSession var1_1, String var2_2, boolean var3_3, Continuation<? super Unit> $completion) {
        if (!($completion instanceof setShowTouch.1)) ** GOTO lbl-1000
        var8_5 = $completion;
        if ((var8_5.label & -2147483648) != 0) {
            var8_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ ScreenRecorderAction this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ScreenRecorderAction.access$setShowTouch(this.this$0, null, null, false, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                value = isEnabled != false ? 1 : 0;
                $continuation.Z$0 = isEnabled;
                $continuation.label = 1;
                v0 = this.execute((AdbSession)adbSession, (String)serialNumber, "settings put system show_touches " + value, (Continuation<? super String>)$continuation);
                ** if (v0 != var9_7) goto lbl20
lbl19:
                // 1 sources

                return var9_7;
lbl20:
                // 1 sources

                ** GOTO lbl30
            }
            case 1: {
                isEnabled = $continuation.Z$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
                }
                catch (Exception e) {
                    this.logger.warn("Failed to set show taps to " + (isEnabled != false), (Throwable)e);
                }
lbl30:
                // 3 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object isShowTouchEnabled(AdbSession var1_1, String var2_2, Continuation<? super Boolean> $completion) {
        if (!($completion instanceof isShowTouchEnabled.1)) ** GOTO lbl-1000
        var6_4 = $completion;
        if ((var6_4.label & -2147483648) != 0) {
            var6_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ ScreenRecorderAction this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ScreenRecorderAction.access$isShowTouchEnabled(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var7_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.execute((AdbSession)adbSession, (String)serialNumber, "settings get system show_touches", (Continuation<? super String>)$continuation);
                if (v0 == var7_6) {
                    return var7_6;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                out = (String)v0;
                return Boxing.boxBoolean((boolean)Intrinsics.areEqual((Object)StringsKt.trim((CharSequence)out).toString(), (Object)"1"));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final CoroutineExceptionHandler coroutineExceptionHandler(Project project, CoroutineScope coroutineScope) {
        boolean $i$f$CoroutineExceptionHandler = false;
        CoroutineExceptionHandler.Key key = CoroutineExceptionHandler.Key;
        return new CoroutineExceptionHandler(key, this, coroutineScope, project){
            final /* synthetic */ ScreenRecorderAction this$0;
            final /* synthetic */ CoroutineScope $coroutineScope$inlined;
            final /* synthetic */ Project $project$inlined;
            {
                this.this$0 = screenRecorderAction;
                this.$coroutineScope$inlined = coroutineScope;
                this.$project$inlined = project;
                super((CoroutineContext.Key)$super_call_param$1);
            }

            public void handleException(CoroutineContext context, Throwable exception) {
                Throwable throwable = exception;
                boolean bl = false;
                ScreenRecorderAction.access$getLogger$p(this.this$0).warn("Failed to record screen", throwable);
                BuildersKt.launch$default((CoroutineScope)this.$coroutineScope$inlined, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$project$inlined, throwable, null){
                    int label;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ Throwable $throwable;
                    {
                        this.$project = $project;
                        this.$throwable = $throwable;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                Object[] objectArray = new Object[]{this.$throwable};
                                Messages.showErrorDialog((Project)this.$project, (String)AndroidAdbUiBundle.message("screenrecord.error.exception", objectArray), (String)AndroidAdbUiBundle.message("screenrecord.action.title", new Object[0]));
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
            }
        };
    }

    public static final /* synthetic */ Object access$isShowTouchEnabled(ScreenRecorderAction $this, AdbSession adbSession, String serialNumber, Continuation $completion) {
        return $this.isShowTouchEnabled(adbSession, serialNumber, (Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ Object access$getDeviceScreenSize(ScreenRecorderAction $this, AdbSession adbSession, String serialNumber, int displayId, Continuation $completion) {
        return $this.getDeviceScreenSize(adbSession, serialNumber, displayId, (Continuation<? super Dimension>)$completion);
    }

    public static final /* synthetic */ Object access$setShowTouch(ScreenRecorderAction $this, AdbSession adbSession, String serialNumber, boolean isEnabled, Continuation $completion) {
        return $this.setShowTouch(adbSession, serialNumber, isEnabled, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Set access$getRecordingInProgress$p(ScreenRecorderAction $this) {
        return $this.recordingInProgress;
    }

    public static final /* synthetic */ Object access$execute(ScreenRecorderAction $this, AdbSession adbSession, String serialNumber, String command, Continuation $completion) {
        return $this.execute(adbSession, serialNumber, command, (Continuation<? super String>)$completion);
    }

    public static final /* synthetic */ Logger access$getLogger$p(ScreenRecorderAction $this) {
        return $this.logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/ui/screenrecording/ScreenRecorderAction$Companion;", "", "<init>", "()V", "MAX_RECORDING_DURATION_MINUTES", "", "MAX_RECORDING_DURATION_MINUTES_LEGACY", "REMOTE_PATH", "", "WM_SIZE_OUTPUT_REGEX", "Lkotlin/text/Regex;", "EMU_TMP_FILENAME", "COMMAND_TIMEOUT", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "intellij.android.adb.ui"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

