/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.explorer;

import com.android.tools.idea.ui.resourcemanager.explorer.ImportResourceDelegate;
import com.android.tools.idea.ui.resourcemanager.explorer.ResourceDragHandlerKt;
import com.android.tools.idea.ui.resourcemanager.model.ResourceAssetSet;
import com.android.tools.idea.ui.resourcemanager.model.ResourceDataManagerKt;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import java.awt.Cursor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.TransferHandler;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0012\u0010\f\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u001c\u0010\u000f\u001a\u00020\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0012\u0010\u0019\u001a\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u0011H\u0014J$\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00112\b\u0010\u001d\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001e\u001a\u00020\u0015H\u0014R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/explorer/ResourceFilesTransferHandler;", "Ljavax/swing/TransferHandler;", "assetList", "Ljavax/swing/JList;", "Lcom/android/tools/idea/ui/resourcemanager/model/ResourceAssetSet;", "importDelegate", "Lcom/android/tools/idea/ui/resourcemanager/explorer/ImportResourceDelegate;", "isValidTransferTarget", "Lkotlin/Function0;", "", "<init>", "(Ljavax/swing/JList;Lcom/android/tools/idea/ui/resourcemanager/explorer/ImportResourceDelegate;Lkotlin/jvm/functions/Function0;)V", "canImport", "support", "Ljavax/swing/TransferHandler$TransferSupport;", "importData", "comp", "Ljavax/swing/JComponent;", "t", "Ljava/awt/datatransfer/Transferable;", "getSourceActions", "", "c", "getDragImage", "Ljava/awt/image/BufferedImage;", "createTransferable", "exportDone", "", "source", "data", "action", "intellij.android.core"})
final class ResourceFilesTransferHandler
extends TransferHandler {
    @NotNull
    private final JList<ResourceAssetSet> assetList;
    @NotNull
    private final ImportResourceDelegate importDelegate;
    @NotNull
    private final Function0<Boolean> isValidTransferTarget;

    public ResourceFilesTransferHandler(@NotNull JList<ResourceAssetSet> assetList, @NotNull ImportResourceDelegate importDelegate, @NotNull Function0<Boolean> isValidTransferTarget) {
        Intrinsics.checkNotNullParameter(assetList, (String)"assetList");
        Intrinsics.checkNotNullParameter((Object)importDelegate, (String)"importDelegate");
        Intrinsics.checkNotNullParameter(isValidTransferTarget, (String)"isValidTransferTarget");
        this.assetList = assetList;
        this.importDelegate = importDelegate;
        this.isValidTransferTarget = isValidTransferTarget;
    }

    @Override
    public boolean canImport(@Nullable TransferHandler.TransferSupport support) {
        if (support == null) {
            return false;
        }
        if ((support.getSourceDropActions() & 1) != 1) {
            return false;
        }
        return FileCopyPasteUtil.isFileListFlavorAvailable((DataFlavor[])support.getDataFlavors());
    }

    @Override
    public boolean importData(@Nullable JComponent comp, @Nullable Transferable t) {
        if (t == null || !((Boolean)this.isValidTransferTarget.invoke()).booleanValue()) {
            return false;
        }
        return this.importDelegate.doImport(t);
    }

    @Override
    public int getSourceActions(@Nullable JComponent c) {
        return 3;
    }

    @Override
    @NotNull
    public BufferedImage getDragImage() {
        return ResourceDragHandlerKt.access$createDragPreview(this.assetList);
    }

    @Override
    @NotNull
    protected Transferable createTransferable(@Nullable JComponent c) {
        block0: {
            JComponent jComponent = c;
            if (jComponent == null) break block0;
            jComponent.setCursor(Cursor.getPredefinedCursor(12));
        }
        return ResourceDataManagerKt.createTransferable(this.assetList.getSelectedValue().getHighestDensityAsset());
    }

    @Override
    protected void exportDone(@Nullable JComponent source2, @Nullable Transferable data2, int action2) {
        block0: {
            JComponent jComponent = source2;
            if (jComponent == null) break block0;
            jComponent.setCursor(Cursor.getDefaultCursor());
        }
    }
}

