/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.explorer;

import com.android.tools.idea.ui.resourcemanager.explorer.HeadlessDragHandler;
import com.android.tools.idea.ui.resourcemanager.explorer.ImportResourceDelegate;
import com.android.tools.idea.ui.resourcemanager.explorer.ResourceDragHandler;
import com.android.tools.idea.ui.resourcemanager.explorer.ResourceDragHandlerImpl;
import com.android.tools.idea.ui.resourcemanager.model.ResourceAssetSet;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import javax.swing.JList;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u001a\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u00a8\u0006\f"}, d2={"resourceDragHandler", "Lcom/android/tools/idea/ui/resourcemanager/explorer/ResourceDragHandler;", "importResourceDelegate", "Lcom/android/tools/idea/ui/resourcemanager/explorer/ImportResourceDelegate;", "isValidTransferTarget", "Lkotlin/Function0;", "", "createDragPreview", "Ljava/awt/image/BufferedImage;", "draggedAssets", "Ljavax/swing/JList;", "Lcom/android/tools/idea/ui/resourcemanager/model/ResourceAssetSet;", "intellij.android.core"})
public final class ResourceDragHandlerKt {
    @NotNull
    public static final ResourceDragHandler resourceDragHandler(@NotNull ImportResourceDelegate importResourceDelegate, @NotNull Function0<Boolean> isValidTransferTarget) {
        Intrinsics.checkNotNullParameter((Object)importResourceDelegate, (String)"importResourceDelegate");
        Intrinsics.checkNotNullParameter(isValidTransferTarget, (String)"isValidTransferTarget");
        return GraphicsEnvironment.isHeadless() ? (ResourceDragHandler)new HeadlessDragHandler() : (ResourceDragHandler)new ResourceDragHandlerImpl(importResourceDelegate, isValidTransferTarget);
    }

    private static final BufferedImage createDragPreview(JList<ResourceAssetSet> draggedAssets) {
        Component component = draggedAssets.getCellRenderer().getListCellRendererComponent(draggedAssets, draggedAssets.getSelectedValue(), draggedAssets.getSelectedIndex(), false, false);
        component.setSize(component.getPreferredSize().width, component.getPreferredSize().height);
        component.validate();
        BufferedImage image = new BufferedImage(component.getWidth(), component.getHeight(), 2);
        Graphics2D $this$createDragPreview_u24lambda_u240 = image.createGraphics();
        boolean bl = false;
        $this$createDragPreview_u24lambda_u240.setColor(draggedAssets.getBackground());
        $this$createDragPreview_u24lambda_u240.fillRect(0, 0, component.getWidth(), component.getHeight());
        component.paint($this$createDragPreview_u24lambda_u240);
        $this$createDragPreview_u24lambda_u240.dispose();
        return image;
    }

    public static final /* synthetic */ BufferedImage access$createDragPreview(JList draggedAssets) {
        return ResourceDragHandlerKt.createDragPreview(draggedAssets);
    }
}

