/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.instrumented.testsuite.view;

import com.android.tools.idea.testartifacts.instrumented.testsuite.api.AndroidTestResultStats;
import com.android.tools.idea.testartifacts.instrumented.testsuite.api.AndroidTestResults;
import com.android.tools.idea.testartifacts.instrumented.testsuite.api.AndroidTestResultsKt;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidDevice;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidTestCase;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidTestCaseResult;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.benchmark.BenchmarkOutput;
import com.android.tools.idea.testartifacts.instrumented.testsuite.view.FilterableTreeNode;
import com.android.tools.idea.testartifacts.instrumented.testsuite.view.TestStepRow;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fJ\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0017\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u001d\u001a\u00020\u001cH\u0016J\u0010\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010#\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001c\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040%2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010&\u001a\u00020\u0016H\u0016J\u0016\u0010&\u001a\u00020\u00162\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(H\u0016J\u0016\u0010)\u001a\u00020\u00042\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(H\u0016J\b\u0010*\u001a\u00020+H\u0016J\u0010\u0010*\u001a\u00020+2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010*\u001a\u00020+2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130(H\u0016J\u0006\u0010,\u001a\u00020\u0011R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0014\u0010\u0006\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/android/tools/idea/testartifacts/instrumented/testsuite/view/AndroidTestResultsRow;", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/api/AndroidTestResults;", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/view/FilterableTreeNode;", "methodName", "", "className", "packageName", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getMethodName", "()Ljava/lang/String;", "getClassName", "getPackageName", "myTestCases", "", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidTestCase;", "addTestCase", "", "device", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidDevice;", "testCase", "getTestCaseResult", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidTestCaseResult;", "getLogcat", "getStartTime", "", "(Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidDevice;)Ljava/lang/Long;", "getDuration", "Ljava/time/Duration;", "getTotalDuration", "getErrorStackTrace", "getBenchmark", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/benchmark/BenchmarkOutput;", "getRetentionInfo", "Ljava/io/File;", "getRetentionSnapshot", "getAdditionalTestArtifacts", "", "getTestResultSummary", "devices", "", "getTestResultSummaryText", "getResultStats", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/api/AndroidTestResultStats;", "sort", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nAndroidTestResultsTableView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidTestResultsTableView.kt\ncom/android/tools/idea/testartifacts/instrumented/testsuite/view/AndroidTestResultsRow\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,1486:1\n1803#2,3:1487\n1803#2,3:1490\n808#2,11:1493\n1011#2,2:1505\n24#3:1504\n*S KotlinDebug\n*F\n+ 1 AndroidTestResultsTableView.kt\ncom/android/tools/idea/testartifacts/instrumented/testsuite/view/AndroidTestResultsRow\n*L\n1265#1:1487,3\n1276#1:1490,3\n1288#1:1493,11\n1294#1:1505,2\n1289#1:1504\n*E\n"})
final class AndroidTestResultsRow
extends FilterableTreeNode
implements AndroidTestResults {
    @NotNull
    private final String methodName;
    @NotNull
    private final String className;
    @NotNull
    private final String packageName;
    @NotNull
    private final Map<String, AndroidTestCase> myTestCases;

    public AndroidTestResultsRow(@NotNull String methodName, @NotNull String className, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        this.methodName = methodName;
        this.className = className;
        this.packageName = packageName;
        this.myTestCases = new LinkedHashMap();
    }

    @Override
    @NotNull
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    @NotNull
    public String getClassName() {
        return this.className;
    }

    @Override
    @NotNull
    public String getPackageName() {
        return this.packageName;
    }

    public final void addTestCase(@NotNull AndroidDevice device2, @NotNull AndroidTestCase testCase) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Intrinsics.checkNotNullParameter((Object)testCase, (String)"testCase");
        this.myTestCases.put(device2.getId(), testCase);
    }

    @Override
    @Nullable
    public AndroidTestCaseResult getTestCaseResult(@NotNull AndroidDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        AndroidTestCase androidTestCase = this.myTestCases.get(device2.getId());
        return androidTestCase != null ? androidTestCase.getResult() : null;
    }

    @Override
    @NotNull
    public String getLogcat(@NotNull AndroidDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Object object = this.myTestCases.get(device2.getId());
        if (object == null || (object = ((AndroidTestCase)object).getLogcat()) == null) {
            object = "";
        }
        return object;
    }

    @Override
    @Nullable
    public Long getStartTime(@NotNull AndroidDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        AndroidTestCase androidTestCase = this.myTestCases.get(device2.getId());
        return androidTestCase != null ? androidTestCase.getStartTimestampMillis() : null;
    }

    @Override
    @Nullable
    public Duration getDuration(@NotNull AndroidDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Object object = this.myTestCases.get(device2.getId());
        if (object == null || (object = ((AndroidTestCase)object).getStartTimestampMillis()) == null) {
            return null;
        }
        long start2 = (Long)object;
        Object object2 = this.myTestCases.get(device2.getId());
        long end = object2 != null && (object2 = ((AndroidTestCase)object2).getEndTimestampMillis()) != null ? (Long)object2 : System.currentTimeMillis();
        return Duration.ofMillis(Math.max(end - start2, 0L));
    }

    @Override
    @NotNull
    public Duration getTotalDuration() {
        Duration duration = Duration.ofMillis(SequencesKt.sumOfLong((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.myTestCases.values()), AndroidTestResultsRow::getTotalDuration$lambda$0)));
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
        return duration;
    }

    @Override
    @NotNull
    public String getErrorStackTrace(@NotNull AndroidDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Object object = this.myTestCases.get(device2.getId());
        if (object == null || (object = ((AndroidTestCase)object).getErrorStackTrace()) == null) {
            object = "";
        }
        return object;
    }

    @Override
    @NotNull
    public BenchmarkOutput getBenchmark(@NotNull AndroidDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Object object = this.myTestCases.get(device2.getId());
        if (object == null || (object = ((AndroidTestCase)object).getBenchmark()) == null) {
            object = "";
        }
        return new BenchmarkOutput((String)object);
    }

    @Override
    @Nullable
    public File getRetentionInfo(@NotNull AndroidDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        AndroidTestCase androidTestCase = this.myTestCases.get(device2.getId());
        return androidTestCase != null ? androidTestCase.getRetentionInfo() : null;
    }

    @Override
    @Nullable
    public File getRetentionSnapshot(@NotNull AndroidDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        AndroidTestCase androidTestCase = this.myTestCases.get(device2.getId());
        return androidTestCase != null ? androidTestCase.getRetentionSnapshot() : null;
    }

    @Override
    @NotNull
    public Map<String, String> getAdditionalTestArtifacts(@NotNull AndroidDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Object object = this.myTestCases.get(device2.getId());
        if (object == null || (object = ((AndroidTestCase)object).getAdditionalTestArtifacts()) == null) {
            object = MapsKt.emptyMap();
        }
        return object;
    }

    @Override
    @NotNull
    public AndroidTestCaseResult getTestResultSummary() {
        return AndroidTestResultsKt.getSummaryResult(this.getResultStats());
    }

    @Override
    @NotNull
    public AndroidTestCaseResult getTestResultSummary(@NotNull List<AndroidDevice> devices2) {
        Intrinsics.checkNotNullParameter(devices2, (String)"devices");
        return AndroidTestResultsKt.getSummaryResult(this.getResultStats(devices2));
    }

    @Override
    @NotNull
    public String getTestResultSummaryText(@NotNull List<AndroidDevice> devices2) {
        Intrinsics.checkNotNullParameter(devices2, (String)"devices");
        AndroidTestResultStats stats = this.getResultStats(devices2);
        return stats.getFailed() == 1 ? "Fail" : (stats.getFailed() > 0 ? "Fail (" + stats.getFailed() + ")" : (stats.getCancelled() > 0 ? "Cancelled" : (stats.getRunning() > 0 ? "Running" : (stats.getPassed() > 0 ? "Pass" : (stats.getSkipped() > 0 ? "Skip" : "")))));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public AndroidTestResultStats getResultStats() {
        void $this$fold$iv;
        Iterable iterable = this.myTestCases.values();
        AndroidTestResultStats initial$iv = new AndroidTestResultStats(0, 0, 0, 0, 0, 31, null);
        boolean $i$f$fold = false;
        AndroidTestResultStats accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void androidTestCase;
            AndroidTestCase androidTestCase2 = (AndroidTestCase)element$iv;
            AndroidTestResultStats acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = acc.addTestCaseResult(androidTestCase.getResult());
        }
        return accumulator$iv;
    }

    @Override
    @NotNull
    public AndroidTestResultStats getResultStats(@NotNull AndroidDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        AndroidTestResultStats stats = new AndroidTestResultStats(0, 0, 0, 0, 0, 31, null);
        return stats.addTestCaseResult(this.getTestCaseResult(device2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public AndroidTestResultStats getResultStats(@NotNull List<AndroidDevice> devices2) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter(devices2, (String)"devices");
        Iterable iterable = devices2;
        AndroidTestResultStats initial$iv = new AndroidTestResultStats(0, 0, 0, 0, 0, 31, null);
        boolean $i$f$fold = false;
        AndroidTestResultStats accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void device2;
            AndroidDevice androidDevice = (AndroidDevice)element$iv;
            AndroidTestResultStats acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = acc.addTestCaseResult(this.getTestCaseResult((AndroidDevice)device2));
        }
        return accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    public final void sort() {
        void $this$filterIsInstanceTo$iv$iv;
        if (this.children == null) {
            return;
        }
        Vector vector = this.children;
        Intrinsics.checkNotNullExpressionValue((Object)vector, (String)"children");
        Iterable $this$filterIsInstance$iv = vector;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof TestStepRow)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        if (((List)destination$iv$iv).size() != this.children.size()) {
            AndroidTestResultsRow $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(AndroidTestResultsRow.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("AndroidTestResultsRow should not have children other than TestStepRow");
            return;
        }
        Vector vector2 = this.children;
        Intrinsics.checkNotNull((Object)vector2, (String)"null cannot be cast to non-null type java.util.Vector<com.android.tools.idea.testartifacts.instrumented.testsuite.view.TestStepRow>");
        List $this$sortBy$iv = vector2;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    TestStepRow it = (TestStepRow)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getTestStep().getIndex());
                    it = (TestStepRow)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getTestStep().getIndex()));
                }
            });
        }
    }

    private static final long getTotalDuration$lambda$0(AndroidTestCase it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Long l = it.getStartTimestampMillis();
        if (l == null) {
            return 0L;
        }
        long start2 = l;
        Long l2 = it.getEndTimestampMillis();
        long end = l2 != null ? l2 : System.currentTimeMillis();
        return Math.max(end - start2, 0L);
    }
}

