/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.instrumented.testsuite.adapter;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.annotations.concurrency.WorkerThread;
import com.android.tools.idea.protobuf.Message;
import com.android.tools.idea.protobuf.TextFormat;
import com.android.tools.idea.protobuf.Timestamp;
import com.android.tools.idea.testartifacts.instrumented.testsuite.adapter.AndroidDeviceResolver;
import com.android.tools.idea.testartifacts.instrumented.testsuite.adapter.ArtifactFileResolver;
import com.android.tools.idea.testartifacts.instrumented.testsuite.adapter.BenchmarkUtilsKt;
import com.android.tools.idea.testartifacts.instrumented.testsuite.api.AndroidTestResultListener;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidDevice;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidTestCase;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidTestCaseResult;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidTestSuite;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidTestSuiteResult;
import com.google.testing.platform.proto.api.core.TestArtifactProto;
import com.google.testing.platform.proto.api.core.TestCaseProto;
import com.google.testing.platform.proto.api.core.TestResultProto;
import com.google.testing.platform.proto.api.core.TestStatusProto;
import com.google.testing.platform.proto.api.core.TestSuiteResultProto;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\f\u0010\u001c\u001a\u00020\u001d*\u00020\u001eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u001d\u0010\f\u001a\u0004\u0018\u00010\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u000b\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/idea/testartifacts/instrumented/testsuite/adapter/UtpTestResultAdapter;", "", "protoFile", "Ljava/io/File;", "<init>", "(Ljava/io/File;)V", "resultProto", "Lcom/google/testing/platform/proto/api/core/TestSuiteResultProto$TestSuiteResult;", "getResultProto", "()Lcom/google/testing/platform/proto/api/core/TestSuiteResultProto$TestSuiteResult;", "resultProto$delegate", "Lkotlin/Lazy;", "packageName", "", "getPackageName", "()Ljava/lang/String;", "packageName$delegate", "forwardResults", "", "listener", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/api/AndroidTestResultListener;", "createTestCase", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidTestCase;", "testResult", "Lcom/google/testing/platform/proto/api/core/TestResultProto$TestResult;", "artifactFileResolver", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/adapter/ArtifactFileResolver;", "getIceboxArtifact", "millis", "", "Lcom/android/tools/idea/protobuf/Timestamp;", "intellij.android.testartifacts"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nUtpTestResultAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UtpTestResultAdapter.kt\ncom/android/tools/idea/testartifacts/instrumented/testsuite/adapter/UtpTestResultAdapter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,272:1\n1869#2,2:273\n1869#2,2:275\n1617#2,9:277\n1869#2:286\n1870#2:288\n1626#2:289\n1#3:287\n*S KotlinDebug\n*F\n+ 1 UtpTestResultAdapter.kt\ncom/android/tools/idea/testartifacts/instrumented/testsuite/adapter/UtpTestResultAdapter\n*L\n82#1:273,2\n89#1:275,2\n65#1:277,9\n65#1:286\n65#1:288\n65#1:289\n65#1:287\n*E\n"})
public final class UtpTestResultAdapter {
    @NotNull
    private final File protoFile;
    @NotNull
    private final Lazy resultProto$delegate;
    @NotNull
    private final Lazy packageName$delegate;
    public static final int $stable = 8;

    public UtpTestResultAdapter(@NotNull File protoFile) {
        Intrinsics.checkNotNullParameter((Object)protoFile, (String)"protoFile");
        this.protoFile = protoFile;
        this.resultProto$delegate = LazyKt.lazy(() -> UtpTestResultAdapter.resultProto_delegate$lambda$1(this));
        this.packageName$delegate = LazyKt.lazy(() -> UtpTestResultAdapter.packageName_delegate$lambda$3(this));
    }

    private final TestSuiteResultProto.TestSuiteResult getResultProto() {
        Lazy lazy = this.resultProto$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (TestSuiteResultProto.TestSuiteResult)object;
    }

    @Nullable
    public final String getPackageName() {
        Lazy lazy = this.packageName$delegate;
        return (String)lazy.getValue();
    }

    @WorkerThread
    public final void forwardResults(@NotNull AndroidTestResultListener listener2) {
        AndroidDevice device2;
        TestResultProto.TestResult testResult;
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        File file = this.protoFile.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getParentFile(...)");
        ArtifactFileResolver artifactFileResolver = new ArtifactFileResolver(file);
        AndroidDeviceResolver androidDeviceResolver = new AndroidDeviceResolver(artifactFileResolver);
        Map deviceToTestCountMap = MapsKt.sortedMapOf((Comparator)new Comparator(){

            public final int compare(T a, T b) {
                AndroidDevice it = (AndroidDevice)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getId());
                it = (AndroidDevice)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getId())));
            }
        }, (Pair[])new Pair[0]);
        Map deviceToTestSuiteMap = MapsKt.sortedMapOf((Comparator)new Comparator(){

            public final int compare(T a, T b) {
                AndroidDevice it = (AndroidDevice)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getId());
                it = (AndroidDevice)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getId())));
            }
        }, (Pair[])new Pair[0]);
        List list = this.getResultProto().getTestResultList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTestResultList(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            testResult = (TestResultProto.TestResult)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)testResult);
            device2 = androidDeviceResolver.getAndroidDevice(testResult);
            deviceToTestCountMap.compute(device2, (arg_0, arg_1) -> UtpTestResultAdapter.forwardResults$lambda$8$lambda$7(UtpTestResultAdapter::forwardResults$lambda$8$lambda$6, arg_0, arg_1));
        }
        List list2 = this.getResultProto().getTestResultList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getTestResultList(...)");
        $this$forEach$iv = list2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AndroidTestSuite testSuite;
            testResult = (TestResultProto.TestResult)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)testResult);
            device2 = androidDeviceResolver.getAndroidDevice(testResult);
            Intrinsics.checkNotNullExpressionValue((Object)deviceToTestSuiteMap.computeIfAbsent(device2, arg_0 -> UtpTestResultAdapter.forwardResults$lambda$12$lambda$11(arg_0 -> UtpTestResultAdapter.forwardResults$lambda$12$lambda$10(this, deviceToTestCountMap, device2, listener2, arg_0), arg_0)), (String)"computeIfAbsent(...)");
            AndroidTestCase testCase = this.createTestCase(testResult, artifactFileResolver);
            if (testResult.getTestStatus() == TestStatusProto.TestStatus.FAILED) {
                testSuite.setResult(AndroidTestSuiteResult.FAILED);
            }
            listener2.onTestCaseStarted(device2, testSuite, testCase);
            listener2.onTestCaseFinished(device2, testSuite, testCase);
        }
        deviceToTestSuiteMap.forEach((arg_0, arg_1) -> UtpTestResultAdapter.forwardResults$lambda$13((Function2)new Function2<AndroidDevice, AndroidTestSuite, Unit>((Object)listener2){

            public final void invoke(AndroidDevice p0, AndroidTestSuite p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                ((AndroidTestResultListener)this.receiver).onTestSuiteFinished(p0, p1);
            }
        }, arg_0, arg_1));
    }

    private final AndroidTestCase createTestCase(TestResultProto.TestResult testResult, ArtifactFileResolver artifactFileResolver) {
        Object object;
        AndroidTestCaseResult androidTestCaseResult;
        TestCaseProto.TestCase testCase = testResult.getTestCase();
        Object object2 = testCase.getTestPackage() + "." + testCase.getTestClass() + "#" + testCase.getTestMethod();
        String string = testCase.getTestMethod();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTestMethod(...)");
        String string2 = string;
        String string3 = testCase.getTestClass();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getTestClass(...)");
        String string4 = string3;
        String string5 = testCase.getTestPackage();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getTestPackage(...)");
        String string6 = string5;
        File file = ArtifactFileResolver.getArtifactFile$default(artifactFileResolver, testResult, "icebox.info", null, 4, null);
        File file2 = this.getIceboxArtifact(testResult, artifactFileResolver);
        TestStatusProto.TestStatus testStatus = testResult.getTestStatus();
        switch (testStatus == null ? -1 : WhenMappings.$EnumSwitchMapping$0[testStatus.ordinal()]) {
            case 1: {
                AndroidTestCaseResult androidTestCaseResult2 = AndroidTestCaseResult.PASSED;
                break;
            }
            case 2: {
                AndroidTestCaseResult androidTestCaseResult2 = AndroidTestCaseResult.FAILED;
                break;
            }
            default: {
                AndroidTestCaseResult androidTestCaseResult2 = androidTestCaseResult = AndroidTestCaseResult.SKIPPED;
            }
        }
        if ((object = ArtifactFileResolver.getArtifactFile$default(artifactFileResolver, testResult, "logcat", null, 4, null)) == null || (object = FilesKt.readText$default((File)object, null, (int)1, null)) == null) {
            object = "";
        }
        Object object3 = object;
        Timestamp timestamp = testCase.getStartTime();
        Intrinsics.checkNotNullExpressionValue((Object)timestamp, (String)"getStartTime(...)");
        long l = this.millis(timestamp);
        Timestamp timestamp2 = testCase.getEndTime();
        Intrinsics.checkNotNullExpressionValue((Object)timestamp2, (String)"getEndTime(...)");
        long l2 = this.millis(timestamp2);
        Object $this$createTestCase_u24lambda_u2415 = object2 = new AndroidTestCase((String)object2, string2, string4, string6, androidTestCaseResult, (String)object3, null, l, l2, null, file, file2, null, 4672, null);
        boolean bl = false;
        BenchmarkUtilsKt.setBenchmarkContextAndPrepareFiles(testResult, (AndroidTestCase)$this$createTestCase_u24lambda_u2415, (Function1<? super String, ? extends File>)((Function1)arg_0 -> UtpTestResultAdapter.createTestCase$lambda$15$lambda$14(artifactFileResolver, arg_0)));
        return object2;
    }

    private final File getIceboxArtifact(TestResultProto.TestResult testResult, ArtifactFileResolver artifactFileResolver) {
        Regex iceboxArtifactRegrex = new Regex("snapshot-" + testResult.getTestCase().getTestClass() + "-" + testResult.getTestCase().getTestMethod() + "-failure[0-9]+(\\.tar(\\.gz)?)?");
        return artifactFileResolver.getArtifactFile(testResult, (Function1<? super TestArtifactProto.Artifact, Boolean>)((Function1)arg_0 -> UtpTestResultAdapter.getIceboxArtifact$lambda$16(iceboxArtifactRegrex, arg_0)));
    }

    private final long millis(Timestamp $this$millis) {
        return $this$millis.getSeconds() * 1000L + (long)$this$millis.getNanos() / 1000000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final TestSuiteResultProto.TestSuiteResult resultProto_delegate$lambda$1(UtpTestResultAdapter this$0) {
        TestSuiteResultProto.TestSuiteResult testSuiteResult;
        if (Intrinsics.areEqual((Object)FilesKt.getExtension((File)this$0.protoFile), (Object)"textproto")) {
            TestSuiteResultProto.TestSuiteResult.Builder builder = TestSuiteResultProto.TestSuiteResult.newBuilder();
            File file = this$0.protoFile;
            Charset charset = Charset.defaultCharset();
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"defaultCharset(...)");
            TextFormat.merge((CharSequence)FilesKt.readText((File)file, (Charset)charset), (Message.Builder)((Message.Builder)builder));
            testSuiteResult = builder.build();
        } else {
            Closeable closeable = new FileInputStream(this$0.protoFile);
            Throwable throwable = null;
            try {
                FileInputStream it = (FileInputStream)closeable;
                boolean bl = false;
                TestSuiteResultProto.TestSuiteResult testSuiteResult2 = TestSuiteResultProto.TestSuiteResult.parseFrom((InputStream)it);
                testSuiteResult = testSuiteResult2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        return testSuiteResult;
    }

    /*
     * WARNING - void declaration
     */
    private static final String packageName_delegate$lambda$3(UtpTestResultAdapter this$0) {
        void $this$mapNotNullTo$iv$iv;
        List list = this$0.getResultProto().getTestResultList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTestResultList(...)");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            TestResultProto.TestResult it = (TestResultProto.TestResult)element$iv$iv;
            boolean bl2 = false;
            TestResultProto.TestResult testResult = it;
            if ((testResult != null && (testResult = testResult.getTestCase()) != null ? testResult.getTestPackage() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (String)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
    }

    private static final Integer forwardResults$lambda$8$lambda$6(AndroidDevice androidDevice, Integer currentValue) {
        Intrinsics.checkNotNullParameter((Object)androidDevice, (String)"<unused var>");
        Integer n = currentValue;
        return n != null ? n + 1 : 1;
    }

    private static final Integer forwardResults$lambda$8$lambda$7(Function2 $tmp0, Object p0, Object p1) {
        return (Integer)$tmp0.invoke(p0, p1);
    }

    private static final AndroidTestSuite forwardResults$lambda$12$lambda$10(UtpTestResultAdapter this$0, Map $deviceToTestCountMap, AndroidDevice $device, AndroidTestResultListener $listener, AndroidDevice newDevice) {
        AndroidTestSuite androidTestSuite;
        Intrinsics.checkNotNullParameter((Object)newDevice, (String)"newDevice");
        String string = this$0.getResultProto().getTestSuiteMetaData().getTestSuiteName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTestSuiteName(...)");
        String string2 = this$0.getResultProto().getTestSuiteMetaData().getTestSuiteName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getTestSuiteName(...)");
        AndroidTestSuite it = androidTestSuite = new AndroidTestSuite(string, string2, ((Number)$deviceToTestCountMap.getOrDefault($device, 0)).intValue(), AndroidTestSuiteResult.PASSED, null, 16, null);
        boolean bl = false;
        $listener.onTestSuiteScheduled(newDevice);
        $listener.onTestSuiteStarted(newDevice, it);
        return androidTestSuite;
    }

    private static final AndroidTestSuite forwardResults$lambda$12$lambda$11(Function1 $tmp0, Object p0) {
        return (AndroidTestSuite)$tmp0.invoke(p0);
    }

    private static final void forwardResults$lambda$13(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final File createTestCase$lambda$15$lambda$14(ArtifactFileResolver $artifactFileResolver, String outputArtifactPath) {
        Intrinsics.checkNotNullParameter((Object)outputArtifactPath, (String)"outputArtifactPath");
        File file = $artifactFileResolver.resolveFile(outputArtifactPath);
        if (file == null) {
            file = new File(outputArtifactPath);
        }
        return file;
    }

    private static final boolean getIceboxArtifact$lambda$16(Regex $iceboxArtifactRegrex, TestArtifactProto.Artifact artifact) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        String string = new File(artifact.getSourcePath().getPath()).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return $iceboxArtifactRegrex.matches((CharSequence)string);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TestStatusProto.TestStatus.values().length];
            try {
                nArray[TestStatusProto.TestStatus.PASSED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TestStatusProto.TestStatus.FAILED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

