/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.instrumented.testsuite.adapter;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.annotations.concurrency.AnyThread;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.tools.idea.testartifacts.instrumented.testsuite.adapter.DdmlibUtilsKt;
import com.android.tools.idea.testartifacts.instrumented.testsuite.api.AndroidTestResultListener;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidDevice;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidTestCase;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidTestCaseResult;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidTestSuite;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidTestSuiteResult;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.benchmark.BenchmarkLine;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.benchmark.BenchmarkOutput;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.util.ClassUtil;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 12\u00020\u00012\u00020\u0002:\u00011B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0013H\u0017J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u000fH\u0017J\u0018\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u0012H\u0017J\u0018\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u0012H\u0017J\u0010\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u000fH\u0017J$\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u000f2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u000eH\u0017J\u0010\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u0012H\u0017J\u0010\u0010\"\u001a\u00020\u00152\u0006\u0010#\u001a\u00020$H\u0017J$\u0010%\u001a\u00020\u00152\u0006\u0010#\u001a\u00020$2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u000eH\u0017J\u0018\u0010'\u001a\u00020\u00152\u0006\u0010(\u001a\u00020\u00122\u0006\u0010)\u001a\u00020\u0012H\u0002J\u0010\u0010*\u001a\u00020\u00152\u0006\u0010+\u001a\u00020,H\u0017J\u001c\u0010-\u001a\u00020\u00152\u0006\u0010+\u001a\u00020,2\n\u0010.\u001a\u0006\u0012\u0002\b\u00030/H\u0017J\u0010\u00100\u001a\u00020\u00152\u0006\u0010+\u001a\u00020,H\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/android/tools/idea/testartifacts/instrumented/testsuite/adapter/DdmlibTestRunListenerAdapter;", "Lcom/android/ddmlib/testrunner/ITestRunListener;", "Lcom/intellij/execution/process/ProcessListener;", "myIDevice", "Lcom/android/ddmlib/IDevice;", "listener", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/api/AndroidTestResultListener;", "<init>", "(Lcom/android/ddmlib/IDevice;Lcom/android/tools/idea/testartifacts/instrumented/testsuite/api/AndroidTestResultListener;)V", "myDevice", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidDevice;", "myTestSuite", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidTestSuite;", "myTestCases", "", "Lcom/android/ddmlib/testrunner/TestIdentifier;", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidTestCase;", "myTestCaseRunCount", "", "", "testRunStarted", "", "runName", "testCount", "testStarted", "testId", "testFailed", "trace", "testAssumptionFailure", "testIgnored", "testEnded", "testMetrics", "testRunFailed", "errorMessage", "testRunStopped", "elapsedTime", "", "testRunEnded", "runMetrics", "copyBenchmarkFilesIfNeeded", "benchmark", "deviceRoot", "startNotified", "event", "Lcom/intellij/execution/process/ProcessEvent;", "onTextAvailable", "outputType", "Lcom/intellij/openapi/util/Key;", "processTerminated", "Companion", "intellij.android.testartifacts"})
@StabilityInferred(parameters=0)
public final class DdmlibTestRunListenerAdapter
implements ITestRunListener,
ProcessListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IDevice myIDevice;
    @NotNull
    private final AndroidTestResultListener listener;
    @NotNull
    private final AndroidDevice myDevice;
    private AndroidTestSuite myTestSuite;
    @NotNull
    private final Map<TestIdentifier, AndroidTestCase> myTestCases;
    @NotNull
    private final Map<String, Integer> myTestCaseRunCount;
    public static final int $stable = 8;
    @NotNull
    private static final Logger logger;
    @NotNull
    public static final String BENCHMARK_TEST_METRICS_KEY = "android.studio.display.benchmark";
    @NotNull
    public static final String BENCHMARK_V2_TEST_METRICS_KEY = "android.studio.v2display.benchmark";
    @NotNull
    public static final String BENCHMARK_PATH_TEST_METRICS_KEY = "android.studio.v2display.benchmark.outputDirPath";
    @NotNull
    public static final String BENCHMARK_V3_TEST_METRICS_KEY = "android.studio.v3display.benchmark";
    @NotNull
    public static final String BENCHMARK_V3_PATH_TEST_METRICS_KEY = "android.studio.v3display.benchmark.outputDirPath";
    @NotNull
    private static final Regex benchmarkPrefixRegex;

    public DdmlibTestRunListenerAdapter(@NotNull IDevice myIDevice, @NotNull AndroidTestResultListener listener2) {
        Intrinsics.checkNotNullParameter((Object)myIDevice, (String)"myIDevice");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.myIDevice = myIDevice;
        this.listener = listener2;
        this.myDevice = DdmlibUtilsKt.convertIDeviceToAndroidDevice(this.myIDevice);
        this.myTestCases = new LinkedHashMap();
        this.myTestCaseRunCount = new LinkedHashMap();
        this.listener.onTestSuiteScheduled(this.myDevice);
    }

    @AnyThread
    public synchronized void testRunStarted(@NotNull String runName, int testCount) {
        Intrinsics.checkNotNullParameter((Object)runName, (String)"runName");
        this.myTestSuite = new AndroidTestSuite(runName, runName, testCount, null, null, 24, null);
        AndroidTestSuite androidTestSuite = this.myTestSuite;
        if (androidTestSuite == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myTestSuite");
            androidTestSuite = null;
        }
        this.listener.onTestSuiteStarted(this.myDevice, androidTestSuite);
    }

    @AnyThread
    public synchronized void testStarted(@NotNull TestIdentifier testId) {
        Intrinsics.checkNotNullParameter((Object)testId, (String)"testId");
        String fullyQualifiedTestMethodName = testId.getClassName() + "#" + testId.getTestName();
        Integer testCaseRunCount = this.myTestCaseRunCount.compute(fullyQualifiedTestMethodName, (arg_0, arg_1) -> DdmlibTestRunListenerAdapter.testStarted$lambda$1(DdmlibTestRunListenerAdapter::testStarted$lambda$0, arg_0, arg_1));
        String string = testId + " - " + testCaseRunCount;
        String string2 = testId.getTestName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getTestName(...)");
        String string3 = ClassUtil.extractClassName((String)testId.getClassName());
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"extractClassName(...)");
        String string4 = ClassUtil.extractPackageName((String)testId.getClassName());
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"extractPackageName(...)");
        AndroidTestCase testCase = new AndroidTestCase(string, string2, string3, string4, AndroidTestCaseResult.IN_PROGRESS, null, null, System.currentTimeMillis(), null, null, null, null, null, 8032, null);
        this.myTestCases.put(testId, testCase);
        AndroidTestSuite androidTestSuite = this.myTestSuite;
        if (androidTestSuite == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myTestSuite");
            androidTestSuite = null;
        }
        this.listener.onTestCaseStarted(this.myDevice, androidTestSuite, testCase);
    }

    @AnyThread
    public synchronized void testFailed(@NotNull TestIdentifier testId, @NotNull String trace) {
        Intrinsics.checkNotNullParameter((Object)testId, (String)"testId");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        AndroidTestCase testCase = (AndroidTestCase)MapsKt.getValue(this.myTestCases, (Object)testId);
        testCase.setResult(AndroidTestCaseResult.FAILED);
        testCase.setErrorStackTrace(trace);
        AndroidTestSuite androidTestSuite = this.myTestSuite;
        if (androidTestSuite == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myTestSuite");
            androidTestSuite = null;
        }
        androidTestSuite.setResult(AndroidTestSuiteResult.FAILED);
    }

    @AnyThread
    public synchronized void testAssumptionFailure(@NotNull TestIdentifier testId, @NotNull String trace) {
        Intrinsics.checkNotNullParameter((Object)testId, (String)"testId");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        AndroidTestCase testCase = (AndroidTestCase)MapsKt.getValue(this.myTestCases, (Object)testId);
        testCase.setResult(AndroidTestCaseResult.SKIPPED);
        testCase.setErrorStackTrace(trace);
    }

    @AnyThread
    public synchronized void testIgnored(@NotNull TestIdentifier testId) {
        Intrinsics.checkNotNullParameter((Object)testId, (String)"testId");
        AndroidTestCase testCase = (AndroidTestCase)MapsKt.getValue(this.myTestCases, (Object)testId);
        testCase.setResult(AndroidTestCaseResult.SKIPPED);
    }

    @AnyThread
    public synchronized void testEnded(@NotNull TestIdentifier testId, @NotNull Map<String, String> testMetrics) {
        Intrinsics.checkNotNullParameter((Object)testId, (String)"testId");
        Intrinsics.checkNotNullParameter(testMetrics, (String)"testMetrics");
        AndroidTestCase testCase = (AndroidTestCase)MapsKt.getValue(this.myTestCases, (Object)testId);
        if (!testCase.getResult().isTerminalState()) {
            testCase.setResult(AndroidTestCaseResult.PASSED);
        }
        testCase.setLogcat(testMetrics.getOrDefault("com.android.ddmlib.testrunner.logcat", ""));
        Object[] objectArray = new String[]{BENCHMARK_V3_TEST_METRICS_KEY, BENCHMARK_V2_TEST_METRICS_KEY, BENCHMARK_TEST_METRICS_KEY};
        testCase.setBenchmark(DdmlibTestRunListenerAdapter.Companion.getBenchmarkOutput(testMetrics, CollectionsKt.listOf((Object[])objectArray)));
        testCase.setEndTimestampMillis(System.currentTimeMillis());
        objectArray = new String[]{BENCHMARK_V2_TEST_METRICS_KEY, BENCHMARK_TEST_METRICS_KEY};
        this.copyBenchmarkFilesIfNeeded(DdmlibTestRunListenerAdapter.Companion.getBenchmarkOutput(testMetrics, CollectionsKt.listOf((Object[])objectArray)), testMetrics.getOrDefault(BENCHMARK_PATH_TEST_METRICS_KEY, ""));
        AndroidTestSuite androidTestSuite = this.myTestSuite;
        if (androidTestSuite == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myTestSuite");
            androidTestSuite = null;
        }
        this.listener.onTestCaseFinished(this.myDevice, androidTestSuite, testCase);
    }

    @AnyThread
    public synchronized void testRunFailed(@NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        AndroidTestSuite androidTestSuite = this.myTestSuite;
        if (androidTestSuite == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myTestSuite");
            androidTestSuite = null;
        }
        androidTestSuite.setResult(AndroidTestSuiteResult.ABORTED);
    }

    @AnyThread
    public synchronized void testRunStopped(long elapsedTime) {
        AndroidTestSuite androidTestSuite = this.myTestSuite;
        if (androidTestSuite == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myTestSuite");
            androidTestSuite = null;
        }
        androidTestSuite.setResult(AndroidTestSuiteResult.CANCELLED);
    }

    @AnyThread
    public synchronized void testRunEnded(long elapsedTime, @NotNull Map<String, String> runMetrics) {
        AndroidTestSuiteResult androidTestSuiteResult;
        AndroidTestSuite androidTestSuite;
        Intrinsics.checkNotNullParameter(runMetrics, (String)"runMetrics");
        if (this.myTestSuite == null) {
            this.myTestSuite = new AndroidTestSuite("", "", 0, AndroidTestSuiteResult.CANCELLED, null, 16, null);
        }
        for (AndroidTestCase testCase : this.myTestCases.values()) {
            AndroidTestSuiteResult androidTestSuiteResult2;
            AndroidTestSuite androidTestSuite2;
            if (testCase.getResult().isTerminalState()) continue;
            testCase.setResult(AndroidTestCaseResult.CANCELLED);
            testCase.setEndTimestampMillis(System.currentTimeMillis());
            AndroidTestSuite androidTestSuite3 = this.myTestSuite;
            if (androidTestSuite3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myTestSuite");
                androidTestSuite3 = null;
            }
            if ((androidTestSuite2 = this.myTestSuite) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myTestSuite");
                androidTestSuite2 = null;
            }
            if ((androidTestSuiteResult2 = androidTestSuite2.getResult()) == null) {
                androidTestSuiteResult2 = AndroidTestSuiteResult.CANCELLED;
            }
            androidTestSuite3.setResult(androidTestSuiteResult2);
        }
        AndroidTestSuite androidTestSuite4 = this.myTestSuite;
        if (androidTestSuite4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myTestSuite");
            androidTestSuite4 = null;
        }
        if ((androidTestSuite = this.myTestSuite) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myTestSuite");
            androidTestSuite = null;
        }
        if ((androidTestSuiteResult = androidTestSuite.getResult()) == null) {
            androidTestSuiteResult = AndroidTestSuiteResult.PASSED;
        }
        androidTestSuite4.setResult(androidTestSuiteResult);
        AndroidTestSuite androidTestSuite5 = this.myTestSuite;
        if (androidTestSuite5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myTestSuite");
            androidTestSuite5 = null;
        }
        this.listener.onTestSuiteFinished(this.myDevice, androidTestSuite5);
    }

    private final void copyBenchmarkFilesIfNeeded(String benchmark, String deviceRoot) {
        if (StringsKt.isBlank((CharSequence)benchmark) || StringsKt.isBlank((CharSequence)deviceRoot)) {
            return;
        }
        BenchmarkOutput benchmarkOutput = new BenchmarkOutput(benchmark);
        for (BenchmarkLine line : benchmarkOutput.getLines()) {
            for (MatchResult match = line.getMatches(); match != null; match = match.next()) {
                Object link2;
                Object object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match.getGroups(), (String)BenchmarkOutput.Companion.getLINK_GROUP());
                if (object == null || (object = object.getValue()) == null) {
                    object = "";
                }
                if (!StringsKt.startsWith$default((String)(link2 = object), (String)BenchmarkOutput.Companion.getBENCHMARK_TRACE_FILE_PREFIX(), (boolean)false, (int)2, null)) continue;
                String string = "Pulling: " + (String)link2;
                Task.Backgroundable task2 = new Task.Backgroundable((String)link2, this, deviceRoot, string){
                    final /* synthetic */ String $link;
                    final /* synthetic */ DdmlibTestRunListenerAdapter this$0;
                    final /* synthetic */ String $deviceRoot;
                    {
                        this.$link = $link;
                        this.this$0 = $receiver;
                        this.$deviceRoot = $deviceRoot;
                        super(null, $super_call_param$1, true);
                    }

                    public void run(ProgressIndicator indicator) {
                        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                        String relativeFilePath = StringsKt.replace$default((String)this.$link, (String)BenchmarkOutput.Companion.getBENCHMARK_TRACE_FILE_PREFIX(), (String)"", (boolean)false, (int)4, null);
                        String localFilePath = FileUtil.getTempDirectory() + File.separator + relativeFilePath;
                        File localFile = new File(localFilePath);
                        localFile.deleteOnExit();
                        if (!localFile.exists() && (localFile.getParentFile().exists() || localFile.getParentFile().mkdirs())) {
                            DdmlibTestRunListenerAdapter.access$getMyIDevice$p(this.this$0).pullFile(this.$deviceRoot + "/" + relativeFilePath, localFile.getAbsolutePath());
                        } else {
                            DdmlibTestRunListenerAdapter.access$getLogger$cp().warn("Unable to copy latest trace file (" + relativeFilePath + ") from device (" + DdmlibTestRunListenerAdapter.access$getMyIDevice$p(this.this$0).getSerialNumber() + ")");
                        }
                    }
                };
                ProgressManager.getInstance().run((Task)task2);
            }
        }
    }

    @AnyThread
    public synchronized void startNotified(@NotNull ProcessEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }

    @AnyThread
    public synchronized void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
    }

    @AnyThread
    public synchronized void processTerminated(@NotNull ProcessEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.getProcessHandler().removeProcessListener((ProcessListener)this);
        this.testRunEnded(0L, new LinkedHashMap());
    }

    private static final Integer testStarted$lambda$0(String string, Integer currentValue) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        Integer n = currentValue;
        return n != null ? n + 1 : 0;
    }

    private static final Integer testStarted$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return (Integer)$tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ IDevice access$getMyIDevice$p(DdmlibTestRunListenerAdapter $this) {
        return $this.myIDevice;
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    static {
        Logger logger = Logger.getInstance(DdmlibTestRunListenerAdapter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        DdmlibTestRunListenerAdapter.logger = logger;
        benchmarkPrefixRegex = new Regex("^benchmark:( )?", RegexOption.MULTILINE);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u000f\u001a\u00020\b2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0013H\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/testartifacts/instrumented/testsuite/adapter/DdmlibTestRunListenerAdapter$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "BENCHMARK_TEST_METRICS_KEY", "", "BENCHMARK_V2_TEST_METRICS_KEY", "BENCHMARK_PATH_TEST_METRICS_KEY", "BENCHMARK_V3_TEST_METRICS_KEY", "BENCHMARK_V3_PATH_TEST_METRICS_KEY", "benchmarkPrefixRegex", "Lkotlin/text/Regex;", "getBenchmarkOutput", "testMetrics", "", "orderedKeys", "", "intellij.android.testartifacts"})
    public static final class Companion {
        private Companion() {
        }

        private final String getBenchmarkOutput(Map<String, String> testMetrics, List<String> orderedKeys) {
            for (String key : orderedKeys) {
                if (!testMetrics.containsKey(key)) continue;
                return benchmarkPrefixRegex.replace((CharSequence)testMetrics.getOrDefault(key, ""), "");
            }
            return "";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

